/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;

@Immutable
public final class CLangStackFrame {
    public static final String RETVAL_LABEL = "___cpa_temp_result_var_";
    private final CFunctionDeclaration stack_function;
    private final PersistentMap<String, SMGRegion> stack_variables;
    private final @Nullable SMGRegion returnValueObject;

    private CLangStackFrame(CFunctionDeclaration pDeclaration, PersistentMap<String, SMGRegion> pVariables, SMGRegion pReturnValueObject) {
        this.stack_variables = (PersistentMap)Preconditions.checkNotNull(pVariables);
        this.stack_function = (CFunctionDeclaration)Preconditions.checkNotNull((Object)pDeclaration);
        this.returnValueObject = pReturnValueObject;
    }

    public CLangStackFrame(CFunctionDeclaration pDeclaration, MachineModel pMachineModel) {
        this.stack_variables = PathCopyingPersistentTreeMap.of();
        this.stack_function = pDeclaration;
        CType returnType = pDeclaration.getType().getReturnType().getCanonicalType();
        if (returnType instanceof CVoidType) {
            this.returnValueObject = null;
        } else {
            int return_value_size = pMachineModel.getSizeofInBits(returnType).intValueExact();
            this.returnValueObject = new SMGRegion(return_value_size, RETVAL_LABEL);
        }
    }

    public CLangStackFrame addStackVariable(String pVariableName, SMGRegion pObject) {
        Preconditions.checkArgument((!this.stack_variables.containsKey((Object)pVariableName) ? 1 : 0) != 0, (String)"Stack frame for function '%s' already contains a variable '%s'", (Object)this.stack_function.toASTString(), (Object)pVariableName);
        return new CLangStackFrame(this.stack_function, (PersistentMap<String, SMGRegion>)this.stack_variables.putAndCopy((Object)pVariableName, (Object)pObject), this.returnValueObject);
    }

    public String toString() {
        Iterable values = this.stack_variables.values();
        if (this.returnValueObject != null) {
            values = Iterables.concat((Iterable)values, (Iterable)ImmutableSet.of((Object)this.returnValueObject));
        }
        return String.format("%s=[%s]", this.stack_function.getName(), Joiner.on((String)", ").join(values));
    }

    public CLangStackFrame removeVariable(String pName) {
        if (RETVAL_LABEL.equals(pName)) {
            return this;
        }
        return new CLangStackFrame(this.stack_function, (PersistentMap<String, SMGRegion>)this.stack_variables.removeAndCopy((Object)pName), this.returnValueObject);
    }

    public SMGRegion getVariable(String pName) {
        if (pName.equals(RETVAL_LABEL) && this.returnValueObject != null) {
            return this.returnValueObject;
        }
        SMGRegion to_return = (SMGRegion)this.stack_variables.get((Object)pName);
        if (to_return == null) {
            throw new NoSuchElementException(String.format("No variable with name '%s' in stack frame for function '%s'", pName, this.stack_function.toASTString()));
        }
        return to_return;
    }

    public boolean containsVariable(String pName) {
        if (pName.equals(RETVAL_LABEL)) {
            return this.returnValueObject != null;
        }
        return this.stack_variables.containsKey((Object)pName);
    }

    public CFunctionDeclaration getFunctionDeclaration() {
        return this.stack_function;
    }

    public Map<String, SMGRegion> getVariables() {
        return this.stack_variables;
    }

    public Set<SMGObject> getAllObjects() {
        ImmutableSet.Builder retset = ImmutableSet.builder();
        retset.addAll((Iterable)this.stack_variables.values());
        if (this.returnValueObject != null) {
            retset.add((Object)this.returnValueObject);
        }
        return retset.build();
    }

    public SMGRegion getReturnObject() {
        return this.returnValueObject;
    }

    public boolean hasVariable(String var) {
        return this.stack_variables.containsKey((Object)var);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CLangStackFrame)) {
            return false;
        }
        CLangStackFrame other = (CLangStackFrame)o;
        return Objects.equals(this.stack_variables, other.stack_variables) && Objects.equals(this.stack_function, other.stack_function) && Objects.equals(this.returnValueObject, other.returnValueObject);
    }

    public int hashCode() {
        return Objects.hash(this.stack_variables, this.stack_function, this.returnValueObject);
    }
}

