/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.truth.Truth;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMGTest;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;

public class CLangStackFrameTest {
    private static final MachineModel usedMachineModel = MachineModel.LINUX64;
    private CLangStackFrame sf;

    @Before
    public void setUp() {
        this.sf = new CLangStackFrame(CLangSMGTest.DUMMY_FUNCTION, usedMachineModel);
    }

    @Test
    public void CLangStackFrameConstructorTest() {
        Map<String, SMGRegion> variables = this.sf.getVariables();
        Truth.assert_().withMessage("CLangStackFrame contains no variables after creation").that(variables).isEmpty();
        Truth.assertThat((Boolean)this.sf.containsVariable("foo")).isFalse();
    }

    @Test
    public void CLangStackFrameAddVariableTest() {
        this.sf = this.sf.addStackVariable("fooVar", new SMGRegion(64L, "fooVarObject"));
        Truth.assert_().withMessage("Added variable is present").that(Boolean.valueOf(this.sf.containsVariable("fooVar"))).isTrue();
        Map<String, SMGRegion> variables = this.sf.getVariables();
        Truth.assert_().withMessage("Variables set is nonempty after variable addition").that(variables).hasSize(1);
        SMGObject smg_object = variables.get("fooVar");
        Truth.assert_().withMessage("Added variable present in variable map").that(smg_object.getLabel()).isEqualTo((Object)"fooVarObject");
        Truth.assert_().withMessage("Added variable present in variable map").that(Long.valueOf(smg_object.getSize())).isEqualTo((Object)64);
        smg_object = this.sf.getVariable("fooVar");
        Truth.assert_().withMessage("Correct variable is returned: label").that(smg_object.getLabel()).isEqualTo((Object)"fooVarObject");
        Truth.assert_().withMessage("Correct variable is returned: size").that(Long.valueOf(smg_object.getSize())).isEqualTo((Object)64);
    }

    @Test
    public void CLangFrameGetObjectsTest() {
        Set<SMGObject> objects = this.sf.getAllObjects();
        Truth.assertThat(objects).hasSize(1);
        this.sf = this.sf.addStackVariable("fooVar", new SMGRegion(64L, "fooVarObject"));
        objects = this.sf.getAllObjects();
        Truth.assertThat(objects).hasSize(2);
    }

    @Test
    public void CLangFrameReturnValueTest() {
        SMGRegion retval = this.sf.getReturnObject();
        Truth.assertThat((Long)retval.getSize()).isEqualTo((Object)usedMachineModel.getSizeofInBits(CNumericTypes.UNSIGNED_LONG_INT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangStackFrameAddVariableTwiceTest() {
        this.sf = this.sf.addStackVariable("fooVar", new SMGRegion(64L, "fooVarObject"));
        this.sf = this.sf.addStackVariable("fooVar", new SMGRegion(128L, "newFooVarObject"));
    }

    @Test(expected=NoSuchElementException.class)
    public void CLangStackFrameMissingVariableTest() {
        Truth.assert_().withMessage("Non-added variable is not present").that(Boolean.valueOf(this.sf.containsVariable("fooVaz"))).isFalse();
        this.sf.getVariable("fooVaz");
    }

    @Test
    public void CLangStackFrameFunctionTest() {
        CFunctionDeclaration fd = this.sf.getFunctionDeclaration();
        Truth.assert_().withMessage("Correct function is returned").that(fd.getName()).isEqualTo((Object)"foo");
    }
}

