/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public abstract class SMGAbstractionFinder {
    protected final int seqLengthEqualityThreshold;
    protected final int seqLengthEntailmentThreshold;
    protected final int seqLengthIncomparableThreshold;

    @VisibleForTesting
    protected SMGAbstractionFinder() {
        this.seqLengthEqualityThreshold = 2;
        this.seqLengthEntailmentThreshold = 2;
        this.seqLengthIncomparableThreshold = 3;
    }

    protected SMGAbstractionFinder(int pSeqLengthEqualityThreshold, int pSeqLengthEntailmentThreshold, int pSeqLengthIncomparableThreshold) {
        this.seqLengthEqualityThreshold = pSeqLengthEqualityThreshold;
        this.seqLengthEntailmentThreshold = pSeqLengthEntailmentThreshold;
        this.seqLengthIncomparableThreshold = pSeqLengthIncomparableThreshold;
    }

    public abstract Set<SMGAbstractionCandidate> traverse(UnmodifiableCLangSMG var1, UnmodifiableSMGState var2, Set<SMGAbstractionBlock> var3) throws SMGInconsistentException;

    protected boolean isSubSmgSeperate(Set<SMGObject> nonSharedObject, Set<SMGValue> nonSharedValues, UnmodifiableCLangSMG smg, Set<SMGObject> reachableObjects, Set<SMGValue> reachableValues, SMGObject rootOfSubSmg) {
        for (SMGObject obj : nonSharedObject) {
            if (obj.equals(rootOfSubSmg)) continue;
            if (!smg.isHeapObject(obj)) {
                return false;
            }
            Set<SMGEdgePointsTo> pointer = SMGUtils.getPointerToThisObject(obj, smg);
            for (SMGEdgePointsTo pte : pointer) {
                if (reachableValues.contains(pte.getValue())) continue;
                return false;
            }
        }
        for (SMGValue val : nonSharedValues) {
            if (!smg.isPointer(val)) continue;
            for (SMGEdgeHasValue hve : smg.getHVEdges(SMGEdgeHasValueFilter.valueFilter(val))) {
                if (reachableObjects.contains(hve.getObject()) || hve.getObject() == rootOfSubSmg) continue;
                return false;
            }
        }
        return true;
    }

    protected final void getSubSmgOf(SMGObject pObject, Predicate<SMGEdgeHasValue> check, UnmodifiableCLangSMG inputSmg, Set<SMGValue> pValues, Set<SMGObject> pObjects) {
        LinkedHashSet<SMGObject> toBeChecked = new LinkedHashSet<SMGObject>();
        pObjects.add(pObject);
        for (SMGEdgeHasValue hve : inputSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject))) {
            SMGEdgePointsTo reachedObjectSubSmgPTEdge;
            SMGObject reachedObjectSubSmg;
            if (!check.test(hve)) continue;
            SMGValue subSmgValue = hve.getValue();
            pValues.add(subSmgValue);
            if (!inputSmg.isPointer(subSmgValue) || !pObjects.add(reachedObjectSubSmg = (reachedObjectSubSmgPTEdge = inputSmg.getPointer(subSmgValue)).getObject())) continue;
            toBeChecked.add(reachedObjectSubSmg);
        }
        LinkedHashSet<SMGObject> toCheck = new LinkedHashSet<SMGObject>();
        while (!toBeChecked.isEmpty()) {
            toCheck.clear();
            toCheck.addAll(toBeChecked);
            toBeChecked.clear();
            for (SMGObject objToCheck : toCheck) {
                this.getSubSmgOf(objToCheck, toBeChecked, inputSmg, pObjects, pValues);
            }
        }
    }

    private void getSubSmgOf(SMGObject pObjToCheck, Set<SMGObject> pToBeChecked, UnmodifiableCLangSMG pInputSmg, Set<SMGObject> pObjects, Set<SMGValue> pValues) {
        for (SMGEdgeHasValue hve : pInputSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObjToCheck))) {
            SMGEdgePointsTo reachedObjectSubSmgPTEdge;
            SMGObject reachedObjectSubSmg;
            SMGValue subDlsValue = hve.getValue();
            pValues.add(subDlsValue);
            if (!pInputSmg.isPointer(subDlsValue) || !pObjects.add(reachedObjectSubSmg = (reachedObjectSubSmgPTEdge = pInputSmg.getPointer(subDlsValue)).getObject())) continue;
            pToBeChecked.add(reachedObjectSubSmg);
        }
    }
}

