/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.smg.EmptyAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListFinder;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListFinder;

public class SMGAbstractionManager {
    private final LogManager logger;
    private final CLangSMG smg;
    private final SMGState smgState;
    private final Set<SMGAbstractionBlock> blocks;
    private final SMGDoublyLinkedListFinder dllCandidateFinder;
    private final SMGSingleLinkedListFinder sllCandidateFinder;

    @VisibleForTesting
    public SMGAbstractionManager(LogManager pLogger, CLangSMG pSMG, SMGState pSMGstate) {
        this.smg = pSMG;
        this.smgState = pSMGstate;
        this.logger = pLogger;
        this.blocks = ImmutableSet.of();
        this.dllCandidateFinder = new SMGDoublyLinkedListFinder();
        this.sllCandidateFinder = new SMGSingleLinkedListFinder();
    }

    public SMGAbstractionManager(LogManager pLogger, CLangSMG pSMG, SMGState pSMGstate, Set<SMGAbstractionBlock> pBlocks, int equalSeq, int entailSeq, int incSeq) {
        this.smg = pSMG;
        this.smgState = pSMGstate;
        this.logger = pLogger;
        this.blocks = pBlocks;
        this.dllCandidateFinder = new SMGDoublyLinkedListFinder(equalSeq, entailSeq, incSeq);
        this.sllCandidateFinder = new SMGSingleLinkedListFinder(equalSeq, entailSeq, incSeq);
    }

    private List<SMGAbstractionCandidate> getCandidates() throws SMGInconsistentException {
        return ImmutableList.builder().addAll(this.dllCandidateFinder.traverse(this.smg, this.smgState, this.blocks)).addAll(this.sllCandidateFinder.traverse(this.smg, this.smgState, this.blocks)).build();
    }

    private SMGAbstractionCandidate getBestCandidate(List<SMGAbstractionCandidate> abstractionCandidates) {
        return Collections.max(abstractionCandidates, Comparator.comparing(SMGAbstractionCandidate::getScore));
    }

    public boolean execute() throws SMGInconsistentException {
        SMGAbstractionCandidate currentAbstraction = this.executeOneStep();
        if (currentAbstraction.isEmpty()) {
            return false;
        }
        while (!currentAbstraction.isEmpty()) {
            currentAbstraction = this.executeOneStep();
        }
        return true;
    }

    public SMGAbstractionCandidate executeOneStep() throws SMGInconsistentException {
        List<SMGAbstractionCandidate> abstractionCandidates = this.getCandidates();
        if (!abstractionCandidates.isEmpty()) {
            SMGAbstractionCandidate best = this.getBestCandidate(abstractionCandidates);
            this.logger.log(Level.ALL, new Object[]{"Execute abstraction of ", best});
            best.execute(this.smg, this.smgState);
            this.logger.log(Level.ALL, new Object[]{"Finish executing abstraction of ", best});
            return best;
        }
        return EmptyAbstractionCandidate.INSTANCE;
    }
}

