/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public class SMGAbstractionManagerTest {
    private CLangSMG smg;

    @Before
    public void setUp() {
        this.smg = new CLangSMG(MachineModel.LINUX64);
        SMGRegion globalVar = new SMGRegion(64L, "pointer");
        SMGRegion next = null;
        for (int i = 0; i < 20; ++i) {
            SMGEdgeHasValue hv;
            SMGRegion node = new SMGRegion(128L, "node " + i);
            this.smg.addHeapObject(node);
            if (next != null) {
                SMGKnownSymbolicValue address = SMGKnownSymValue.of();
                SMGEdgePointsTo pt = new SMGEdgePointsTo(address, next, 0L);
                hv = new SMGEdgeHasValue(this.smg.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID), 64L, (SMGObject)node, (SMGValue)address);
                this.smg.addValue(address);
                this.smg.addPointsToEdge(pt);
            } else {
                hv = new SMGEdgeHasValue(128L, 0L, (SMGObject)node, (SMGValue)SMGZeroValue.INSTANCE);
            }
            this.smg.addHasValueEdge(hv);
            next = node;
        }
        SMGKnownSymbolicValue address = SMGKnownSymValue.of();
        SMGEdgeHasValue hv = new SMGEdgeHasValue(this.smg.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID), 64L, (SMGObject)globalVar, (SMGValue)address);
        SMGEdgePointsTo pt = new SMGEdgePointsTo(address, next, 0L);
        this.smg.addGlobalObject(globalVar);
        this.smg.addValue(address);
        this.smg.addPointsToEdge(pt);
        this.smg.addHasValueEdge(hv);
    }

    @Test
    public void testExecute() throws SMGInconsistentException, InvalidConfigurationException {
        SMGState dummyState = new SMGState(LogManager.createTestLogManager(), MachineModel.LINUX32, new SMGOptions(Configuration.defaultConfiguration()));
        SMGAbstractionManager manager = new SMGAbstractionManager(LogManager.createTestLogManager(), this.smg, dummyState);
        manager.execute();
        SMGRegion globalVar = this.smg.getObjectForVisibleVariable("pointer");
        SMGHasValueEdges hvs = this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(globalVar));
        Truth.assertThat((Iterable)hvs).hasSize(1);
        SMGEdgeHasValue hv = (SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)hvs);
        SMGEdgePointsTo pt = this.smg.getPointer(hv.getValue());
        SMGObject segment = pt.getObject();
        Truth.assertThat((Boolean)segment.isAbstract()).isTrue();
    }
}

