/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGExportDotOption;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelationKind;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGRightHandSideEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;

public class SMGBuiltins {
    private final SMGRightHandSideEvaluator expressionEvaluator;
    private final MachineModel machineModel;
    private final LogManager logger;
    private final SMGExportDotOption exportSMGOptions;
    private final SMGOptions options;
    private ImmutableList<Pattern> safeUnknownFunctionCompiledPatterns;
    private static final int MEMSET_BUFFER_PARAMETER = 0;
    private static final int MEMSET_CHAR_PARAMETER = 1;
    private static final int MEMSET_COUNT_PARAMETER = 2;
    private static final int MEMCPY_TARGET_PARAMETER = 0;
    private static final int MEMCPY_SOURCE_PARAMETER = 1;
    private static final int MEMCPY_SIZE_PARAMETER = 2;
    private static final int MALLOC_PARAMETER = 0;
    private static final int STRCMP_FIRST_PARAMETER = 0;
    private static final int STRCMP_SECOND_PARAMETER = 1;
    private final Set<String> BUILTINS = Sets.newHashSet((Object[])new String[]{"__VERIFIER_BUILTIN_PLOT", "memcpy", "memset", "__builtin_alloca", "printf", "strcmp", "realloc"});
    private static final String NONDET_PREFIX = "__VERIFIER_nondet_";

    public SMGBuiltins(SMGRightHandSideEvaluator pExpressionEvaluator, SMGOptions pOptions, SMGExportDotOption pExportSMGOptions, MachineModel pMachineModel, LogManager pLogger) {
        this.expressionEvaluator = pExpressionEvaluator;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.exportSMGOptions = pExportSMGOptions;
        this.options = pOptions;
    }

    private void evaluateVBPlot(CFunctionCallExpression functionCall, UnmodifiableSMGState currentState) {
        String name = functionCall.getParameterExpressions().get(0).toASTString();
        if (this.exportSMGOptions.hasExportPath() && currentState != null) {
            SMGUtils.dumpSMGPlot(this.logger, currentState, functionCall.toASTString(), this.exportSMGOptions.getOutputFilePath(name));
        }
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateMemset(CFunctionCallExpression functionCall, SMGState pSMGState, CFAEdge cfaEdge) throws CPATransferException {
        CExpression countExpr;
        CExpression chExpr;
        CExpression bufferExpr;
        try {
            bufferExpr = functionCall.getParameterExpressions().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Memset buffer argument not found.", cfaEdge, functionCall);
        }
        try {
            chExpr = functionCall.getParameterExpressions().get(1);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Memset ch argument not found.", cfaEdge, functionCall);
        }
        try {
            countExpr = functionCall.getParameterExpressions().get(2);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Memset count argument not found.", cfaEdge, functionCall);
        }
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>(4);
        for (SMGAbstractObjectAndState.SMGAddressValueAndState bufferAddressAndState : this.evaluateAddress(pSMGState, cfaEdge, bufferExpr)) {
            for (SMGAbstractObjectAndState.SMGExplicitValueAndState countValueAndState : this.evaluateExplicitValue(bufferAddressAndState.getSmgState(), cfaEdge, countExpr)) {
                for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : this.evaluateExpressionValue(countValueAndState.getSmgState(), cfaEdge, chExpr)) {
                    for (SMGAbstractObjectAndState.SMGExplicitValueAndState expValueAndState : this.evaluateExplicitValue(sMGValueAndState.getSmgState(), cfaEdge, chExpr)) {
                        result.add(this.evaluateMemset(expValueAndState.getSmgState(), cfaEdge, bufferAddressAndState.getObject(), (SMGExplicitValue)countValueAndState.getObject(), (SMGValue)sMGValueAndState.getObject(), (SMGExplicitValue)expValueAndState.getObject()));
                    }
                }
            }
        }
        return result;
    }

    private SMGAbstractObjectAndState.SMGAddressValueAndState evaluateMemset(SMGState currentState, CFAEdge cfaEdge, SMGAddressValue bufferAddress, SMGExplicitValue countValue, SMGValue ch, SMGExplicitValue expValue) throws CPATransferException {
        if (bufferAddress.isUnknown() || countValue.isUnknown()) {
            currentState = currentState.withInvalidWrite().withErrorDescription("Can't evaluate dst or count for memset");
            return SMGAbstractObjectAndState.SMGAddressValueAndState.of(currentState);
        }
        int count = countValue.getAsInt();
        Verify.verify((count <= Integer.MAX_VALUE / this.machineModel.getSizeofCharInBits() ? 1 : 0) != 0, (String)"Type too large to be handled by SMG for memset in edge %s", (Object)cfaEdge);
        if (ch.isUnknown()) {
            ch = SMGKnownSymValue.of();
        }
        SMGObject bufferMemory = bufferAddress.getObject();
        long offset = bufferAddress.getOffset().getAsLong();
        if (ch.equals(SMGZeroValue.INSTANCE)) {
            currentState = this.expressionEvaluator.writeValue(currentState, bufferMemory, offset, TypeUtils.createTypeWithLength(count * this.machineModel.getSizeofCharInBits()), ch, cfaEdge);
        } else {
            for (int c = 0; c < count; ++c) {
                currentState = this.expressionEvaluator.writeValue(currentState, bufferMemory, offset + (long)c * (long)this.machineModel.getSizeofCharInBits(), CNumericTypes.SIGNED_CHAR, ch, cfaEdge);
            }
            if (!expValue.isUnknown()) {
                currentState.putExplicit((SMGKnownSymbolicValue)ch, (SMGKnownExpValue)expValue);
            }
        }
        return SMGAbstractObjectAndState.SMGAddressValueAndState.of(currentState, bufferAddress);
    }

    protected List<? extends SMGAbstractObjectAndState.SMGValueAndState> evaluateExpressionValue(SMGState smgState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
        return this.expressionEvaluator.evaluateExpressionValue(smgState, cfaEdge, rValue);
    }

    protected List<SMGAbstractObjectAndState.SMGExplicitValueAndState> evaluateExplicitValue(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRValue) throws CPATransferException {
        return this.expressionEvaluator.evaluateExplicitValue(pState, pCfaEdge, pRValue);
    }

    protected List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateAddress(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRvalue) throws CPATransferException {
        return this.expressionEvaluator.evaluateAddress(pState, pCfaEdge, pRvalue);
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateExternalAllocation(CFunctionCallExpression pFunctionCall, SMGState pState) throws SMGInconsistentException {
        String functionName = pFunctionCall.getFunctionNameExpression().toASTString();
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>();
        String allocation_label = functionName + "_ID" + SMGCPA.getNewValue() + "_Line:" + pFunctionCall.getFileLocation().getStartingLineNumber();
        result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(pState, pState.addExternalAllocation(allocation_label)));
        return result;
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateAlloca(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge, SMGTransferRelationKind kind) throws CPATransferException {
        CRightHandSide sizeExpr;
        try {
            sizeExpr = functionCall.getParameterExpressions().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("alloca argument not found.", cfaEdge, functionCall);
        }
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>();
        for (SMGAbstractObjectAndState.SMGExplicitValueAndState valueAndState : this.evaluateExplicitValue(pState, cfaEdge, sizeExpr)) {
            result.addAll(this.evaluateAlloca(valueAndState.getSmgState(), (SMGExplicitValue)valueAndState.getObject(), cfaEdge, sizeExpr, kind));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateAlloca(SMGState currentState, SMGExplicitValue pSizeValue, CFAEdge cfaEdge, CRightHandSide sizeExpr, SMGTransferRelationKind kind) throws CPATransferException {
        SMGExplicitValue sizeValue = pSizeValue;
        if (sizeValue.isUnknown()) {
            if (this.options.isGuessSizeOfUnknownMemorySize()) {
                SMGAbstractObjectAndState.SMGExplicitValueAndState forcedValueAndState = this.expressionEvaluator.forceExplicitValue(currentState, cfaEdge, sizeExpr);
                List<SMGAbstractObjectAndState.SMGExplicitValueAndState> valueAndStates = this.evaluateExplicitValue(currentState = forcedValueAndState.getSmgState(), cfaEdge, sizeExpr);
                if (valueAndStates.size() != 1) {
                    throw new SMGInconsistentException("Found abstraction where non should exist,due to the expression " + sizeExpr.toASTString() + "already being evaluated once in this transferrelation step.");
                }
                SMGAbstractObjectAndState.SMGExplicitValueAndState valueAndState = valueAndStates.get(0);
                sizeValue = (SMGExplicitValue)valueAndState.getObject();
                currentState = valueAndState.getSmgState();
                if (sizeValue.isUnknown()) {
                    if (kind != SMGTransferRelationKind.REFINEMENT) throw new UnsupportedCodeException("Not able to compute allocation size", cfaEdge);
                    sizeValue = SMGZeroValue.INSTANCE;
                }
            } else {
                if (kind != SMGTransferRelationKind.REFINEMENT) throw new UnsupportedCodeException("Not able to compute allocation size", cfaEdge);
                sizeValue = SMGZeroValue.INSTANCE;
            }
        }
        String allocation_label = "alloc_ID" + SMGCPA.getNewValue();
        SMGState state = currentState.copyOf();
        SMGEdgePointsTo addressValue = state.addNewStackAllocation(sizeValue.getAsInt() * this.machineModel.getSizeofCharInBits(), allocation_label);
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>(2);
        result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(state, addressValue));
        if (!this.options.isEnableMallocFailure()) return result;
        result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(currentState.copyOf(), SMGZeroValue.INSTANCE));
        return result;
    }

    private List<SMGAbstractObjectAndState.SMGExplicitValueAndState> getAllocateFunctionSize(SMGState pState, CFAEdge cfaEdge, CFunctionCallExpression functionCall, SMGTransferRelationKind kind) throws CPATransferException {
        String functionName = functionCall.getFunctionNameExpression().toASTString();
        if (this.options.getArrayAllocationFunctions().contains((Object)functionName)) {
            ArrayList<SMGAbstractObjectAndState.SMGExplicitValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGExplicitValueAndState>();
            for (SMGAbstractObjectAndState.SMGExplicitValueAndState numValueAndState : this.getAllocateFunctionParameter(this.options.getMemoryArrayAllocationFunctionsNumParameter(), functionCall, pState, cfaEdge, kind)) {
                for (SMGAbstractObjectAndState.SMGExplicitValueAndState elemSizeValueAndState : this.getAllocateFunctionParameter(this.options.getMemoryArrayAllocationFunctionsElemSizeParameter(), functionCall, numValueAndState.getSmgState(), cfaEdge, kind)) {
                    SMGExplicitValue size = ((SMGExplicitValue)numValueAndState.getObject()).multiply((SMGExplicitValue)elemSizeValueAndState.getObject());
                    result.add(SMGAbstractObjectAndState.SMGExplicitValueAndState.of(elemSizeValueAndState.getSmgState(), size));
                }
            }
            return result;
        }
        return this.getAllocateFunctionParameter(this.options.getMemoryAllocationFunctionsSizeParameter(), functionCall, pState, cfaEdge, kind);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SMGAbstractObjectAndState.SMGExplicitValueAndState> getAllocateFunctionParameter(int pParameterNumber, CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge, SMGTransferRelationKind kind) throws CPATransferException {
        CRightHandSide sizeExpr;
        SMGState currentState = pState;
        String functionName = functionCall.getFunctionNameExpression().toASTString();
        try {
            sizeExpr = functionCall.getParameterExpressions().get(pParameterNumber);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException(functionName + " argument #" + pParameterNumber + " not found.", cfaEdge, functionCall);
        }
        ArrayList<SMGAbstractObjectAndState.SMGExplicitValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGExplicitValueAndState>();
        Iterator<SMGAbstractObjectAndState.SMGExplicitValueAndState> iterator = this.evaluateExplicitValue(currentState, cfaEdge, sizeExpr).iterator();
        while (iterator.hasNext()) {
            SMGAbstractObjectAndState.SMGExplicitValueAndState valueAndState;
            SMGAbstractObjectAndState.SMGExplicitValueAndState resultValueAndState = valueAndState = iterator.next();
            SMGExplicitValue value = (SMGExplicitValue)valueAndState.getObject();
            if (value.isUnknown()) {
                if (this.options.isGuessSizeOfUnknownMemorySize()) {
                    currentState = valueAndState.getSmgState();
                    SMGAbstractObjectAndState.SMGExplicitValueAndState forcedValueAndState = this.expressionEvaluator.forceExplicitValue(currentState, cfaEdge, sizeExpr);
                    List<SMGAbstractObjectAndState.SMGExplicitValueAndState> forcedvalueAndStates = this.evaluateExplicitValue(currentState = forcedValueAndState.getSmgState(), cfaEdge, sizeExpr);
                    if (forcedvalueAndStates.size() != 1) {
                        throw new SMGInconsistentException("Found abstraction where non should exist,due to the expression " + sizeExpr.toASTString() + "already being evaluated once in this transferrelation step.");
                    }
                    resultValueAndState = forcedvalueAndStates.get(0);
                    value = (SMGExplicitValue)resultValueAndState.getObject();
                    if (value.isUnknown()) {
                        if (kind != SMGTransferRelationKind.REFINEMENT) throw new UnsupportedCodeException("Not able to compute allocation size", cfaEdge);
                        resultValueAndState = SMGAbstractObjectAndState.SMGExplicitValueAndState.of(currentState, SMGZeroValue.INSTANCE);
                    }
                } else {
                    if (kind != SMGTransferRelationKind.REFINEMENT) throw new UnsupportedCodeException("Not able to compute allocation size", cfaEdge);
                    resultValueAndState = SMGAbstractObjectAndState.SMGExplicitValueAndState.of(currentState, SMGZeroValue.INSTANCE);
                }
            }
            result.add(resultValueAndState);
        }
        return result;
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateConfigurableAllocationFunction(CFunctionCallExpression functionCall, SMGState pState, CFAEdge cfaEdge, SMGTransferRelationKind kind) throws CPATransferException {
        String functionName = functionCall.getFunctionNameExpression().toASTString();
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>();
        for (SMGAbstractObjectAndState.SMGExplicitValueAndState sizeAndState : this.getAllocateFunctionSize(pState, cfaEdge, functionCall, kind)) {
            int size = ((SMGExplicitValue)sizeAndState.getObject()).getAsInt();
            SMGState currentState = sizeAndState.getSmgState();
            String allocation_label = functionName + "_ID" + SMGCPA.getNewValue() + "_Line:" + functionCall.getFileLocation().getStartingLineNumber();
            SMGEdgePointsTo new_address = currentState.addNewHeapAllocation(size * this.machineModel.getSizeofCharInBits(), allocation_label);
            SMGState newState = currentState;
            if (this.options.getZeroingMemoryAllocation().contains((Object)functionName)) {
                newState = this.expressionEvaluator.writeValue(currentState, new_address.getObject(), 0L, TypeUtils.createTypeWithLength(size * this.machineModel.getSizeofCharInBits()), SMGZeroValue.INSTANCE, cfaEdge);
            }
            result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(newState, new_address));
            if (!this.options.isEnableMallocFailure()) continue;
            result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(currentState.copyOf(), SMGZeroValue.INSTANCE));
        }
        return result;
    }

    public final List<SMGState> evaluateFree(CFunctionCallExpression pFunctionCall, SMGState pState, CFAEdge cfaEdge) throws CPATransferException {
        CExpression pointerExp;
        try {
            pointerExp = pFunctionCall.getParameterExpressions().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Built-in free(): No parameter passed", cfaEdge, pFunctionCall);
        }
        ArrayList<SMGState> resultStates = new ArrayList<SMGState>();
        for (SMGAbstractObjectAndState.SMGAddressValueAndState addressAndState : this.expressionEvaluator.evaluateAddress(pState, cfaEdge, pointerExp)) {
            SMGAddressValue address = addressAndState.getObject();
            SMGState currentState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                this.logger.log(Level.INFO, new Object[]{"Free on expression ", pointerExp.toASTString(), " is invalid, because the target of the address could not be calculated."});
                SMGState invalidFreeState = currentState.withInvalidFree().withErrorDescription("Free on expression " + pointerExp.toASTString() + " is invalid, because the target of the address could not be calculated.");
                resultStates.add(invalidFreeState);
                continue;
            }
            if (address.isZero()) {
                this.logger.log(Level.INFO, new Object[]{pFunctionCall.getFileLocation(), ":", "The argument of a free invocation:", cfaEdge.getRawStatement(), "is 0"});
            } else {
                currentState = currentState.free(address.getOffset().getAsInt(), address.getObject());
            }
            resultStates.add(currentState);
        }
        return resultStates;
    }

    boolean isABuiltIn(String functionName) {
        return this.BUILTINS.contains(functionName) || this.isNondetBuiltin(functionName) || this.isConfigurableAllocationFunction(functionName) || this.isDeallocationFunction(functionName) || this.isExternalAllocationFunction(functionName);
    }

    private boolean isNondetBuiltin(String pFunctionName) {
        return pFunctionName.startsWith(NONDET_PREFIX) || pFunctionName.equals("nondet_int");
    }

    boolean isConfigurableAllocationFunction(String functionName) {
        return this.options.getMemoryAllocationFunctions().contains((Object)functionName) || this.options.getArrayAllocationFunctions().contains((Object)functionName);
    }

    boolean isDeallocationFunction(String functionName) {
        return this.options.getDeallocationFunctions().contains((Object)functionName);
    }

    private boolean isExternalAllocationFunction(String functionName) {
        return this.options.getExternalAllocationFunction().contains((Object)functionName);
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateMemcpy(CFunctionCallExpression pFunctionCall, SMGState pSmgState, CFAEdge pCfaEdge) throws CPATransferException {
        CExpression sizeExpr;
        CExpression sourceStr2Expr;
        CExpression targetStr1Expr;
        try {
            targetStr1Expr = pFunctionCall.getParameterExpressions().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Memcpy target argument not found.", pCfaEdge, pFunctionCall);
        }
        try {
            sourceStr2Expr = pFunctionCall.getParameterExpressions().get(1);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Memcpy source argument not found.", pCfaEdge, pFunctionCall);
        }
        try {
            sizeExpr = pFunctionCall.getParameterExpressions().get(2);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Memcpy count argument not found.", pCfaEdge, pFunctionCall);
        }
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>(4);
        for (SMGAbstractObjectAndState.SMGAddressValueAndState targetStr1AndState : this.evaluateAddress(pSmgState, pCfaEdge, targetStr1Expr)) {
            for (SMGAbstractObjectAndState.SMGAddressValueAndState sourceStr2AndState : this.evaluateAddress(targetStr1AndState.getSmgState(), pCfaEdge, sourceStr2Expr)) {
                for (SMGAbstractObjectAndState.SMGExplicitValueAndState sizeValueAndState : this.evaluateExplicitValue(sourceStr2AndState.getSmgState(), pCfaEdge, sizeExpr)) {
                    SMGState currentState = sizeValueAndState.getSmgState();
                    SMGAddressValue targetObject = targetStr1AndState.getObject();
                    SMGAddressValue sourceObject = sourceStr2AndState.getObject();
                    SMGExplicitValue explicitSizeValue = (SMGExplicitValue)sizeValueAndState.getObject();
                    if (!targetObject.isUnknown() && !sourceObject.isUnknown()) {
                        CType expressionType = sizeExpr.getExpressionType();
                        SMGType symbolicValueSMGType = SMGType.constructSMGType(expressionType, currentState, pCfaEdge, this.expressionEvaluator);
                        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : this.evaluateExpressionValue(currentState, pCfaEdge, sizeExpr)) {
                            SMGValue symbolicValue = (SMGValue)sMGValueAndState.getObject();
                            long sourceRangeOffset = sourceObject.getOffset().getAsLong() / (long)this.machineModel.getSizeofCharInBits();
                            long sourceSize = sourceObject.getObject().getSize() / (long)this.machineModel.getSizeofCharInBits();
                            long availableSource = sourceSize - sourceRangeOffset;
                            long targetRangeOffset = targetObject.getOffset().getAsLong() / (long)this.machineModel.getSizeofCharInBits();
                            long targetSize = targetObject.getObject().getSize() / (long)this.machineModel.getSizeofCharInBits();
                            long availableTarget = targetSize - targetRangeOffset;
                            if (!explicitSizeValue.isUnknown() || symbolicValue.isUnknown()) continue;
                            if (!currentState.getHeap().isObjectExternallyAllocated(sourceObject.getObject())) {
                                currentState.addErrorPredicate(symbolicValue, symbolicValueSMGType, SMGKnownExpValue.valueOf(availableSource), pCfaEdge);
                            }
                            if (currentState.getHeap().isObjectExternallyAllocated(targetObject.getObject())) continue;
                            currentState.addErrorPredicate(symbolicValue, symbolicValueSMGType, SMGKnownExpValue.valueOf(availableTarget), pCfaEdge);
                        }
                    }
                    result.add(this.evaluateMemcpy(currentState, targetObject, sourceObject, explicitSizeValue));
                }
            }
        }
        return result;
    }

    private SMGAbstractObjectAndState.SMGAddressValueAndState evaluateMemcpy(SMGState currentState, SMGAddressValue targetStr1Address, SMGAddressValue sourceStr2Address, SMGExplicitValue sizeValue) throws SMGInconsistentException {
        if (targetStr1Address.isUnknown() || sourceStr2Address.isUnknown() || sizeValue.isUnknown()) {
            if (!currentState.isTrackPredicatesEnabled()) {
                currentState = sizeValue.isUnknown() ? currentState.withInvalidWrite().withInvalidRead().withErrorDescription("Can't evaluate memcpy dst and src") : (targetStr1Address.isUnknown() ? currentState.withInvalidWrite().withErrorDescription("Can't evaluate memcpy dst") : currentState.withInvalidRead().withErrorDescription("Can't evaluate memcpy src"));
            }
            if (!sourceStr2Address.isUnknown() && sourceStr2Address.getObject().equals(SMGNullObject.INSTANCE)) {
                currentState = currentState.withInvalidRead().withErrorDescription("Memcpy src is null pointer");
            }
            if (!targetStr1Address.isUnknown() && targetStr1Address.getObject().equals(SMGNullObject.INSTANCE)) {
                currentState = currentState.withInvalidWrite().withErrorDescription("Memcpy to null pointer dst");
            }
            if (targetStr1Address.isUnknown()) {
                currentState.unknownWrite();
            } else {
                currentState.writeUnknownValueInUnknownField(targetStr1Address.getAddress().getObject());
            }
            return SMGAbstractObjectAndState.SMGAddressValueAndState.of(currentState);
        }
        SMGObject source = sourceStr2Address.getObject();
        SMGObject target = targetStr1Address.getObject();
        long sourceOffset = sourceStr2Address.getOffset().getAsLong();
        long sourceLastCopyBitOffset = sizeValue.getAsLong() * (long)this.machineModel.getSizeofCharInBits() + sourceOffset;
        long targetOffset = targetStr1Address.getOffset().getAsLong();
        if (sourceLastCopyBitOffset > source.getSize()) {
            currentState = currentState.withInvalidRead().withErrorDescription("Overread on memcpy");
        } else if (targetOffset > target.getSize() - sizeValue.getAsLong() * (long)this.machineModel.getSizeofCharInBits()) {
            currentState = currentState.withInvalidWrite().withErrorDescription("Overwrite on memcpy");
        } else {
            currentState.copy(source, target, sourceOffset, sourceLastCopyBitOffset, targetOffset);
        }
        return SMGAbstractObjectAndState.SMGAddressValueAndState.of(currentState, targetStr1Address);
    }

    List<? extends SMGAbstractObjectAndState.SMGValueAndState> handleBuiltinFunctionCall(CFAEdge pCfaEdge, CFunctionCallExpression cFCExpression, String calledFunctionName, SMGState newState, SMGTransferRelationKind kind) throws CPATransferException {
        if (this.isExternalAllocationFunction(calledFunctionName)) {
            return this.evaluateExternalAllocation(cFCExpression, newState);
        }
        switch (calledFunctionName) {
            case "__builtin_alloca": {
                return this.evaluateAlloca(cFCExpression, newState, pCfaEdge, kind);
            }
            case "memset": {
                return this.evaluateMemset(cFCExpression, newState, pCfaEdge);
            }
            case "memcpy": {
                return this.evaluateMemcpy(cFCExpression, newState, pCfaEdge);
            }
            case "strcmp": {
                return this.evaluateStrcmp(cFCExpression, newState, pCfaEdge);
            }
            case "__VERIFIER_BUILTIN_PLOT": {
                this.evaluateVBPlot(cFCExpression, newState);
            }
            case "printf": {
                return ImmutableList.of((Object)SMGAbstractObjectAndState.SMGAddressValueAndState.of(newState));
            }
        }
        if (this.isNondetBuiltin(calledFunctionName)) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(newState));
        }
        throw new AssertionError((Object)("Unexpected function handled as a builtin: " + calledFunctionName));
    }

    private List<SMGAbstractObjectAndState.SMGValueAndState> evaluateStrcmp(CFunctionCallExpression pFunctionCall, SMGState pState, CFAEdge pCfaEdge) throws CPATransferException {
        if (pFunctionCall.getParameterExpressions().size() != 2) {
            throw new UnrecognizedCodeException("Strcmp needs exact 2 arguments", pCfaEdge);
        }
        CExpression firstArgumentExpr = pFunctionCall.getParameterExpressions().get(0);
        CExpression secondArgumentExpr = pFunctionCall.getParameterExpressions().get(1);
        ArrayList<SMGAbstractObjectAndState.SMGValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>();
        for (SMGAbstractObjectAndState.SMGAddressValueAndState firstValueAndState : this.evaluateAddress(pState, pCfaEdge, firstArgumentExpr)) {
            for (SMGAbstractObjectAndState.SMGAddressValueAndState secondValueAndState : this.evaluateAddress(firstValueAndState.getSmgState(), pCfaEdge, secondArgumentExpr)) {
                result.add(this.evaluateStrcmp(firstValueAndState.getObject(), secondValueAndState.getObject(), secondValueAndState.getSmgState()));
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SMGAbstractObjectAndState.SMGValueAndState evaluateStrcmp(SMGAddressValue firstSymbolic, SMGAddressValue secondSymbolic, SMGState pState) throws SMGInconsistentException {
        if (!this.allValuesAreDefined(firstSymbolic, secondSymbolic)) {
            return SMGAbstractObjectAndState.SMGValueAndState.of(pState, SMGUnknownValue.INSTANCE);
        }
        if (firstSymbolic.equals(secondSymbolic)) {
            return SMGAbstractObjectAndState.SMGValueAndState.of(pState, SMGZeroValue.INSTANCE);
        }
        SMGObject firstRegion = firstSymbolic.getObject();
        SMGObject secondRegion = secondSymbolic.getObject();
        if (firstRegion == null || secondRegion == null) {
            return SMGAbstractObjectAndState.SMGValueAndState.of(pState, SMGUnknownValue.INSTANCE);
        }
        int comp = 0;
        int offset = 0;
        SMGState state = pState;
        while (comp == 0) {
            SMGKnownExpValue expSecondValue;
            SMGAbstractObjectAndState.SMGValueAndState symFirstValueAndState = state.readValue(firstRegion, offset, this.machineModel.getSizeofCharInBits());
            SMGAbstractObjectAndState.SMGValueAndState symSecondValueAndState = symFirstValueAndState.getSmgState().readValue(secondRegion, offset, this.machineModel.getSizeofCharInBits());
            SMGValue symFirstValue = (SMGValue)symFirstValueAndState.getObject();
            SMGValue symSecondValue = (SMGValue)symSecondValueAndState.getObject();
            state = symSecondValueAndState.getSmgState();
            if (!this.allValuesAreDefined(symFirstValue, symSecondValue)) {
                return SMGAbstractObjectAndState.SMGValueAndState.of(pState, SMGUnknownValue.INSTANCE);
            }
            SMGKnownExpValue expFirstValue = state.getExplicit(symFirstValue);
            if (!this.allValuesAreDefined(expFirstValue, expSecondValue = state.getExplicit(symSecondValue))) {
                if (!symFirstValue.equals(symSecondValue)) return SMGAbstractObjectAndState.SMGValueAndState.of(pState, SMGUnknownValue.INSTANCE);
                comp = 0;
            } else {
                comp = expFirstValue.subtract(expSecondValue).getAsInt();
                if (((Object)expFirstValue).equals(SMGZeroValue.INSTANCE)) break;
            }
            offset += this.machineModel.getSizeofCharInBits();
        }
        if (comp == 0) {
            return SMGAbstractObjectAndState.SMGValueAndState.of(state, SMGZeroValue.INSTANCE);
        }
        SMGKnownSymbolicValue symbolicResult = SMGKnownSymValue.of();
        SMGState resultState = state.copyOf();
        resultState.putExplicit(symbolicResult, SMGKnownExpValue.valueOf(comp));
        return SMGAbstractObjectAndState.SMGValueAndState.of(resultState, symbolicResult);
    }

    private boolean allValuesAreDefined(SMGValue ... values) {
        for (SMGValue value : values) {
            if (value != null && !value.isUnknown()) continue;
            return false;
        }
        return true;
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> handleUnknownFunction(CFAEdge pCfaEdge, CFunctionCallExpression cFCExpression, String calledFunctionName, SMGState pState) throws CPATransferException, AssertionError {
        switch (this.options.getHandleUnknownFunctions()) {
            case STRICT: {
                if (!this.isSafeFunction(calledFunctionName)) {
                    throw new CPATransferException(String.format("Unknown function '%s' may be unsafe. See the cpa.smg.handleUnknownFunctions or cpa.smg.safeUnknownFunctionsPatterns", calledFunctionName));
                }
            }
            case ASSUME_SAFE: {
                return ImmutableList.of((Object)SMGAbstractObjectAndState.SMGAddressValueAndState.of(pState));
            }
            case ASSUME_EXTERNAL_ALLOCATED: {
                return this.expressionEvaluator.handleSafeExternFunction(cFCExpression, pState, pCfaEdge);
            }
        }
        throw new AssertionError((Object)("Unhandled enum value in switch: " + this.options.getHandleUnknownFunctions()));
    }

    private boolean isSafeFunction(String calledFunctionName) {
        if (this.safeUnknownFunctionCompiledPatterns == null) {
            ArrayList<Pattern> list = new ArrayList<Pattern>();
            for (String safeUnknownFunctionPattern : this.options.getSafeUnknownFunctionsPatterns()) {
                list.add(Pattern.compile(safeUnknownFunctionPattern));
            }
            this.safeUnknownFunctionCompiledPatterns = ImmutableList.copyOf(list);
        }
        for (Pattern safeUnknownFunctionPattern : this.safeUnknownFunctionCompiledPatterns) {
            if (!safeUnknownFunctionPattern.matcher(calledFunctionName).matches()) continue;
            return true;
        }
        return false;
    }

    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> handleFunctioncall(CFunctionCallExpression pFunctionCall, String functionName, SMGState pSmgState, CFAEdge pCfaEdge, SMGTransferRelationKind pKind) throws CPATransferException, AssertionError {
        if (this.isABuiltIn(functionName)) {
            if (this.isConfigurableAllocationFunction(functionName)) {
                return this.evaluateConfigurableAllocationFunction(pFunctionCall, pSmgState, pCfaEdge, pKind);
            }
            if (functionName.equals("realloc")) {
                return this.evaluateRealloc();
            }
            return this.handleBuiltinFunctionCall(pCfaEdge, pFunctionCall, functionName, pSmgState, pKind);
        }
        return this.handleUnknownFunction(pCfaEdge, pFunctionCall, functionName, pSmgState);
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateRealloc() throws CPATransferException {
        throw new CPATransferException("Unhandled realloc function");
    }
}

