/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopNeverOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithConcreteCex;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.AdditionalInfoConverter;
import org.sosy_lab.cpachecker.cpa.smg.AdditionalInfoExtractor;
import org.sosy_lab.cpachecker.cpa.smg.SMGAdditionalInfoConverter;
import org.sosy_lab.cpachecker.cpa.smg.SMGConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.smg.SMGExportDotOption;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.smg.SMGPredicateManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGStatistics;
import org.sosy_lab.cpachecker.cpa.smg.SMGStopOperator;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelationKind;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPrecision;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;

@Options(prefix="cpa.smg")
public class SMGCPA
implements ConfigurableProgramAnalysis,
ConfigurableProgramAnalysisWithConcreteCex,
ConfigurableProgramAnalysisWithAdditionalInfo,
StatisticsProvider {
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "NEVER", "END_BLOCK"}, description="which stop operator to use for the SMGCPA")
    private String stopType = "SEP";
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for the SMGCPA")
    private String mergeType = "SEP";
    private final SMGPredicateManager smgPredicateManager;
    private final BlockOperator blockOperator;
    private final MachineModel machineModel;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final CFA cfa;
    private final AssumptionToEdgeAllocator assumptionToEdgeAllocator;
    private final SMGOptions options;
    private final SMGExportDotOption exportOptions;
    private final SMGStatistics stats = new SMGStatistics();
    private SMGTransferRelationKind kind = SMGTransferRelationKind.STATIC;
    private SMGPrecision precision;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SMGCPA.class);
    }

    private SMGCPA(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.cfa = pCfa;
        this.machineModel = this.cfa.getMachineModel();
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.options = new SMGOptions(this.config);
        this.exportOptions = new SMGExportDotOption(this.options.getExportSMGFilePattern(), this.options.getExportSMGLevel());
        this.assumptionToEdgeAllocator = AssumptionToEdgeAllocator.create(this.config, this.logger, this.machineModel);
        this.blockOperator = new BlockOperator();
        pConfig.inject((Object)this.blockOperator);
        this.blockOperator.setCFA(this.cfa);
        this.precision = SMGPrecision.createStaticPrecision(this.options.isHeapAbstractionEnabled());
        this.smgPredicateManager = new SMGPredicateManager(this.config, this.logger, pShutdownNotifier);
    }

    public void enableRefinement(PathTemplate pNewPathTemplate) {
        this.exportOptions.changeToRefinement(pNewPathTemplate);
        this.kind = SMGTransferRelationKind.REFINEMENT;
        this.precision = SMGPrecision.createRefineablePrecision(this.precision);
    }

    public SMGOptions getOptions() {
        return this.options;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return DelegateAbstractDomain.getInstance();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new SMGTransferRelation(this.logger, this.machineModel, this.exportOptions, this.kind, this.smgPredicateManager, this.options, this.shutdownNotifier);
    }

    @Override
    public MergeOperator getMergeOperator() {
        switch (this.mergeType) {
            case "SEP": {
                return MergeSepOperator.getInstance();
            }
            case "JOIN": {
                return new MergeJoinOperator(this.getAbstractDomain());
            }
        }
        throw new AssertionError((Object)"unknown mergetype for SMGCPA");
    }

    @Override
    public StopOperator getStopOperator() {
        switch (this.stopType) {
            case "END_BLOCK": {
                return new SMGStopOperator(this.getAbstractDomain());
            }
            case "NEVER": {
                return StopNeverOperator.getInstance();
            }
            case "SEP": {
                return new StopSepOperator(this.getAbstractDomain());
            }
        }
        throw new AssertionError((Object)"unknown stoptype for SMGCPA");
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return new SMGPrecisionAdjustment(this.logger, this.exportOptions, this.blockOperator, this.stats);
    }

    @Override
    public UnmodifiableSMGState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        SMGState initState = new SMGState(this.logger, this.machineModel, this.options);
        try {
            initState.performConsistencyCheck(SMGRuntimeCheck.FULL);
        }
        catch (SMGInconsistentException exc) {
            throw new AssertionError((Object)exc);
        }
        if (pNode instanceof CFunctionEntryNode) {
            CFunctionEntryNode functionNode = (CFunctionEntryNode)pNode;
            try {
                initState.addStackFrame(functionNode.getFunctionDefinition());
                initState.performConsistencyCheck(SMGRuntimeCheck.FULL);
            }
            catch (SMGInconsistentException exc) {
                throw new AssertionError((Object)exc);
            }
        }
        return initState;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    @Override
    public ConcreteStatePath createConcreteStatePath(ARGPath pPath) {
        return new SMGConcreteErrorPathAllocator(this.assumptionToEdgeAllocator).allocateAssignmentsToPath(pPath);
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public CFA getCFA() {
        return this.cfa;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    public SMGPredicateManager getPredicateManager() {
        return this.smgPredicateManager;
    }

    public BlockOperator getBlockOperator() {
        return this.blockOperator;
    }

    public void nextRefinement() {
        this.exportOptions.nextRefinement();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    @Override
    public AdditionalInfoConverter exportAdditionalInfoConverter() {
        return new SMGAdditionalInfoConverter();
    }

    @Override
    public CFAPathWithAdditionalInfo createExtendedInfo(ARGPath pPath) {
        return new AdditionalInfoExtractor().createExtendedInfo(pPath);
    }

    public static int getNewValue() {
        return idGenerator.getFreshId() + 1;
    }
}

