/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.AssumptionToEdgeAllocator;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.value.refiner.ConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.util.Pair;

public class SMGConcreteErrorPathAllocator
extends ConcreteErrorPathAllocator<SMGState> {
    private static final String MEMORY_NAME = "SMG_Analysis_Heap";

    public SMGConcreteErrorPathAllocator(AssumptionToEdgeAllocator pAssumptionToEdgeAllocator) {
        super(SMGState.class, pAssumptionToEdgeAllocator);
    }

    @Override
    protected ConcreteStatePath createConcreteStatePath(List<Pair<SMGState, List<CFAEdge>>> pPath) {
        ArrayList<ConcreteStatePath.ConcreteStatePathNode> result = new ArrayList<ConcreteStatePath.ConcreteStatePathNode>();
        SMGObjectAddressMap variableAddresses = new SMGObjectAddressMap();
        for (Pair<SMGState, List<CFAEdge>> edgeStatePair : pPath) {
            SMGState pSMGState = edgeStatePair.getFirst();
            List<CFAEdge> edges = edgeStatePair.getSecond();
            if (edges.size() > 1) {
                Iterator it = Lists.reverse(edges).iterator();
                ArrayList<ConcreteStatePath.IntermediateConcreteState> intermediateStates = new ArrayList<ConcreteStatePath.IntermediateConcreteState>();
                HashSet<CLeftHandSide> alreadyAssigned = new HashSet<CLeftHandSide>();
                while (it.hasNext()) {
                    CFAEdge innerEdge = (CFAEdge)it.next();
                    ConcreteState state = this.createConcreteState(variableAddresses, pSMGState, alreadyAssigned, innerEdge);
                    if (it.hasNext()) {
                        intermediateStates.add(new ConcreteStatePath.IntermediateConcreteState(innerEdge, state));
                        continue;
                    }
                    result.addAll(Lists.reverse(intermediateStates));
                    result.add(new ConcreteStatePath.SingleConcreteState(innerEdge, state));
                }
                continue;
            }
            result.add(new ConcreteStatePath.SingleConcreteState((CFAEdge)Iterables.getOnlyElement(edges), new ConcreteState((Map<LeftHandSide, Object>)ImmutableMap.of(), this.allocateAddresses(pSMGState, variableAddresses), variableAddresses.getAddressMap(), exp -> MEMORY_NAME)));
        }
        return new ConcreteStatePath(result);
    }

    private ConcreteState createConcreteState(SMGObjectAddressMap variableAddresses, SMGState pSMGState, Set<CLeftHandSide> alreadyAssigned, CFAEdge innerEdge) {
        CStatement stmt;
        ConcreteState state = this.allValuesForLeftHandSideKnown(innerEdge, alreadyAssigned) ? new ConcreteState((Map<LeftHandSide, Object>)ImmutableMap.of(), this.allocateAddresses(pSMGState, variableAddresses), variableAddresses.getAddressMap(), exp -> MEMORY_NAME) : ConcreteState.empty();
        if (innerEdge.getEdgeType() == CFAEdgeType.StatementEdge && (stmt = ((CStatementEdge)innerEdge).getStatement()) instanceof CAssignment) {
            CLeftHandSide lhs = ((CAssignment)stmt).getLeftHandSide();
            alreadyAssigned.add(lhs);
        }
        return state;
    }

    private boolean allValuesForLeftHandSideKnown(CFAEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        if (pCfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            return this.isDeclarationValueKnown((CDeclarationEdge)pCfaEdge, pAlreadyAssigned);
        }
        if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
            return this.isStatementValueKnown((CStatementEdge)pCfaEdge, pAlreadyAssigned);
        }
        return false;
    }

    private boolean isStatementValueKnown(CStatementEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CStatement stmt = pCfaEdge.getStatement();
        if (stmt instanceof CAssignment) {
            CLeftHandSide leftHandSide = ((CAssignment)stmt).getLeftHandSide();
            return this.isLeftHandSideValueKnown(leftHandSide, pAlreadyAssigned);
        }
        return false;
    }

    private Map<String, Memory> allocateAddresses(SMGState pSMGState, SMGObjectAddressMap pAdresses) {
        Map<Address, Object> values = this.createHeapValues(pSMGState, pAdresses);
        return ImmutableMap.of((Object)MEMORY_NAME, (Object)new Memory(MEMORY_NAME, values));
    }

    private Map<Address, Object> createHeapValues(SMGState pSMGState, SMGObjectAddressMap pAdresses) {
        HashMap<Address, Object> result = new HashMap<Address, Object>();
        for (SMGEdgeHasValue hvEdge : pSMGState.getHeap().getHVEdges()) {
            SMGValue symbolicValue = hvEdge.getValue();
            BigInteger value = null;
            if (symbolicValue.isZero()) {
                value = BigInteger.ZERO;
            } else if (pSMGState.getHeap().isPointer(symbolicValue)) {
                SMGEdgePointsTo pointer = pSMGState.getHeap().getPointer(symbolicValue);
                value = pAdresses.calculateAddress(pointer.getObject(), pointer.getOffset(), pSMGState).getAddressValue();
            } else {
                if (!pSMGState.isExplicit(symbolicValue)) continue;
                value = BigInteger.valueOf(pSMGState.getExplicit(symbolicValue).getAsLong());
            }
            Address address = pAdresses.calculateAddress(hvEdge.getObject(), hvEdge.getOffset(), pSMGState);
            result.put(address, value);
        }
        return result;
    }

    private static IDExpression createIDExpression(UnmodifiableCLangSMG smg, SMGObject pObject) {
        if (smg.getGlobalObjects().containsValue((Object)pObject)) {
            return new IDExpression(pObject.getLabel());
        }
        for (CLangStackFrame frame : smg.getStackFrames()) {
            if (!frame.getVariables().containsValue(pObject)) continue;
            return new IDExpression(pObject.getLabel(), frame.getFunctionDeclaration().getName());
        }
        return null;
    }

    public static class SMGObjectAddressMap {
        private final Map<SMGObject, Address> objectAddressMap = new HashMap<SMGObject, Address>();
        private Address nextAlloc = Address.valueOf(BigInteger.valueOf(100L));
        private final Map<LeftHandSide, Address> variableAddressMap = new HashMap<LeftHandSide, Address>();

        public Address calculateAddress(SMGObject pObject, long pOffset, SMGState pSMGState) {
            if (!this.objectAddressMap.containsKey(pObject)) {
                this.objectAddressMap.put(pObject, this.nextAlloc);
                IDExpression lhs = SMGConcreteErrorPathAllocator.createIDExpression(pSMGState.getHeap(), pObject);
                if (lhs != null) {
                    this.variableAddressMap.put(lhs, this.nextAlloc);
                }
                BigInteger objectSize = BigInteger.valueOf(pObject.getSize());
                BigInteger nextAllocOffset = this.nextAlloc.getAddressValue().add(objectSize).add(BigInteger.ONE);
                this.nextAlloc = this.nextAlloc.addOffset(nextAllocOffset);
            }
            return this.objectAddressMap.get(pObject).addOffset(BigInteger.valueOf(pOffset));
        }

        public Map<LeftHandSide, Address> getAddressMap() {
            return ImmutableMap.copyOf(this.variableAddressMap);
        }
    }
}

