/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;

class SMGErrorInfo {
    private final boolean invalidWrite;
    private final boolean invalidRead;
    private final boolean invalidFree;
    private final boolean hasMemoryLeak;
    private final String errorDescription;
    private final PersistentList<Object> invalidChain;
    private final PersistentList<Object> currentChain;

    private SMGErrorInfo(boolean pInvalidWrite, boolean pInvalidRead, boolean pInvalidFree, boolean pHasMemoryLeak, String pErrorDescription, PersistentList<Object> pInvalidChain, PersistentList<Object> pCurrentChain) {
        this.invalidWrite = pInvalidWrite;
        this.invalidRead = pInvalidRead;
        this.invalidFree = pInvalidFree;
        this.hasMemoryLeak = pHasMemoryLeak;
        this.errorDescription = pErrorDescription;
        this.invalidChain = pInvalidChain;
        this.currentChain = pCurrentChain;
    }

    static SMGErrorInfo of() {
        return new SMGErrorInfo(false, false, false, false, "", (PersistentList<Object>)PersistentLinkedList.of(), (PersistentList<Object>)PersistentLinkedList.of());
    }

    SMGErrorInfo withErrorMessage(String pErrorDescription) {
        return new SMGErrorInfo(this.invalidWrite, this.invalidRead, this.invalidFree, this.hasMemoryLeak, pErrorDescription, this.invalidChain, this.currentChain);
    }

    SMGErrorInfo withProperty(SMGState.Property pProperty) {
        boolean pInvalidWrite = this.invalidWrite;
        boolean pInvalidRead = this.invalidRead;
        boolean pInvalidFree = this.invalidFree;
        boolean pHasLeaks = this.hasMemoryLeak;
        switch (pProperty) {
            case INVALID_WRITE: {
                pInvalidWrite = true;
                break;
            }
            case INVALID_READ: {
                pInvalidRead = true;
                break;
            }
            case INVALID_FREE: {
                pInvalidFree = true;
                break;
            }
            case INVALID_HEAP: {
                pHasLeaks = true;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new SMGErrorInfo(pInvalidWrite, pInvalidRead, pInvalidFree, pHasLeaks, this.errorDescription, this.invalidChain, this.currentChain);
    }

    boolean hasMemoryErrors() {
        return this.invalidWrite || this.invalidRead || this.invalidFree || this.hasMemoryLeak;
    }

    SMGErrorInfo mergeWith(SMGErrorInfo pOther) {
        return new SMGErrorInfo(this.invalidWrite || pOther.invalidWrite, this.invalidRead || pOther.invalidRead, this.invalidFree || pOther.invalidFree, this.hasMemoryLeak || pOther.hasMemoryLeak, this.errorDescription, this.invalidChain, this.currentChain);
    }

    SMGErrorInfo withClearChain() {
        return new SMGErrorInfo(this.invalidWrite, this.invalidRead, this.invalidFree, this.hasMemoryLeak, this.errorDescription, (PersistentList<Object>)PersistentLinkedList.of(), (PersistentList<Object>)PersistentLinkedList.of());
    }

    SMGErrorInfo moveCurrentChainToInvalidChain() {
        return new SMGErrorInfo(this.invalidWrite, this.invalidRead, this.invalidFree, this.hasMemoryLeak, this.errorDescription, (PersistentList<Object>)this.invalidChain.withAll(this.currentChain), this.currentChain);
    }

    public SMGErrorInfo withObject(Object o) {
        return new SMGErrorInfo(this.invalidWrite, this.invalidRead, this.invalidFree, this.hasMemoryLeak, this.errorDescription, this.invalidChain, (PersistentList<Object>)this.currentChain.with(o));
    }

    SMGErrorInfo withInvalidObject(SMGObject pSmgObject) {
        return this.withInvalidObjects(Collections.singleton(pSmgObject));
    }

    public SMGErrorInfo withInvalidObjects(Collection<?> pObjects) {
        return new SMGErrorInfo(this.invalidWrite, this.invalidRead, this.invalidFree, this.hasMemoryLeak, this.errorDescription, (PersistentList<Object>)this.invalidChain.withAll(new ArrayList(pObjects)), this.currentChain);
    }

    public int hashCode() {
        return Objects.hash(this.invalidWrite, this.invalidRead, this.invalidFree, this.hasMemoryLeak, this.invalidChain, this.currentChain);
    }

    public boolean equals(Object pOther) {
        if (!(pOther instanceof SMGErrorInfo)) {
            return false;
        }
        SMGErrorInfo o = (SMGErrorInfo)pOther;
        return this.invalidWrite == o.invalidWrite && this.invalidRead == o.invalidRead && this.invalidFree == o.invalidFree && this.hasMemoryLeak == o.hasMemoryLeak && this.invalidChain.equals(o.invalidChain) && this.currentChain.equals(o.currentChain);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ErrorInfo {");
        str.append(this.errorDescription.isEmpty() ? "<>" : this.errorDescription).append(", ");
        if (this.invalidWrite) {
            str.append("invalid write").append(", ");
        }
        if (this.invalidRead) {
            str.append("invalid read").append(", ");
        }
        if (this.isInvalidFree()) {
            str.append("invalid free").append(", ");
        }
        if (this.hasMemoryLeak()) {
            str.append("has memory leak").append(", ");
        }
        return str.append("}").toString();
    }

    String getErrorDescription() {
        return this.errorDescription;
    }

    boolean isInvalidWrite() {
        return this.invalidWrite;
    }

    boolean isInvalidRead() {
        return this.invalidRead;
    }

    boolean isInvalidFree() {
        return this.invalidFree;
    }

    boolean hasMemoryLeak() {
        return this.hasMemoryLeak;
    }

    List<Object> getCurrentChain() {
        return this.currentChain;
    }

    List<Object> getInvalidChain() {
        return this.invalidChain;
    }
}

