/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.nio.file.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;

public class SMGExportDotOption {
    private static final SMGExportDotOption NO_EXPORT = new SMGExportDotOption(null, SMGOptions.SMGExportLevel.NEVER);
    private final SMGOptions.SMGExportLevel exportSMG;
    private PathTemplate exportSMGFilePattern;
    private boolean isRefinement;
    private int refinement_id;

    public SMGExportDotOption(PathTemplate pExportSMGFilePattern, SMGOptions.SMGExportLevel pExportSMG) {
        this.exportSMGFilePattern = pExportSMGFilePattern;
        this.exportSMG = pExportSMG;
    }

    public PathTemplate getExportSMGFilePattern() {
        return this.exportSMGFilePattern;
    }

    public void exportSMGSeperatedByRefinements(PathTemplate pExportSMGFilePattern) {
        this.exportSMGFilePattern = pExportSMGFilePattern;
        this.refinement_id = 0;
    }

    public void nextRefinement() {
        ++this.refinement_id;
    }

    public boolean exportSMG(SMGOptions.SMGExportLevel pLevel) {
        return pLevel.compareTo(this.exportSMG) <= 0 && this.exportSMGFilePattern != null;
    }

    public String toString() {
        return "SMGExportDotOption [exportSMG=" + this.exportSMG + ", exportSMGFilePattern=" + this.exportSMGFilePattern + ", isRefinement=" + this.isRefinement + ", refinement_counter=" + this.refinement_id + "]";
    }

    public Path getOutputFilePath(String pSMGName) {
        if (this.isRefinement) {
            return this.exportSMGFilePattern.getPath(new Object[]{this.refinement_id, pSMGName});
        }
        return this.exportSMGFilePattern.getPath(new Object[]{pSMGName});
    }

    public boolean hasExportPath() {
        return this.exportSMGFilePattern != null;
    }

    public static SMGExportDotOption getNoExportInstance() {
        return NO_EXPORT;
    }

    public void changeToRefinement(PathTemplate pNewPathTemplate) {
        this.exportSMGFilePattern = pNewPathTemplate;
        this.isRefinement = true;
        this.refinement_id = 0;
    }
}

