/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;

public final class SMGIntersectStates {
    private final UnmodifiableSMGState smgState1;
    private final UnmodifiableSMGState smgState2;
    private final UnmodifiableCLangSMG heap1;
    private final UnmodifiableCLangSMG heap2;
    private final SMGNodeMapping mapping1 = new SMGNodeMapping();
    private final SMGNodeMapping mapping2 = new SMGNodeMapping();
    private final Set<SMGEdgeHasValue> singleHveEdge1 = new HashSet<SMGEdgeHasValue>();
    private final Set<SMGEdgeHasValue> singleHveEdge2 = new HashSet<SMGEdgeHasValue>();
    private final CLangSMG destSMG;
    private PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> destExplicitValues = PersistentBiMap.of();

    public SMGIntersectStates(UnmodifiableSMGState pSmgState1, UnmodifiableSMGState pSmgState2) {
        this.smgState1 = pSmgState1;
        this.smgState2 = pSmgState2;
        this.heap1 = pSmgState1.getHeap();
        this.heap2 = pSmgState2.getHeap();
        this.mapping1.map(SMGNullObject.INSTANCE, SMGNullObject.INSTANCE);
        this.mapping2.map(SMGNullObject.INSTANCE, SMGNullObject.INSTANCE);
        this.destSMG = new CLangSMG(this.heap1.getMachineModel());
    }

    public SMGIntersectionResult intersect() {
        SMGRegion returnSMG2;
        SMGRegion returnSMG1;
        SMGObject finalObject;
        Sets.SetView localVars;
        CLangStackFrame frameInSMG2;
        Iterator<SMGEdgeHasValue> frameInSMG1;
        PersistentMap<String, SMGRegion> globals_in_smg1 = this.heap1.getGlobalObjects();
        PersistentMap<String, SMGRegion> globals_in_smg2 = this.heap2.getGlobalObjects();
        Sets.SetView globalVars = Sets.union(globals_in_smg1.keySet(), globals_in_smg2.keySet());
        for (String globalVar : globalVars) {
            SMGRegion globalInSMG1 = (SMGRegion)globals_in_smg1.get(globalVar);
            SMGRegion globalInSMG2 = (SMGRegion)globals_in_smg2.get(globalVar);
            SMGRegion finalObject2 = globalInSMG1;
            this.destSMG.addGlobalObject(finalObject2);
            this.mapping1.map(globalInSMG1, finalObject2);
            this.mapping2.map(globalInSMG2, finalObject2);
        }
        Iterator<CLangStackFrame> smg1stackIterator = this.heap1.getStackFrames().iterator();
        Iterator<CLangStackFrame> smg2stackIterator = this.heap2.getStackFrames().iterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            frameInSMG1 = smg1stackIterator.next();
            frameInSMG2 = smg2stackIterator.next();
            this.destSMG.addStackFrame(((CLangStackFrame)((Object)frameInSMG1)).getFunctionDeclaration());
            localVars = Sets.union(((CLangStackFrame)((Object)frameInSMG1)).getVariables().keySet(), frameInSMG2.getVariables().keySet());
            for (String localVar : localVars) {
                SMGRegion localInSMG1 = ((CLangStackFrame)((Object)frameInSMG1)).getVariable(localVar);
                SMGRegion localInSMG2 = frameInSMG2.getVariable(localVar);
                finalObject = localInSMG1;
                this.destSMG.addStackObject((SMGRegion)finalObject);
                this.mapping1.map(localInSMG1, finalObject);
                this.mapping2.map(localInSMG2, finalObject);
            }
            returnSMG1 = ((CLangStackFrame)((Object)frameInSMG1)).getReturnObject();
            returnSMG2 = frameInSMG2.getReturnObject();
            if (returnSMG1 == null) continue;
            SMGObject finalObject3 = this.destSMG.getFunctionReturnObject();
            this.mapping1.map(returnSMG1, finalObject3);
            this.mapping2.map(returnSMG2, finalObject3);
        }
        for (String globalVar : globalVars) {
            SMGObject finalObject4;
            Object globalInSMG2;
            SMGRegion globalInSMG1 = (SMGRegion)globals_in_smg1.get(globalVar);
            boolean defined = this.intersectPairFields(globalInSMG1, (SMGObject)(globalInSMG2 = (SMGRegion)globals_in_smg2.get(globalVar)), finalObject4 = this.mapping1.get(globalInSMG1));
            if (defined) continue;
            return SMGIntersectionResult.getNotDefinedInstance();
        }
        smg1stackIterator = this.heap1.getStackFrames().iterator();
        smg2stackIterator = this.heap2.getStackFrames().iterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            SMGObject finalObject5;
            boolean defined;
            frameInSMG1 = smg1stackIterator.next();
            frameInSMG2 = smg2stackIterator.next();
            localVars = Sets.union(((CLangStackFrame)((Object)frameInSMG1)).getVariables().keySet(), frameInSMG2.getVariables().keySet());
            for (String localVar : localVars) {
                SMGRegion localInSMG2;
                SMGRegion localInSMG1 = ((CLangStackFrame)((Object)frameInSMG1)).getVariable(localVar);
                boolean defined2 = this.intersectPairFields(localInSMG1, localInSMG2 = frameInSMG2.getVariable(localVar), finalObject = this.mapping1.get(localInSMG1));
                if (defined2) continue;
                return SMGIntersectionResult.getNotDefinedInstance();
            }
            returnSMG1 = ((CLangStackFrame)((Object)frameInSMG1)).getReturnObject();
            returnSMG2 = frameInSMG2.getReturnObject();
            if (returnSMG1 == null || (defined = this.intersectPairFields(returnSMG1, returnSMG2, finalObject5 = this.destSMG.getFunctionReturnObject()))) continue;
            return SMGIntersectionResult.getNotDefinedInstance();
        }
        for (SMGEdgeHasValue hve1 : this.singleHveEdge1) {
            this.intersectHveEdgeWithTop(hve1, this.heap1, this.smgState1, this.mapping1);
        }
        for (SMGEdgeHasValue hve2 : this.singleHveEdge2) {
            this.intersectHveEdgeWithTop(hve2, this.heap2, this.smgState2, this.mapping2);
        }
        SMGState pIntersectResult = this.smgState1.copyWith(this.destSMG, this.destExplicitValues);
        return new SMGIntersectionResult(this.smgState1, this.smgState2, pIntersectResult, true);
    }

    private void intersectHveEdgeWithTop(SMGEdgeHasValue pHve, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGNodeMapping pMapping) {
        SMGObject destObject = pMapping.get(pHve.getObject());
        SMGValue value = pHve.getValue();
        this.intersectValueWithTop(value, pSmg, pSmgState, pMapping);
        SMGValue destValue = pMapping.get(value);
        SMGEdgeHasValue destHve = new SMGEdgeHasValue(pHve.getSizeInBits(), pHve.getOffset(), destObject, destValue);
        this.destSMG.addHasValueEdge(destHve);
    }

    private void intersectValueWithTop(SMGValue pValue, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGNodeMapping pMapping) {
        if (pMapping.containsKey(pValue)) {
            return;
        }
        pMapping.map(pValue, pValue);
        SMGKnownSymbolicValue symVal = (SMGKnownSymbolicValue)pValue;
        if (pSmgState.isExplicit(symVal)) {
            this.destExplicitValues = this.destExplicitValues.putAndCopy(symVal, pSmgState.getExplicit(symVal));
        }
        if (pSmg.isPointer(pValue)) {
            this.intersectPointerWithTop(pSmg.getPointer(pValue), pSmg, pSmgState, pMapping);
        }
    }

    private void intersectPointerWithTop(SMGEdgePointsTo pPte, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGNodeMapping pMapping) {
        this.intersectObjectWithTop(pPte.getObject(), pSmg, pSmgState, pMapping);
        this.destSMG.addPointsToEdge(pPte);
    }

    private void intersectObjectWithTop(SMGObject pObject, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGNodeMapping pMapping) {
        if (pMapping.containsKey(pObject)) {
            return;
        }
        this.destSMG.addHeapObject(pObject);
        pMapping.map(pObject, pObject);
        for (SMGEdgeHasValue hve : pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject))) {
            this.intersectHveEdgeWithTop(hve, pSmg, pSmgState, pMapping);
        }
    }

    private boolean intersectPairFields(SMGObject pObject1, SMGObject pObject2, SMGObject pDestObject) {
        SMGHasValueEdges hves1 = this.heap1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject1));
        SMGHasValueEdges hves2 = this.heap2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject2));
        ImmutableMap offsetToHve1Map = Maps.uniqueIndex((Iterable)hves1, SMGEdge::getOffset);
        ImmutableMap offsetToHve2Map = Maps.uniqueIndex((Iterable)hves2, SMGEdge::getOffset);
        Sets.SetView offsetSet = Sets.union(offsetToHve1Map.keySet(), offsetToHve2Map.keySet());
        Iterator iterator = offsetSet.iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            if (offsetToHve1Map.containsKey(offset)) {
                SMGEdgeHasValue hve1;
                if (offsetToHve2Map.containsKey(offset)) {
                    SMGEdgeHasValue hve2;
                    hve1 = (SMGEdgeHasValue)offsetToHve1Map.get(offset);
                    boolean defined = this.intersectPairHveEdges(hve1, hve2 = (SMGEdgeHasValue)offsetToHve2Map.get(offset), pDestObject);
                    if (defined) continue;
                    return false;
                }
                hve1 = (SMGEdgeHasValue)offsetToHve1Map.get(offset);
                this.singleHveEdge1.add(hve1);
                continue;
            }
            SMGEdgeHasValue hve2 = (SMGEdgeHasValue)offsetToHve2Map.get(offset);
            this.singleHveEdge2.add(hve2);
        }
        return true;
    }

    private boolean intersectPairHveEdges(SMGEdgeHasValue pHve1, SMGEdgeHasValue pHve2, SMGObject pDestObject) {
        SMGValue value2;
        SMGValue value1 = pHve1.getValue();
        boolean defined = this.intersectValues(value1, value2 = pHve2.getValue());
        if (!defined) {
            return false;
        }
        SMGValue destValue = this.mapping1.get(value1);
        SMGEdgeHasValue destHveEdge = new SMGEdgeHasValue(pHve1.getSizeInBits(), pHve1.getOffset(), pDestObject, destValue);
        this.destSMG.addHasValueEdge(destHveEdge);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean intersectValues(SMGValue pValue1, SMGValue pValue2) {
        SMGEdgePointsTo pte2;
        SMGEdgePointsTo pte1;
        boolean defined;
        boolean containsValue1 = this.mapping1.containsKey(pValue1);
        boolean containsValue2 = this.mapping2.containsKey(pValue2);
        if (containsValue1 && containsValue2) {
            return this.mapping1.get(pValue1).equals(this.mapping2.get(pValue2));
        }
        if (containsValue1 || containsValue2) {
            return false;
        }
        SMGValue destValue = pValue1;
        this.mapping1.map(pValue1, destValue);
        this.mapping2.map(pValue2, destValue);
        this.destSMG.addValue(destValue);
        boolean isPointer1 = this.heap1.isPointer(pValue1);
        boolean isPointer2 = this.heap2.isPointer(pValue2);
        if (isPointer1 ^ isPointer2) {
            return false;
        }
        if (isPointer1 && isPointer2 && !(defined = this.intersectPairPointsToEdges(pte1 = this.heap1.getPointer(pValue1), pte2 = this.heap2.getPointer(pValue2), destValue))) {
            return false;
        }
        SMGKnownSymbolicValue symVal1 = (SMGKnownSymbolicValue)pValue1;
        SMGKnownSymbolicValue symVal2 = (SMGKnownSymbolicValue)pValue2;
        SMGKnownSymbolicValue symDestVal = symVal1;
        SMGExplicitValue expVal1 = SMGUnknownValue.INSTANCE;
        SMGExplicitValue expVal2 = SMGUnknownValue.INSTANCE;
        if (this.smgState1.isExplicit(symVal1)) {
            expVal1 = this.smgState1.getExplicit(symVal1);
        }
        if (this.smgState1.isExplicit(symVal2)) {
            expVal2 = this.smgState1.getExplicit(symVal2);
        }
        if (!expVal1.isUnknown() && !expVal2.isUnknown()) {
            if (!expVal1.equals(expVal2)) return false;
            this.destExplicitValues = this.destExplicitValues.putAndCopy(symDestVal, (SMGKnownExpValue)expVal1);
            return true;
        } else if (!expVal1.isUnknown()) {
            this.destExplicitValues = this.destExplicitValues.putAndCopy(symDestVal, (SMGKnownExpValue)expVal1);
            return true;
        } else {
            if (expVal2.isUnknown()) return true;
            this.destExplicitValues = this.destExplicitValues.putAndCopy(symDestVal, (SMGKnownExpValue)expVal2);
        }
        return true;
    }

    private boolean intersectPairPointsToEdges(SMGEdgePointsTo pPte1, SMGEdgePointsTo pPte2, SMGValue destValue) {
        SMGObject obj2;
        SMGTargetSpecifier tg2;
        long offset2;
        long offset1 = pPte1.getOffset();
        if (offset1 != (offset2 = pPte2.getOffset())) {
            return false;
        }
        SMGTargetSpecifier tg1 = pPte1.getTargetSpecifier();
        if (tg1 != (tg2 = pPte2.getTargetSpecifier())) {
            return false;
        }
        SMGObject obj1 = pPte1.getObject();
        boolean defined = this.intersectObjectPair(obj1, obj2 = pPte2.getObject());
        if (!defined) {
            return false;
        }
        SMGObject destObject = this.mapping1.get(obj1);
        SMGEdgePointsTo destPte = new SMGEdgePointsTo(destValue, destObject, offset1, tg1);
        this.destSMG.addPointsToEdge(destPte);
        return true;
    }

    private boolean intersectObjectPair(SMGObject pObj1, SMGObject pObj2) {
        boolean containsObject1 = this.mapping1.containsKey(pObj1);
        boolean containsObject2 = this.mapping2.containsKey(pObj2);
        if (containsObject1 && containsObject2) {
            return this.mapping1.get(pObj1).equals(this.mapping2.get(pObj2));
        }
        if (containsObject1 || containsObject2) {
            return false;
        }
        boolean match = SMGIntersectStates.matchObject(pObj1, pObj2);
        if (!match) {
            return false;
        }
        SMGObject destObject = SMGIntersectStates.getConcretestObject(pObj1, pObj2);
        this.mapping1.map(pObj1, destObject);
        this.mapping2.map(pObj2, destObject);
        this.destSMG.addHeapObject(destObject);
        boolean defined = this.intersectPairFields(pObj1, pObj2, destObject);
        return defined;
    }

    private static boolean matchObject(SMGObject pObj1, SMGObject pObj2) {
        if (pObj1.getSize() != pObj2.getSize()) {
            return false;
        }
        if (pObj1.getLevel() != pObj2.getLevel()) {
            return false;
        }
        if (pObj1.getKind() != pObj2.getKind()) {
            switch (pObj1.getKind()) {
                case OPTIONAL: {
                    switch (pObj2.getKind()) {
                        case REG: 
                        case DLL: 
                        case SLL: {
                            return true;
                        }
                    }
                    return false;
                }
                case REG: 
                case DLL: 
                case SLL: {
                    return pObj2.getKind() == SMGObjectKind.OPTIONAL;
                }
            }
            return false;
        }
        switch (pObj1.getKind()) {
            case DLL: {
                return ((SMGDoublyLinkedList)pObj1).matchSpecificShape((SMGDoublyLinkedList)pObj2);
            }
            case SLL: {
                return ((SMGSingleLinkedList)pObj1).matchSpecificShape((SMGSingleLinkedList)pObj2);
            }
            case GENERIC: {
                return pObj1.equals(pObj2);
            }
        }
        return true;
    }

    private static SMGObject getConcretestObject(SMGObject pObj1, SMGObject pObj2) {
        if (!pObj1.isAbstract()) {
            return pObj1;
        }
        if (!pObj2.isAbstract()) {
            return pObj2;
        }
        SMGObjectKind kind1 = pObj1.getKind();
        SMGObjectKind kind2 = pObj2.getKind();
        if (kind1 == SMGObjectKind.OPTIONAL) {
            return pObj2;
        }
        if (kind2 == SMGObjectKind.OPTIONAL) {
            return pObj1;
        }
        if (kind1 == kind2) {
            switch (kind1) {
                case DLL: {
                    int length1 = ((SMGDoublyLinkedList)pObj1).getMinimumLength();
                    int length2 = ((SMGDoublyLinkedList)pObj2).getMinimumLength();
                    return length1 < length2 ? pObj2 : pObj1;
                }
                case SLL: {
                    int length1 = ((SMGSingleLinkedList)pObj1).getMinimumLength();
                    int length2 = ((SMGSingleLinkedList)pObj2).getMinimumLength();
                    return length1 < length2 ? pObj2 : pObj1;
                }
            }
            return pObj1;
        }
        return pObj1;
    }

    public static class SMGIntersectionResult {
        private static final SMGIntersectionResult NOT_DEFINED = new SMGIntersectionResult(null, null, null, false);
        private final UnmodifiableSMGState smg1;
        private final UnmodifiableSMGState smg2;
        private final UnmodifiableSMGState combinationResult;
        private final boolean defined;

        public SMGIntersectionResult(UnmodifiableSMGState pSmg1, UnmodifiableSMGState pSmg2, UnmodifiableSMGState pJoinResult, boolean pDefined) {
            this.smg1 = pSmg1;
            this.smg2 = pSmg2;
            this.combinationResult = pJoinResult;
            this.defined = pDefined;
        }

        public UnmodifiableSMGState getSmg1() {
            return this.smg1;
        }

        public UnmodifiableSMGState getSmg2() {
            return this.smg2;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public UnmodifiableSMGState getCombinationResult() {
            return this.combinationResult;
        }

        public static SMGIntersectionResult getNotDefinedInstance() {
            return NOT_DEFINED;
        }
    }
}

