/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectVisitor;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.optional.SMGOptionalObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;

public final class SMGPlotter {
    private final Map<SMGObject, SMGObjectNode> objectIndex = new HashMap<SMGObject, SMGObjectNode>();
    private static int nulls = 0;
    private int offset = 0;

    public static void debuggingPlot(UnmodifiableCLangSMG pSmg, String pId, PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> explicitValues) throws IOException {
        PathTemplate exportSMGFilePattern = PathTemplate.ofFormatString((String)"smg-debug-%s.dot");
        pId = pId.replace("\"", "");
        Path outputFile = exportSMGFilePattern.getPath(new Object[]{pId});
        SMGPlotter plotter = new SMGPlotter();
        IO.writeFile((Path)outputFile, (Charset)Charset.defaultCharset(), (Object)plotter.smgAsDot(pSmg, pId, "debug plot", explicitValues));
    }

    public static String convertToValidDot(String original) {
        return CharMatcher.anyOf((CharSequence)"[]:").replaceFrom((CharSequence)original, (CharSequence)"_");
    }

    public String smgAsDot(UnmodifiableCLangSMG smg, String name, String location, PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> explicitValues) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph gr_").append(name.replace('-', '_')).append("{\n");
        this.offset += 2;
        sb.append(this.newLineWithOffset("label = \"" + location.replace("\"", "\\\"") + "\";"));
        sb.append(this.newLineWithOffset("rankdir=LR;"));
        this.addStackSubgraph(smg, sb);
        SMGNodeDotVisitor visitor = new SMGNodeDotVisitor(smg);
        for (SMGObject sMGObject : smg.getHeapObjects()) {
            if (!this.objectIndex.containsKey(sMGObject)) {
                this.objectIndex.put(sMGObject, sMGObject.accept(visitor));
            }
            if (sMGObject == SMGNullObject.INSTANCE) continue;
            sb.append(this.newLineWithOffset(this.objectIndex.get(sMGObject).getDefinition()));
        }
        this.addGlobalObjectSubgraph(smg, sb);
        for (SMGValue sMGValue : smg.getValues()) {
            if (sMGValue.isZero()) continue;
            sb.append(this.newLineWithOffset(SMGPlotter.smgValueAsDot(sMGValue, explicitValues)));
        }
        HashSet<SMGValue> processed = new HashSet<SMGValue>();
        for (SMGValue value : smg.getValues()) {
            if (value.isZero()) continue;
            for (SMGValue neqValue : smg.getNeqsForValue(value)) {
                if (processed.contains(neqValue)) continue;
                sb.append(this.newLineWithOffset(SMGPlotter.neqRelationAsDot(value, neqValue, explicitValues)));
            }
            processed.add(value);
        }
        HashBasedTable hashBasedTable = HashBasedTable.create();
        for (SMGEdge edge : smg.getHVEdges()) {
            LinkedHashSet<SMGEdgeHasValue> edges = (LinkedHashSet<SMGEdgeHasValue>)hashBasedTable.get((Object)edge.getObject(), (Object)edge.getValue());
            if (edges == null) {
                edges = new LinkedHashSet<SMGEdgeHasValue>();
                hashBasedTable.put((Object)edge.getObject(), (Object)edge.getValue(), edges);
            }
            edges.add((SMGEdgeHasValue)edge);
        }
        for (Table.Cell entry : hashBasedTable.cellSet()) {
            Object prefix = "";
            Object target = "value_" + ((SMGValue)entry.getColumnKey()).asDotId();
            if (((SMGValue)entry.getColumnKey()).isZero()) {
                String newNull = SMGPlotter.newNullLabel();
                prefix = newNull + "[shape=plaintext, label=\"NULL\"];";
                target = newNull;
            }
            ArrayList<String> labels = new ArrayList<String>();
            for (SMGEdgeHasValue edge : (Set)entry.getValue()) {
                labels.add(String.format("%db-%db", edge.getOffset(), edge.getOffset() + edge.getSizeInBits()));
            }
            sb.append(this.newLineWithOffset(String.format("%s%s -> %s [label=\"[%s]\"];", prefix, this.objectIndex.get(entry.getRowKey()).getName(), target, Joiner.on((String)", ").join(labels))));
        }
        for (SMGEdge edge : smg.getPTEdges()) {
            if (edge.getValue().isZero()) continue;
            sb.append(this.newLineWithOffset(this.smgPTEdgeAsDot((SMGEdgePointsTo)edge)));
        }
        sb.append("}");
        return sb.toString();
    }

    private void addStackSubgraph(UnmodifiableCLangSMG pSmg, StringBuilder pSb) {
        pSb.append(this.newLineWithOffset("subgraph cluster_stack {"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("label=\"Stack\";"));
        int i = pSmg.getStackFrames().size();
        for (CLangStackFrame stack_item : pSmg.getStackFrames()) {
            this.addStackItemSubgraph(stack_item, pSb, i);
            --i;
        }
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private void addStackItemSubgraph(CLangStackFrame pStackFrame, StringBuilder pSb, int pIndex) {
        pSb.append(this.newLineWithOffset("subgraph cluster_stack_" + pStackFrame.getFunctionDeclaration().getName() + " {"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("fontcolor=blue;"));
        pSb.append(this.newLineWithOffset("label=\"#" + pIndex + ": " + pStackFrame.getFunctionDeclaration().toASTString() + "\";"));
        LinkedHashMap<String, SMGRegion> to_print = new LinkedHashMap<String, SMGRegion>(pStackFrame.getVariables());
        SMGRegion returnObject = pStackFrame.getReturnObject();
        if (returnObject != null) {
            to_print.put("___cpa_temp_result_var_", returnObject);
        }
        pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot(to_print, String.valueOf(pIndex))));
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private String smgScopeFrameAsDot(Map<String, SMGRegion> pNamespace, String structId) {
        ArrayList<CallSite> nodes = new ArrayList<CallSite>();
        for (Map.Entry<String, SMGRegion> entry : pNamespace.entrySet()) {
            String key = entry.getKey();
            if (key.equals("node")) {
                key = "node1";
            }
            SMGObject obj = entry.getValue();
            nodes.add((CallSite)((Object)("<item_" + key + "> " + obj)));
            this.objectIndex.put(obj, new SMGObjectNode("struct" + structId + ":item_" + key));
        }
        return String.format("struct%s [shape=record, height=%.2f, label=\"%s\"];%n", structId, 0.5 * (double)nodes.size(), Joiner.on((String)" | ").join(nodes));
    }

    private void addGlobalObjectSubgraph(UnmodifiableCLangSMG pSmg, StringBuilder pSb) {
        if (pSmg.getGlobalObjects().size() > 0) {
            pSb.append(this.newLineWithOffset("subgraph cluster_global{"));
            this.offset += 2;
            pSb.append(this.newLineWithOffset("label=\"Global objects\";"));
            pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot((Map<String, SMGRegion>)pSmg.getGlobalObjects(), "global")));
            this.offset -= 2;
            pSb.append(this.newLineWithOffset("}"));
        }
    }

    private static String newNullLabel() {
        return "value_null_" + ++nulls;
    }

    private String smgPTEdgeAsDot(SMGEdgePointsTo pEdge) {
        String str = "value_" + pEdge.getValue().asDotId() + " -> ";
        SMGObjectNode oi = this.objectIndex.get(pEdge.getObject());
        str = oi != null ? str + oi.getName() : str + "\"<invalid object reference>\"";
        return str + "[label=\"+" + pEdge.getOffset() + "b, " + pEdge.getTargetSpecifier() + "\"];";
    }

    private static String smgValueAsDot(SMGValue value, PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> explicitValues) {
        Object label = "#" + value.asDotId();
        String color = "red";
        if (value instanceof SMGKnownExpValue) {
            label = value.toString();
            color = "green";
        } else if (explicitValues.containsKey(value)) {
            label = (String)label + " : " + explicitValues.get(value).getAsLong();
            color = "black";
        } else if (value instanceof SMGKnownAddressValue) {
            label = (String)label + "\\n" + ((SMGKnownAddressValue)value).getObject();
            color = "blue";
        }
        return String.format("value_%s[color=%s label=\"%s\"];", value.asDotId(), color, label);
    }

    private static String neqRelationAsDot(SMGValue v1, SMGValue v2, PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> explicitValues) {
        Object toNodeStr;
        Object toNode;
        if (v2.isZero()) {
            String newLabel = SMGPlotter.newNullLabel();
            toNode = newLabel;
            toNodeStr = newLabel + "[shape=plaintext, label=\"NULL\", fontcolor=\"red\"];";
        } else {
            toNodeStr = SMGPlotter.smgValueAsDot(v2, explicitValues);
            toNode = "value_" + v2.asDotId();
        }
        return String.format("%s%n  value_%s -> %s [color=\"red\", fontcolor=\"red\", label=\"neq\"];", toNodeStr, v1.asDotId(), toNode);
    }

    private String newLineWithOffset(String pLine) {
        return " ".repeat(this.offset) + pLine + "\n";
    }

    private static final class SMGNodeDotVisitor
    implements SMGObjectVisitor<SMGObjectNode> {
        private final UnmodifiableCLangSMG smg;

        public SMGNodeDotVisitor(UnmodifiableCLangSMG pSmg) {
            this.smg = pSmg;
        }

        private SMGObjectNode defaultNode(String label, SMGObject obj) {
            String color = this.smg.isObjectValid(obj) ? "blue" : "red";
            return new SMGObjectNode(label, this.defaultDefinition(color, "rectangle", "dashed", obj));
        }

        private String defaultDefinition(String pColor, String pShape, String pStyle, SMGObject pObject) {
            return "color=" + pColor + ", shape=" + pShape + ", style=" + pStyle + ", label =\"" + pObject + "\"";
        }

        @Override
        public SMGObjectNode visit(SMGRegion pRegion) {
            String color;
            String style;
            if (this.smg.isObjectValid(pRegion)) {
                style = "solid";
                color = "black";
            } else {
                style = "dotted";
                color = "red";
            }
            if (this.smg.isObjectExternallyAllocated(pRegion)) {
                color = "green";
            }
            return new SMGObjectNode("region", this.defaultDefinition(color, "rectangle", style, pRegion));
        }

        @Override
        public SMGObjectNode visit(SMGSingleLinkedList sll) {
            return this.defaultNode("sll", sll);
        }

        @Override
        public SMGObjectNode visit(SMGDoublyLinkedList dll) {
            return this.defaultNode("dll", dll);
        }

        @Override
        public SMGObjectNode visit(SMGOptionalObject opt) {
            return this.defaultNode("opt", opt);
        }

        @Override
        public SMGObjectNode visit(GenericAbstraction obj) {
            return this.defaultNode("abstraction", obj);
        }

        @Override
        public SMGObjectNode visit(SMGNullObject pObject) {
            return new SMGObjectNode("NULL");
        }
    }

    private static final class SMGObjectNode {
        private final String name;
        private final String definition;
        private static int counter = 0;

        public SMGObjectNode(String pType, String pDefinition) {
            this.name = "node_" + pType + "_" + counter++;
            this.definition = pDefinition;
        }

        public SMGObjectNode(String pName) {
            this.name = pName;
            this.definition = null;
        }

        public String getName() {
            return this.name;
        }

        public String getDefinition() {
            return this.name + "[" + this.definition + "];";
        }
    }
}

