/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.Function;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.smg.SMGExportDotOption;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGStatistics;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;

public class SMGPrecisionAdjustment
implements PrecisionAdjustment {
    private final SMGStatistics statistics;
    private final LogManager logger;
    private final SMGExportDotOption exportOptions;
    private final BlockOperator blockOperator;

    public SMGPrecisionAdjustment(LogManager pLogger, SMGExportDotOption pExportOptions, BlockOperator pBlockOperator, SMGStatistics pStats) {
        this.logger = pLogger;
        this.exportOptions = pExportOptions;
        this.blockOperator = pBlockOperator;
        this.statistics = pStats;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException {
        CFANode node = AbstractStates.extractLocation(pFullState);
        UnmodifiableSMGState state = (UnmodifiableSMGState)pState;
        state = state.copyWithBlockEnd(this.blockOperator.isBlockEnd(node, 0));
        return this.prec(state, (SMGPrecision)pPrecision, node);
    }

    private Optional<PrecisionAdjustmentResult> prec(UnmodifiableSMGState pState, SMGPrecision pPrecision, CFANode node) throws CPAException {
        boolean heapAbstractionChange;
        boolean fieldAbstractionChange;
        String description;
        String name;
        boolean stackAbstractionChange;
        boolean allowsFieldAbstraction = pPrecision.getAbstractionOptions().allowsFieldAbstraction();
        boolean allowsHeapAbstraction = pPrecision.allowsHeapAbstractionOnNode(node, this.blockOperator);
        boolean allowsStackAbstraction = pPrecision.getAbstractionOptions().allowsStackAbstraction();
        if (!(allowsFieldAbstraction || allowsHeapAbstraction || allowsStackAbstraction)) {
            return Optional.of(PrecisionAdjustmentResult.create(pState, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
        }
        this.statistics.totalAbstraction.start();
        UnmodifiableSMGState result = pState;
        SMGState newState = pState.copyOf();
        if (allowsStackAbstraction && (stackAbstractionChange = newState.forgetNonTrackedStackVariables(pPrecision.getTrackedStackVariablesOnNode(node)))) {
            name = String.format("%03d-%03d-after-stack-abstraction", result.getId(), newState.getId());
            description = "after-stack-abstraction-of-smg-" + result.getId();
            SMGUtils.plotWhenConfigured(name, newState, description, this.logger, SMGOptions.SMGExportLevel.EVERY, this.exportOptions);
            result = newState;
            this.logger.log(Level.ALL, new Object[]{"Precision adjustment on node ", node.getNodeNumber(), " with result state id: ", result.getId()});
        }
        if (allowsFieldAbstraction && (fieldAbstractionChange = newState.forgetNonTrackedHve(pPrecision.getTrackedMemoryPathsOnNode(node)))) {
            name = String.format("%03d-%03d-after-field-abstraction", result.getId(), newState.getId());
            description = "after-field-abstraction-of-smg-" + result.getId();
            SMGUtils.plotWhenConfigured(name, newState, description, this.logger, SMGOptions.SMGExportLevel.EVERY, this.exportOptions);
            result = newState;
            this.logger.log(Level.ALL, new Object[]{"Precision adjustment on node ", node.getNodeNumber(), " with result state id: ", result.getId()});
        }
        if (allowsHeapAbstraction && (heapAbstractionChange = newState.executeHeapAbstraction(pPrecision.getAbstractionBlocks(node)))) {
            name = String.format("%03d-before-heap-abstraction", result.getId());
            String name2 = String.format("%03d-after-heap-abstraction", result.getId());
            String description2 = "before-heap-abstraction-of-smg-" + result.getId();
            String description22 = "after-heap-abstraction-of-smg-" + result.getId();
            SMGUtils.plotWhenConfigured(name, result, description2, this.logger, SMGOptions.SMGExportLevel.EVERY, this.exportOptions);
            SMGUtils.plotWhenConfigured(name2, newState, description22, this.logger, SMGOptions.SMGExportLevel.EVERY, this.exportOptions);
            this.logger.log(Level.ALL, new Object[]{"Heap abstraction on node ", node.getNodeNumber(), " with state id: ", pState.getId()});
            result = newState;
        }
        this.statistics.totalAbstraction.stop();
        this.statistics.abstractions.inc();
        return Optional.of(PrecisionAdjustmentResult.create(result, pPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
    }
}

