/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGPredicateRelation;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.util.predicates.smt.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="cpa.smg")
public class SMGPredicateManager {
    @Option(secure=true, name="verifyPredicates", description="Allow SMG to check predicates")
    private boolean verifyPredicates = false;
    private final Configuration config;
    private final LogManager logger;
    private final Solver solver;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final BitvectorFormulaManagerView efmgr;
    private final Map<SMGValue, BitvectorFormula> createdValueFormulas;
    private final Map<SMGValue, SMGType> valueTypes;

    public SMGPredicateManager(Configuration pConfig, LogManager pLogger, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        this.config = pConfig;
        this.config.inject((Object)this);
        this.logger = pLogger;
        this.solver = Solver.create(pConfig, pLogger, shutdownNotifier);
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.efmgr = this.fmgr.getBitvectorFormulaManager();
        this.createdValueFormulas = new HashMap<SMGValue, BitvectorFormula>();
        this.valueTypes = new HashMap<SMGValue, SMGType>();
    }

    private BooleanFormula createBooleanFormula(Formula pFormulaOne, Formula pFormulaTwo, CBinaryExpression.BinaryOperator pOp) {
        switch (pOp) {
            case GREATER_THAN: {
                return this.fmgr.makeGreaterThan(pFormulaOne, pFormulaTwo, true);
            }
            case GREATER_EQUAL: {
                return this.fmgr.makeGreaterOrEqual(pFormulaOne, pFormulaTwo, true);
            }
            case LESS_THAN: {
                return this.fmgr.makeLessThan(pFormulaOne, pFormulaTwo, true);
            }
            case LESS_EQUAL: {
                return this.fmgr.makeLessOrEqual(pFormulaOne, pFormulaTwo, true);
            }
            case EQUALS: {
                return this.fmgr.makeEqual(pFormulaOne, pFormulaTwo);
            }
            case NOT_EQUALS: {
                return this.bfmgr.not(this.fmgr.makeEqual(pFormulaOne, pFormulaTwo));
            }
        }
        throw new AssertionError();
    }

    private BooleanFormula addPredicateToFormula(BooleanFormula pFormula, SMGPredicateRelation.ExplicitRelation pRelation, boolean conjunction) {
        BigInteger explicitValue = pRelation.getExplicitValue().getValue();
        SMGType symbolicSMGType = pRelation.getSymbolicSMGType();
        long explicitSize = symbolicSMGType.getCastedSize();
        CBinaryExpression.BinaryOperator op = pRelation.getOperator();
        BitvectorFormula explicitValueFormula = this.efmgr.makeBitvector(BigInteger.valueOf(explicitSize + 1L).intValueExact(), explicitValue);
        BitvectorFormula explicitValueFormulaCasted = this.efmgr.extract(explicitValueFormula, BigInteger.valueOf(explicitSize - 1L).intValueExact(), 0);
        BitvectorFormula symbolicValue = this.getCastedValue(pRelation.getSymbolicValue(), symbolicSMGType);
        BooleanFormula result = this.createBooleanFormula((Formula)symbolicValue, (Formula)explicitValueFormulaCasted, op);
        result = conjunction ? this.bfmgr.and(result, pFormula) : this.bfmgr.or(result, pFormula);
        return result;
    }

    private BitvectorFormula getCastedValue(SMGValue pSMGValue, SMGType pSMGType) {
        BitvectorFormula valueFormula = this.createdValueFormulas.get(pSMGValue);
        if (valueFormula == null) {
            long size = pSMGType.getOriginSize();
            boolean isSigned = pSMGType.isOriginSigned();
            valueFormula = this.efmgr.makeVariable(BigInteger.valueOf(size).intValueExact(), pSMGValue.toString());
            valueFormula = this.efmgr.extend(valueFormula, 0, isSigned);
            this.createdValueFormulas.put(pSMGValue, valueFormula);
            this.valueTypes.put(pSMGValue, pSMGType);
        }
        return this.cast(valueFormula, this.valueTypes.get(pSMGValue), pSMGType);
    }

    private BitvectorFormula cast(BitvectorFormula pVariableFormula, SMGType pFromSMGType, SMGType pToSMGType) {
        long fromSize = pFromSMGType.getOriginSize();
        boolean isFromSigned = pFromSMGType.isOriginSigned();
        long toSize = pToSMGType.getCastedSize();
        boolean isToSigned = pToSMGType.isCastedSigned();
        BitvectorFormula result = pVariableFormula;
        if (toSize > fromSize) {
            result = this.efmgr.extend(result, BigInteger.valueOf(toSize - fromSize).intValueExact(), isToSigned);
        } else if (toSize < fromSize) {
            result = this.efmgr.extract(result, BigInteger.valueOf(toSize - 1L).intValueExact(), 0);
        } else if (isToSigned != isFromSigned) {
            result = this.efmgr.extend(result, 0, isToSigned);
        }
        return result;
    }

    private BooleanFormula addPredicateToFormula(BooleanFormula pFormula, SMGPredicateRelation.SymbolicRelation pRelation, boolean conjunction) {
        BitvectorFormula formulaTwo;
        BitvectorFormula formulaOne;
        SMGType firstValSMGType = pRelation.getFirstValSMGType();
        long firstCastedSize = firstValSMGType.getCastedSize();
        SMGType secondValSMGType = pRelation.getSecondValSMGType();
        long secondCastedSize = secondValSMGType.getCastedSize();
        if (pRelation.getFirstValue().isZero()) {
            firstCastedSize = secondCastedSize;
            formulaOne = this.efmgr.makeBitvector(BigInteger.valueOf(firstCastedSize).intValueExact(), 0L);
        } else {
            formulaOne = this.getCastedValue(pRelation.getFirstValue(), firstValSMGType);
        }
        if (pRelation.getSecondValue().isZero()) {
            secondCastedSize = firstCastedSize;
            formulaTwo = this.efmgr.makeBitvector(BigInteger.valueOf(secondCastedSize).intValueExact(), 0L);
        } else {
            formulaTwo = this.getCastedValue(pRelation.getSecondValue(), secondValSMGType);
        }
        if (firstCastedSize > secondCastedSize) {
            formulaTwo = this.cast(formulaTwo, secondValSMGType, firstValSMGType);
        }
        if (secondCastedSize > firstCastedSize) {
            formulaOne = this.cast(formulaOne, firstValSMGType, secondValSMGType);
        }
        CBinaryExpression.BinaryOperator op = pRelation.getOperator();
        BooleanFormula result = this.createBooleanFormula((Formula)formulaOne, (Formula)formulaTwo, op);
        result = conjunction ? this.fmgr.makeAnd(pFormula, result) : this.fmgr.makeOr(pFormula, result);
        return result;
    }

    public BooleanFormula getPathPredicateFormula(UnmodifiableSMGState pState) {
        SMGPredicateRelation pRelation = pState.getPathPredicateRelation();
        BooleanFormula predicateFormula = this.getPredicateFormula(pRelation, true);
        predicateFormula = this.fmgr.makeAnd(predicateFormula, this.getExplicitFormulaFromState(pState));
        return predicateFormula;
    }

    public BooleanFormula getErrorPredicateFormula(SMGPredicateRelation pErrorPredicate, UnmodifiableSMGState pState) {
        BooleanFormula errorFormula = this.getPredicateFormula(pErrorPredicate, false);
        BooleanFormula pathFormula = this.getPathPredicateFormula(pState);
        pathFormula = this.fmgr.makeAnd(pathFormula, this.getExplicitFormulaFromState(pState));
        return this.fmgr.makeAnd(pathFormula, errorFormula);
    }

    private BooleanFormula getExplicitFormulaFromState(UnmodifiableSMGState pState) {
        BooleanFormula result = this.bfmgr.makeBoolean(true);
        if (!this.verifyPredicates) {
            return result;
        }
        SMGPredicateRelation errorPredicateRelation = pState.getErrorPredicateRelation();
        SMGPredicateRelation pathPredicateRelation = pState.getPathPredicateRelation();
        for (Map.Entry<SMGKnownSymbolicValue, SMGKnownExpValue> expValueEntry : pState.getExplicitValues()) {
            SMGKnownSymbolicValue symbolicValue = expValueEntry.getKey();
            if (!errorPredicateRelation.hasRelation(symbolicValue) && !pathPredicateRelation.hasRelation(symbolicValue)) continue;
            SMGKnownExpValue explicitValue = expValueEntry.getValue();
            BitvectorFormula valueFormula = this.createdValueFormulas.get(symbolicValue);
            SMGType symbolicType = this.valueTypes.get(symbolicValue);
            valueFormula = this.cast(valueFormula, symbolicType, symbolicType);
            BooleanFormula equality = this.fmgr.makeEqual(valueFormula, this.efmgr.makeBitvector(BigInteger.valueOf(symbolicType.getCastedSize()).intValueExact(), explicitValue.getValue()));
            result = this.fmgr.makeAnd(result, equality);
        }
        return result;
    }

    private BooleanFormula getPredicateFormula(SMGPredicateRelation pRelation, boolean conjunction) {
        BooleanFormula result = this.bfmgr.makeBoolean(conjunction);
        if (!this.verifyPredicates) {
            return result;
        }
        for (Map.Entry<SMGPredicateRelation.SMGValuesPair, ImmutableSet<SMGPredicateRelation.SymbolicRelation>> entry : pRelation.getValuesRelations()) {
            if (entry.getKey().getSecond().compareTo(entry.getKey().getFirst()) < 0) continue;
            ImmutableSet<SMGPredicateRelation.SymbolicRelation> values = entry.getValue();
            for (SMGPredicateRelation.SymbolicRelation value : values) {
                result = this.addPredicateToFormula(result, value, conjunction);
            }
        }
        for (SMGPredicateRelation.ExplicitRelation relation : pRelation.getExplicitRelations()) {
            result = this.addPredicateToFormula(result, relation, conjunction);
        }
        return result;
    }

    public boolean isUnsat(BooleanFormula pFormula) throws SolverException, InterruptedException {
        if (this.verifyPredicates && pFormula != null) {
            boolean result = this.solver.isUnsat(pFormula);
            if (result) {
                this.logger.log(Level.FINER, new Object[]{"Unsat: " + pFormula});
            }
            return result;
        }
        return false;
    }

    public boolean isErrorPathFeasible(UnmodifiableSMGState pState) {
        if (!this.verifyPredicates) {
            return false;
        }
        SMGPredicateRelation errorPredicate = pState.getErrorPredicateRelation();
        if (!errorPredicate.isEmpty()) {
            BooleanFormula errorPredicateFormula = this.getErrorPredicateFormula(errorPredicate, pState);
            try {
                if (!this.isUnsat(errorPredicateFormula)) {
                    this.logger.log(Level.FINER, new Object[]{"Sat: ", errorPredicateFormula});
                    return true;
                }
                return false;
            }
            catch (SolverException pE) {
                this.logger.log(Level.WARNING, new Object[]{"Solver Exception: " + pE + " on predicate " + errorPredicate});
            }
            catch (InterruptedException pE) {
                this.logger.log(Level.WARNING, new Object[]{"Solver Interrupted Exception: " + pE + " on predicate " + errorPredicate});
            }
        }
        return !errorPredicate.isEmpty();
    }
}

