/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGErrorInfo;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGPlotter;
import org.sosy_lab.cpachecker.cpa.smg.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smg.SMGStateInformation;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGPredicateRelation;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.optional.SMGOptionalObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGIsLessOrEqual;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoin;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPath;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGState
implements UnmodifiableSMGState,
AbstractQueryableState,
Graphable {
    private static final String HAS_INVALID_FREES = "has-invalid-frees";
    private static final String HAS_INVALID_READS = "has-invalid-reads";
    private static final String HAS_INVALID_WRITES = "has-invalid-writes";
    private static final String HAS_LEAKS = "has-leaks";
    private static final String HAS_HEAP_OBJECTS = "has-heap-objects";
    private static final Pattern externalAllocationRecursivePattern = Pattern.compile("^(r_)(\\d+)(_.*)$");
    private static final UniqueIdGenerator ID_COUNTER = new UniqueIdGenerator();
    private final int predecessorId;
    private final int id;
    private PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> explicitValues;
    private final CLangSMG heap;
    private final boolean blockEnded;
    private SMGErrorInfo errorInfo;
    private final LogManager logger;
    private final SMGOptions options;
    private final long sizeOfVoidPointerInBits;

    private void issueMemoryError(String pMessage, boolean pUndefinedBehavior) {
        if (this.options.isMemoryErrorTarget()) {
            this.logger.log(Level.FINE, new Object[]{pMessage});
        } else if (pUndefinedBehavior) {
            this.logger.log(Level.FINE, new Object[]{pMessage});
            this.logger.log(Level.FINE, new Object[]{"Non-target undefined behavior detected. The verification result is unreliable."});
        }
    }

    @Override
    public String getErrorDescription() {
        return this.errorInfo.getErrorDescription();
    }

    @Override
    public SMGState withErrorDescription(String pErrorDescription) {
        return new SMGState(this.logger, this.options, this.heap.copyOf(), this.id, this.explicitValues, this.errorInfo.withErrorMessage(pErrorDescription), this.blockEnded);
    }

    public SMGState(LogManager pLogger, MachineModel pMachineModel, SMGOptions pOptions) {
        this(pLogger, pOptions, new CLangSMG(pMachineModel), ID_COUNTER.getFreshId(), PersistentBiMap.of());
        this.explicitValues = this.explicitValues.putAndCopy(SMGZeroValue.INSTANCE, SMGZeroValue.INSTANCE);
    }

    public SMGState(LogManager pLogger, SMGOptions pOptions, CLangSMG pHeap, int pPredId, PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> pMergedExplicitValues) {
        this(pLogger, pOptions, pHeap, pPredId, pMergedExplicitValues, SMGErrorInfo.of(), false);
    }

    private SMGState(LogManager pLogger, SMGOptions pOptions, CLangSMG pHeap, int pPredId, PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> pExplicitValues, SMGErrorInfo pErrorInfo, boolean pBlockEnded) {
        this.options = pOptions;
        this.heap = pHeap;
        this.logger = pLogger;
        this.predecessorId = pPredId;
        this.id = ID_COUNTER.getFreshId();
        this.explicitValues = pExplicitValues;
        this.errorInfo = pErrorInfo;
        this.blockEnded = pBlockEnded;
        this.sizeOfVoidPointerInBits = this.heap.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID).longValueExact();
    }

    private SMGState(SMGState pOriginalState, Property pProperty) {
        this.heap = pOriginalState.heap.copyOf();
        this.logger = pOriginalState.logger;
        this.options = pOriginalState.options;
        this.predecessorId = pOriginalState.getId();
        this.id = ID_COUNTER.getFreshId();
        this.explicitValues = pOriginalState.explicitValues;
        this.blockEnded = pOriginalState.blockEnded;
        this.errorInfo = pOriginalState.errorInfo.withProperty(pProperty);
        this.sizeOfVoidPointerInBits = pOriginalState.sizeOfVoidPointerInBits;
    }

    @Override
    public SMGState copyOf() {
        return new SMGState(this.logger, this.options, this.heap.copyOf(), this.id, this.explicitValues, this.errorInfo, this.blockEnded);
    }

    @Override
    public SMGState copyWith(CLangSMG pSmg, PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> pValues) {
        return new SMGState(this.logger, this.options, pSmg, this.id, pValues, this.errorInfo, this.blockEnded);
    }

    @Override
    public SMGState copyWithBlockEnd(boolean isBlockEnd) {
        return new SMGState(this.logger, this.options, this.heap.copyOf(), this.id, this.explicitValues, this.errorInfo, isBlockEnd);
    }

    @Override
    public SMGState withViolationsOf(SMGState pOther) {
        if (this.errorInfo.equals(pOther.errorInfo)) {
            return this;
        }
        SMGState result = new SMGState(this.logger, this.options, this.heap, ID_COUNTER.getFreshId(), this.explicitValues);
        result.errorInfo = result.errorInfo.mergeWith(pOther.errorInfo);
        return result;
    }

    public SMGRegion addGlobalVariable(long pTypeSize, String pVarName) throws SMGInconsistentException {
        SMGRegion new_object = new SMGRegion(pTypeSize, pVarName);
        this.heap.addGlobalObject(new_object);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new_object;
    }

    public Optional<SMGObject> addLocalVariable(long pTypeSize, String pVarName) throws SMGInconsistentException {
        if (this.heap.getStackFrames().isEmpty()) {
            return Optional.empty();
        }
        SMGRegion new_object = new SMGRegion(pTypeSize, pVarName);
        this.heap.addStackObject(new_object);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return Optional.of(new_object);
    }

    public Optional<SMGRegion> addAnonymousVariable(long pTypeSize) throws SMGInconsistentException {
        if (this.heap.getStackFrames().isEmpty()) {
            return Optional.empty();
        }
        SMGRegion new_object = new SMGRegion(pTypeSize);
        this.heap.addStackObject(new_object);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return Optional.of(new_object);
    }

    public void addLocalVariable(long pTypeSize, String pVarName, SMGRegion smgObject) throws SMGInconsistentException {
        SMGRegion new_object2 = new SMGRegion(pTypeSize, pVarName);
        assert (smgObject.getLabel().equals(new_object2.getLabel()));
        assert (smgObject.getSize() == pTypeSize || smgObject.getSize() == (long)this.heap.getSizeofPtrInBits());
        this.heap.addStackObject(smgObject);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    public void addStackFrame(CFunctionDeclaration pFunctionDefinition) throws SMGInconsistentException {
        this.heap.addStackFrame(pFunctionDefinition);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final int getPredecessorId() {
        return this.predecessorId;
    }

    public final void performConsistencyCheck(SMGRuntimeCheck pLevel) throws SMGInconsistentException {
        if ((pLevel == null || this.options.getRuntimeCheck().isFinerOrEqualThan(pLevel)) && !CLangSMGConsistencyVerifier.verifyCLangSMG(this.logger, this.heap)) {
            throw new SMGInconsistentException(String.format("SMG was found inconsistent during a check on state id %d:%n%s", this.getId(), this));
        }
    }

    @Override
    public String toDot(String pName, String pLocation) {
        SMGPlotter plotter = new SMGPlotter();
        return plotter.smgAsDot(this.heap, pName, pLocation, this.explicitValues);
    }

    @Override
    public String toString() {
        String parent = this.getPredecessorId() == 0 ? "no parent, initial state" : "parent [" + this.getPredecessorId() + "]";
        return String.format("SMGState [%d] <-- %s: %s", this.getId(), parent, this.heap);
    }

    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> getPointerFromAddress(SMGAddress pAddress) throws SMGInconsistentException {
        if (pAddress.isUnknown()) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(this));
        }
        SMGObject target = pAddress.getObject();
        SMGExplicitValue offset = pAddress.getOffset();
        if (target instanceof SMGRegion) {
            SMGSymbolicValue address = this.getAddress((SMGRegion)target, offset.getAsLong());
            if (address == null) {
                return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(this, new SMGEdgePointsTo(SMGKnownSymValue.of(), target, offset.getAsLong())));
            }
            return this.getPointerFromValue(address);
        }
        if (target == SMGNullObject.INSTANCE) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(this, new SMGEdgePointsTo(SMGZeroValue.INSTANCE, target, offset.getAsLong())));
        }
        if (target.isAbstract()) {
            this.performConsistencyCheck(SMGRuntimeCheck.HALF);
            SMGKnownSymbolicValue symbolicValue = SMGKnownSymValue.of();
            this.heap.addValue(symbolicValue);
            return this.handleMaterilisation(new SMGEdgePointsTo(symbolicValue, target, offset.getAsLong(), SMGTargetSpecifier.FIRST), (SMGAbstractObject)((Object)target));
        }
        throw new AssertionError((Object)("Abstraction " + target + " was not materialised."));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> getPointerFromValue(SMGValue pValue) throws SMGInconsistentException {
        if (this.heap.isPointer(pValue)) {
            SMGEdgePointsTo addressValue = this.heap.getPointer(pValue);
            SMGObject obj = addressValue.getObject();
            if (obj.isAbstract()) {
                this.performConsistencyCheck(SMGRuntimeCheck.HALF);
                return this.handleMaterilisation(addressValue, (SMGAbstractObject)((Object)obj));
            }
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(this, addressValue));
        }
        throw new SMGInconsistentException("Asked for a Points-To edge for a non-pointer value");
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> handleMaterilisation(SMGEdgePointsTo pointerToAbstractObject, SMGAbstractObject pSmgAbstractObject) throws SMGInconsistentException {
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>(2);
        switch (pSmgAbstractObject.getKind()) {
            case DLL: {
                SMGDoublyLinkedList dllListSeg = (SMGDoublyLinkedList)pSmgAbstractObject;
                if (dllListSeg.getMinimumLength() == 0) {
                    result.addAll(this.copyOf().removeDls(dllListSeg, pointerToAbstractObject));
                }
                result.add(this.materialiseDls(dllListSeg, pointerToAbstractObject));
                break;
            }
            case SLL: {
                SMGSingleLinkedList sllListSeg = (SMGSingleLinkedList)pSmgAbstractObject;
                if (sllListSeg.getMinimumLength() == 0) {
                    result.addAll(this.copyOf().removeSll(sllListSeg, pointerToAbstractObject));
                }
                result.add(this.materialiseSll(sllListSeg, pointerToAbstractObject));
                break;
            }
            case OPTIONAL: {
                SMGOptionalObject optionalObject = (SMGOptionalObject)pSmgAbstractObject;
                result.addAll(this.copyOf().removeOptionalObject(optionalObject));
                result.add(this.materialiseOptionalObject(optionalObject, pointerToAbstractObject));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Materilization of abstraction" + pSmgAbstractObject + " not yet implemented.");
            }
        }
        return result;
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> removeOptionalObject(SMGOptionalObject pOptionalObject) throws SMGInconsistentException {
        this.logger.log(Level.ALL, new Object[]{"Remove ", pOptionalObject, " in state id ", this.getId()});
        Set<SMGEdgePointsTo> pointer = SMGUtils.getPointerToThisObject(pOptionalObject, this.heap);
        SMGHasValueEdges fields = this.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pOptionalObject));
        this.heap.markHeapObjectDeletedAndRemoveEdges(pOptionalObject);
        SMGValue pointerValue = SMGZeroValue.INSTANCE;
        for (SMGEdgeHasValue field : fields) {
            if (!this.heap.isPointer(field.getValue()) || field.getValue().isZero()) continue;
            pointerValue = field.getValue();
            break;
        }
        for (SMGEdgePointsTo edge : pointer) {
            this.heap.removePointsToEdge(edge.getValue());
            this.heap.replaceValue(pointerValue, edge.getValue());
        }
        return this.getPointerFromValue(pointerValue);
    }

    private SMGAbstractObjectAndState.SMGAddressValueAndState materialiseOptionalObject(SMGOptionalObject pOptionalObject, SMGEdgePointsTo pPointerToAbstractObject) {
        this.logger.log(Level.ALL, new Object[]{"Materialise ", pOptionalObject, " in state id ", this.getId()});
        Set<SMGEdgePointsTo> pointer = SMGUtils.getPointerToThisObject(pOptionalObject, this.heap);
        SMGHasValueEdges fields = this.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pOptionalObject));
        SMGRegion newObject = new SMGRegion(pOptionalObject.getSize(), "Concrete object of " + pOptionalObject, pOptionalObject.getLevel());
        this.heap.addHeapObject(newObject);
        this.heap.setValidity(newObject, this.heap.isObjectValid(pOptionalObject));
        this.heap.markHeapObjectDeletedAndRemoveEdges(pOptionalObject);
        for (SMGEdgeHasValue sMGEdgeHasValue : fields) {
            this.heap.addHasValueEdge(new SMGEdgeHasValue(sMGEdgeHasValue.getSizeInBits(), sMGEdgeHasValue.getOffset(), (SMGObject)newObject, sMGEdgeHasValue.getValue()));
        }
        for (SMGEdgePointsTo sMGEdgePointsTo : pointer) {
            this.heap.removePointsToEdge(sMGEdgePointsTo.getValue());
            this.heap.addPointsToEdge(new SMGEdgePointsTo(sMGEdgePointsTo.getValue(), newObject, sMGEdgePointsTo.getOffset()));
        }
        return SMGAbstractObjectAndState.SMGAddressValueAndState.of(this, new SMGEdgePointsTo(pPointerToAbstractObject.getValue(), newObject, pPointerToAbstractObject.getOffset()));
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> removeSll(SMGSingleLinkedList pListSeg, SMGEdgePointsTo pPointerToAbstractObject) throws SMGInconsistentException {
        this.logger.log(Level.ALL, new Object[]{"Remove ", pListSeg, " in state id ", this.getId()});
        ImmutableSet restriction = ImmutableSet.of((Object)pListSeg.getNfo());
        this.removeRestrictedSubSmg(pListSeg, (Set<Long>)restriction);
        long nfo = pListSeg.getNfo();
        long hfo = pListSeg.getHfo();
        SMGValue nextPointer = (SMGValue)this.readValue(pListSeg, nfo, this.sizeOfVoidPointerInBits).getObject();
        SMGSymbolicValue firstPointer = this.getAddress(pListSeg, hfo, SMGTargetSpecifier.FIRST);
        this.heap.markHeapObjectDeletedAndRemoveEdges(pListSeg);
        this.heap.replaceValue(nextPointer, firstPointer);
        if (firstPointer.equals(pPointerToAbstractObject.getValue())) {
            return this.getPointerFromValue(nextPointer);
        }
        throw new AssertionError((Object)("Unexpected dereference of pointer " + pPointerToAbstractObject.getValue() + " pointing to abstraction " + pListSeg));
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> removeDls(SMGDoublyLinkedList pListSeg, SMGEdgePointsTo pPointerToAbstractObject) throws SMGInconsistentException {
        this.logger.log(Level.ALL, new Object[]{"Remove ", pListSeg, " in state id ", this.getId()});
        ImmutableSet restriction = ImmutableSet.of((Object)pListSeg.getNfo(), (Object)pListSeg.getPfo());
        this.removeRestrictedSubSmg(pListSeg, (Set<Long>)restriction);
        long nfo = pListSeg.getNfo();
        long pfo = pListSeg.getPfo();
        long hfo = pListSeg.getHfo();
        SMGValue nextPointer = (SMGValue)this.readValue(pListSeg, nfo, this.sizeOfVoidPointerInBits).getObject();
        SMGValue prevPointer = (SMGValue)this.readValue(pListSeg, pfo, this.sizeOfVoidPointerInBits).getObject();
        SMGSymbolicValue firstPointer = this.getAddress(pListSeg, hfo, SMGTargetSpecifier.FIRST);
        SMGSymbolicValue lastPointer = this.getAddress(pListSeg, hfo, SMGTargetSpecifier.LAST);
        this.heap.markHeapObjectDeletedAndRemoveEdges(pListSeg);
        if (firstPointer != null) {
            this.heap.removePointsToEdge(firstPointer);
            this.heap.replaceValue(nextPointer, firstPointer);
        }
        if (lastPointer != null) {
            this.heap.removePointsToEdge(lastPointer);
            this.heap.replaceValue(prevPointer, lastPointer);
        }
        if (firstPointer != null && firstPointer.equals(pPointerToAbstractObject.getValue())) {
            return this.getPointerFromValue(nextPointer);
        }
        if (lastPointer != null && lastPointer.equals(pPointerToAbstractObject.getValue())) {
            return this.getPointerFromValue(prevPointer);
        }
        throw new AssertionError((Object)("Unexpected dereference of pointer " + pPointerToAbstractObject.getValue() + " pointing to abstraction " + pListSeg));
    }

    private SMGAbstractObjectAndState.SMGAddressValueAndState materialiseSll(SMGSingleLinkedList pListSeg, SMGEdgePointsTo pPointerToAbstractObject) throws SMGInconsistentException {
        this.logger.log(Level.ALL, new Object[]{"Materialise ", pListSeg, " in state id ", this.getId()});
        if (pPointerToAbstractObject.getTargetSpecifier() != SMGTargetSpecifier.FIRST) {
            throw new SMGInconsistentException("Target specifier of pointer " + pPointerToAbstractObject.getValue() + "that leads to a sll has unexpected target specifier " + pPointerToAbstractObject.getTargetSpecifier());
        }
        SMGRegion newConcreteRegion = new SMGRegion(pListSeg.getSize(), "concrete sll segment ID " + SMGCPA.getNewValue(), 0);
        this.heap.addHeapObject(newConcreteRegion);
        ImmutableSet restriction = ImmutableSet.of((Object)new SMGEdgeHasValue(this.sizeOfVoidPointerInBits, pListSeg.getNfo(), (SMGObject)pListSeg, (SMGValue)SMGZeroValue.INSTANCE));
        this.copyRestrictedSubSmgToObject(pListSeg, newConcreteRegion, (Set<SMGEdgeHasValue>)restriction);
        long hfo = pListSeg.getHfo();
        long nfo = pListSeg.getNfo();
        Iterable<SMGEdgeHasValue> oldSllFieldsToOldRegion = this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pListSeg).filterAtOffset(nfo).filterBySize(this.sizeOfVoidPointerInBits));
        SMGValue oldPointerToRegion = (SMGValue)this.readValue(pListSeg, nfo, this.sizeOfVoidPointerInBits).getObject();
        if (oldSllFieldsToOldRegion.iterator().hasNext()) {
            SMGEdgeHasValue oldSllFieldToOldRegion = (SMGEdgeHasValue)Iterables.getOnlyElement(oldSllFieldsToOldRegion);
            this.heap.removeHasValueEdge(oldSllFieldToOldRegion);
        }
        SMGValue oldPointerToSll = pPointerToAbstractObject.getValue();
        SMGHasValueEdges oldFieldsEdges = this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pListSeg));
        Set<SMGEdgePointsTo> oldPtEdges = SMGUtils.getPointerToThisObject(pListSeg, this.heap);
        this.heap.removePointsToEdge(oldPointerToSll);
        this.heap.markHeapObjectDeletedAndRemoveEdges(pListSeg);
        SMGSingleLinkedList newSll = new SMGSingleLinkedList(pListSeg.getSize(), pListSeg.getHfo(), pListSeg.getNfo(), pListSeg.getMinimumLength() > 0 ? pListSeg.getMinimumLength() - 1 : 0, 0);
        this.heap.addHeapObject(newSll);
        this.heap.setValidity(newSll, true);
        SMGSymbolicValue newPointerToNewRegion = this.getAddress(newConcreteRegion, hfo);
        if (newPointerToNewRegion != null) {
            this.heap.removePointsToEdge(newPointerToNewRegion);
            this.heap.replaceValue(oldPointerToSll, newPointerToNewRegion);
        }
        SMGEdgePointsTo newPtEdgeToNewRegionFromOutsideSMG = new SMGEdgePointsTo(oldPointerToSll, newConcreteRegion, hfo);
        SMGSymbolicValue newPointerToSll = SMGKnownSymValue.of();
        Iterable<SMGEdgeHasValue> fieldsContainingOldPointerToSll = this.heap.getHVEdges(SMGEdgeHasValueFilter.valueFilter(oldPointerToSll));
        long sizeOfPointerToSll = !fieldsContainingOldPointerToSll.iterator().hasNext() ? this.sizeOfVoidPointerInBits : fieldsContainingOldPointerToSll.iterator().next().getSizeInBits();
        SMGEdgePointsTo newPtEToSll = new SMGEdgePointsTo(newPointerToSll, newSll, hfo, SMGTargetSpecifier.FIRST);
        newPointerToSll = SMGKnownAddressValue.valueOf(newPtEToSll);
        this.writeValue(newConcreteRegion, nfo, sizeOfPointerToSll, newPointerToSll);
        for (SMGEdgeHasValue hve : oldFieldsEdges) {
            this.heap.addHasValueEdge(new SMGEdgeHasValue(hve.getSizeInBits(), hve.getOffset(), (SMGObject)newSll, hve.getValue()));
        }
        for (SMGEdgePointsTo ptE : oldPtEdges) {
            this.heap.addPointsToEdge(new SMGEdgePointsTo(ptE.getValue(), newSll, ptE.getOffset(), ptE.getTargetSpecifier()));
        }
        this.heap.addPointsToEdge(newPtEdgeToNewRegionFromOutsideSMG);
        this.heap.addValue(newPointerToSll);
        this.heap.addPointsToEdge(newPtEToSll);
        this.writeValue(newSll, nfo, this.sizeOfVoidPointerInBits, oldPointerToRegion);
        return SMGAbstractObjectAndState.SMGAddressValueAndState.of(this, newPtEdgeToNewRegionFromOutsideSMG);
    }

    private SMGAbstractObjectAndState.SMGAddressValueAndState materialiseDls(SMGDoublyLinkedList pListSeg, SMGEdgePointsTo pPointerToAbstractObject) throws SMGInconsistentException {
        long offsetPointingToRegion;
        long offsetPointingToDll;
        this.logger.log(Level.ALL, new Object[]{"Materialise ", pListSeg, " in state id ", this.getId()});
        SMGRegion newConcreteRegion = new SMGRegion(pListSeg.getSize(), "concrete dll segment ID " + SMGCPA.getNewValue(), 0);
        this.heap.addHeapObject(newConcreteRegion);
        ImmutableSet restriction = ImmutableSet.of((Object)new SMGEdgeHasValue(this.sizeOfVoidPointerInBits, pListSeg.getNfo(), (SMGObject)pListSeg, (SMGValue)SMGZeroValue.INSTANCE), (Object)new SMGEdgeHasValue(this.sizeOfVoidPointerInBits, pListSeg.getPfo(), (SMGObject)pListSeg, (SMGValue)SMGZeroValue.INSTANCE));
        this.copyRestrictedSubSmgToObject(pListSeg, newConcreteRegion, (Set<SMGEdgeHasValue>)restriction);
        SMGTargetSpecifier tg = pPointerToAbstractObject.getTargetSpecifier();
        switch (tg) {
            case FIRST: {
                offsetPointingToDll = pListSeg.getNfo();
                offsetPointingToRegion = pListSeg.getPfo();
                break;
            }
            case LAST: {
                offsetPointingToDll = pListSeg.getPfo();
                offsetPointingToRegion = pListSeg.getNfo();
                break;
            }
            default: {
                throw new SMGInconsistentException("Target specifier of pointer " + pPointerToAbstractObject.getValue() + "that leads to a dll has unexpected target specifier " + tg);
            }
        }
        long hfo = pListSeg.getHfo();
        Iterable<SMGEdgeHasValue> oldDllFieldsToOldRegion = this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pListSeg).filterAtOffset(offsetPointingToRegion).filterWithoutSize());
        SMGValue oldPointerToRegion = (SMGValue)this.readValue(pListSeg, offsetPointingToRegion, this.sizeOfVoidPointerInBits).getObject();
        if (oldDllFieldsToOldRegion.iterator().hasNext()) {
            SMGEdgeHasValue oldDllFieldToOldRegion = (SMGEdgeHasValue)Iterables.getOnlyElement(oldDllFieldsToOldRegion);
            if (oldDllFieldToOldRegion.getValue().isZero()) {
                oldDllFieldToOldRegion = new SMGEdgeHasValue(this.sizeOfVoidPointerInBits, oldDllFieldToOldRegion.getOffset(), oldDllFieldToOldRegion.getObject(), oldDllFieldToOldRegion.getValue());
            }
            this.heap.removeHasValueEdge(oldDllFieldToOldRegion);
        }
        SMGKnownSymbolicValue oldPointerToDll = (SMGKnownSymbolicValue)pPointerToAbstractObject.getValue();
        this.heap.removePointsToEdge(oldPointerToDll);
        SMGHasValueEdges oldFieldsEdges = this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pListSeg));
        Set<SMGEdgePointsTo> oldPtEdges = SMGUtils.getPointerToThisObject(pListSeg, this.heap);
        this.heap.markHeapObjectDeletedAndRemoveEdges(pListSeg);
        SMGDoublyLinkedList newDll = new SMGDoublyLinkedList(pListSeg.getSize(), pListSeg.getHfo(), pListSeg.getNfo(), pListSeg.getPfo(), pListSeg.getMinimumLength() > 0 ? pListSeg.getMinimumLength() - 1 : 0, 0);
        this.heap.addHeapObject(newDll);
        this.heap.setValidity(newDll, true);
        SMGSymbolicValue newPointerToNewRegion = this.getAddress(newConcreteRegion, hfo);
        if (newPointerToNewRegion != null) {
            this.heap.removePointsToEdge(newPointerToNewRegion);
            this.heap.replaceValue(oldPointerToDll, newPointerToNewRegion);
        }
        SMGEdgePointsTo newPtEdgeToNewRegionFromOutsideSMG = new SMGEdgePointsTo(oldPointerToDll, newConcreteRegion, hfo);
        this.writeValue(newConcreteRegion, offsetPointingToRegion, this.sizeOfVoidPointerInBits, oldPointerToRegion);
        SMGKnownSymbolicValue newPointerToDll = SMGKnownSymValue.of();
        Iterable<SMGEdgeHasValue> fieldsContainingOldPointerToDll = this.heap.getHVEdges(SMGEdgeHasValueFilter.valueFilter(oldPointerToDll));
        long sizeOfPointerToDll = !fieldsContainingOldPointerToDll.iterator().hasNext() ? this.sizeOfVoidPointerInBits : fieldsContainingOldPointerToDll.iterator().next().getSizeInBits();
        this.writeValue(newConcreteRegion, offsetPointingToDll, sizeOfPointerToDll, newPointerToDll);
        SMGEdgePointsTo newPtEToDll = new SMGEdgePointsTo(newPointerToDll, newDll, hfo, tg);
        this.writeValue(newDll, offsetPointingToRegion, this.sizeOfVoidPointerInBits, oldPointerToDll);
        for (SMGEdgeHasValue hve : oldFieldsEdges) {
            this.heap.addHasValueEdge(new SMGEdgeHasValue(hve.getSizeInBits(), hve.getOffset(), (SMGObject)newDll, hve.getValue()));
        }
        for (SMGEdgePointsTo ptE : oldPtEdges) {
            this.heap.addPointsToEdge(new SMGEdgePointsTo(ptE.getValue(), newDll, ptE.getOffset(), ptE.getTargetSpecifier()));
        }
        this.heap.addPointsToEdge(newPtEdgeToNewRegionFromOutsideSMG);
        this.heap.addValue(newPointerToDll);
        this.heap.addPointsToEdge(newPtEToDll);
        return SMGAbstractObjectAndState.SMGAddressValueAndState.of(this, newPtEdgeToNewRegionFromOutsideSMG);
    }

    private void copyRestrictedSubSmgToObject(SMGObject pRoot, SMGRegion pNewRegion, Set<SMGEdgeHasValue> pRestrictions) {
        HashSet<SMGObject> toBeChecked = new HashSet<SMGObject>();
        HashMap<SMGObject, SMGObject> newObjectMap = new HashMap<SMGObject, SMGObject>();
        HashMap<SMGValue, SMGValue> newValueMap = new HashMap<SMGValue, SMGValue>();
        newObjectMap.put(pRoot, pNewRegion);
        for (SMGEdgeHasValue hve : this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pRoot))) {
            boolean restricted = false;
            for (SMGEdgeHasValue restriction : pRestrictions) {
                if (!restriction.overlapsWith(hve)) continue;
                restricted = true;
            }
            if (!restricted) {
                SMGValue subDlsValue;
                SMGValue newVal = subDlsValue = hve.getValue();
                if (this.heap.isPointer(subDlsValue)) {
                    SMGEdgePointsTo sMGEdgePointsTo = this.heap.getPointer(subDlsValue);
                    SMGObject reachedObjectSubSmg = sMGEdgePointsTo.getObject();
                    int n = reachedObjectSubSmg.getLevel();
                    SMGTargetSpecifier tg = sMGEdgePointsTo.getTargetSpecifier();
                    if (!(n == 0 && tg != SMGTargetSpecifier.ALL || newVal.isZero())) {
                        SMGObject copyOfReachedObject;
                        if (!newObjectMap.containsKey(reachedObjectSubSmg)) {
                            assert (n > 0);
                            copyOfReachedObject = reachedObjectSubSmg.copy(reachedObjectSubSmg.getLevel() - 1);
                            newObjectMap.put(reachedObjectSubSmg, copyOfReachedObject);
                            this.heap.addHeapObject(copyOfReachedObject);
                            this.heap.setValidity(copyOfReachedObject, this.heap.isObjectValid(reachedObjectSubSmg));
                            toBeChecked.add(reachedObjectSubSmg);
                        } else {
                            copyOfReachedObject = (SMGObject)newObjectMap.get(reachedObjectSubSmg);
                        }
                        if (newValueMap.containsKey(subDlsValue)) {
                            newVal = (SMGValue)newValueMap.get(subDlsValue);
                        } else {
                            newVal = SMGKnownSymValue.of();
                            this.heap.addValue(newVal);
                            newValueMap.put(subDlsValue, newVal);
                            SMGTargetSpecifier newTg = copyOfReachedObject instanceof SMGRegion ? SMGTargetSpecifier.REGION : sMGEdgePointsTo.getTargetSpecifier();
                            SMGEdgePointsTo newPtEdge = new SMGEdgePointsTo(newVal, copyOfReachedObject, sMGEdgePointsTo.getOffset(), newTg);
                            this.heap.addPointsToEdge(newPtEdge);
                        }
                    }
                }
                this.heap.addHasValueEdge(new SMGEdgeHasValue(hve.getSizeInBits(), hve.getOffset(), (SMGObject)pNewRegion, newVal));
                continue;
            }
            if (!hve.getValue().isZero()) continue;
            HashMap<Long, Long> newEdges = new HashMap<Long, Long>();
            newEdges.put(hve.getOffset(), hve.getSizeInBits());
            for (SMGEdgeHasValue sMGEdgeHasValue : pRestrictions) {
                for (Map.Entry entry : newEdges.entrySet()) {
                    HashMap<Long, Long> recalcEdges = new HashMap<Long, Long>();
                    Long offset = (Long)entry.getKey();
                    Long sizeInBits = (Long)entry.getValue();
                    if (sMGEdgeHasValue.overlapsWith(offset, sizeInBits)) {
                        long restrictionEndOffset;
                        long endOffset;
                        if (offset < sMGEdgeHasValue.getOffset()) {
                            recalcEdges.put(offset, sMGEdgeHasValue.getOffset() - offset);
                        }
                        if ((endOffset = offset + sizeInBits) > (restrictionEndOffset = sMGEdgeHasValue.getOffset() + sMGEdgeHasValue.getSizeInBits())) {
                            recalcEdges.put(restrictionEndOffset, endOffset - restrictionEndOffset);
                        }
                    } else {
                        recalcEdges.put(offset, sizeInBits);
                    }
                    newEdges = recalcEdges;
                }
            }
            for (Map.Entry entry : newEdges.entrySet()) {
                SMGEdgeHasValue expandedZeroEdge = new SMGEdgeHasValue((Long)entry.getValue(), (long)((Long)entry.getKey()), (SMGObject)pNewRegion, (SMGValue)SMGZeroValue.INSTANCE);
                this.heap.addHasValueEdge(expandedZeroEdge);
            }
        }
        HashSet<SMGObject> toCheck = new HashSet<SMGObject>();
        while (!toBeChecked.isEmpty()) {
            toCheck.clear();
            toCheck.addAll(toBeChecked);
            toBeChecked.clear();
            for (SMGObject objToCheck : toCheck) {
                this.copyObjectAndNodesIntoDestSMG(objToCheck, toBeChecked, newObjectMap, newValueMap);
            }
        }
    }

    private void copyObjectAndNodesIntoDestSMG(SMGObject pObjToCheck, Set<SMGObject> pToBeChecked, Map<SMGObject, SMGObject> newObjectMap, Map<SMGValue, SMGValue> newValueMap) {
        SMGObject newObj = newObjectMap.get(pObjToCheck);
        for (SMGEdgeHasValue hve : this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObjToCheck))) {
            SMGValue subDlsValue;
            SMGValue newVal = subDlsValue = hve.getValue();
            if (this.heap.isPointer(subDlsValue)) {
                SMGEdgePointsTo reachedObjectSubSmgPTEdge = this.heap.getPointer(subDlsValue);
                SMGObject reachedObjectSubSmg = reachedObjectSubSmgPTEdge.getObject();
                int level = reachedObjectSubSmg.getLevel();
                SMGTargetSpecifier tg = reachedObjectSubSmgPTEdge.getTargetSpecifier();
                if (!(level == 0 && tg != SMGTargetSpecifier.ALL || newVal.isZero())) {
                    SMGObject copyOfReachedObject;
                    if (!newObjectMap.containsKey(reachedObjectSubSmg)) {
                        assert (level > 0);
                        copyOfReachedObject = reachedObjectSubSmg.copy(reachedObjectSubSmg.getLevel() - 1);
                        newObjectMap.put(reachedObjectSubSmg, copyOfReachedObject);
                        this.heap.addHeapObject(copyOfReachedObject);
                        this.heap.setValidity(copyOfReachedObject, this.heap.isObjectValid(reachedObjectSubSmg));
                        pToBeChecked.add(reachedObjectSubSmg);
                    } else {
                        copyOfReachedObject = newObjectMap.get(reachedObjectSubSmg);
                    }
                    if (newValueMap.containsKey(subDlsValue)) {
                        newVal = newValueMap.get(subDlsValue);
                    } else {
                        newVal = SMGKnownSymValue.of();
                        this.heap.addValue(newVal);
                        newValueMap.put(subDlsValue, newVal);
                        SMGTargetSpecifier newTg = copyOfReachedObject instanceof SMGRegion ? SMGTargetSpecifier.REGION : reachedObjectSubSmgPTEdge.getTargetSpecifier();
                        SMGEdgePointsTo newPtEdge = new SMGEdgePointsTo(newVal, copyOfReachedObject, reachedObjectSubSmgPTEdge.getOffset(), newTg);
                        this.heap.addPointsToEdge(newPtEdge);
                    }
                }
            }
            this.heap.addHasValueEdge(new SMGEdgeHasValue(hve.getSizeInBits(), hve.getOffset(), newObj, newVal));
        }
    }

    private void removeRestrictedSubSmg(SMGObject pRoot, Set<Long> pRestriction) {
        HashSet<SMGObject> toBeChecked = new HashSet<SMGObject>();
        HashSet<SMGObject> reached = new HashSet<SMGObject>();
        reached.add(pRoot);
        for (SMGEdgeHasValue hve : this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pRoot))) {
            SMGValue subDlsValue;
            if (pRestriction.contains(hve.getOffset()) || !this.heap.isPointer(subDlsValue = hve.getValue())) continue;
            SMGEdgePointsTo reachedObjectSubSmgPTEdge = this.heap.getPointer(subDlsValue);
            SMGObject reachedObjectSubSmg = reachedObjectSubSmgPTEdge.getObject();
            int level = reachedObjectSubSmg.getLevel();
            SMGTargetSpecifier tg = reachedObjectSubSmgPTEdge.getTargetSpecifier();
            if (reached.contains(reachedObjectSubSmg) || level == 0 && tg != SMGTargetSpecifier.ALL || subDlsValue.isZero()) continue;
            assert (level > 0);
            reached.add(reachedObjectSubSmg);
            this.heap.setValidity(reachedObjectSubSmg, false);
            toBeChecked.add(reachedObjectSubSmg);
        }
        HashSet<SMGObject> toCheck = new HashSet<SMGObject>();
        while (!toBeChecked.isEmpty()) {
            toCheck.clear();
            toCheck.addAll(toBeChecked);
            toBeChecked.clear();
            for (SMGObject objToCheck : toCheck) {
                this.removeRestrictedSubSmg(objToCheck, toBeChecked, reached);
            }
        }
        for (SMGObject toBeRemoved : reached) {
            if (toBeRemoved == pRoot) continue;
            this.heap.markHeapObjectDeletedAndRemoveEdges(toBeRemoved);
        }
    }

    private void removeRestrictedSubSmg(SMGObject pObjToCheck, Set<SMGObject> pToBeChecked, Set<SMGObject> reached) {
        for (SMGEdgeHasValue hve : this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObjToCheck))) {
            SMGValue subDlsValue = hve.getValue();
            if (!this.heap.isPointer(subDlsValue)) continue;
            SMGEdgePointsTo reachedObjectSubSmgPTEdge = this.heap.getPointer(subDlsValue);
            SMGObject reachedObjectSubSmg = reachedObjectSubSmgPTEdge.getObject();
            int level = reachedObjectSubSmg.getLevel();
            SMGTargetSpecifier tg = reachedObjectSubSmgPTEdge.getTargetSpecifier();
            if (reached.contains(reachedObjectSubSmg) || level == 0 && tg != SMGTargetSpecifier.ALL || subDlsValue.isZero()) continue;
            assert (level > 0);
            reached.add(reachedObjectSubSmg);
            this.heap.setValidity(reachedObjectSubSmg, false);
            pToBeChecked.add(reachedObjectSubSmg);
        }
    }

    public SMGAbstractObjectAndState.SMGValueAndState forceReadValue(SMGObject pObject, long pOffset, CType pType) throws SMGInconsistentException {
        long sizeInBits = this.heap.getMachineModel().getSizeofInBits(pType).longValueExact();
        SMGAbstractObjectAndState.SMGValueAndState valueAndState = this.readValue(pObject, pOffset, sizeInBits);
        if (((SMGValue)valueAndState.getObject()).isUnknown() && !valueAndState.getSmgState().errorInfo.isInvalidRead()) {
            SMGStateEdgePair stateAndNewEdge;
            if (valueAndState.getSmgState().getHeap().isObjectExternallyAllocated(pObject) && pType.getCanonicalType() instanceof CPointerType) {
                SMGAddressValue new_address = SMGKnownAddressValue.valueOf(valueAndState.getSmgState().addExternalAllocation(this.genRecursiveLabel(pObject.getLabel())));
                stateAndNewEdge = this.writeValue(pObject, pOffset, sizeInBits, new_address);
            } else {
                SMGKnownSymbolicValue newValue = SMGKnownSymValue.of();
                stateAndNewEdge = this.writeValue0(pObject, pOffset, sizeInBits, newValue);
            }
            return SMGAbstractObjectAndState.SMGValueAndState.of(stateAndNewEdge.getState(), stateAndNewEdge.getNewEdge().getValue());
        }
        return valueAndState;
    }

    private String genRecursiveLabel(String pLabel) {
        Matcher result = externalAllocationRecursivePattern.matcher(pLabel);
        if (result.matches()) {
            String in = result.group(2);
            int level = Integer.parseInt(in) + 1;
            return result.replaceFirst("$1" + level + "$3");
        }
        return "r_1_" + pLabel;
    }

    public SMGAbstractObjectAndState.SMGValueAndState readValue(SMGObject pObject, long pOffset, long pSizeInBits) throws SMGInconsistentException {
        if (!this.heap.isObjectValid(pObject) && !this.heap.isObjectExternallyAllocated(pObject)) {
            SMGState newState = this.withInvalidRead().withErrorDescription("Try to read from deallocated object");
            newState.addInvalidObject(pObject);
            return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(newState);
        }
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObject).filterAtOffset(pOffset).filterBySize(pSizeInBits);
        Iterable<SMGEdgeHasValue> matchingEdges = this.heap.getHVEdges(filter);
        if (matchingEdges.iterator().hasNext()) {
            SMGEdgeHasValue object_edge = (SMGEdgeHasValue)Iterables.getOnlyElement(matchingEdges);
            this.performConsistencyCheck(SMGRuntimeCheck.HALF);
            this.addElementToCurrentChain(object_edge);
            return SMGAbstractObjectAndState.SMGValueAndState.of(this, object_edge.getValue());
        }
        SMGEdgeHasValueFilter filterOffsetZero = new SMGEdgeHasValueFilter().overlapsWith(new SMGEdgeHasValue(pSizeInBits, pOffset, pObject, (SMGValue)SMGZeroValue.INSTANCE));
        Iterable<SMGEdgeHasValue> matchingEdgesOffsetZero = this.heap.getHVEdges(filterOffsetZero);
        for (SMGEdgeHasValue object_edge : matchingEdgesOffsetZero) {
            SMGValue symValue;
            if (pOffset < object_edge.getOffset() || pOffset + pSizeInBits > object_edge.getOffset() + object_edge.getSizeInBits() || !this.isExplicit(symValue = object_edge.getValue())) continue;
            SMGKnownExpValue expValue = this.getExplicit(symValue);
            BigInteger value = expValue.getValue();
            value = value.shiftRight((int)(pOffset - object_edge.getOffset()));
            for (int i = (int)pSizeInBits; i < value.bitLength(); ++i) {
                value = value.clearBit(i);
            }
            this.addElementToCurrentChain(object_edge);
            return SMGAbstractObjectAndState.SMGValueAndState.of(this, SMGKnownExpValue.valueOf(value));
        }
        SMGEdgeHasValue edge = new SMGEdgeHasValue(pSizeInBits, pOffset, pObject, (SMGValue)SMGZeroValue.INSTANCE);
        if (this.heap.isCoveredByNullifiedBlocks(edge)) {
            return SMGAbstractObjectAndState.SMGValueAndState.of(this, SMGZeroValue.INSTANCE);
        }
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this);
    }

    @Override
    public SMGState withInvalidRead() {
        SMGState smgState = new SMGState(this, Property.INVALID_READ);
        smgState.moveCurrentChainToInvalidChain();
        return smgState;
    }

    public SMGStateEdgePair writeValue(SMGObject pObject, long pOffset, long pSizeInBits, SMGValue pValue) throws SMGInconsistentException {
        SMGAddress address;
        SMGValue value = pValue.isUnknown() ? SMGKnownSymValue.of() : pValue;
        if (pValue instanceof SMGAddressValue && !(address = ((SMGAddressValue)pValue).getAddress()).isUnknown()) {
            this.addPointsToEdge(address.getObject(), address.getOffset().getAsLong(), value);
        }
        return this.writeValue0(pObject, pOffset, pSizeInBits, value);
    }

    public void addPointsToEdge(SMGObject pObject, long pOffset, SMGValue pValue) {
        this.heap.addValue(pValue);
        this.heap.addPointsToEdge(new SMGEdgePointsTo(pValue, pObject, pOffset));
    }

    private SMGStateEdgePair writeValue0(SMGObject pObject, long pOffset, long pSizeInBits, SMGValue pValue) throws SMGInconsistentException {
        if (!this.heap.isObjectValid(pObject) && !this.heap.isObjectExternallyAllocated(pObject)) {
            SMGState newState = this.withInvalidWrite();
            newState.withErrorDescription("Attempt to write to deallocated object").addInvalidObject(pObject);
            return new SMGStateEdgePair(newState, null);
        }
        SMGEdgeHasValue new_edge = new SMGEdgeHasValue(pSizeInBits, pOffset, pObject, pValue);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObject).overlapsWith(new_edge);
        Iterable<SMGEdgeHasValue> overlappingEdges = this.heap.getHVEdges(filter);
        if (Iterables.contains(overlappingEdges, (Object)new_edge)) {
            this.performConsistencyCheck(SMGRuntimeCheck.HALF);
            return new SMGStateEdgePair(this, new_edge);
        }
        this.heap.addValue(pValue);
        ArrayList<SMGEdgeHasValue> overlappingZeroEdges = new ArrayList<SMGEdgeHasValue>();
        for (SMGEdgeHasValue hv : overlappingEdges) {
            boolean hvEdgeIsZero;
            boolean bl = hvEdgeIsZero = hv.getValue() == SMGZeroValue.INSTANCE;
            if (hvEdgeIsZero) {
                overlappingZeroEdges.add(hv);
                continue;
            }
            this.heap.removeHasValueEdge(hv);
        }
        this.shrinkOverlappingZeroEdges(new_edge, overlappingZeroEdges);
        this.heap.addHasValueEdge(new_edge);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new SMGStateEdgePair(this, new_edge);
    }

    @Override
    public boolean isBlockEnded() {
        return this.blockEnded;
    }

    private void shrinkOverlappingZeroEdges(SMGEdgeHasValue pNew_edge, Iterable<SMGEdgeHasValue> pOverlappingZeroEdges) {
        SMGObject object = pNew_edge.getObject();
        long offset = pNew_edge.getOffset();
        long sizeOfType = pNew_edge.getSizeInBits();
        for (SMGEdgeHasValue zeroEdge : pOverlappingZeroEdges) {
            SMGEdgeHasValue newZeroEdge;
            this.heap.removeHasValueEdge(zeroEdge);
            long zeroEdgeOffset = zeroEdge.getOffset();
            long offset2 = offset + sizeOfType;
            long zeroEdgeOffset2 = zeroEdgeOffset + zeroEdge.getSizeInBits();
            if (zeroEdgeOffset < offset) {
                newZeroEdge = new SMGEdgeHasValue(Math.toIntExact(offset - zeroEdgeOffset), zeroEdgeOffset, object, (SMGValue)SMGZeroValue.INSTANCE);
                this.heap.addHasValueEdge(newZeroEdge);
            }
            if (offset2 >= zeroEdgeOffset2) continue;
            newZeroEdge = new SMGEdgeHasValue(Math.toIntExact(zeroEdgeOffset2 - offset2), offset2, object, (SMGValue)SMGZeroValue.INSTANCE);
            this.heap.addHasValueEdge(newZeroEdge);
        }
    }

    @Override
    public SMGState withInvalidWrite() {
        SMGState smgState = new SMGState(this, Property.INVALID_WRITE);
        smgState.moveCurrentChainToInvalidChain();
        return smgState;
    }

    @Override
    public UnmodifiableSMGState join(UnmodifiableSMGState reachedState) throws SMGInconsistentException {
        if (this.options.getJoinOnBlockEnd() && !reachedState.isBlockEnded()) {
            return reachedState;
        }
        SMGJoin join = new SMGJoin(this.heap, reachedState.getHeap(), this, reachedState);
        if (join.getStatus() != SMGJoinStatus.INCOMPARABLE || !join.isDefined()) {
            return reachedState;
        }
        CLangSMG destHeap = join.getJointSMG();
        return new SMGState(this.logger, this.options, destHeap, this.predecessorId, join.getMergedExplicitValues());
    }

    @Override
    public boolean isLessOrEqual(UnmodifiableSMGState reachedState) throws SMGInconsistentException {
        if (!this.getErrorPredicateRelation().isEmpty() || !reachedState.getErrorPredicateRelation().isEmpty()) {
            return false;
        }
        if (this.options.isHeapAbstractionEnabled()) {
            SMGJoin join = new SMGJoin(this.heap, reachedState.getHeap(), this, reachedState);
            if (!join.isDefined()) {
                return false;
            }
            SMGJoinStatus jss = join.getStatus();
            if (jss != SMGJoinStatus.EQUAL && jss != SMGJoinStatus.RIGHT_ENTAIL) {
                return false;
            }
            SMGState s1 = reachedState.copyOf();
            SMGState s2 = this.copyOf();
            s1.pruneUnreachable();
            s2.pruneUnreachable();
            this.logger.log(Level.ALL, new Object[]{this.getId(), " is Less or Equal ", reachedState.getId()});
            return s1.errorInfo.hasMemoryLeak() == s2.errorInfo.hasMemoryLeak();
        }
        return SMGIsLessOrEqual.isLessOrEqual(reachedState.getHeap(), this.heap);
    }

    @Override
    public String getCPAName() {
        return "SMGCPA";
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "toString": {
                return this.toString();
            }
            case "heapObjects": {
                return this.heap.getHeapObjects();
            }
        }
        return this.checkProperty(pProperty);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "has-leaks": {
                if (this.errorInfo.hasMemoryLeak()) {
                    this.issueMemoryError("Memory leak found", false);
                    return true;
                }
                return false;
            }
            case "has-invalid-writes": {
                if (this.errorInfo.isInvalidWrite()) {
                    this.issueMemoryError("Invalid write found", true);
                    return true;
                }
                return false;
            }
            case "has-invalid-reads": {
                if (this.errorInfo.isInvalidRead()) {
                    this.issueMemoryError("Invalid read found", true);
                    return true;
                }
                return false;
            }
            case "has-invalid-frees": {
                if (this.errorInfo.isInvalidFree()) {
                    this.issueMemoryError("Invalid free found", true);
                    return true;
                }
                return false;
            }
            case "has-heap-objects": {
                PersistentSet<SMGObject> heapObs = this.heap.getHeapObjects();
                Preconditions.checkState((heapObs.size() >= 1 && heapObs.contains(SMGNullObject.INSTANCE) ? 1 : 0) != 0, (Object)"NULL must always be a heap object");
                for (SMGObject object : heapObs) {
                    if (this.heap.isObjectValid(object)) continue;
                    heapObs = heapObs.removeAndCopy(object);
                }
                return !heapObs.isEmpty();
            }
        }
        throw new InvalidQueryException("Query '" + pProperty + "' is invalid.");
    }

    public void addGlobalObject(SMGRegion newObject) {
        this.heap.addGlobalObject(newObject);
    }

    public SMGEdgePointsTo addNewHeapAllocation(int pSize, String pLabel) throws SMGInconsistentException {
        return this.addHeapAllocation(pLabel, pSize, 0, false);
    }

    public SMGEdgePointsTo addExternalAllocation(String pLabel) throws SMGInconsistentException {
        return this.addHeapAllocation(pLabel, this.options.getExternalAllocationSize(), this.options.getExternalAllocationSize() / 2, true);
    }

    private SMGEdgePointsTo addHeapAllocation(String label, int size, int offset, boolean external) throws SMGInconsistentException {
        SMGRegion new_object = new SMGRegion(size, label);
        SMGKnownSymbolicValue new_value = SMGKnownSymValue.of();
        this.heap.addHeapObject(new_object);
        this.heap.setValidity(new_object, true);
        this.heap.addValue(new_value);
        for (SMGObject object : this.heap.getObjects()) {
            if (SMGNullObject.INSTANCE.equals(object) || this.heap.isObjectValid(object)) continue;
            this.heap.addPossibleEqualObjects(new_object, object);
        }
        SMGEdgePointsTo pointsTo = new SMGEdgePointsTo(new_value, new_object, offset);
        this.heap.addPointsToEdge(pointsTo);
        this.heap.setExternallyAllocatedFlag(new_object, external);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return pointsTo;
    }

    public void setExternallyAllocatedFlag(SMGObject pObject) {
        this.heap.setExternallyAllocatedFlag(pObject, true);
    }

    public SMGEdgePointsTo addNewStackAllocation(int pSize, String pLabel) throws SMGInconsistentException {
        SMGRegion new_object = new SMGRegion(pSize, pLabel);
        SMGKnownSymbolicValue new_value = SMGKnownSymValue.of();
        this.heap.addStackObject(new_object);
        this.heap.addValue(new_value);
        for (SMGObject object : this.heap.getObjects()) {
            if (SMGNullObject.INSTANCE.equals(object) || this.heap.isObjectValid(object)) continue;
            this.heap.addPossibleEqualObjects(new_object, object);
        }
        SMGEdgePointsTo pointsTo = new SMGEdgePointsTo(new_value, new_object, 0L);
        this.heap.addPointsToEdge(pointsTo);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return pointsTo;
    }

    public void setMemLeak(String errorMsg, Collection<SMGObject> pUnreachableObjects) {
        this.errorInfo = this.errorInfo.withProperty(Property.INVALID_HEAP).withErrorMessage(errorMsg).withInvalidObjects(pUnreachableObjects);
    }

    @Override
    public @Nullable SMGSymbolicValue getAddress(SMGObject memory, long offset, SMGTargetSpecifier tg) {
        SMGEdgePointsToFilter filter = SMGEdgePointsToFilter.targetObjectFilter(memory).filterAtTargetOffset(offset).filterByTargetSpecifier(tg);
        Set<SMGEdgePointsTo> edges = this.heap.getPtEdges(filter);
        if (edges.isEmpty()) {
            return null;
        }
        return (SMGSymbolicValue)((SMGEdgePointsTo)Iterables.getOnlyElement(edges)).getValue();
    }

    protected SMGState free(Integer offset, SMGObject smgObject) throws SMGInconsistentException {
        if (!this.heap.isHeapObject(smgObject) && !this.heap.isObjectExternallyAllocated(smgObject)) {
            SMGState newState = this.withInvalidFree().withErrorDescription("Invalid free of unallocated object is found");
            newState.addInvalidObject(smgObject);
            return newState;
        }
        if (!this.heap.isObjectValid(smgObject)) {
            SMGState newState = this.withInvalidFree().withErrorDescription("Double free is found");
            newState.addInvalidObject(smgObject);
            return newState;
        }
        if (offset != 0 && !this.heap.isObjectExternallyAllocated(smgObject)) {
            SMGState newState = this.withInvalidFree();
            newState.addInvalidObject(smgObject);
            String description = offset % 8 != 0 ? "Invalid free at " + offset + " bit offset from allocated is found" : "Invalid free at " + offset / 8 + " byte offset from allocated is found";
            return newState.withErrorDescription(description);
        }
        this.heap.setValidity(smgObject, false);
        this.heap.setExternallyAllocatedFlag(smgObject, false);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filter = SMGEdgeHasValueFilter.objectFilter(smgObject);
        for (SMGEdgeHasValue edge : this.heap.getHVEdges(filter)) {
            this.heap.removeHasValueEdge(edge);
        }
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return this;
    }

    @Override
    public Collection<Object> getInvalidChain() {
        return Collections.unmodifiableList(this.errorInfo.getInvalidChain());
    }

    public void addInvalidObject(SMGObject pSmgObject) {
        this.errorInfo = this.errorInfo.withInvalidObject(pSmgObject);
    }

    public void addElementToCurrentChain(Object elem) {
        if (elem instanceof SMGValue && ((SMGValue)elem).isZero()) {
            return;
        }
        this.errorInfo = this.errorInfo.withObject(elem);
    }

    @Override
    public Collection<Object> getCurrentChain() {
        return Collections.unmodifiableList(this.errorInfo.getCurrentChain());
    }

    protected void cleanCurrentChain() {
        this.errorInfo = this.errorInfo.withClearChain();
    }

    private void moveCurrentChainToInvalidChain() {
        this.errorInfo = this.errorInfo.moveCurrentChainToInvalidChain();
    }

    public void dropStackFrame() throws SMGInconsistentException {
        this.heap.dropStackFrame();
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    public void pruneUnreachable() throws SMGInconsistentException {
        Set<SMGObject> unreachable = this.heap.pruneUnreachable();
        if (!unreachable.isEmpty()) {
            StringBuilder error = new StringBuilder();
            for (SMGObject obj : unreachable) {
                error.append(obj.getLabel());
            }
            this.setMemLeak("Memory leak of " + error + " is detected", unreachable);
        }
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    @Override
    public SMGState withInvalidFree() {
        return new SMGState(this, Property.INVALID_FREE);
    }

    @VisibleForTesting
    Iterable<SMGEdgeHasValue> getHVEdges(SMGEdgeHasValueFilter pFilter) {
        return this.heap.getHVEdges(pFilter);
    }

    SMGHasValueEdges getHVEdges(SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject pFilter) {
        return this.heap.getHVEdges(pFilter);
    }

    public SMGState copy(SMGObject pSource, SMGObject pTarget, long pSourceOffset, long pSourceLastCopyBitOffset, long pTargetOffset) throws SMGInconsistentException {
        SMGState newSMGState = this;
        long copyRange = pSourceLastCopyBitOffset - pSourceOffset;
        assert (pSource.getSize() >= pSourceLastCopyBitOffset);
        assert (pSourceOffset >= 0L);
        assert (pTargetOffset >= 0L);
        assert (copyRange >= 0L);
        assert (copyRange <= pTarget.getSize());
        if (copyRange == 0L) {
            return newSMGState;
        }
        if (pSource.equals(pTarget) && pSourceOffset == pTargetOffset) {
            return newSMGState;
        }
        long targetRangeSize = pTargetOffset + copyRange;
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterSource = SMGEdgeHasValueFilter.objectFilter(pSource);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterTarget = SMGEdgeHasValueFilter.objectFilter(pTarget);
        for (SMGEdgeHasValue edge : this.getHVEdges(filterTarget)) {
            long zeroEdgeOffset2;
            if (!edge.overlapsWith(pTargetOffset, targetRangeSize)) continue;
            this.heap.removeHasValueEdge(edge);
            if (edge.getValue() != SMGZeroValue.INSTANCE) continue;
            SMGObject object = edge.getObject();
            long zeroEdgeOffset = edge.getOffset();
            if (zeroEdgeOffset < pTargetOffset) {
                this.heap.addHasValueEdge(new SMGEdgeHasValue(pTargetOffset - zeroEdgeOffset, zeroEdgeOffset, object, (SMGValue)SMGZeroValue.INSTANCE));
            }
            if (targetRangeSize >= (zeroEdgeOffset2 = zeroEdgeOffset + edge.getSizeInBits())) continue;
            this.heap.addHasValueEdge(new SMGEdgeHasValue(zeroEdgeOffset2 - targetRangeSize, targetRangeSize, object, (SMGValue)SMGZeroValue.INSTANCE));
        }
        long copyShift = pTargetOffset - pSourceOffset;
        for (SMGEdgeHasValue edge : this.getHVEdges(filterSource)) {
            SMGValue newValue = edge.getValue();
            if (!edge.overlapsWith(pSourceOffset, pSourceLastCopyBitOffset)) continue;
            long newSize = edge.getSizeInBits();
            long edgeOffset = edge.getOffset();
            long edgeEndOffset = edgeOffset + newSize;
            boolean writeEdge = true;
            if (edgeEndOffset > pSourceLastCopyBitOffset) {
                newSize -= edgeEndOffset - pSourceLastCopyBitOffset;
                writeEdge = newValue.isZero();
            }
            long newOffset = edgeOffset + copyShift;
            if (edgeOffset < pSourceOffset) {
                newOffset = pTargetOffset;
                newSize -= pSourceOffset - edgeOffset;
                writeEdge = newValue.isZero();
            }
            if (!writeEdge) continue;
            newSMGState = this.writeValue0(pTarget, newOffset, newSize, newValue).getState();
        }
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
        Set<SMGObject> unreachable = newSMGState.heap.pruneUnreachable();
        if (!unreachable.isEmpty()) {
            newSMGState.setMemLeak("Memory leak is detected", unreachable);
        }
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
        return newSMGState;
    }

    @Override
    public SMGState withUnknownDereference() {
        if (this.options.isHandleUnknownDereferenceAsSafe() && this.isTrackErrorPredicatesEnabled()) {
            return this;
        }
        return new SMGState(this, Property.INVALID_WRITE).withErrorDescription("Unknown dereference");
    }

    public void identifyEqualValues(SMGKnownSymbolicValue pKnownVal1, SMGKnownSymbolicValue pKnownVal2) {
        assert (this.explicitValues.get(pKnownVal1) == null || !this.explicitValues.get(pKnownVal1).equals(this.explicitValues.get(pKnownVal2)));
        if (pKnownVal2.isZero()) {
            SMGKnownSymbolicValue tmp = pKnownVal1;
            pKnownVal1 = pKnownVal2;
            pKnownVal2 = tmp;
        }
        if (!pKnownVal1.isZero() && this.heap.isPointer(pKnownVal1)) {
            SMGObject objectPointedBy2;
            SMGObject objectPointedBy1 = this.heap.getObjectPointedBy(pKnownVal1);
            if (!this.heap.isObjectValid(objectPointedBy1)) {
                this.heap.removePointsToEdge(pKnownVal1);
                SMGKnownSymbolicValue tmp = pKnownVal1;
                pKnownVal1 = pKnownVal2;
                pKnownVal2 = tmp;
            } else if (!pKnownVal2.isZero() && this.heap.isPointer(pKnownVal2) && !this.heap.isObjectValid(objectPointedBy2 = this.heap.getObjectPointedBy(pKnownVal2))) {
                this.heap.removePointsToEdge(pKnownVal2);
            }
        }
        this.heap.replaceValue(pKnownVal1, pKnownVal2);
        Preconditions.checkArgument((!pKnownVal2.isZero() ? 1 : 0) != 0);
        SMGKnownExpValue expVal = this.explicitValues.get(pKnownVal2);
        this.explicitValues = this.explicitValues.removeAndCopy(pKnownVal2);
        if (expVal != null) {
            this.explicitValues = this.explicitValues.putAndCopy(pKnownVal1, expVal);
        }
    }

    public void identifyNonEqualValues(SMGKnownSymbolicValue pKnownVal1, SMGKnownSymbolicValue pKnownVal2) {
        this.heap.addNeqRelation(pKnownVal1, pKnownVal2);
    }

    @Override
    public boolean isTrackPredicatesEnabled() {
        return this.options.trackPredicates();
    }

    public boolean isTrackErrorPredicatesEnabled() {
        return this.options.trackErrorPredicates();
    }

    public boolean isCrashOnUnknownEnabled() {
        return this.options.crashOnUnknown();
    }

    public void addPredicateRelation(SMGValue pV1, SMGType pSMGType1, SMGValue pV2, SMGType pSMGType2, CBinaryExpression.BinaryOperator pOp, CFAEdge pEdge) {
        if (this.isTrackPredicatesEnabled() && pEdge instanceof CAssumeEdge) {
            CBinaryExpression.BinaryOperator temp = ((CAssumeEdge)pEdge).getTruthAssumption() ? pOp : pOp.getOppositLogicalOperator();
            this.logger.logf(Level.FINER, "SymValue1 %s %s SymValue2 %s AddPredicate: %s", new Object[]{pV1, temp, pV2, pEdge});
            this.getPathPredicateRelation().addRelation(pV1, pSMGType1, pV2, pSMGType2, temp);
        }
    }

    public void addPredicateRelation(SMGValue pV1, SMGType pSMGType1, SMGExplicitValue pV2, CBinaryExpression.BinaryOperator pOp, CFAEdge pEdge) {
        if (this.isTrackPredicatesEnabled() && pEdge instanceof CAssumeEdge) {
            CBinaryExpression.BinaryOperator temp = ((CAssumeEdge)pEdge).getTruthAssumption() ? pOp : pOp.getOppositLogicalOperator();
            this.logger.logf(Level.FINER, "SymValue %s %s; ExplValue %s; AddPredicate: %s", new Object[]{pV1, temp, pV2, pEdge});
            this.getPathPredicateRelation().addExplicitRelation(pV1, pSMGType1, pV2, temp);
        }
    }

    @Override
    public SMGPredicateRelation getPathPredicateRelation() {
        return this.heap.getPathPredicateRelation();
    }

    public void addErrorPredicate(SMGValue pSymbolicValue, SMGType pSymbolicSMGType, SMGExplicitValue pExplicitValue, CFAEdge pEdge) {
        if (this.isTrackErrorPredicatesEnabled()) {
            this.logger.log(Level.FINER, new Object[]{"Add Error Predicate: SymValue  ", pSymbolicValue, " ; ExplValue", " ", pExplicitValue, "; on edge: ", pEdge});
            this.getErrorPredicateRelation().addExplicitRelation(pSymbolicValue, pSymbolicSMGType, pExplicitValue, CBinaryExpression.BinaryOperator.GREATER_THAN);
        }
    }

    @Override
    public SMGPredicateRelation getErrorPredicateRelation() {
        return this.heap.getErrorPredicateRelation();
    }

    public SMGState resetErrorRelation() {
        SMGState newState = this.copyOf();
        newState.heap.resetErrorRelation();
        return newState;
    }

    public SMGKnownSymbolicValue putExplicit(SMGKnownSymbolicValue pKey, SMGKnownExpValue pValue) {
        Preconditions.checkNotNull((Object)pKey);
        Preconditions.checkNotNull((Object)pValue);
        if (this.explicitValues.inverse().containsKey(pValue)) {
            SMGKnownSymbolicValue symValue = this.explicitValues.inverse().get(pValue);
            if (!pKey.equals(symValue)) {
                if (symValue.isZero()) {
                    this.heap.replaceValue(symValue, pKey);
                } else {
                    Preconditions.checkArgument((!symValue.isZero() ? 1 : 0) != 0);
                    this.explicitValues = this.explicitValues.removeAndCopy(symValue);
                    this.heap.replaceValue(pKey, symValue);
                    this.explicitValues = this.explicitValues.putAndCopy(pKey, pValue);
                    return symValue;
                }
            }
            return null;
        }
        this.explicitValues = this.explicitValues.putAndCopy(pKey, pValue);
        return null;
    }

    @Deprecated
    public void clearExplicit(SMGKnownSymbolicValue pKey) {
        Preconditions.checkArgument((!pKey.isZero() ? 1 : 0) != 0);
        this.explicitValues = this.explicitValues.removeAndCopy(pKey);
    }

    @Override
    public boolean isExplicit(SMGValue value) {
        return this.explicitValues.containsKey(value);
    }

    @Override
    public @Nullable SMGKnownExpValue getExplicit(SMGValue pKey) {
        return this.explicitValues.get(pKey);
    }

    public @Nullable SMGKnownSymbolicValue getSymbolicOfExplicit(SMGExplicitValue pExplicitValue) {
        if (pExplicitValue.isZero()) {
            return SMGZeroValue.INSTANCE;
        }
        return this.explicitValues.inverse().get(pExplicitValue);
    }

    @Override
    public boolean hasMemoryErrors() {
        return this.errorInfo.hasMemoryErrors();
    }

    @Override
    public boolean hasMemoryLeaks() {
        return this.errorInfo.hasMemoryLeak();
    }

    @Override
    public boolean areNonEqual(SMGValue pValue1, SMGValue pValue2) {
        SMGObject object2;
        SMGObject object1;
        if (pValue1.isUnknown() || pValue2.isUnknown() || pValue1.equals(pValue2)) {
            return false;
        }
        if (pValue1 instanceof SMGExplicitValue && pValue2 instanceof SMGExplicitValue) {
            return !pValue1.equals(pValue2);
        }
        if (this.isExplicit(pValue1) && this.isExplicit(pValue2)) {
            return !this.getExplicit(pValue1).equals(this.getExplicit(pValue2));
        }
        if (this.heap.isPointer(pValue1) && this.heap.isPointer(pValue2) && !(object1 = this.heap.getObjectPointedBy(pValue1)).equals(object2 = this.heap.getObjectPointedBy(pValue2))) {
            return !this.heap.arePossibleEquals(object1, object2);
        }
        return this.heap.haveNeqRelation(pValue1, pValue2);
    }

    @Override
    public SMGObject getObjectForFunction(CFunctionDeclaration pDeclaration) {
        String functionQualifiedSMGName = SMGState.getUniqueFunctionName(pDeclaration);
        return this.heap.getObjectForVisibleVariable(functionQualifiedSMGName);
    }

    public SMGObject createObjectForFunction(CFunctionDeclaration pDeclaration) throws SMGInconsistentException {
        String functionQualifiedSMGName = SMGState.getUniqueFunctionName(pDeclaration);
        assert (this.heap.getObjectForVisibleVariable(functionQualifiedSMGName) == null);
        return this.addGlobalVariable(0L, functionQualifiedSMGName);
    }

    private static String getUniqueFunctionName(CFunctionDeclaration pDeclaration) {
        StringBuilder functionName = new StringBuilder(pDeclaration.getQualifiedName());
        for (CParameterDeclaration parameterDcl : pDeclaration.getParameters()) {
            functionName.append("_");
            functionName.append(CharMatcher.anyOf((CharSequence)"* ").replaceFrom((CharSequence)parameterDcl.toASTString(), (CharSequence)"_"));
        }
        return "__" + functionName;
    }

    public boolean executeHeapAbstraction(Set<SMGAbstractionBlock> blocks) throws SMGInconsistentException {
        boolean usesHeapInterpolation = true;
        SMGAbstractionManager manager = usesHeapInterpolation ? new SMGAbstractionManager(this.logger, this.heap, this, blocks, 2, 2, 2) : new SMGAbstractionManager(this.logger, this.heap, this, blocks, 2, 2, 3);
        boolean change = manager.execute();
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return change;
    }

    public Optional<SMGEdgeHasValue> forget(SMGMemoryPath location) {
        return this.heap.forget(location);
    }

    public void clearValues() {
        this.heap.clearValues();
    }

    public void writeUnknownValueInUnknownField(SMGObject target) {
        this.heap.getHVEdges(SMGEdgeHasValueFilter.objectFilter(target)).forEach(this.heap::removeHasValueEdge);
    }

    public void clearObjects() {
        this.heap.clearObjects();
    }

    public SMGAbstractionCandidate executeHeapAbstractionOneStep(Set<SMGAbstractionBlock> pResult) throws SMGInconsistentException {
        SMGAbstractionManager manager = new SMGAbstractionManager(this.logger, this.heap, this, pResult, 2, 2, 2);
        SMGAbstractionCandidate result = manager.executeOneStep();
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return result;
    }

    public boolean forgetNonTrackedHve(Set<SMGMemoryPath> pMempaths) {
        HashSet<SMGEdgeHasValue> trackedHves = new HashSet<SMGEdgeHasValue>();
        HashSet<SMGValue> trackedValues = new HashSet<SMGValue>();
        trackedValues.add(SMGZeroValue.INSTANCE);
        for (SMGMemoryPath path : pMempaths) {
            Optional<SMGEdgeHasValue> hve = this.heap.getHVEdgeFromMemoryLocation(path);
            if (!hve.isPresent()) continue;
            trackedHves.add(hve.orElseThrow());
            trackedValues.add(hve.orElseThrow().getValue());
        }
        boolean change = false;
        for (SMGEdgeHasValue edge : this.heap.getHVEdges()) {
            if (edge.getObject().isAbstract()) {
                trackedValues.add(edge.getValue());
                continue;
            }
            if (trackedHves.contains(edge)) continue;
            this.heap.removeHasValueEdge(edge);
            change = true;
        }
        if (change) {
            for (SMGValue value : this.heap.getValues()) {
                if (trackedValues.contains(value)) continue;
                this.heap.removePointsToEdge(value);
                this.heap.removeValue(value);
                change = true;
            }
        }
        return change;
    }

    public void forget(SMGEdgeHasValue pHveEdge) {
        this.heap.removeHasValueEdge(pHveEdge);
    }

    public void remember(SMGEdgeHasValue pHveEdge) {
        this.heap.addHasValueEdge(pHveEdge);
    }

    @Override
    public Map<MemoryLocation, SMGRegion> getStackVariables() {
        LinkedHashMap<MemoryLocation, SMGRegion> result = new LinkedHashMap<MemoryLocation, SMGRegion>();
        for (Map.Entry variableEntry : this.heap.getGlobalObjects().entrySet()) {
            String variableName = (String)variableEntry.getKey();
            SMGRegion reg = (SMGRegion)variableEntry.getValue();
            result.put(MemoryLocation.parseExtendedQualifiedName(variableName), reg);
        }
        for (CLangStackFrame frame : this.heap.getStackFrames()) {
            String functionName = frame.getFunctionDeclaration().getName();
            for (Map.Entry<String, SMGRegion> variableEntry : frame.getVariables().entrySet()) {
                String variableName = variableEntry.getKey();
                SMGRegion reg = variableEntry.getValue();
                result.put(MemoryLocation.forLocalVariable(functionName, variableName), reg);
            }
        }
        return result;
    }

    public boolean forgetNonTrackedStackVariables(Set<MemoryLocation> pTrackedStackVariables) {
        boolean change = false;
        for (String variable : this.heap.getGlobalObjects().keySet()) {
            MemoryLocation globalVar = MemoryLocation.parseExtendedQualifiedName(variable);
            if (pTrackedStackVariables.contains(globalVar)) continue;
            this.heap.removeGlobalVariableAndEdges(variable);
            change = true;
        }
        for (CLangStackFrame frame : this.heap.getStackFrames()) {
            String functionName = frame.getFunctionDeclaration().getName();
            for (String variable : frame.getVariables().keySet()) {
                MemoryLocation var = MemoryLocation.forLocalVariable(functionName, variable);
                if (pTrackedStackVariables.contains(var)) continue;
                this.heap.forgetFunctionStackVariable(var, false);
                change = true;
            }
        }
        return change;
    }

    public SMGStateInformation forgetStackVariable(MemoryLocation pMemoryLocation) {
        return this.heap.forgetStackVariable(pMemoryLocation);
    }

    public void remember(MemoryLocation pMemoryLocation, SMGRegion pRegion, SMGStateInformation pInfo) {
        this.heap.remember(pMemoryLocation, pRegion, pInfo);
    }

    public void unknownWrite() {
        if (!this.isTrackErrorPredicatesEnabled()) {
            this.heap.clearValues();
        }
    }

    @Override
    public String toDOTLabel() {
        String parent = this.getPredecessorId() == 0 ? "no parent, initial state" : "parent [" + this.getPredecessorId() + "]";
        return String.format("[%d] with %s", this.getId(), parent);
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public UnmodifiableCLangSMG getHeap() {
        return this.heap;
    }

    @Override
    public Set<Map.Entry<SMGKnownSymbolicValue, SMGKnownExpValue>> getExplicitValues() {
        return Collections.unmodifiableSet(this.explicitValues.entrySet());
    }

    static enum Property {
        INVALID_READ,
        INVALID_WRITE,
        INVALID_FREE,
        INVALID_HEAP;

    }

    public static class SMGStateEdgePair {
        private final SMGState smgState;
        private final @Nullable SMGEdgeHasValue edge;

        private SMGStateEdgePair(SMGState pState, @Nullable SMGEdgeHasValue pEdge) {
            this.smgState = pState;
            this.edge = pEdge;
        }

        public boolean smgStateHasNewEdge() {
            return this.edge != null;
        }

        public SMGEdgeHasValue getNewEdge() {
            return this.edge;
        }

        public SMGState getState() {
            return this.smgState;
        }
    }
}

