/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdgeSet;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;

public class SMGStateInformation {
    private static final SMGStateInformation EMPTY = new SMGStateInformation();
    private final SMGHasValueEdges hvEdges;
    private final ImmutableSet<SMGEdgePointsTo> ptEdges;
    private final boolean valid;
    private final boolean external;

    private SMGStateInformation() {
        this.hvEdges = new SMGHasValueEdgeSet();
        this.ptEdges = ImmutableSet.of();
        this.valid = false;
        this.external = false;
    }

    private SMGStateInformation(SMGHasValueEdges pHves, Set<SMGEdgePointsTo> pPtes, boolean pIsRegionValid, boolean pIsRegionExternallyAllocated) {
        this.hvEdges = pHves;
        this.ptEdges = ImmutableSet.copyOf(pPtes);
        this.valid = pIsRegionValid;
        this.external = pIsRegionExternallyAllocated;
    }

    public static SMGStateInformation of() {
        return EMPTY;
    }

    public ImmutableSet<SMGEdgePointsTo> getPtEdges() {
        return this.ptEdges;
    }

    public SMGHasValueEdges getHvEdges() {
        return this.hvEdges;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String toString() {
        return this.hvEdges + "\n" + this.ptEdges;
    }

    public static SMGStateInformation of(SMGHasValueEdges pHves, Set<SMGEdgePointsTo> ptes, boolean pIsRegionValid, boolean pIsRegionExternallyAllocated) {
        return new SMGStateInformation(pHves, ptes, pIsRegionValid, pIsRegionExternallyAllocated);
    }
}

