/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMGTest;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;

public class SMGStateTest {
    private static final LogManager logger = LogManager.createTestLogManager();
    private SMGState consistent_state;
    private SMGState inconsistent_state;
    private static final int mockSize16b = 16;
    private static final int mockSize8b = 8;
    private CSimpleType unspecifiedType = new CSimpleType(false, false, CBasicType.UNSPECIFIED, false, false, true, false, false, false, false);
    private CType pointerType = new CPointerType(false, false, this.unspecifiedType);
    private static final MachineModel MM = MachineModel.LINUX32;
    private final long ptrSize = MM.getSizeofInBits(this.pointerType).longValueExact();

    @Test
    public void abstractionTest() throws SMGInconsistentException, InvalidConfigurationException {
        CLangSMG smg1 = new CLangSMG(MM);
        smg1.addStackFrame(CLangSMGTest.DUMMY_FUNCTION);
        for (int i = 0; i < 20; ++i) {
            SMGCPA.getNewValue();
        }
        SMGKnownSymbolicValue value5 = SMGKnownSymValue.valueOf(5);
        SMGKnownSymbolicValue value6 = SMGKnownSymValue.valueOf(6);
        SMGKnownSymbolicValue value7 = SMGKnownSymValue.valueOf(7);
        SMGKnownSymbolicValue value8 = SMGKnownSymValue.valueOf(8);
        SMGKnownSymbolicValue value9 = SMGKnownSymValue.valueOf(9);
        SMGKnownSymbolicValue value10 = SMGKnownSymValue.valueOf(10);
        SMGRegion l1 = new SMGRegion(96L, "l1");
        SMGRegion l2 = new SMGRegion(96L, "l2");
        SMGRegion l3 = new SMGRegion(96L, "l3");
        SMGRegion l4 = new SMGRegion(96L, "l4");
        SMGRegion l5 = new SMGRegion(96L, "l5");
        SMGEdgeHasValue l1fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l1, (SMGValue)value7);
        SMGEdgeHasValue l2fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l2, (SMGValue)value8);
        SMGEdgeHasValue l3fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l3, (SMGValue)value9);
        SMGEdgeHasValue l4fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l4, (SMGValue)value10);
        SMGEdgeHasValue l5fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l5, (SMGValue)value5);
        SMGEdgeHasValue l1fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l1, (SMGValue)value5);
        SMGEdgeHasValue l2fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l2, (SMGValue)value6);
        SMGEdgeHasValue l3fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l3, (SMGValue)value7);
        SMGEdgeHasValue l4fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l4, (SMGValue)value8);
        SMGEdgeHasValue l5fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l5, (SMGValue)value9);
        SMGEdgePointsTo l1t = new SMGEdgePointsTo(value6, l1, 0L);
        SMGEdgePointsTo l2t = new SMGEdgePointsTo(value7, l2, 0L);
        SMGEdgePointsTo l3t = new SMGEdgePointsTo(value8, l3, 0L);
        SMGEdgePointsTo l4t = new SMGEdgePointsTo(value9, l4, 0L);
        SMGEdgePointsTo l5t = new SMGEdgePointsTo(value10, l5, 0L);
        smg1.addHeapObject(l1);
        smg1.addHeapObject(l2);
        smg1.addHeapObject(l3);
        smg1.addHeapObject(l4);
        smg1.addHeapObject(l5);
        smg1.addValue(value5);
        smg1.addValue(value6);
        smg1.addValue(value7);
        smg1.addValue(value8);
        smg1.addValue(value9);
        smg1.addValue(value10);
        smg1.addHasValueEdge(l1fn);
        smg1.addHasValueEdge(l2fn);
        smg1.addHasValueEdge(l3fn);
        smg1.addHasValueEdge(l4fn);
        smg1.addHasValueEdge(l5fn);
        smg1.addHasValueEdge(l1fp);
        smg1.addHasValueEdge(l2fp);
        smg1.addHasValueEdge(l3fp);
        smg1.addHasValueEdge(l4fp);
        smg1.addHasValueEdge(l5fp);
        smg1.addPointsToEdge(l1t);
        smg1.addPointsToEdge(l2t);
        smg1.addPointsToEdge(l3t);
        smg1.addPointsToEdge(l4t);
        smg1.addPointsToEdge(l5t);
        smg1.setValidity(l1, true);
        smg1.setValidity(l2, true);
        smg1.setValidity(l3, true);
        smg1.setValidity(l4, true);
        smg1.setValidity(l5, true);
        SMGState smg1State = new SMGState(logger, new SMGOptions(Configuration.defaultConfiguration()), smg1, 0, PersistentBiMap.of());
        SMGRegion head = smg1State.addGlobalVariable(64L, "head");
        smg1State.addPointsToEdge(head, 0L, value5);
        smg1State.writeValue(head, 0L, this.ptrSize, SMGKnownSymValue.valueOf(6));
        smg1State.writeValue(head, 4L, this.ptrSize, SMGKnownSymValue.valueOf(10));
        smg1State.performConsistencyCheck(SMGRuntimeCheck.NONE);
        smg1State.executeHeapAbstraction((Set<SMGAbstractionBlock>)ImmutableSet.of());
        smg1State.performConsistencyCheck(SMGRuntimeCheck.NONE);
    }

    @Test
    public void materialiseTest() throws SMGInconsistentException, InvalidConfigurationException {
        for (int i = 0; i < 20; ++i) {
            SMGCPA.getNewValue();
        }
        CLangSMG heap = new CLangSMG(MachineModel.LINUX32);
        SMGKnownSymbolicValue value5 = SMGKnownSymValue.valueOf(5);
        SMGKnownSymbolicValue value6 = SMGKnownSymValue.valueOf(6);
        SMGKnownSymbolicValue value7 = SMGKnownSymValue.valueOf(7);
        SMGKnownSymbolicValue value8 = SMGKnownSymValue.valueOf(8);
        SMGKnownSymbolicValue value9 = SMGKnownSymValue.valueOf(9);
        SMGKnownSymbolicValue value10 = SMGKnownSymValue.valueOf(10);
        SMGKnownSymbolicValue value11 = SMGKnownSymValue.valueOf(11);
        SMGKnownSymbolicValue value12 = SMGKnownSymValue.valueOf(12);
        SMGKnownSymbolicValue value13 = SMGKnownSymValue.valueOf(13);
        SMGDoublyLinkedList dll = new SMGDoublyLinkedList(96L, 0L, 0L, 32L, 0, 0);
        SMGEdgeHasValue dllN = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)dll, (SMGValue)value5);
        SMGEdgeHasValue dllP = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)dll, (SMGValue)value5);
        heap.addHeapObject(dll);
        heap.setValidity(dll, true);
        heap.addValue(value5);
        heap.addValue(value6);
        heap.addValue(value7);
        heap.addHasValueEdge(dllP);
        heap.addHasValueEdge(dllN);
        heap.addPointsToEdge(new SMGEdgePointsTo(value6, dll, 0L, SMGTargetSpecifier.FIRST));
        heap.addPointsToEdge(new SMGEdgePointsTo(value7, dll, 0L, SMGTargetSpecifier.LAST));
        SMGRegion l1 = new SMGRegion(96L, "l1", 1);
        SMGRegion l2 = new SMGRegion(96L, "l2", 1);
        SMGRegion l3 = new SMGRegion(96L, "l3", 1);
        SMGRegion l4 = new SMGRegion(96L, "l4", 1);
        SMGRegion l5 = new SMGRegion(96L, "l5", 1);
        SMGEdgeHasValue l1fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l1, (SMGValue)value13);
        SMGEdgeHasValue l2fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l2, (SMGValue)value8);
        SMGEdgeHasValue l3fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l3, (SMGValue)value9);
        SMGEdgeHasValue l4fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l4, (SMGValue)value10);
        SMGEdgeHasValue l5fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l5, (SMGValue)value11);
        SMGEdgeHasValue dllSub = new SMGEdgeHasValue(this.ptrSize, 64L, (SMGObject)dll, (SMGValue)value12);
        SMGEdgeHasValue l1fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l1, (SMGValue)value11);
        SMGEdgeHasValue l2fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l2, (SMGValue)value12);
        SMGEdgeHasValue l3fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l3, (SMGValue)value13);
        SMGEdgeHasValue l4fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l4, (SMGValue)value8);
        SMGEdgeHasValue l5fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l5, (SMGValue)value9);
        SMGEdgePointsTo l1t = new SMGEdgePointsTo(value12, l1, 0L);
        SMGEdgePointsTo l2t = new SMGEdgePointsTo(value13, l2, 0L);
        SMGEdgePointsTo l3t = new SMGEdgePointsTo(value8, l3, 0L);
        SMGEdgePointsTo l4t = new SMGEdgePointsTo(value9, l4, 0L);
        SMGEdgePointsTo l5t = new SMGEdgePointsTo(value10, l5, 0L);
        heap.addHeapObject(l1);
        heap.addHeapObject(l2);
        heap.addHeapObject(l3);
        heap.addHeapObject(l4);
        heap.addHeapObject(l5);
        heap.addValue(value11);
        heap.addValue(value12);
        heap.addValue(value13);
        heap.addValue(value8);
        heap.addValue(value9);
        heap.addValue(value10);
        heap.addHasValueEdge(l1fn);
        heap.addHasValueEdge(l2fn);
        heap.addHasValueEdge(l3fn);
        heap.addHasValueEdge(l4fn);
        heap.addHasValueEdge(l5fn);
        heap.addHasValueEdge(dllSub);
        heap.addHasValueEdge(l1fp);
        heap.addHasValueEdge(l2fp);
        heap.addHasValueEdge(l3fp);
        heap.addHasValueEdge(l4fp);
        heap.addHasValueEdge(l5fp);
        heap.addPointsToEdge(l1t);
        heap.addPointsToEdge(l2t);
        heap.addPointsToEdge(l3t);
        heap.addPointsToEdge(l4t);
        heap.addPointsToEdge(l5t);
        heap.setValidity(l1, true);
        heap.setValidity(l2, true);
        heap.setValidity(l3, true);
        heap.setValidity(l4, true);
        heap.setValidity(l5, true);
        SMGState smg1State = new SMGState(logger, new SMGOptions(Configuration.defaultConfiguration()), heap, 0, PersistentBiMap.of());
        smg1State.addStackFrame(CLangSMGTest.DUMMY_FUNCTION);
        SMGRegion head = smg1State.addGlobalVariable(64L, "head");
        smg1State.addPointsToEdge(head, 0L, value5);
        smg1State.writeValue(head, 0L, this.ptrSize, SMGKnownSymValue.valueOf(6));
        smg1State.writeValue(head, 32L, this.ptrSize, SMGKnownSymValue.valueOf(10));
        smg1State.performConsistencyCheck(SMGRuntimeCheck.NONE);
        List<SMGAbstractObjectAndState.SMGAddressValueAndState> add = smg1State.getPointerFromValue(value6);
        add.get(1).getSmgState().performConsistencyCheck(SMGRuntimeCheck.NONE);
        add.get(0).getSmgState().performConsistencyCheck(SMGRuntimeCheck.NONE);
        SMGState newState = add.get(1).getSmgState();
        List<SMGAbstractObjectAndState.SMGAddressValueAndState> add2 = newState.getPointerFromValue(value7);
        add2.get(1).getSmgState().performConsistencyCheck(SMGRuntimeCheck.NONE);
        add2.get(0).getSmgState().performConsistencyCheck(SMGRuntimeCheck.NONE);
    }

    @Test
    public void materialiseNullifiedDlsWithHiddenPrevFieldTest() throws SMGInconsistentException, InvalidConfigurationException {
        int sizeInBits = 96;
        long hfo = 0L;
        long nfo = 0L;
        long pfo = 32L;
        int minLength = 3;
        boolean level = false;
        MachineModel model32 = MachineModel.LINUX32;
        int ptrSizeInBits = model32.getSizeofPtrInBits();
        CLangSMG heap = new CLangSMG(model32);
        SMGKnownSymbolicValue value6 = SMGKnownSymValue.valueOf(6);
        SMGKnownSymbolicValue value7 = SMGKnownSymValue.valueOf(7);
        SMGKnownSymbolicValue value8 = SMGKnownSymValue.valueOf(8);
        SMGKnownSymbolicValue value9 = SMGKnownSymValue.valueOf(9);
        heap.addValue(value6);
        heap.addValue(value7);
        heap.addValue(value8);
        heap.addValue(value9);
        SMGDoublyLinkedList dll = new SMGDoublyLinkedList(96L, 0L, 0L, 32L, 3, 0);
        heap.addHeapObject(dll);
        heap.setValidity(dll, true);
        heap.addPointsToEdge(new SMGEdgePointsTo(value6, dll, 0L, SMGTargetSpecifier.FIRST));
        heap.addPointsToEdge(new SMGEdgePointsTo(value7, dll, 0L, SMGTargetSpecifier.LAST));
        SMGEdgeHasValue nextField = new SMGEdgeHasValue(96L, 0L, (SMGObject)dll, (SMGValue)SMGZeroValue.INSTANCE);
        heap.addHasValueEdge(nextField);
        SMGOptions options = new SMGOptions(Configuration.defaultConfiguration());
        SMGState smg1State = new SMGState(logger, options, heap, 0, PersistentBiMap.of());
        smg1State.addStackFrame(CLangSMGTest.DUMMY_FUNCTION);
        SMGRegion head = smg1State.addGlobalVariable(model32.getSizeofPtrInBits(), "head");
        smg1State.writeValue(head, 0L, this.ptrSize, value6);
        smg1State.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        List<SMGAbstractObjectAndState.SMGAddressValueAndState> valAndStates1 = smg1State.getPointerFromValue(value6);
        Truth.assertThat(valAndStates1).hasSize(1);
        SMGState newState = valAndStates1.get(0).getSmgState();
        newState.pruneUnreachable();
        newState.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        UnmodifiableCLangSMG newSMG = newState.getHeap();
        SMGObject concreteRegion = newSMG.getObjectPointedBy(value6);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject regFilter = SMGEdgeHasValueFilter.objectFilter(concreteRegion);
        SMGEdgeHasValue newNextField = (SMGEdgeHasValue)Iterables.getOnlyElement(newSMG.getHVEdges(regFilter.filterAtOffset(0L).filterWithoutSize()));
        SMGEdgeHasValue prevField = (SMGEdgeHasValue)Iterables.getOnlyElement(newSMG.getHVEdges(regFilter.filterAtOffset(32L).filterWithoutSize()));
        Truth.assertThat((Long)newNextField.getSizeInBits()).isEqualTo((Object)ptrSizeInBits);
        Truth.assertThat((Long)prevField.getSizeInBits()).isEqualTo((Object)(2 * ptrSizeInBits));
        SMGObject newDll = newSMG.getPointer(newNextField.getValue()).getObject();
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject newDllFilter = SMGEdgeHasValueFilter.objectFilter(newDll);
        SMGEdgeHasValue newDllPrevField = (SMGEdgeHasValue)Iterables.getOnlyElement(newSMG.getHVEdges(newDllFilter.filterAtOffset(32L).filterWithoutSize()));
        Truth.assertThat((Comparable)newSMG.getPointer(newDllPrevField.getValue()).getObject()).isEqualTo((Object)concreteRegion);
        Truth.assertThat((Comparable)newDll).isInstanceOf(SMGDoublyLinkedList.class);
        Truth.assertThat((Integer)((SMGDoublyLinkedList)newDll).getMinimumLength()).isEqualTo((Object)(dll.getMinimumLength() - 1));
        Truth.assertThat((Comparable)prevField.getValue()).isEqualTo((Object)SMGZeroValue.INSTANCE);
    }

    @Test
    public void materialiseNullifiedSlsWithHiddenNextFieldTest() throws SMGInconsistentException, InvalidConfigurationException {
        int sizeInBits = 96;
        long hfo = 0L;
        long dfo1 = 0L;
        long nfo = 32L;
        long dfo2 = 64L;
        int minLength = 3;
        boolean level = false;
        MachineModel model32 = MachineModel.LINUX32;
        int ptrSizeInBits = model32.getSizeofPtrInBits();
        CLangSMG heap = new CLangSMG(model32);
        SMGKnownSymbolicValue value6 = SMGKnownSymValue.valueOf(6);
        heap.addValue(value6);
        SMGSingleLinkedList sll = new SMGSingleLinkedList(96L, 0L, 32L, 3, 0);
        heap.addHeapObject(sll);
        heap.setValidity(sll, true);
        heap.addPointsToEdge(new SMGEdgePointsTo(value6, sll, 0L, SMGTargetSpecifier.FIRST));
        SMGEdgeHasValue initialDataField = new SMGEdgeHasValue(96L, 0L, (SMGObject)sll, (SMGValue)SMGZeroValue.INSTANCE);
        heap.addHasValueEdge(initialDataField);
        SMGOptions options = new SMGOptions(Configuration.defaultConfiguration());
        SMGState smg1State = new SMGState(logger, options, heap, 0, PersistentBiMap.of());
        smg1State.addStackFrame(CLangSMGTest.DUMMY_FUNCTION);
        SMGRegion head = smg1State.addGlobalVariable(model32.getSizeofPtrInBits(), "head");
        smg1State.writeValue(head, 0L, this.ptrSize, value6);
        smg1State.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        List<SMGAbstractObjectAndState.SMGAddressValueAndState> valAndStates1 = smg1State.getPointerFromValue(value6);
        Truth.assertThat(valAndStates1).hasSize(1);
        SMGState newState = valAndStates1.get(0).getSmgState();
        newState.pruneUnreachable();
        newState.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        UnmodifiableCLangSMG newSMG = newState.getHeap();
        SMGObject concreteRegion = newSMG.getObjectPointedBy(value6);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject regFilter = SMGEdgeHasValueFilter.objectFilter(concreteRegion);
        SMGEdgeHasValue dataFieldBeforeNext = (SMGEdgeHasValue)Iterables.getOnlyElement(newSMG.getHVEdges(regFilter.filterAtOffset(0L).filterWithoutSize()));
        SMGEdgeHasValue nextField = (SMGEdgeHasValue)Iterables.getOnlyElement(newSMG.getHVEdges(regFilter.filterAtOffset(32L).filterWithoutSize()));
        SMGEdgeHasValue dataFieldAfterNext = (SMGEdgeHasValue)Iterables.getOnlyElement(newSMG.getHVEdges(regFilter.filterAtOffset(64L).filterWithoutSize()));
        Truth.assertThat((Long)dataFieldBeforeNext.getSizeInBits()).isEqualTo((Object)ptrSizeInBits);
        Truth.assertThat((Long)nextField.getSizeInBits()).isEqualTo((Object)ptrSizeInBits);
        Truth.assertThat((Long)dataFieldAfterNext.getSizeInBits()).isEqualTo((Object)ptrSizeInBits);
        Truth.assertThat((Boolean)newSMG.isPointer(nextField.getValue())).isTrue();
        SMGObject newSll = newSMG.getPointer(nextField.getValue()).getObject();
        SMGValue sllAddress = ((SMGEdgePointsTo)Iterables.getOnlyElement(newSMG.getPtEdges(SMGEdgePointsToFilter.targetObjectFilter(newSll).filterAtTargetOffset(0L)))).getValue();
        Truth.assertThat((Comparable)nextField.getValue()).isEqualTo((Object)sllAddress);
        Truth.assertThat((Comparable)dataFieldBeforeNext.getValue()).isEqualTo((Object)SMGZeroValue.INSTANCE);
        Truth.assertThat((Comparable)dataFieldAfterNext.getValue()).isEqualTo((Object)SMGZeroValue.INSTANCE);
        Truth.assertThat((Comparable)newSll).isInstanceOf(SMGSingleLinkedList.class);
        Truth.assertThat((Integer)((SMGSingleLinkedList)newSll).getMinimumLength()).isEqualTo((Object)(sll.getMinimumLength() - 1));
    }

    @Before
    public void setUp() throws SMGInconsistentException, InvalidConfigurationException {
        ConfigurationBuilder builder = Configuration.builder();
        builder.setOption("cpa.smg.runtimeCheck", "HALF");
        Configuration config = builder.build();
        this.consistent_state = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(config));
        this.inconsistent_state = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(config));
        SMGEdgePointsTo pt = this.inconsistent_state.addNewHeapAllocation(8, "label");
        this.consistent_state.addGlobalObject((SMGRegion)pt.getObject());
        this.inconsistent_state.addGlobalObject((SMGRegion)pt.getObject());
    }

    @Test(expected=SMGInconsistentException.class)
    public void ConfigurableConsistencyInconsistentReported1Test() throws SMGInconsistentException {
        SMGState inconsistentState = this.inconsistent_state.copyOf();
        inconsistentState.performConsistencyCheck(SMGRuntimeCheck.NONE);
    }

    @Test(expected=SMGInconsistentException.class)
    public void ConfigurableConsistencyInconsistentReported2Test() throws SMGInconsistentException {
        SMGState inconsistentState = this.inconsistent_state.copyOf();
        inconsistentState.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    @Test
    public void ConfigurableConsistencyInconsistentNotReportedTest() throws SMGInconsistentException {
        SMGState inconsistentState = this.inconsistent_state.copyOf();
        inconsistentState.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    @Test
    public void ConfigurableConsistencyConsistent1Test() throws SMGInconsistentException {
        SMGState consistentState = this.consistent_state.copyOf();
        consistentState.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    @Test
    public void ConfigurableConsistencyConsistent2Test() throws SMGInconsistentException {
        SMGState consistentState = this.consistent_state.copyOf();
        consistentState.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    @Test
    public void PredecessorsTest() throws InvalidConfigurationException {
        SMGState original = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration()));
        SMGState second = original.copyOf();
        Truth.assertThat((Integer)second.getId()).isNotEqualTo((Object)original.getId());
        SMGState copy = original.copyOf();
        Truth.assertThat((Integer)original.getId()).isNotEqualTo((Object)copy.getId());
        Truth.assertThat((Integer)second.getId()).isNotEqualTo((Object)copy.getId());
        Truth.assertThat((Integer)original.getId()).isEqualTo((Object)second.getPredecessorId());
        Truth.assertThat((Integer)original.getId()).isEqualTo((Object)copy.getPredecessorId());
    }

    @Test
    public void WriteReinterpretationTest() throws SMGInconsistentException, InvalidConfigurationException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration()));
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        SMGKnownSymbolicValue new_value = SMGKnownSymValue.of();
        SMGEdgeHasValue hv = state.writeValue(pt.getObject(), 0L, 16L, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filter = SMGEdgeHasValueFilter.objectFilter(pt.getObject());
        SMGHasValueEdges values_for_obj = state.getHVEdges(filter);
        Truth.assertThat((Iterable)values_for_obj).hasSize(1);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv);
        state.writeValue(pt.getObject(), 0L, 16L, new_value);
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Truth.assertThat((Iterable)values_for_obj).hasSize(1);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv);
        SMGKnownSymbolicValue newer_value = SMGKnownSymValue.valueOf(SMGCPA.getNewValue());
        SMGEdgeHasValue new_hv = state.writeValue(pt.getObject(), 0L, 16L, newer_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Truth.assertThat((Iterable)values_for_obj).hasSize(1);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)new_hv);
        Truth.assertThat((Iterable)values_for_obj).doesNotContain((Object)hv);
        SMGEdgeHasValue hv8at0 = state.writeValue(pt.getObject(), 0L, 8L, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Truth.assertThat((Iterable)values_for_obj).hasSize(1);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv8at0);
        SMGEdgeHasValue hv8at8 = state.writeValue(pt.getObject(), 8L, 8L, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Truth.assertThat((Iterable)values_for_obj).hasSize(2);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv8at0);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv8at8);
        SMGEdgeHasValue hv8at4 = state.writeValue(pt.getObject(), 4L, 8L, new_value).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(filter);
        Truth.assertThat((Iterable)values_for_obj).hasSize(1);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv8at4);
        Truth.assertThat((Iterable)values_for_obj).doesNotContain((Object)hv8at0);
        Truth.assertThat((Iterable)values_for_obj).doesNotContain((Object)hv8at8);
    }

    @Test
    public void WriteReinterpretationNullifiedTest() throws SMGInconsistentException, InvalidConfigurationException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration()));
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        SMGEdgeHasValue hv = state.writeValue(pt.getObject(), 0L, 16L, SMGZeroValue.INSTANCE).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGHasValueEdges values_for_obj = state.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pt.getObject()));
        Truth.assertThat((Iterable)values_for_obj).hasSize(1);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv);
        SMGEdgeHasValue hv8at4 = state.writeValue(pt.getObject(), 4L, 8L, SMGUnknownValue.INSTANCE).getNewEdge();
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        values_for_obj = state.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pt.getObject()));
        Truth.assertThat((Iterable)values_for_obj).hasSize(3);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)hv8at4);
        Truth.assertThat((Iterable)values_for_obj).contains((Object)new SMGEdgeHasValue(4L, 0L, pt.getObject(), (SMGValue)SMGZeroValue.INSTANCE));
        Truth.assertThat((Iterable)values_for_obj).contains((Object)new SMGEdgeHasValue(4L, 12L, pt.getObject(), (SMGValue)SMGZeroValue.INSTANCE));
        SMGEdgeHasValueFilter nullFilter = SMGEdgeHasValueFilter.objectFilter(pt.getObject()).filterHavingValue(SMGZeroValue.INSTANCE).filterWithoutSize();
        Iterable<SMGEdgeHasValue> nulls_for_value = state.getHVEdges(nullFilter);
        Truth.assertThat(nulls_for_value).hasSize(2);
        Truth.assertThat(state.getHVEdges(nullFilter.filterAtOffset(0L))).hasSize(1);
        Truth.assertThat(state.getHVEdges(nullFilter.filterAtOffset(12L))).hasSize(1);
    }

    @Test
    public void getPointerFromValueTest() throws SMGInconsistentException, InvalidConfigurationException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration()));
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        SMGAddressValue pt_obtained = ((SMGAbstractObjectAndState.SMGAddressValueAndState)Iterables.getOnlyElement(state.getPointerFromValue(pt.getValue()))).getObject();
        Truth.assertThat((Comparable)pt.getObject()).isEqualTo((Object)pt_obtained.getObject());
    }

    @Test(expected=SMGInconsistentException.class)
    public void getPointerFromValueNonPointerTest() throws SMGInconsistentException, InvalidConfigurationException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration()));
        state.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        SMGEdgePointsTo pt = state.addNewHeapAllocation(16, "OBJECT");
        SMGKnownSymbolicValue nonpointer = SMGKnownSymValue.of();
        state.writeValue(pt.getObject(), 0L, 16L, nonpointer);
        state.getPointerFromValue(nonpointer);
    }

    @Test
    public void SMGStateMemoryLeaksTest() throws InvalidConfigurationException {
        SMGState state = new SMGState(logger, MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration()));
        Truth.assertThat((Boolean)state.hasMemoryLeaks()).isFalse();
        state.setMemLeak("", (Collection<SMGObject>)ImmutableList.of());
        Truth.assertThat((Boolean)state.hasMemoryLeaks()).isTrue();
    }
}

