/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGExportDotOption;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGPredicateManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelationKind;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.AssumeVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.LValueAssignmentVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGRightHandSideEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPrecision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class SMGTransferRelation
extends ForwardingTransferRelation<Collection<SMGState>, SMGState, SMGPrecision> {
    private static final UniqueIdGenerator ID_COUNTER = new UniqueIdGenerator();
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel machineModel;
    private final SMGOptions options;
    private final SMGExportDotOption exportSMGOptions;
    private final SMGPredicateManager smgPredicateManager;
    private final ShutdownNotifier shutdownNotifier;
    final SMGRightHandSideEvaluator expressionEvaluator;
    private final SMGTransferRelationKind kind;

    public SMGTransferRelation(LogManager pLogger, MachineModel pMachineModel, SMGExportDotOption pExportOptions, SMGTransferRelationKind pKind, SMGPredicateManager pSMGPredicateManager, SMGOptions pOptions, ShutdownNotifier pShutdownNotifier) {
        this.kind = pKind;
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.machineModel = pMachineModel;
        this.expressionEvaluator = new SMGRightHandSideEvaluator(this.logger, this.machineModel, pOptions, this.kind, pExportOptions);
        this.smgPredicateManager = pSMGPredicateManager;
        this.options = pOptions;
        this.exportSMGOptions = pExportOptions;
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    protected Collection<SMGState> postProcessing(Collection<SMGState> pSuccessors, CFAEdge edge) {
        this.plotWhenConfigured(pSuccessors, "Line " + edge.getLineNumber() + ": " + edge.getDescription(), SMGOptions.SMGExportLevel.INTERESTING);
        ArrayList<SMGState> successors = new ArrayList<SMGState>();
        for (SMGState s : pSuccessors) {
            for (CSimpleDeclaration variable : edge.getSuccessor().getOutOfScopeVariables()) {
                s.forgetStackVariable(MemoryLocation.forDeclaration(variable));
            }
            successors.add(this.checkAndSetErrorRelation(s));
        }
        return successors;
    }

    private void plotWhenConfigured(Collection<? extends UnmodifiableSMGState> pStates, String pLocation, SMGOptions.SMGExportLevel pLevel) {
        for (UnmodifiableSMGState unmodifiableSMGState : pStates) {
            SMGUtils.plotWhenConfigured(this.getDotExportFileName(unmodifiableSMGState), unmodifiableSMGState, pLocation, (LogManager)this.logger, pLevel, this.exportSMGOptions);
        }
    }

    private String getDotExportFileName(UnmodifiableSMGState pState) {
        if (pState.getPredecessorId() == 0) {
            return String.format("initial-%03d", pState.getId());
        }
        return String.format("%04d-%04d-%04d", pState.getPredecessorId(), pState.getId(), ID_COUNTER.getFreshId());
    }

    @Override
    protected Set<SMGState> handleBlankEdge(BlankEdge cfaEdge) throws CPATransferException {
        if (cfaEdge.getSuccessor() instanceof FunctionExitNode) {
            assert ("default return".equals(cfaEdge.getDescription()) || "skipped unnecessary edges".equals(cfaEdge.getDescription()));
            if (cfaEdge.getSuccessor().getNumLeavingEdges() == 0) {
                SMGState successor = ((SMGState)this.state).copyOf();
                if (this.options.isHandleNonFreedMemoryInMainAsMemLeak()) {
                    successor.dropStackFrame();
                }
                successor.pruneUnreachable();
                return Collections.singleton(successor);
            }
        }
        return Collections.singleton((SMGState)this.state);
    }

    @Override
    protected Collection<SMGState> handleReturnStatementEdge(CReturnStatementEdge returnEdge) throws CPATransferException {
        Object successors;
        SMGState smgState = ((SMGState)this.state).copyOf();
        SMGObject tmpFieldMemory = smgState.getHeap().getFunctionReturnObject();
        if (tmpFieldMemory != null) {
            CExpression returnExp = returnEdge.getExpression().orElse(CIntegerLiteralExpression.ZERO);
            CType expType = TypeUtils.getRealExpressionType(returnExp);
            Optional<CAssignment> returnAssignment = returnEdge.asAssignment();
            if (returnAssignment.isPresent()) {
                expType = returnAssignment.orElseThrow().getLeftHandSide().getExpressionType();
            }
            successors = this.assignFieldToState(smgState, returnEdge, tmpFieldMemory, 0L, expType, returnExp);
        } else {
            successors = ImmutableList.of((Object)smgState);
        }
        if (returnEdge.getSuccessor().getNumLeavingEdges() == 0) {
            for (SMGState successor : successors) {
                if (this.options.isHandleNonFreedMemoryInMainAsMemLeak()) {
                    successor.dropStackFrame();
                }
                successor.pruneUnreachable();
            }
        }
        return successors;
    }

    @Override
    protected Collection<SMGState> handleFunctionReturnEdge(CFunctionReturnEdge functionReturnEdge, CFunctionSummaryEdge fnkCall, CFunctionCall summaryExpr, String callerFunctionName) throws CPATransferException {
        List<SMGState> successors = this.handleFunctionReturn(functionReturnEdge);
        if (this.options.isCheckForMemLeaksAtEveryFrameDrop()) {
            for (SMGState successor : successors) {
                SMGUtils.plotWhenConfigured("beforePrune" + this.getDotExportFileName(successor), successor, functionReturnEdge.getDescription(), (LogManager)this.logger, SMGOptions.SMGExportLevel.INTERESTING, this.exportSMGOptions);
                successor.pruneUnreachable();
            }
        }
        return successors;
    }

    private List<SMGState> handleFunctionReturn(CFunctionReturnEdge functionReturnEdge) throws CPATransferException {
        CFunctionSummaryEdge summaryEdge = functionReturnEdge.getSummaryEdge();
        CFunctionCall exprOnSummary = summaryEdge.getExpression();
        SMGState newState = ((SMGState)this.state).copyOf();
        assert (((CLangStackFrame)Iterables.getLast(newState.getHeap().getStackFrames())).getFunctionDeclaration().equals(functionReturnEdge.getFunctionEntry().getFunctionDefinition()));
        if (exprOnSummary instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement funcAssignment = (CFunctionCallAssignmentStatement)exprOnSummary;
            CLeftHandSide lValue = funcAssignment.getLeftHandSide();
            CType rValueType = TypeUtils.getRealExpressionType(funcAssignment.getRightHandSide());
            SMGObject tmpMemory = newState.getHeap().getFunctionReturnObject();
            SMGValue rValue = (SMGValue)this.expressionEvaluator.readValue(newState, tmpMemory, SMGZeroValue.INSTANCE, rValueType, functionReturnEdge).getObject();
            newState.dropStackFrame();
            LValueAssignmentVisitor visitor = this.expressionEvaluator.getLValueAssignmentVisitor(functionReturnEdge, newState);
            List<SMGAbstractObjectAndState.SMGAddressAndState> addressAndValues = lValue.accept(visitor);
            ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)addressAndValues.size());
            for (SMGAbstractObjectAndState.SMGAddressAndState addressAndValue : addressAndValues) {
                SMGAddress address = (SMGAddress)addressAndValue.getObject();
                SMGState newState2 = addressAndValue.getSmgState();
                if (!address.isUnknown()) {
                    if (rValue.isUnknown()) {
                        rValue = SMGKnownSymValue.of();
                    }
                    SMGObject object = address.getObject();
                    long offset = address.getOffset().getAsLong();
                    rValueType = TypeUtils.getRealExpressionType(lValue);
                    SMGState resultState = this.expressionEvaluator.assignFieldToState(newState2, functionReturnEdge, object, offset, rValue, rValueType);
                    result.add((Object)resultState);
                    continue;
                }
                result.add((Object)newState2);
            }
            return result.build();
        }
        newState.dropStackFrame();
        return ImmutableList.of((Object)newState);
    }

    @Override
    protected Collection<SMGState> handleFunctionCallEdge(CFunctionCallEdge callEdge, List<CExpression> arguments, List<CParameterDeclaration> paramDecl, String calledFunctionName) throws CPATransferException {
        if (!callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs()) assert (paramDecl.size() == arguments.size());
        SMGState initialNewState = ((SMGState)this.state).copyOf();
        LinkedHashMap<UnmodifiableSMGState, List<Pair<SMGRegion, SMGValue>>> valuesMap = new LinkedHashMap<UnmodifiableSMGState, List<Pair<SMGRegion, SMGValue>>>();
        ArrayList initialValuesList = new ArrayList();
        valuesMap.put(initialNewState, initialValuesList);
        List<SMGState> newStates = this.evaluateArgumentValues(callEdge, arguments, paramDecl, initialNewState, valuesMap);
        for (SMGState newState : newStates) {
            this.assignParameterValues(callEdge, paramDecl, (List)valuesMap.get(newState), newState);
        }
        return newStates;
    }

    private List<SMGState> evaluateArgumentValues(CFunctionCallEdge callEdge, List<CExpression> arguments, List<CParameterDeclaration> paramDecl, SMGState initialNewState, Map<UnmodifiableSMGState, List<Pair<SMGRegion, SMGValue>>> valuesMap) throws CPATransferException {
        List<SMGState> newStates = Collections.singletonList(initialNewState);
        for (int i = 0; i < paramDecl.size(); ++i) {
            CExpression exp = arguments.get(i);
            String varName = paramDecl.get(i).getName();
            CType cParamType = TypeUtils.getRealExpressionType(paramDecl.get(i));
            ArrayList<SMGState> result = new ArrayList<SMGState>();
            if (exp instanceof CCastExpression) {
                exp = ((CCastExpression)exp).getOperand();
            }
            if (exp instanceof CStringLiteralExpression) {
                CStringLiteralExpression strExp = (CStringLiteralExpression)exp;
                cParamType = strExp.transformTypeToArrayType();
                String name = strExp.getContentString() + " string literal";
                SMGRegion stringObj = initialNewState.getHeap().getObjectForVisibleVariable(name);
                if (stringObj != null) {
                    name = name + "ID" + SMGCPA.getNewValue();
                }
                stringObj = initialNewState.addGlobalVariable(this.machineModel.getSizeofInBits(cParamType).longValue(), name);
                CInitializerExpression initializer = new CInitializerExpression(exp.getFileLocation(), exp);
                CVariableDeclaration decl = new CVariableDeclaration(exp.getFileLocation(), true, CStorageClass.AUTO, cParamType, name, name, name, initializer);
                newStates = new ArrayList<SMGState>(this.handleInitializer(initialNewState, decl, callEdge, stringObj, 0L, cParamType, initializer));
                exp = new CIdExpression(exp.getFileLocation(), cParamType, name, decl);
            }
            long size = cParamType instanceof CArrayType ? (long)this.machineModel.getSizeofPtrInBits() : this.expressionEvaluator.getBitSizeof(callEdge, cParamType, initialNewState);
            SMGRegion paramObj = new SMGRegion(size, varName);
            for (SMGState newState : newStates) {
                result.addAll(this.evaluateArgumentValue(callEdge, valuesMap, i, exp, paramObj, newState));
            }
            newStates = result;
        }
        return newStates;
    }

    private List<SMGState> evaluateArgumentValue(CFunctionCallEdge callEdge, Map<UnmodifiableSMGState, List<Pair<SMGRegion, SMGValue>>> valuesMap, int i, CExpression exp, SMGRegion paramObj, SMGState newState) throws CPATransferException {
        ArrayList<SMGState> result = new ArrayList<SMGState>();
        for (SMGAbstractObjectAndState.SMGValueAndState stateValue : this.readValueToBeAssiged(newState, callEdge, exp)) {
            SMGState newStateWithReadSymbolicValue = stateValue.getSmgState();
            SMGValue value = (SMGValue)stateValue.getObject();
            for (Pair<SMGState, SMGKnownSymbolicValue> newStateWithExpVal : this.assignExplicitValueToSymbolicValue(newStateWithReadSymbolicValue, callEdge, value, exp)) {
                SMGState curState = newStateWithExpVal.getFirst();
                result.add(curState);
                if (!valuesMap.containsKey(curState)) {
                    valuesMap.put(curState, new ArrayList(valuesMap.get(newState)));
                }
                List<Pair<SMGRegion, SMGValue>> curValues = valuesMap.get(curState);
                assert (curValues.size() == i) : "evaluation of parameters out of order";
                curValues.add(i, Pair.of(paramObj, value));
                if (newStateWithExpVal.getSecond() == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    Pair<SMGRegion, SMGValue> lhsCheckValuePair = curValues.get(j);
                    SMGValue symbolicValue = lhsCheckValuePair.getSecond();
                    if (!newStateWithExpVal.getSecond().equals(symbolicValue)) continue;
                    curValues.set(j, Pair.of(lhsCheckValuePair.getFirst(), value));
                }
            }
        }
        return result;
    }

    private void assignParameterValues(CFunctionCallEdge callEdge, List<CParameterDeclaration> paramDecl, List<Pair<SMGRegion, SMGValue>> values, SMGState newState) throws SMGInconsistentException, UnrecognizedCodeException {
        newState.addStackFrame(callEdge.getSuccessor().getFunctionDefinition());
        for (int i = 0; i < paramDecl.size(); ++i) {
            String varName = paramDecl.get(i).getName();
            CType cParamType = TypeUtils.getRealExpressionType(paramDecl.get(i));
            if (cParamType instanceof CArrayType) {
                cParamType = new CPointerType(cParamType.isConst(), cParamType.isVolatile(), ((CArrayType)cParamType).getType());
            }
            SMGRegion newObject = values.get(i).getFirst();
            SMGValue symbolicValue = values.get(i).getSecond();
            long typeSize = this.expressionEvaluator.getBitSizeof(callEdge, cParamType, newState);
            newState.addLocalVariable(typeSize, varName, newObject);
            CType rValueType = cParamType;
            newState = this.expressionEvaluator.assignFieldToState(newState, callEdge, newObject, 0L, symbolicValue, rValueType);
        }
    }

    @Override
    protected void setInfo(AbstractState abstractState, Precision abstractPrecision, CFAEdge cfaEdge) {
        super.setInfo(abstractState, abstractPrecision, cfaEdge);
        this.state = ((SMGState)this.state).copyOf();
        ((SMGState)this.state).cleanCurrentChain();
    }

    @Override
    protected Collection<SMGState> handleAssumption(CAssumeEdge cfaEdge, CExpression expression, boolean truthAssumption) throws CPATransferException, InterruptedException {
        return this.handleAssumption(expression, cfaEdge, truthAssumption);
    }

    private List<SMGState> handleAssumption(CExpression expression, CFAEdge cfaEdge, boolean truthValue) throws CPATransferException, InterruptedException {
        expression = SMGTransferRelation.eliminateOuterEquals(expression);
        AssumeVisitor visitor = this.expressionEvaluator.getAssumeVisitor(cfaEdge, (SMGState)this.state);
        ArrayList<SMGState> result = new ArrayList<SMGState>();
        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : expression.accept(visitor)) {
            SMGValue value = (SMGValue)sMGValueAndState.getObject();
            this.state = sMGValueAndState.getSmgState();
            if (!value.isUnknown()) {
                if ((!truthValue || !value.equals(SMGKnownSymValue.TRUE)) && (truthValue || !value.equals(SMGZeroValue.INSTANCE))) continue;
                result.add((SMGState)this.state);
                continue;
            }
            result.addAll(this.deriveFurtherInformationFromAssumption(visitor, cfaEdge, truthValue, expression));
        }
        return result;
    }

    private SMGState checkAndSetErrorRelation(SMGState smgState) {
        if (this.smgPredicateManager.isErrorPathFeasible(smgState)) {
            smgState = smgState.withInvalidRead().withInvalidWrite().withErrorDescription("Possible overflow");
        }
        return smgState.resetErrorRelation();
    }

    private List<SMGState> deriveFurtherInformationFromAssumption(AssumeVisitor visitor, CFAEdge cfaEdge, boolean truthValue, CExpression expression) throws CPATransferException, InterruptedException {
        SMGValue val2ImpliesOn;
        SMGValue val1ImpliesOn;
        boolean impliesEqOn = visitor.impliesEqOn(truthValue, (UnmodifiableSMGState)this.state);
        boolean impliesNeqOn = visitor.impliesNeqOn(truthValue, (UnmodifiableSMGState)this.state);
        if (impliesEqOn || impliesNeqOn) {
            val1ImpliesOn = visitor.impliesVal1((UnmodifiableSMGState)this.state);
            val2ImpliesOn = visitor.impliesVal2((UnmodifiableSMGState)this.state);
        } else {
            val1ImpliesOn = SMGUnknownValue.INSTANCE;
            val2ImpliesOn = SMGUnknownValue.INSTANCE;
        }
        ArrayList<SMGState> result = new ArrayList<SMGState>();
        for (SMGAbstractObjectAndState.SMGExplicitValueAndState explicitValueAndState : this.expressionEvaluator.evaluateExplicitValue((SMGState)this.state, cfaEdge, expression)) {
            this.shutdownNotifier.shutdownIfNecessary();
            SMGExplicitValue explicitValue = (SMGExplicitValue)explicitValueAndState.getObject();
            SMGState explicitSmgState = explicitValueAndState.getSmgState();
            if (explicitValue.isUnknown()) {
                SMGState newState = explicitSmgState.copyOf();
                if (!val1ImpliesOn.isUnknown() && !val2ImpliesOn.isUnknown()) {
                    SMGKnownSymbolicValue val1 = val1ImpliesOn instanceof SMGKnownExpValue ? newState.getSymbolicOfExplicit((SMGKnownExpValue)val1ImpliesOn) : (SMGKnownSymbolicValue)val1ImpliesOn;
                    SMGKnownSymbolicValue val2 = val2ImpliesOn instanceof SMGKnownExpValue ? newState.getSymbolicOfExplicit((SMGKnownExpValue)val2ImpliesOn) : (SMGKnownSymbolicValue)val2ImpliesOn;
                    if (val1 != null && val2 != null) {
                        if (impliesEqOn) {
                            if (newState.areNonEqual(val1, val2)) continue;
                            newState.identifyEqualValues(val1, val2);
                        } else if (impliesNeqOn) {
                            newState.identifyNonEqualValues(val1, val2);
                        }
                    }
                }
                newState = this.expressionEvaluator.deriveFurtherInformation(newState, truthValue, cfaEdge, expression);
                BooleanFormula predicateFormula = this.smgPredicateManager.getPathPredicateFormula(newState);
                try {
                    if (!newState.hasMemoryErrors() && this.smgPredicateManager.isUnsat(predicateFormula)) continue;
                    result.add(newState);
                    continue;
                }
                catch (SolverException pE) {
                    throw new CPATransferException("Solver Exception on predicate " + predicateFormula, pE);
                }
            }
            if ((!truthValue || explicitValue.equals(SMGZeroValue.INSTANCE)) && (truthValue || !explicitValue.equals(SMGZeroValue.INSTANCE))) continue;
            result.add(explicitSmgState);
        }
        return result;
    }

    private static CExpression eliminateOuterEquals(CExpression pExpression) {
        if (!(pExpression instanceof CBinaryExpression)) {
            return pExpression;
        }
        CBinaryExpression binExp = (CBinaryExpression)pExpression;
        CExpression op1 = binExp.getOperand1();
        CExpression op2 = binExp.getOperand2();
        CBinaryExpression.BinaryOperator op = binExp.getOperator();
        if (!(op1 instanceof CBinaryExpression) || !(op2 instanceof CIntegerLiteralExpression) || !((CIntegerLiteralExpression)op2).getValue().equals(BigInteger.ZERO) || op != CBinaryExpression.BinaryOperator.EQUALS && op != CBinaryExpression.BinaryOperator.NOT_EQUALS) {
            return pExpression;
        }
        CBinaryExpression binExpOp1 = (CBinaryExpression)op1;
        switch (binExpOp1.getOperator()) {
            case EQUALS: {
                return new CBinaryExpression(binExpOp1.getFileLocation(), binExpOp1.getExpressionType(), binExpOp1.getCalculationType(), binExpOp1.getOperand1(), binExpOp1.getOperand2(), op == CBinaryExpression.BinaryOperator.EQUALS ? CBinaryExpression.BinaryOperator.NOT_EQUALS : CBinaryExpression.BinaryOperator.EQUALS);
            }
            case NOT_EQUALS: {
                return new CBinaryExpression(binExpOp1.getFileLocation(), binExpOp1.getExpressionType(), binExpOp1.getCalculationType(), binExpOp1.getOperand1(), binExpOp1.getOperand2(), op == CBinaryExpression.BinaryOperator.EQUALS ? CBinaryExpression.BinaryOperator.EQUALS : CBinaryExpression.BinaryOperator.NOT_EQUALS);
            }
        }
        return pExpression;
    }

    @Override
    protected Collection<SMGState> handleStatementEdge(CStatementEdge pCfaEdge, CStatement cStmt) throws CPATransferException {
        if (cStmt instanceof CAssignment) {
            CAssignment cAssignment = (CAssignment)cStmt;
            CLeftHandSide lValue = cAssignment.getLeftHandSide();
            CRightHandSide rValue = cAssignment.getRightHandSide();
            return this.handleAssignment((SMGState)this.state, pCfaEdge, lValue, rValue);
        }
        if (cStmt instanceof CFunctionCallStatement) {
            CFunctionCallStatement cFCall = (CFunctionCallStatement)cStmt;
            CFunctionCallExpression cFCExpression = cFCall.getFunctionCallExpression();
            CExpression fileNameExpression = cFCExpression.getFunctionNameExpression();
            String calledFunctionName = fileNameExpression.toASTString();
            LinkedHashSet<SMGState> states = new LinkedHashSet<SMGState>();
            states.add(((SMGState)this.state).copyOf());
            for (CExpression param : cFCExpression.getParameterExpressions()) {
                if (!(param instanceof CPointerExpression)) continue;
                for (SMGAbstractObjectAndState.SMGValueAndState valueAndState : this.readValueToBeAssiged((SMGState)this.state, pCfaEdge, param)) {
                    states.add(valueAndState.getSmgState());
                }
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (SMGState newState : states) {
                result.addAll(this.handleFunctionCallWithoutBody(newState, pCfaEdge, cFCExpression, calledFunctionName));
            }
            return result.build();
        }
        return ImmutableList.of((Object)((SMGState)this.state));
    }

    private Collection<SMGState> handleFunctionCallWithoutBody(SMGState pState, CStatementEdge pCfaEdge, CFunctionCallExpression cFCExpression, String calledFunctionName) throws CPATransferException, AssertionError {
        if (this.expressionEvaluator.builtins.isABuiltIn(calledFunctionName)) {
            if (this.expressionEvaluator.builtins.isConfigurableAllocationFunction(calledFunctionName)) {
                this.logger.logf(Level.INFO, "%s: Calling '%s' and not using the result, resulting in memory leak.", new Object[]{pCfaEdge.getFileLocation(), calledFunctionName});
                List<SMGState> newStates = SMGTransferRelation.asSMGStateList(this.expressionEvaluator.builtins.evaluateConfigurableAllocationFunction(cFCExpression, pState, pCfaEdge, this.kind));
                for (SMGState s : newStates) {
                    s.setMemLeak("Calling '" + calledFunctionName + "' and not using the result, resulting in memory leak.", (Collection<SMGObject>)ImmutableList.of());
                }
                return newStates;
            }
            if (this.expressionEvaluator.builtins.isDeallocationFunction(calledFunctionName)) {
                return this.expressionEvaluator.builtins.evaluateFree(cFCExpression, pState, pCfaEdge);
            }
            return SMGTransferRelation.asSMGStateList(this.expressionEvaluator.builtins.handleBuiltinFunctionCall(pCfaEdge, cFCExpression, calledFunctionName, pState, this.kind));
        }
        return SMGTransferRelation.asSMGStateList(this.expressionEvaluator.builtins.handleUnknownFunction(pCfaEdge, cFCExpression, calledFunctionName, pState));
    }

    private List<SMGState> handleAssignment(SMGState pState, CFAEdge cfaEdge, CExpression lValue, CRightHandSide rValue) throws CPATransferException {
        ArrayList<SMGState> result = new ArrayList<SMGState>(4);
        LValueAssignmentVisitor visitor = this.expressionEvaluator.getLValueAssignmentVisitor(cfaEdge, pState);
        for (SMGAbstractObjectAndState.SMGAddressAndState addressOfFieldAndState : lValue.accept(visitor)) {
            SMGAddress addressOfField = (SMGAddress)addressOfFieldAndState.getObject();
            pState = addressOfFieldAndState.getSmgState();
            CType fieldType = TypeUtils.getRealExpressionType(lValue);
            if (addressOfField.isUnknown()) {
                List<SMGState> newStates = SMGTransferRelation.asSMGStateList(this.readValueToBeAssiged(pState.copyOf(), cfaEdge, rValue));
                newStates.forEach(smgState -> smgState.unknownWrite());
                result.addAll(newStates);
                continue;
            }
            result.addAll(this.assignFieldToState(pState.copyOf(), cfaEdge, addressOfField.getObject(), addressOfField.getOffset().getAsLong(), fieldType, rValue));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<SMGAbstractObjectAndState.SMGValueAndState> readValueToBeAssiged(SMGState pNewState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGValueAndState> resultValueAndStates = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>();
        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : this.expressionEvaluator.evaluateExpressionValue(pNewState, cfaEdge, rValue)) {
            void var6_6;
            SMGValue value = (SMGValue)sMGValueAndState.getObject();
            if (value.isUnknown()) {
                value = SMGKnownSymValue.of();
                SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState2 = SMGAbstractObjectAndState.SMGValueAndState.of(sMGValueAndState.getSmgState(), value);
            }
            resultValueAndStates.add((SMGAbstractObjectAndState.SMGValueAndState)var6_6);
        }
        return resultValueAndStates;
    }

    private List<SMGState> assignFieldToState(SMGState pNewState, CFAEdge cfaEdge, SMGObject memoryOfField, long fieldOffset, CType pLFieldType, CRightHandSide rValue) throws CPATransferException {
        ArrayList<SMGState> result = new ArrayList<SMGState>(4);
        CType rValueType = TypeUtils.getRealExpressionType(rValue);
        SMGExpressionEvaluator expEvaluator = new SMGExpressionEvaluator(this.logger, this.machineModel);
        for (SMGAbstractObjectAndState.SMGExplicitValueAndState expValueAndState : expEvaluator.evaluateExplicitValue(pNewState, cfaEdge, rValue)) {
            SMGExplicitValue expValue = (SMGExplicitValue)expValueAndState.getObject();
            SMGState newState = expValueAndState.getSmgState();
            rValueType = pLFieldType;
            if (!expValue.isUnknown()) {
                SMGKnownSymbolicValue symbolicValue = newState.getSymbolicOfExplicit(expValue);
                if (symbolicValue != null) {
                    result.add(this.expressionEvaluator.assignFieldToState(newState, cfaEdge, memoryOfField, fieldOffset, symbolicValue, rValueType));
                    continue;
                }
                for (SMGAbstractObjectAndState.SMGValueAndState valueAndState : this.readValueToBeAssiged(newState, cfaEdge, rValue)) {
                    SMGValue value = (SMGValue)valueAndState.getObject();
                    SMGState curState = valueAndState.getSmgState();
                    if (value instanceof SMGKnownSymbolicValue) {
                        curState.putExplicit((SMGKnownSymbolicValue)value, (SMGKnownExpValue)expValue);
                    }
                    result.add(this.expressionEvaluator.assignFieldToState(curState, cfaEdge, memoryOfField, fieldOffset, value, rValueType));
                }
                continue;
            }
            for (SMGAbstractObjectAndState.SMGValueAndState valueAndState : this.readValueToBeAssiged(newState, cfaEdge, rValue)) {
                SMGValue value = (SMGValue)valueAndState.getObject();
                SMGState curState = valueAndState.getSmgState();
                rValueType = pLFieldType;
                result.add(this.expressionEvaluator.assignFieldToState(curState, cfaEdge, memoryOfField, fieldOffset, value, rValueType));
            }
        }
        return result;
    }

    private List<Pair<SMGState, SMGKnownSymbolicValue>> assignExplicitValueToSymbolicValue(SMGState pNewState, CFAEdge pCfaEdge, SMGValue value, CRightHandSide pRValue) throws CPATransferException {
        ArrayList<Pair<SMGState, SMGKnownSymbolicValue>> result = new ArrayList<Pair<SMGState, SMGKnownSymbolicValue>>();
        SMGExpressionEvaluator expEvaluator = new SMGExpressionEvaluator(this.logger, this.machineModel);
        for (SMGAbstractObjectAndState.SMGExplicitValueAndState expValueAndState : expEvaluator.evaluateExplicitValue(pNewState, pCfaEdge, pRValue)) {
            SMGExplicitValue expValue = (SMGExplicitValue)expValueAndState.getObject();
            SMGState newState = expValueAndState.getSmgState();
            if (!expValue.isUnknown()) {
                SMGKnownSymbolicValue mergedSymValue = newState.putExplicit((SMGKnownSymbolicValue)value, (SMGKnownExpValue)expValue);
                result.add(Pair.of(newState, mergedSymValue));
                continue;
            }
            result.add(Pair.of(newState, null));
        }
        return result;
    }

    private List<SMGState> handleVariableDeclaration(SMGState pState, CVariableDeclaration pVarDecl, CDeclarationEdge pEdge) throws CPATransferException {
        String varName = pVarDecl.getName();
        CType cType = TypeUtils.getRealExpressionType(pVarDecl);
        if (cType.isIncomplete() && cType instanceof CElaboratedType) {
            return ImmutableList.of((Object)pState);
        }
        SMGObject newObject = pState.getHeap().getObjectForVisibleVariable(varName);
        boolean isExtern = pVarDecl.getCStorageClass().equals((Object)CStorageClass.EXTERN);
        if (newObject == null && (!isExtern || this.options.getAllocateExternalVariables())) {
            long typeSize = this.expressionEvaluator.getBitSizeof(pEdge, cType, pState);
            if (this.options.isHandleIncompleteExternalVariableAsExternalAllocation() && cType.isIncomplete() && isExtern) {
                typeSize = this.options.getExternalAllocationSize();
            }
            if (pVarDecl.isGlobal()) {
                newObject = pState.addGlobalVariable(typeSize, varName);
            } else {
                Optional<SMGObject> addedLocalVariable = pState.addLocalVariable(typeSize, varName);
                if (!addedLocalVariable.isPresent()) {
                    throw new SMGInconsistentException("Cannot add a local variable to an empty stack.");
                }
                newObject = addedLocalVariable.orElseThrow();
            }
        }
        return this.handleInitializerForDeclaration(pState, newObject, pVarDecl, pEdge);
    }

    @Override
    protected List<SMGState> handleDeclarationEdge(CDeclarationEdge edge, CDeclaration cDecl) throws CPATransferException {
        if (!(cDecl instanceof CVariableDeclaration)) {
            return ImmutableList.of((Object)((SMGState)this.state));
        }
        SMGState newState = ((SMGState)this.state).copyOf();
        return this.handleVariableDeclaration(newState, (CVariableDeclaration)cDecl, edge);
    }

    private List<SMGState> handleInitializerForDeclaration(SMGState pState, SMGObject pObject, CVariableDeclaration pVarDecl, CDeclarationEdge pEdge) throws CPATransferException {
        CInitializer newInitializer = pVarDecl.getInitializer();
        CType cType = TypeUtils.getRealExpressionType(pVarDecl);
        if (newInitializer != null) {
            return this.handleInitializer(pState, pVarDecl, pEdge, pObject, 0L, cType, newInitializer);
        }
        if (pVarDecl.isGlobal()) {
            if (pVarDecl.getCStorageClass().equals((Object)CStorageClass.EXTERN)) {
                if (this.options.isHandleIncompleteExternalVariableAsExternalAllocation()) {
                    pState.setExternallyAllocatedFlag(pObject);
                }
            } else {
                pState = this.expressionEvaluator.writeValue(pState, pObject, 0L, cType, SMGZeroValue.INSTANCE, pEdge);
            }
        }
        return ImmutableList.of((Object)pState);
    }

    private List<SMGState> handleInitializer(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, long pOffset, CType pLValueType, CInitializer pInitializer) throws CPATransferException {
        if (pInitializer instanceof CInitializerExpression) {
            CExpression expression = ((CInitializerExpression)pInitializer).getExpression();
            if (expression instanceof CStringLiteralExpression) {
                return this.handleStringInitializer(pNewState, pVarDecl, pEdge, pNewObject, pOffset, pLValueType, pInitializer.getFileLocation(), (CStringLiteralExpression)expression);
            }
            if (expression instanceof CCastExpression) {
                return this.handleCastInitializer(pNewState, pVarDecl, pEdge, pNewObject, pOffset, pLValueType, pInitializer.getFileLocation(), (CCastExpression)expression);
            }
            return this.assignFieldToState(pNewState, pEdge, pNewObject, pOffset, pLValueType, expression);
        }
        if (pInitializer instanceof CInitializerList) {
            CInitializerList pNewInitializer = (CInitializerList)pInitializer;
            CType realCType = pLValueType.getCanonicalType();
            if (realCType instanceof CArrayType) {
                CArrayType arrayType = (CArrayType)realCType;
                return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, arrayType, pNewInitializer);
            }
            if (realCType instanceof CCompositeType) {
                CCompositeType structType = (CCompositeType)realCType;
                return this.handleInitializerList(pNewState.copyOf(), pVarDecl, pEdge, pNewObject, pOffset, structType, pNewInitializer);
            }
            this.logger.log(Level.INFO, () -> String.format("Type %s cannot be resolved sufficiently to handle initializer %s", realCType.toASTString(""), pNewInitializer));
            return ImmutableList.of((Object)pNewState);
        }
        if (pInitializer instanceof CDesignatedInitializer) {
            throw new AssertionError((Object)("Error in handling initializer, designated Initializer " + pInitializer.toASTString() + " should not appear at this point."));
        }
        throw new UnrecognizedCodeException("Did not recognize Initializer", pInitializer);
    }

    private List<SMGState> handleCastInitializer(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, long pOffset, CType pLValueType, FileLocation pFileLocation, CCastExpression pExpression) throws CPATransferException {
        CExpression expression = pExpression.getOperand();
        if (expression instanceof CStringLiteralExpression) {
            return this.handleStringInitializer(pNewState, pVarDecl, pEdge, pNewObject, pOffset, pLValueType, pFileLocation, (CStringLiteralExpression)expression);
        }
        if (expression instanceof CCastExpression) {
            return this.handleCastInitializer(pNewState, pVarDecl, pEdge, pNewObject, pOffset, pLValueType, pFileLocation, (CCastExpression)expression);
        }
        return this.assignFieldToState(pNewState, pEdge, pNewObject, pOffset, pLValueType, expression);
    }

    private List<SMGState> handleStringInitializer(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, long pOffset, CType pLValueType, FileLocation pFileLocation, CStringLiteralExpression pExpression) throws CPATransferException {
        CType realCType = TypeUtils.getRealExpressionType(pVarDecl);
        if (realCType instanceof CArrayType) {
            realCType = ((CArrayType)realCType).getType();
        } else if (realCType instanceof CPointerType) {
            realCType = ((CPointerType)realCType).getType();
        }
        if (realCType instanceof CCompositeType || pLValueType instanceof CPointerType) {
            ArrayList<SMGState> smgStates = new ArrayList<SMGState>();
            CArrayType cParamType = pExpression.transformTypeToArrayType();
            String name = pExpression.getContentString() + " string literal";
            SMGRegion region = pNewState.getHeap().getObjectForVisibleVariable(name);
            if (region != null) {
                smgStates.add(pNewState);
                name = name + "ID" + SMGCPA.getNewValue();
            }
            region = pNewState.addGlobalVariable(this.machineModel.getSizeofInBits(cParamType).longValue(), name);
            CInitializerExpression initializer = new CInitializerExpression(pExpression.getFileLocation(), pExpression);
            CVariableDeclaration decl = new CVariableDeclaration(pFileLocation, false, CStorageClass.AUTO, cParamType, region.getLabel(), region.getLabel(), region.getLabel(), initializer);
            for (SMGState smgState : this.handleInitializer(pNewState, decl, pEdge, region, 0L, cParamType, initializer)) {
                CIdExpression exp = new CIdExpression(pFileLocation, cParamType, region.getLabel(), decl);
                CInitializerExpression newInitializer = new CInitializerExpression(pExpression.getFileLocation(), exp);
                smgStates.addAll(this.handleInitializer(smgState, pVarDecl, pEdge, pNewObject, pOffset, pExpression.getExpressionType(), newInitializer));
            }
            return smgStates;
        }
        ArrayList<CInitializer> charInitialziers = new ArrayList<CInitializer>();
        CArrayType arrayType = pExpression.transformTypeToArrayType();
        for (CCharLiteralExpression charLiteralExp : pExpression.expandStringLiteral(arrayType)) {
            charInitialziers.add(new CInitializerExpression(pFileLocation, charLiteralExp));
        }
        return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, arrayType, new CInitializerList(pFileLocation, charInitialziers));
    }

    private Pair<BigInteger, Integer> calculateOffsetAndPositionOfFieldFromDesignator(long offsetAtStartOfStruct, List<CCompositeType.CCompositeTypeMemberDeclaration> pMemberTypes, CDesignatedInitializer pInitializer, CCompositeType pLValueType) throws UnrecognizedCodeException {
        assert (pInitializer.getDesignators().size() == 1);
        String fieldDesignator = ((CFieldDesignator)pInitializer.getDesignators().get(0)).getFieldName();
        BigInteger offset = BigInteger.valueOf(offsetAtStartOfStruct);
        int sizeOfByte = this.machineModel.getSizeofCharInBits();
        for (int listCounter = 0; listCounter < pMemberTypes.size(); ++listCounter) {
            CCompositeType.CCompositeTypeMemberDeclaration memberDcl = pMemberTypes.get(listCounter);
            if (memberDcl.getName().equals(fieldDesignator)) {
                return Pair.of(offset, listCounter);
            }
            if (pLValueType.getKind() != CComplexType.ComplexTypeKind.STRUCT) continue;
            BigInteger memberSize = this.machineModel.getSizeofInBits(memberDcl.getType());
            if (!(memberDcl.getType() instanceof CBitFieldType)) {
                BigInteger overByte = (offset = offset.add(memberSize)).mod(BigInteger.valueOf(this.machineModel.getSizeofCharInBits()));
                if (overByte.compareTo(BigInteger.ZERO) > 0) {
                    offset = offset.add(BigInteger.valueOf(this.machineModel.getSizeofCharInBits()).subtract(overByte));
                }
                offset = offset.add(this.machineModel.getPadding(offset.divide(BigInteger.valueOf(sizeOfByte)), memberDcl.getType()).multiply(BigInteger.valueOf(sizeOfByte)));
                continue;
            }
            CType innerType = ((CBitFieldType)memberDcl.getType()).getType();
            if (memberSize.compareTo(BigInteger.ZERO) == 0) {
                offset = this.machineModel.calculatePaddedBitsize(BigInteger.ZERO, offset, innerType, sizeOfByte);
                continue;
            }
            offset = this.machineModel.calculateNecessaryBitfieldOffset(offset, innerType, sizeOfByte, memberSize);
            offset = offset.add(memberSize);
        }
        throw new UnrecognizedCodeException("CDesignator field name not in struct.", pInitializer);
    }

    private List<SMGState> handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, long pOffset, CCompositeType pLValueType, CInitializerList pNewInitializer) throws CPATransferException {
        int listCounter = 0;
        List<CCompositeType.CCompositeTypeMemberDeclaration> memberTypes = pLValueType.getMembers();
        Pair<SMGState, Long> startOffsetAndState = Pair.of(pNewState, pOffset);
        ArrayList<Pair<SMGState, Long>> offsetAndStates = new ArrayList<Pair<SMGState, Long>>();
        offsetAndStates.add(startOffsetAndState);
        if (pVarDecl.isGlobal()) {
            ArrayList<Pair<SMGState, Long>> result = new ArrayList<Pair<SMGState, Long>>();
            long sizeOfType = this.expressionEvaluator.getBitSizeof(pEdge, pLValueType, pNewState);
            SMGState newState = this.expressionEvaluator.writeValue(pNewState, pNewObject, pOffset, TypeUtils.createTypeWithLength(Math.toIntExact(sizeOfType)), SMGZeroValue.INSTANCE, pEdge);
            result.add(Pair.of(newState, pOffset));
            offsetAndStates = result;
        }
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            if (initializer instanceof CDesignatedInitializer) {
                Pair<BigInteger, Integer> offsetAndPosition = this.calculateOffsetAndPositionOfFieldFromDesignator(pOffset, memberTypes, (CDesignatedInitializer)initializer, pLValueType);
                long offset = offsetAndPosition.getFirst().longValueExact();
                listCounter = offsetAndPosition.getSecond();
                initializer = ((CDesignatedInitializer)initializer).getRightHandSide();
                ArrayList<Pair<SMGState, Long>> arrayList = new ArrayList<Pair<SMGState, Long>>();
                arrayList.add(Pair.of(pNewState, offset));
                offsetAndStates = arrayList;
            }
            if (listCounter >= memberTypes.size()) {
                throw new UnrecognizedCodeException(String.format("More initializer in initializer list %s than fit in type %s", pNewInitializer.toASTString(), pLValueType.toASTString("")), pEdge);
            }
            CType memberType = memberTypes.get(listCounter).getType();
            ArrayList resultOffsetAndStates = new ArrayList();
            for (Pair pair : offsetAndStates) {
                long offset = this.getOffsetWithPadding((Long)pair.getSecond(), memberType);
                SMGState newState = (SMGState)pair.getFirst();
                List<SMGState> pNewStates = this.handleInitializer(newState, pVarDecl, pEdge, pNewObject, offset, memberType, initializer);
                long currentOffset = offset += this.machineModel.getSizeofInBits(memberType).longValueExact();
                resultOffsetAndStates.addAll(Lists.transform(pNewStates, s -> Pair.of(s, currentOffset)));
            }
            offsetAndStates = resultOffsetAndStates;
            ++listCounter;
        }
        return Lists.transform(offsetAndStates, Pair::getFirst);
    }

    private long getOffsetWithPadding(long offset, CType memberType) {
        if (!(memberType instanceof CBitFieldType)) {
            int overByte = Math.toIntExact(offset % (long)this.machineModel.getSizeofCharInBits());
            if (overByte > 0) {
                offset += (long)(this.machineModel.getSizeofCharInBits() - overByte);
            }
            long padding = this.machineModel.getPadding(BigInteger.valueOf(offset / (long)this.machineModel.getSizeofCharInBits()), memberType).longValueExact();
            offset += padding * (long)this.machineModel.getSizeofCharInBits();
        }
        return offset;
    }

    private List<SMGState> handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, long pOffset, CArrayType pLValueType, CInitializerList pNewInitializer) throws CPATransferException {
        int listCounter = 0;
        CType elementType = pLValueType.getType();
        long sizeOfElementType = this.expressionEvaluator.getBitSizeof(pEdge, elementType, pNewState);
        ArrayList<SMGState> newStates = new ArrayList<SMGState>(4);
        newStates.add(pNewState);
        ArrayList<SMGState> result = new ArrayList<SMGState>(newStates.size());
        for (SMGState newState : newStates) {
            if (!this.options.isGCCZeroLengthArray() || pLValueType.getLength() != null) {
                long sizeOfType = this.expressionEvaluator.getBitSizeof(pEdge, pLValueType, pNewState);
                newState = this.expressionEvaluator.writeValue(newState, pNewObject, pOffset, TypeUtils.createTypeWithLength(Math.toIntExact(sizeOfType)), SMGZeroValue.INSTANCE, pEdge);
            }
            result.add(newState);
        }
        newStates = result;
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            if (initializer instanceof CDesignatedInitializer) {
                CDesignatedInitializer designatedInitializer = (CDesignatedInitializer)initializer;
                assert (designatedInitializer.getDesignators().size() == 1);
                CDesignator cDesignator = designatedInitializer.getDesignators().get(0);
                if (!(cDesignator instanceof CArrayDesignator)) {
                    throw new UnrecognizedCodeException("Non array designator for array " + pNewInitializer.toASTString(), pEdge);
                }
                CExpression subscriptExpression = ((CArrayDesignator)cDesignator).getSubscriptExpression();
                SMGAbstractObjectAndState.SMGExplicitValueAndState smgExplicitValueAndState = this.expressionEvaluator.forceExplicitValue(pNewState, pEdge, subscriptExpression);
                listCounter = ((SMGExplicitValue)smgExplicitValueAndState.getObject()).getAsInt();
                initializer = designatedInitializer.getRightHandSide();
            }
            if (listCounter >= pLValueType.getLengthAsInt().orElse(0)) {
                throw new UnrecognizedCodeException("More Initializers in initializer list " + pNewInitializer.toASTString() + " than fit in type " + pLValueType.toASTString(""), pEdge);
            }
            long offset = pOffset + (long)listCounter * sizeOfElementType;
            result = new ArrayList(newStates.size());
            for (SMGState newState : newStates) {
                result.addAll(this.handleInitializer(newState, pVarDecl, pEdge, pNewObject, offset, pLValueType.getType(), initializer));
            }
            newStates = result;
            ++listCounter;
        }
        return ImmutableList.copyOf(newStates);
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, Iterable<AbstractState> elements, CFAEdge cfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        ArrayList<SMGState> toStrengthen = new ArrayList<SMGState>();
        ArrayList<SMGState> result = new ArrayList<SMGState>();
        toStrengthen.add((SMGState)element);
        result.add((SMGState)element);
        for (AbstractState ae : elements) {
            if (!(ae instanceof AutomatonState)) continue;
            result.clear();
            for (SMGState stateToStrengthen : toStrengthen) {
                Collection<SMGState> ret = this.strengthen((AutomatonState)ae, stateToStrengthen, cfaEdge);
                if (ret == null) {
                    result.add(stateToStrengthen);
                    continue;
                }
                result.addAll(ret);
            }
            toStrengthen.clear();
            toStrengthen.addAll(result);
        }
        return result;
    }

    private Collection<SMGState> strengthen(AutomatonState pAutomatonState, SMGState pElement, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        FluentIterable assumptions = FluentIterable.from(pAutomatonState.getAssumptions()).filter(CExpression.class);
        if (assumptions.isEmpty()) {
            return Collections.singleton(pElement);
        }
        StringBuilder assumeDesc = new StringBuilder();
        SMGState newElement = pElement;
        if (pCfaEdge instanceof CAssumeEdge && !((CAssumeEdge)pCfaEdge).getTruthAssumption()) {
            CFANode pred = pCfaEdge.getPredecessor();
            CFAEdge thisEdge = pCfaEdge;
            pCfaEdge = (CFAEdge)Iterables.getOnlyElement((Iterable)CFAUtils.leavingEdges(pred).filter(e -> e != thisEdge));
            Preconditions.checkState((pCfaEdge instanceof CAssumeEdge && ((CAssumeEdge)pCfaEdge).getTruthAssumption() ? 1 : 0) != 0);
        }
        for (CExpression assume : assumptions) {
            assumeDesc.append(assume.toASTString());
            this.state = newElement;
            List<SMGState> newElements = this.handleAssumption(assume, pCfaEdge, true);
            if (newElements.isEmpty()) {
                newElement = null;
                break;
            }
            newElement = ((SMGState)Iterables.getOnlyElement(newElements)).withViolationsOf(newElement);
        }
        if (newElement == null) {
            return ImmutableList.of();
        }
        SMGUtils.plotWhenConfigured(this.getDotExportFileName(newElement), newElement, assumeDesc.toString(), (LogManager)this.logger, SMGOptions.SMGExportLevel.EVERY, this.exportSMGOptions);
        return Collections.singleton(newElement);
    }

    static List<SMGState> asSMGStateList(List<? extends SMGAbstractObjectAndState.SMGValueAndState> valueAndStateList) {
        return Lists.transform(valueAndStateList, SMGAbstractObjectAndState::getSmgState);
    }
}

