/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.smg.SMGExportDotOption;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.exceptions.NoException;

public final class SMGUtils {
    private SMGUtils() {
    }

    public static SMGHasValueEdges getFieldsOfObject(SMGObject pSmgObject, UnmodifiableSMG pInputSMG) {
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject edgeFilter = SMGEdgeHasValueFilter.objectFilter(pSmgObject);
        return pInputSMG.getHVEdges(edgeFilter);
    }

    public static Set<SMGEdgePointsTo> getPointerToThisObject(SMGObject pSmgObject, UnmodifiableSMG pInputSMG) {
        SMGEdgePointsToFilter objectFilter = SMGEdgePointsToFilter.targetObjectFilter(pSmgObject);
        return pInputSMG.getPtEdges(objectFilter);
    }

    public static Iterable<SMGEdgeHasValue> getFieldsofThisValue(SMGValue value, UnmodifiableSMG pInputSMG) {
        SMGEdgeHasValueFilter valueFilter = SMGEdgeHasValueFilter.valueFilter(value);
        return pInputSMG.getHVEdges(valueFilter);
    }

    @Deprecated
    public static boolean isRecursiveOnOffset(CType pType, long fieldOffset, MachineModel pModel) {
        CFieldTypeVisitor v = new CFieldTypeVisitor(fieldOffset, pModel);
        CType typeAtOffset = pType.accept(v);
        if (CFieldTypeVisitor.isUnknownInstance(typeAtOffset)) {
            return false;
        }
        return pType.getCanonicalType().equals(typeAtOffset.getCanonicalType());
    }

    public static void plotWhenConfigured(String pSMGName, UnmodifiableSMGState pState, String pLocation, LogManager pLogger, SMGOptions.SMGExportLevel pLevel, SMGExportDotOption pExportOption) {
        if (pExportOption.exportSMG(pLevel)) {
            SMGUtils.dumpSMGPlot(pLogger, pSMGName, pState, pLocation, pExportOption);
        }
    }

    private static void dumpSMGPlot(LogManager pLogger, String pSMGName, UnmodifiableSMGState pCurrentState, String pLocation, SMGExportDotOption pExportOption) {
        if (pCurrentState != null && pExportOption.hasExportPath()) {
            Path outputFile = pExportOption.getOutputFilePath(pSMGName);
            SMGUtils.dumpSMGPlot(pLogger, pCurrentState, pLocation, outputFile);
        }
    }

    public static void dumpSMGPlot(LogManager pLogger, UnmodifiableSMGState currentState, String location, Path pOutputFile) {
        try {
            String dot = currentState.toDot("SMG" + currentState.getId(), location);
            IO.writeFile((Path)pOutputFile, (Charset)Charset.defaultCharset(), (Object)dot);
        }
        catch (IOException e) {
            pLogger.logUserException(Level.WARNING, (Throwable)e, "Could not write SMG " + currentState.getId() + " to file");
        }
    }

    private static class CFieldTypeVisitor
    implements CTypeVisitor<CType, NoException> {
        private final long fieldOffset;
        private final MachineModel model;
        private static final CType UNKNOWN = new CSimpleType(false, false, CBasicType.UNSPECIFIED, false, false, false, false, false, false, false);

        public CFieldTypeVisitor(long pFieldOffset, MachineModel pModel) {
            this.fieldOffset = pFieldOffset;
            this.model = pModel;
        }

        public static boolean isUnknownInstance(CType type) {
            return type == UNKNOWN;
        }

        @Override
        public CType visit(CArrayType pArrayType) {
            if (this.fieldOffset % this.model.getSizeofInBits(pArrayType).longValueExact() == 0L) {
                return pArrayType.getType();
            }
            return UNKNOWN;
        }

        @Override
        public CType visit(CCompositeType pCompositeType) {
            List<CCompositeType.CCompositeTypeMemberDeclaration> members = pCompositeType.getMembers();
            long memberOffset = 0L;
            for (CCompositeType.CCompositeTypeMemberDeclaration member : members) {
                if (this.fieldOffset == memberOffset) {
                    return member.getType();
                }
                if (memberOffset > this.fieldOffset) {
                    return UNKNOWN;
                }
                memberOffset += this.model.getSizeofInBits(member.getType()).longValueExact();
            }
            return UNKNOWN;
        }

        @Override
        public CType visit(CElaboratedType pElaboratedType) {
            return pElaboratedType.getRealType().accept(this);
        }

        @Override
        public CType visit(CEnumType pEnumType) {
            return UNKNOWN;
        }

        @Override
        public CType visit(CFunctionType pFunctionType) {
            return UNKNOWN;
        }

        @Override
        public CType visit(CPointerType pPointerType) {
            return pPointerType.getType().accept(this);
        }

        @Override
        public CType visit(CProblemType pProblemType) {
            return UNKNOWN;
        }

        @Override
        public CType visit(CSimpleType pSimpleType) {
            return UNKNOWN;
        }

        @Override
        public CType visit(CTypedefType pTypedefType) {
            return pTypedefType.getRealType();
        }

        @Override
        public CType visit(CVoidType pVoidType) {
            return UNKNOWN;
        }

        @Override
        public CType visit(CBitFieldType pCBitFieldType) {
            return pCBitFieldType.getType().accept(this);
        }
    }
}

