/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

abstract class AddressVisitor
extends DefaultCExpressionVisitor<List<SMGAbstractObjectAndState.SMGAddressAndState>, CPATransferException>
implements CRightHandSideVisitor<List<SMGAbstractObjectAndState.SMGAddressAndState>, CPATransferException> {
    final SMGExpressionEvaluator smgExpressionEvaluator;
    private final CFAEdge cfaEdge;
    private final SMGState initialSmgState;

    AddressVisitor(SMGExpressionEvaluator pSmgExpressionEvaluator, CFAEdge pEdge, SMGState pSmgState) {
        this.smgExpressionEvaluator = (SMGExpressionEvaluator)Preconditions.checkNotNull((Object)pSmgExpressionEvaluator);
        this.cfaEdge = pEdge;
        this.initialSmgState = pSmgState;
    }

    @Override
    protected List<SMGAbstractObjectAndState.SMGAddressAndState> visitDefault(CExpression pExp) {
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressAndState.withUnknownAddress(this.getInitialSmgState()));
    }

    List<SMGAbstractObjectAndState.SMGAddressAndState> visitDefault(CRightHandSide rhs) {
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressAndState.withUnknownAddress(this.getInitialSmgState()));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CIdExpression variableName) throws CPATransferException {
        CSimpleDeclaration dcl;
        SMGState state = this.getInitialSmgState();
        SMGObject object = state.getHeap().getObjectForVisibleVariable(variableName.getName());
        if (object != null) {
            state.addElementToCurrentChain(object);
        }
        if (object == null && variableName.getDeclaration() != null && (dcl = variableName.getDeclaration()) instanceof CVariableDeclaration) {
            CVariableDeclaration varDcl = (CVariableDeclaration)dcl;
            if (varDcl.isGlobal()) {
                object = state.addGlobalVariable(this.smgExpressionEvaluator.getBitSizeof(this.getCfaEdge(), varDcl.getType(), state), varDcl.getName());
            } else {
                Optional<SMGObject> addedLocalVariable = state.addLocalVariable(this.smgExpressionEvaluator.getBitSizeof(this.getCfaEdge(), varDcl.getType(), state), varDcl.getName());
                if (addedLocalVariable.isPresent()) {
                    object = addedLocalVariable.orElseThrow();
                } else {
                    return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressAndState.of(state, SMGAddress.UNKNOWN));
                }
            }
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressAndState.of(state, SMGAddress.valueOf(object, SMGZeroValue.INSTANCE)));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CArraySubscriptExpression exp) throws CPATransferException {
        return this.smgExpressionEvaluator.evaluateArraySubscriptAddress(this.getInitialSmgState(), this.getCfaEdge(), exp);
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CFieldReference pE) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressOfField(this.getInitialSmgState(), this.getCfaEdge(), pE);
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CPointerExpression pointerExpression) throws CPATransferException {
        CExpression operand = pointerExpression.getOperand();
        assert (TypeUtils.getRealExpressionType(operand) instanceof CPointerType || TypeUtils.getRealExpressionType(operand) instanceof CArrayType);
        return AddressVisitor.asAddressAndStateList(this.smgExpressionEvaluator.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), operand));
    }

    final CFAEdge getCfaEdge() {
        return this.cfaEdge;
    }

    final SMGState getInitialSmgState() {
        return this.initialSmgState;
    }

    static List<SMGAbstractObjectAndState.SMGAddressAndState> asAddressAndStateList(List<SMGAbstractObjectAndState.SMGAddressValueAndState> lst) {
        ArrayList<SMGAbstractObjectAndState.SMGAddressAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressAndState>();
        for (SMGAbstractObjectAndState.SMGAddressValueAndState addressValueAndState : lst) {
            result.add(SMGAbstractObjectAndState.SMGAddressAndState.of(addressValueAndState.getSmgState(), addressValueAndState.getObject().getAddress()));
        }
        return result;
    }
}

