/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.AddressVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

class ArrayVisitor
extends AddressVisitor
implements CRightHandSideVisitor<List<SMGAbstractObjectAndState.SMGAddressAndState>, CPATransferException> {
    public ArrayVisitor(SMGExpressionEvaluator pSmgExpressionEvaluator, CFAEdge pEdge, SMGState pSmgState) {
        super(pSmgExpressionEvaluator, pEdge, pSmgState);
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CUnaryExpression unaryExpression) throws CPATransferException {
        throw new AssertionError((Object)"The result of any unary expression cannot be an array type.");
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CBinaryExpression binaryExp) throws CPATransferException {
        CType addressType;
        CExpression arrayOffset;
        CExpression address;
        CType rVarInBinaryExpType;
        boolean rVarIsAddress;
        CExpression lVarInBinaryExp = binaryExp.getOperand1();
        CExpression rVarInBinaryExp = binaryExp.getOperand2();
        CType lVarInBinaryExpType = TypeUtils.getRealExpressionType(lVarInBinaryExp);
        boolean lVarIsAddress = lVarInBinaryExpType instanceof CArrayType;
        if (lVarIsAddress == (rVarIsAddress = (rVarInBinaryExpType = TypeUtils.getRealExpressionType(rVarInBinaryExp)) instanceof CArrayType)) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressAndState.withUnknownAddress(this.getInitialSmgState()));
        }
        if (lVarIsAddress) {
            address = lVarInBinaryExp;
            arrayOffset = rVarInBinaryExp;
            addressType = lVarInBinaryExpType;
        } else if (rVarIsAddress) {
            address = rVarInBinaryExp;
            arrayOffset = lVarInBinaryExp;
            addressType = rVarInBinaryExpType;
        } else {
            throw new UnrecognizedCodeException("Expected either " + lVarInBinaryExp.toASTString() + " or " + rVarInBinaryExp.toASTString() + "to be a pointer to an array.", binaryExp);
        }
        return ArrayVisitor.asAddressAndStateList(this.smgExpressionEvaluator.handlePointerArithmetic(this.getInitialSmgState(), this.getCfaEdge(), address, arrayOffset, addressType, lVarIsAddress, binaryExp));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CIdExpression pVariableName) throws CPATransferException {
        Object addressAndStates = super.visit(pVariableName);
        if (pVariableName.getDeclaration() instanceof CParameterDeclaration) {
            CType type = TypeUtils.getRealExpressionType(pVariableName);
            if (type instanceof CArrayType) {
                type = new CPointerType(type.isConst(), type.isVolatile(), ((CArrayType)type).getType());
            }
            ArrayList<SMGAbstractObjectAndState.SMGAddressAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressAndState>();
            Iterator iterator = addressAndStates.iterator();
            while (iterator.hasNext()) {
                SMGAbstractObjectAndState.SMGAddressAndState addressAndState = (SMGAbstractObjectAndState.SMGAddressAndState)iterator.next();
                SMGAddress address = (SMGAddress)addressAndState.getObject();
                SMGState newState = addressAndState.getSmgState();
                SMGAbstractObjectAndState.SMGValueAndState pointerAndState = this.smgExpressionEvaluator.readValue(newState, address.getObject(), address.getOffset(), type, this.getCfaEdge());
                result.addAll(ArrayVisitor.asAddressAndStateList(this.smgExpressionEvaluator.getAddressFromSymbolicValue(pointerAndState)));
            }
            return result;
        }
        return addressAndStates;
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CCastExpression cast) throws CPATransferException {
        CExpression op = cast.getOperand();
        if (op.getExpressionType() instanceof CArrayType) {
            return cast.getOperand().accept(this);
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressAndState.withUnknownAddress(this.getInitialSmgState()));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressAndState> visit(CFunctionCallExpression pIastFunctionCallExpression) {
        return this.visitDefault(pIastFunctionCallExpression);
    }
}

