/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.LValueAssignmentVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGRightHandSideEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

class AssigningValueVisitor
extends DefaultCExpressionVisitor<Void, CPATransferException> {
    private final SMGRightHandSideEvaluator smgRightHandSideEvaluator;
    private SMGState assignableState;
    private final boolean truthValue;
    private final CFAEdge edge;

    public AssigningValueVisitor(SMGRightHandSideEvaluator pSmgRightHandSideEvaluator, SMGState pSMGState, boolean pTruthvalue, CFAEdge pEdge) {
        this.smgRightHandSideEvaluator = pSmgRightHandSideEvaluator;
        this.assignableState = pSMGState;
        this.truthValue = pTruthvalue;
        this.edge = pEdge;
    }

    public SMGState getAssignedState() {
        return this.assignableState;
    }

    @Override
    protected Void visitDefault(CExpression pExp) {
        return null;
    }

    @Override
    public Void visit(CPointerExpression pointerExpression) throws CPATransferException {
        this.deriveFurtherInformation(pointerExpression);
        return null;
    }

    @Override
    public Void visit(CIdExpression pExp) throws CPATransferException {
        this.deriveFurtherInformation(pExp);
        return null;
    }

    @Override
    public Void visit(CArraySubscriptExpression pExp) throws CPATransferException {
        this.deriveFurtherInformation(pExp);
        return null;
    }

    @Override
    public Void visit(CFieldReference pExp) throws CPATransferException {
        this.deriveFurtherInformation(pExp);
        return null;
    }

    @Override
    public Void visit(CCastExpression pE) throws CPATransferException {
        return pE.getOperand().accept(this);
    }

    @Override
    public Void visit(CCharLiteralExpression pE) throws CPATransferException {
        throw new AssertionError();
    }

    @Override
    public Void visit(CFloatLiteralExpression pE) throws CPATransferException {
        throw new AssertionError();
    }

    @Override
    public Void visit(CIntegerLiteralExpression pE) throws CPATransferException {
        throw new AssertionError();
    }

    @Override
    public Void visit(CBinaryExpression binExp) throws CPATransferException {
        CExpression operand1 = this.unwrap(binExp.getOperand1());
        CExpression operand2 = this.unwrap(binExp.getOperand2());
        CBinaryExpression.BinaryOperator op = binExp.getOperator();
        if (operand1 instanceof CLeftHandSide) {
            this.deriveFurtherInformation((CLeftHandSide)operand1, operand2, op);
        }
        if (operand2 instanceof CLeftHandSide) {
            this.deriveFurtherInformation((CLeftHandSide)operand2, operand1, op.getSwitchOperandsSidesLogicalOperator());
        }
        return null;
    }

    private void deriveFurtherInformation(CLeftHandSide lValue, CExpression exp, CBinaryExpression.BinaryOperator op) throws CPATransferException {
        SMGExplicitValue rValue = this.smgRightHandSideEvaluator.evaluateExplicitValueV2(this.assignableState, this.edge, exp);
        if (rValue.isUnknown()) {
            return;
        }
        SMGValue rSymValue = this.smgRightHandSideEvaluator.evaluateExpressionValueV2(this.assignableState, this.edge, lValue);
        CType lValueType = TypeUtils.getRealExpressionType(lValue);
        if (rSymValue.isUnknown()) {
            rSymValue = SMGKnownSymValue.of();
            LValueAssignmentVisitor visitor = this.smgRightHandSideEvaluator.getLValueAssignmentVisitor(this.edge, this.assignableState);
            List<SMGAbstractObjectAndState.SMGAddressAndState> addressOfFields = lValue.accept(visitor);
            if (addressOfFields.size() != 1) {
                return;
            }
            SMGAddress addressOfField = (SMGAddress)addressOfFields.get(0).getObject();
            if (addressOfField.isUnknown()) {
                return;
            }
            this.assignableState = this.smgRightHandSideEvaluator.writeValue(this.assignableState, addressOfField.getObject(), addressOfField.getOffset().getAsLong(), lValueType, rSymValue, this.edge);
        }
        SMGType symValueType = SMGType.constructSMGType(lValueType, this.assignableState, this.edge, this.smgRightHandSideEvaluator);
        this.assignableState.addPredicateRelation(rSymValue, symValueType, rValue, op, this.edge);
        if (this.truthValue) {
            if (op == CBinaryExpression.BinaryOperator.EQUALS) {
                this.assignableState.putExplicit((SMGKnownSymbolicValue)rSymValue, (SMGKnownExpValue)rValue);
            }
        } else if (op == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
            this.assignableState.putExplicit((SMGKnownSymbolicValue)rSymValue, (SMGKnownExpValue)rValue);
        }
    }

    @Override
    public Void visit(CUnaryExpression pE) throws CPATransferException {
        CUnaryExpression.UnaryOperator op = pE.getOperator();
        CExpression operand = pE.getOperand();
        switch (op) {
            case AMPER: {
                throw new AssertionError((Object)"In this case, the assume should be able to be calculated");
            }
            case MINUS: 
            case TILDE: {
                return operand.accept(this);
            }
            case SIZEOF: {
                throw new AssertionError((Object)"At the moment, this case should be able to be calculated");
            }
        }
        return null;
    }

    private void deriveFurtherInformation(CLeftHandSide lValue) throws CPATransferException {
        if (this.truthValue) {
            return;
        }
        LValueAssignmentVisitor visitor = this.smgRightHandSideEvaluator.getLValueAssignmentVisitor(this.edge, this.assignableState);
        List<SMGAbstractObjectAndState.SMGAddressAndState> addressOfFields = lValue.accept(visitor);
        if (addressOfFields.size() != 1) {
            return;
        }
        SMGAddress addressOfField = (SMGAddress)addressOfFields.get(0).getObject();
        if (addressOfField.isUnknown()) {
            return;
        }
        assert (this.smgRightHandSideEvaluator.evaluateExplicitValueV2(this.assignableState, this.edge, lValue).isUnknown());
        SMGValue value = this.smgRightHandSideEvaluator.evaluateExpressionValueV2(this.assignableState, this.edge, lValue);
        assert (!value.isUnknown());
        this.assignableState.putExplicit((SMGKnownSymbolicValue)value, SMGZeroValue.INSTANCE);
    }

    private CExpression unwrap(CExpression expression) {
        if (expression instanceof CCastExpression) {
            expression = this.unwrap(((CCastExpression)expression).getOperand());
        }
        return expression;
    }
}

