/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class AssumeVisitor
extends ExpressionValueVisitor {
    private final Map<UnmodifiableSMGState, BinaryRelationResult> relations = new HashMap<UnmodifiableSMGState, BinaryRelationResult>();

    public AssumeVisitor(SMGExpressionEvaluator pSmgExpressionEvaluator, CFAEdge pEdge, SMGState pSmgState) {
        super(pSmgExpressionEvaluator, pEdge, pSmgState);
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CBinaryExpression pExp) throws CPATransferException {
        CBinaryExpression.BinaryOperator binaryOperator = pExp.getOperator();
        switch (binaryOperator) {
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_EQUAL: 
            case LESS_THAN: 
            case GREATER_EQUAL: 
            case GREATER_THAN: {
                ArrayList<SMGAbstractObjectAndState.SMGValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>(4);
                CExpression leftSideExpression = pExp.getOperand1();
                CExpression rightSideExpression = pExp.getOperand2();
                CFAEdge edge = this.getCfaEdge();
                for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : this.smgExpressionEvaluator.evaluateExpressionValue(this.getInitialSmgState(), edge, leftSideExpression)) {
                    SMGValue leftSideVal = (SMGValue)sMGValueAndState.getObject();
                    SMGState newState = sMGValueAndState.getSmgState();
                    for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState2 : this.smgExpressionEvaluator.evaluateExpressionValue(newState, edge, rightSideExpression)) {
                        SMGKnownSymbolicValue expValue;
                        SMGValue rightSideVal = (SMGValue)sMGValueAndState2.getObject();
                        newState = sMGValueAndState2.getSmgState();
                        if (leftSideVal instanceof SMGKnownSymbolicValue && newState.isExplicit(expValue = (SMGKnownSymbolicValue)leftSideVal)) {
                            leftSideVal = newState.getExplicit(expValue);
                        }
                        if (rightSideVal instanceof SMGKnownSymbolicValue && newState.isExplicit(expValue = (SMGKnownSymbolicValue)rightSideVal)) {
                            rightSideVal = newState.getExplicit(expValue);
                        }
                        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState3 : this.evaluateBinaryAssumption(newState, binaryOperator, leftSideVal, rightSideVal)) {
                            newState = sMGValueAndState3.getSmgState();
                            SMGValue resultValue = (SMGValue)sMGValueAndState3.getObject();
                            CType leftSideType = leftSideExpression.getExpressionType();
                            SMGType leftSideSMGType = SMGType.constructSMGType(leftSideType, newState, edge, this.smgExpressionEvaluator);
                            while (leftSideExpression instanceof CCastExpression) {
                                CCastExpression leftSideCastExpression = (CCastExpression)leftSideExpression;
                                leftSideExpression = leftSideCastExpression.getOperand();
                                CType leftSideOriginType = leftSideExpression.getExpressionType();
                                SMGType leftSideOriginSMGType = SMGType.constructSMGType(leftSideOriginType, newState, edge, this.smgExpressionEvaluator);
                                leftSideSMGType = new SMGType(leftSideSMGType, leftSideOriginSMGType);
                            }
                            CType rightSideType = rightSideExpression.getExpressionType();
                            SMGType rightSideSMGType = SMGType.constructSMGType(rightSideType, newState, edge, this.smgExpressionEvaluator);
                            while (rightSideExpression instanceof CCastExpression) {
                                CCastExpression rightSideCastExpression = (CCastExpression)rightSideExpression;
                                rightSideExpression = rightSideCastExpression.getOperand();
                                CType rightSideOriginType = rightSideExpression.getExpressionType();
                                SMGType rightSideOriginSMGType = SMGType.constructSMGType(rightSideOriginType, newState, edge, this.smgExpressionEvaluator);
                                rightSideSMGType = new SMGType(leftSideSMGType, rightSideOriginSMGType);
                            }
                            newState.addPredicateRelation(leftSideVal, leftSideSMGType, rightSideVal, rightSideSMGType, binaryOperator, edge);
                            result.add(SMGAbstractObjectAndState.SMGValueAndState.of(newState, resultValue));
                        }
                    }
                }
                return result;
            }
        }
        return super.visit(pExp);
    }

    private boolean isPointer(UnmodifiableSMGState pNewSmgState, SMGValue symVal) {
        if (symVal.isUnknown()) {
            return false;
        }
        if (symVal.isZero()) {
            return true;
        }
        return pNewSmgState.getHeap().isPointer(symVal);
    }

    private boolean comparePointer(SMGAddressValue pV1, SMGAddressValue pV2, CBinaryExpression.BinaryOperator pOp) {
        SMGObject object2;
        SMGObject object1 = pV1.getObject();
        if (object1 == (object2 = pV2.getObject())) {
            long offset1 = pV1.getOffset().getAsLong();
            long offset2 = pV2.getOffset().getAsLong();
            switch (pOp) {
                case GREATER_EQUAL: {
                    return offset1 >= offset2;
                }
                case GREATER_THAN: {
                    return offset1 > offset2;
                }
                case LESS_EQUAL: {
                    return offset1 <= offset2;
                }
                case LESS_THAN: {
                    return offset1 < offset2;
                }
                case EQUALS: {
                    return offset1 == offset2;
                }
                case NOT_EQUALS: {
                    return offset1 != offset2;
                }
            }
            throw new AssertionError((Object)"Impossible case thrown");
        }
        return !(pOp != CBinaryExpression.BinaryOperator.NOT_EQUALS || !this.getInitialSmgState().getHeap().isObjectValid(object1) && !SMGNullObject.INSTANCE.equals(object1) || !this.getInitialSmgState().getHeap().isObjectValid(object2) && !SMGNullObject.INSTANCE.equals(object2));
    }

    private SMGAbstractObjectAndState.SMGValueAndState evaluateBinaryAssumptionOfConcreteSymbolicValues(SMGState pNewState, CBinaryExpression.BinaryOperator pOp, SMGValue pV1, SMGValue pV2) {
        SMGKnownExpValue explicit1;
        boolean isPointerOp1 = pV1 instanceof SMGKnownAddressValue;
        boolean isPointerOp2 = pV2 instanceof SMGKnownAddressValue;
        boolean areEqual = pV1.equals(pV2);
        boolean areNonEqual = pNewState.areNonEqual(pV1, pV2);
        boolean isTrue = false;
        boolean isFalse = false;
        boolean impliesEqWhenFalse = false;
        boolean impliesNeqWhenTrue = false;
        boolean impliesEqWhenTrue = false;
        boolean impliesNeqWhenFalse = false;
        block0 : switch (pOp) {
            case NOT_EQUALS: {
                isTrue = areNonEqual;
                isFalse = areEqual;
                impliesEqWhenFalse = true;
                impliesNeqWhenTrue = true;
                break;
            }
            case EQUALS: {
                isTrue = areEqual;
                isFalse = areNonEqual;
                impliesEqWhenTrue = true;
                impliesNeqWhenFalse = true;
                break;
            }
            case LESS_EQUAL: 
            case LESS_THAN: 
            case GREATER_EQUAL: 
            case GREATER_THAN: {
                switch (pOp) {
                    case LESS_EQUAL: 
                    case GREATER_EQUAL: {
                        if (areEqual) {
                            isTrue = true;
                            impliesEqWhenTrue = true;
                            impliesNeqWhenFalse = true;
                            break block0;
                        }
                        impliesNeqWhenFalse = true;
                        break block0;
                    }
                    case LESS_THAN: 
                    case GREATER_THAN: {
                        if (areEqual) {
                            isFalse = true;
                        }
                        impliesNeqWhenTrue = true;
                        break block0;
                    }
                }
                throw new AssertionError((Object)"Impossible case thrown");
            }
            default: {
                throw new AssertionError((Object)("Binary Relation with non-relational operator: " + pOp));
            }
        }
        if (isPointerOp1 && isPointerOp2) {
            isTrue = this.comparePointer((SMGKnownAddressValue)pV1, (SMGKnownAddressValue)pV2, pOp);
            isFalse = this.comparePointer((SMGKnownAddressValue)pV1, (SMGKnownAddressValue)pV2, pOp.getOppositLogicalOperator());
        } else if (isPointerOp1 && !pV2.isUnknown()) {
            SMGKnownExpValue explicit2 = pNewState.getExplicit(pV2);
            if (explicit2 != null) {
                isTrue = this.comparePointer((SMGKnownAddressValue)pV1, SMGKnownAddressValue.valueOf((SMGKnownSymbolicValue)pV2, SMGNullObject.INSTANCE, explicit2), pOp);
                isFalse = this.comparePointer((SMGKnownAddressValue)pV1, SMGKnownAddressValue.valueOf((SMGKnownSymbolicValue)pV2, SMGNullObject.INSTANCE, explicit2), pOp.getOppositLogicalOperator());
            }
        } else if (isPointerOp2 && !pV1.isUnknown() && (explicit1 = pNewState.getExplicit(pV1)) != null) {
            isTrue = this.comparePointer(SMGKnownAddressValue.valueOf((SMGKnownSymbolicValue)pV1, SMGNullObject.INSTANCE, explicit1), (SMGKnownAddressValue)pV2, pOp);
            isFalse = this.comparePointer(SMGKnownAddressValue.valueOf((SMGKnownSymbolicValue)pV1, SMGNullObject.INSTANCE, explicit1), (SMGKnownAddressValue)pV2, pOp.getOppositLogicalOperator());
        }
        BinaryRelationResult relationResult = new BinaryRelationResult(isTrue, isFalse, impliesEqWhenFalse, impliesNeqWhenFalse, impliesEqWhenTrue, impliesNeqWhenTrue, pV1, pV2);
        this.relations.put(pNewState, relationResult);
        if (isTrue) {
            return SMGAbstractObjectAndState.SMGValueAndState.of(pNewState, SMGKnownSymValue.TRUE);
        }
        if (isFalse) {
            return SMGAbstractObjectAndState.SMGValueAndState.of(pNewState, SMGZeroValue.INSTANCE);
        }
        return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(pNewState);
    }

    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> evaluateBinaryAssumption(SMGState pNewState, CBinaryExpression.BinaryOperator pOp, SMGValue pV1, SMGValue pV2) throws SMGInconsistentException {
        if (pV2.isUnknown() || pV1.isUnknown()) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(pNewState));
        }
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)4);
        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : this.getOperand(pNewState, pV1)) {
            SMGValue operand1 = (SMGValue)sMGValueAndState.getObject();
            for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState2 : this.getOperand(pNewState, pV2)) {
                SMGValue operand2 = (SMGValue)sMGValueAndState2.getObject();
                SMGState newState = sMGValueAndState2.getSmgState();
                SMGAbstractObjectAndState.SMGValueAndState resultValueAndState = this.evaluateBinaryAssumptionOfConcreteSymbolicValues(newState, pOp, operand1, operand2);
                result.add((Object)resultValueAndState);
            }
        }
        return result.build();
    }

    private List<? extends SMGAbstractObjectAndState.SMGValueAndState> getOperand(SMGState pNewState, SMGValue pV) throws SMGInconsistentException {
        if (this.isPointer(pNewState, pV)) {
            return this.smgExpressionEvaluator.getAddressFromSymbolicValue(SMGAbstractObjectAndState.SMGValueAndState.of(pNewState, pV));
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(pNewState, pV));
    }

    public boolean impliesEqOn(boolean pTruth, UnmodifiableSMGState pState) {
        if (!this.relations.containsKey(pState)) {
            return false;
        }
        return this.relations.get(pState).impliesEq(pTruth);
    }

    public boolean impliesNeqOn(boolean pTruth, UnmodifiableSMGState pState) {
        if (!this.relations.containsKey(pState)) {
            return false;
        }
        return this.relations.get(pState).impliesNeq(pTruth);
    }

    public SMGValue impliesVal1(UnmodifiableSMGState pState) {
        return this.relations.get(pState).getVal1();
    }

    public SMGValue impliesVal2(UnmodifiableSMGState pState) {
        return this.relations.get(pState).getVal2();
    }

    private static class BinaryRelationResult {
        private final boolean isTrue;
        private final boolean isFalse;
        private final boolean impliesEqWhenTrue;
        private final boolean impliesNeqWhenTrue;
        private final boolean impliesEqWhenFalse;
        private final boolean impliesNeqWhenFalse;
        private final SMGValue val1;
        private final SMGValue val2;

        BinaryRelationResult(boolean pIsTrue, boolean pIsFalse, boolean pImpliesEqWhenFalse, boolean pImpliesNeqWhenFalse, boolean pImpliesEqWhenTrue, boolean pImpliesNeqWhenTrue, SMGValue pVal1, SMGValue pVal2) {
            this.isTrue = pIsTrue;
            this.isFalse = pIsFalse;
            this.impliesEqWhenFalse = pImpliesEqWhenFalse;
            this.impliesNeqWhenFalse = pImpliesNeqWhenFalse;
            this.impliesEqWhenTrue = pImpliesEqWhenTrue;
            this.impliesNeqWhenTrue = pImpliesNeqWhenTrue;
            this.val1 = pVal1;
            this.val2 = pVal2;
        }

        public boolean isTrue() {
            return this.isTrue;
        }

        public boolean isFalse() {
            return this.isFalse;
        }

        boolean impliesEq(boolean pTruth) {
            return pTruth ? this.impliesEqWhenTrue : this.impliesEqWhenFalse;
        }

        boolean impliesNeq(boolean pTruth) {
            return pTruth ? this.impliesNeqWhenTrue : this.impliesNeqWhenFalse;
        }

        SMGValue getVal2() {
            return this.val2;
        }

        SMGValue getVal1() {
            return this.val1;
        }
    }
}

