/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.LValueAssignmentVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

class CSizeOfVisitor
extends MachineModel.BaseSizeofVisitor {
    private final CFAEdge edge;
    private final SMGState state;
    private final Optional<CExpression> expression;
    private final SMGExpressionEvaluator eval;

    public CSizeOfVisitor(SMGExpressionEvaluator pSmgExpressionEvaluator, CFAEdge pEdge, SMGState pState, Optional<CExpression> pExpression) {
        super(pSmgExpressionEvaluator.machineModel);
        this.edge = pEdge;
        this.state = pState;
        this.expression = pExpression;
        this.eval = pSmgExpressionEvaluator;
    }

    @Override
    public BigInteger visit(CArrayType pArrayType) throws IllegalArgumentException {
        BigInteger length;
        CExpression arrayLength = pArrayType.getLength();
        BigInteger sizeOfType = pArrayType.getType().accept(this);
        if (arrayLength == null) {
            return super.visit(pArrayType);
        }
        if (arrayLength instanceof CIntegerLiteralExpression) {
            length = ((CIntegerLiteralExpression)arrayLength).getValue();
        } else if (this.edge instanceof CDeclarationEdge) {
            SMGExplicitValue lengthAsExplicitValue;
            try {
                lengthAsExplicitValue = this.eval.evaluateExplicitValueV2(this.state, this.edge, arrayLength);
            }
            catch (CPATransferException e) {
                throw new IllegalArgumentException("Exception when calculating array length of " + pArrayType.toASTString("") + ".", e);
            }
            length = lengthAsExplicitValue.isUnknown() ? this.handleUnkownArrayLengthValue(pArrayType) : lengthAsExplicitValue.getValue();
        } else {
            if (this.expression.filter(CLeftHandSide.class::isInstance).isPresent()) {
                List<SMGAbstractObjectAndState.SMGAddressAndState> addressOfFieldAndState;
                LValueAssignmentVisitor visitor = this.eval.getLValueAssignmentVisitor(this.edge, this.state);
                try {
                    addressOfFieldAndState = this.expression.orElseThrow().accept(visitor);
                }
                catch (CPATransferException e) {
                    return this.handleUnkownArrayLengthValue(pArrayType);
                }
                assert (!addressOfFieldAndState.isEmpty());
                SMGAddress addressOfField = (SMGAddress)addressOfFieldAndState.get(0).getObject();
                if (addressOfField.isUnknown()) {
                    return this.handleUnkownArrayLengthValue(pArrayType);
                }
                SMGObject arrayObject = addressOfField.getObject();
                BigInteger offset = addressOfField.getOffset().getValue();
                return BigInteger.valueOf(arrayObject.getSize()).subtract(offset);
            }
            throw new IllegalArgumentException("Unable to calculate the size of the array type " + pArrayType.toASTString("") + ".");
        }
        return length.multiply(sizeOfType);
    }

    BigInteger handleUnkownArrayLengthValue(CArrayType pArrayType) {
        throw new IllegalArgumentException("Can't calculate array length of type " + pArrayType.toASTString("") + ".");
    }
}

