/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

class ExplicitValueVisitor
extends AbstractExpressionValueVisitor {
    private final SMGExpressionEvaluator smgExpressionEvaluator;
    private final CFAEdge edge;
    private SMGState smgState;
    private final List<SMGState> smgStatesToBeProccessed = new ArrayList<SMGState>();

    public ExplicitValueVisitor(SMGExpressionEvaluator pSmgExpressionEvaluator, SMGState pSmgState, String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, CFAEdge pEdge) {
        super(pFunctionName, pMachineModel, pLogger);
        this.smgExpressionEvaluator = pSmgExpressionEvaluator;
        this.smgState = pSmgState;
        this.edge = pEdge;
    }

    public SMGState getState() {
        return this.smgState;
    }

    void setState(SMGState pSmgState) {
        this.smgState = pSmgState;
    }

    CFAEdge getEdge() {
        return this.edge;
    }

    public List<SMGState> getSmgStatesToBeProccessed() {
        return this.smgStatesToBeProccessed;
    }

    private SMGExplicitValue getExplicitValue(SMGValue pValue) {
        if (pValue.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        if (pValue instanceof SMGKnownExpValue) {
            return (SMGExplicitValue)pValue;
        }
        if (!this.getState().isExplicit(pValue)) {
            return SMGUnknownValue.INSTANCE;
        }
        return (SMGExplicitValue)Preconditions.checkNotNull((Object)this.getState().getExplicit(pValue), (Object)"known and existing value cannot be read from state");
    }

    @Override
    public Value visit(CBinaryExpression binaryExp) throws UnrecognizedCodeException {
        Value value = super.visit(binaryExp);
        if (value.isUnknown()) {
            if (binaryExp.getOperator().isLogicalOperator()) {
                List<? extends SMGAbstractObjectAndState.SMGValueAndState> symValueAndStates;
                try {
                    symValueAndStates = this.smgExpressionEvaluator.evaluateAssumptionValue(this.getState(), this.edge, binaryExp);
                }
                catch (CPATransferException e) {
                    UnrecognizedCodeException e2 = new UnrecognizedCodeException("SMG cannot be evaluated", binaryExp);
                    e2.initCause(e);
                    throw e2;
                }
                SMGAbstractObjectAndState.SMGValueAndState symValueAndState = this.getStateAndAddRestForLater(symValueAndStates);
                SMGValue symValue = (SMGValue)symValueAndState.getObject();
                this.setState(symValueAndState.getSmgState());
                if (symValue.equals(SMGKnownSymValue.TRUE)) {
                    return new NumericValue(1);
                }
                if (symValue.equals(SMGZeroValue.INSTANCE)) {
                    return new NumericValue(0);
                }
            } else if (CBinaryExpression.BinaryOperator.MINUS == binaryExp.getOperator()) {
                List<? extends SMGAbstractObjectAndState.SMGValueAndState> symValueAndStates;
                try {
                    symValueAndStates = this.smgExpressionEvaluator.evaluateAssumptionValue(this.getState(), this.edge, binaryExp);
                }
                catch (CPATransferException e) {
                    UnrecognizedCodeException e2 = new UnrecognizedCodeException("SMG cannot be evaluated", binaryExp);
                    e2.initCause(e);
                    throw e2;
                }
                SMGAbstractObjectAndState.SMGValueAndState symValueAndState = this.getStateAndAddRestForLater(symValueAndStates);
                SMGValue symValue = (SMGValue)symValueAndState.getObject();
                this.setState(symValueAndState.getSmgState());
                CType type1 = binaryExp.getOperand1().getExpressionType().getCanonicalType();
                if (symValue instanceof SMGKnownExpValue && type1 instanceof CPointerType) {
                    return new NumericValue(((SMGKnownExpValue)symValue).getValue());
                }
            }
        }
        return value;
    }

    @Override
    protected Value evaluateCPointerExpression(CPointerExpression pCPointerExpression) throws UnrecognizedCodeException {
        return this.evaluateLeftHandSideExpression(pCPointerExpression);
    }

    private Value evaluateLeftHandSideExpression(CLeftHandSide leftHandSide) throws UnrecognizedCodeException {
        List<? extends SMGAbstractObjectAndState.SMGValueAndState> valueAndStates;
        try {
            valueAndStates = this.smgExpressionEvaluator.evaluateExpressionValue(this.getState(), this.edge, leftHandSide);
        }
        catch (CPATransferException e) {
            UnrecognizedCodeException e2 = new UnrecognizedCodeException("SMG cannot be evaluated", leftHandSide);
            e2.initCause(e);
            throw e2;
        }
        SMGAbstractObjectAndState.SMGValueAndState valueAndState = this.getStateAndAddRestForLater(valueAndStates);
        SMGValue value = (SMGValue)valueAndState.getObject();
        this.setState(valueAndState.getSmgState());
        SMGExplicitValue expValue = this.getExplicitValue(value);
        if (expValue.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        return new NumericValue(expValue.getAsLong());
    }

    private SMGAbstractObjectAndState.SMGValueAndState getStateAndAddRestForLater(List<? extends SMGAbstractObjectAndState.SMGValueAndState> valueAndStates) {
        SMGAbstractObjectAndState.SMGValueAndState valueAndState = !valueAndStates.isEmpty() ? valueAndStates.get(0) : SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this.getState());
        for (int c = 1; c < valueAndStates.size(); ++c) {
            this.smgStatesToBeProccessed.add(valueAndStates.get(c).getSmgState());
        }
        return valueAndState;
    }

    @Override
    protected Value evaluateCIdExpression(CIdExpression pCIdExpression) throws UnrecognizedCodeException {
        return this.evaluateLeftHandSideExpression(pCIdExpression);
    }

    @Override
    protected Value evaluateJIdExpression(JIdExpression pVarName) {
        return null;
    }

    @Override
    protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCodeException {
        return this.evaluateLeftHandSideExpression(pLValue);
    }

    @Override
    protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCodeException {
        return this.evaluateLeftHandSideExpression(pLValue);
    }

    @Override
    public Value visit(JClassLiteralExpression pJClassLiteralExpression) {
        return Value.UnknownValue.getInstance();
    }
}

