/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ArrayVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.AssumeVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

class ExpressionValueVisitor
extends DefaultCExpressionVisitor<List<? extends SMGAbstractObjectAndState.SMGValueAndState>, CPATransferException>
implements CRightHandSideVisitor<List<? extends SMGAbstractObjectAndState.SMGValueAndState>, CPATransferException> {
    final SMGExpressionEvaluator smgExpressionEvaluator;
    final CFAEdge cfaEdge;
    private final SMGState initialSmgState;

    public ExpressionValueVisitor(SMGExpressionEvaluator pSmgExpressionEvaluator, CFAEdge pEdge, SMGState pSmgState) {
        this.smgExpressionEvaluator = pSmgExpressionEvaluator;
        this.cfaEdge = pEdge;
        this.initialSmgState = pSmgState;
    }

    @Override
    protected List<? extends SMGAbstractObjectAndState.SMGValueAndState> visitDefault(CExpression pExp) {
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this.getInitialSmgState()));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CArraySubscriptExpression exp) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>();
        for (SMGAbstractObjectAndState.SMGAddressAndState addressAndState : this.smgExpressionEvaluator.evaluateArraySubscriptAddress(this.getInitialSmgState(), this.getCfaEdge(), exp)) {
            SMGAddress address = (SMGAddress)addressAndState.getObject();
            SMGState newState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                result.add(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(newState));
                continue;
            }
            SMGAbstractObjectAndState.SMGValueAndState symbolicValueResultAndState = this.smgExpressionEvaluator.readValue(newState, address.getObject(), address.getOffset(), TypeUtils.getRealExpressionType(exp), this.cfaEdge);
            result.add(symbolicValueResultAndState);
        }
        return result;
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CIntegerLiteralExpression exp) throws CPATransferException {
        BigInteger value = exp.getValue();
        SMGKnownSymbolicValue symbolicOfExplicit = this.getInitialSmgState().getSymbolicOfExplicit(SMGKnownExpValue.valueOf(value));
        if (symbolicOfExplicit == null) {
            symbolicOfExplicit = SMGKnownSymValue.of();
            this.getInitialSmgState().putExplicit(symbolicOfExplicit, SMGKnownExpValue.valueOf(value));
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(this.getInitialSmgState(), symbolicOfExplicit));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CCharLiteralExpression exp) throws CPATransferException {
        char value = exp.getCharacter();
        SMGExplicitValue val = value == '\u0000' ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(this.getInitialSmgState(), val));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CFieldReference fieldReference) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>(2);
        List<SMGAbstractObjectAndState.SMGAddressAndState> addressOfFieldAndStates = this.smgExpressionEvaluator.getAddressOfField(this.getInitialSmgState(), this.getCfaEdge(), fieldReference);
        for (SMGAbstractObjectAndState.SMGAddressAndState addressOfFieldAndState : addressOfFieldAndStates) {
            SMGAddress addressOfField = (SMGAddress)addressOfFieldAndState.getObject();
            SMGState newState = addressOfFieldAndState.getSmgState();
            if (addressOfField.isUnknown()) {
                result.add(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(newState));
                continue;
            }
            CType fieldType = TypeUtils.getRealExpressionType(fieldReference);
            result.add(this.smgExpressionEvaluator.readValue(newState, addressOfField.getObject(), addressOfField.getOffset(), fieldType, this.cfaEdge));
        }
        return result;
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CFloatLiteralExpression exp) throws CPATransferException {
        boolean isZero = exp.getValue().compareTo(BigDecimal.ZERO) == 0;
        SMGExplicitValue val = isZero ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(this.getInitialSmgState(), val));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CIdExpression idExpression) throws CPATransferException {
        SMGState smgState;
        SMGRegion variableObject;
        CSimpleDeclaration decl = idExpression.getDeclaration();
        if (decl instanceof CEnumType.CEnumerator) {
            long enumValue = ((CEnumType.CEnumerator)decl).getValue();
            SMGExplicitValue val = enumValue == 0L ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
            return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(this.getInitialSmgState(), val));
        }
        if ((decl instanceof CVariableDeclaration || decl instanceof CParameterDeclaration) && (variableObject = (smgState = this.getInitialSmgState()).getHeap().getObjectForVisibleVariable(idExpression.getName())) != null) {
            smgState.addElementToCurrentChain(variableObject);
            SMGAbstractObjectAndState.SMGValueAndState result = this.smgExpressionEvaluator.readValue(smgState, variableObject, SMGZeroValue.INSTANCE, TypeUtils.getRealExpressionType(idExpression), this.cfaEdge);
            result.getSmgState().addElementToCurrentChain(result.getObject());
            return Collections.singletonList(result);
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this.getInitialSmgState()));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CUnaryExpression unaryExpression) throws CPATransferException {
        CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        CExpression unaryOperand = unaryExpression.getOperand();
        switch (unaryOperator) {
            case AMPER: {
                throw new UnrecognizedCodeException("Can't use & of expression " + unaryOperand.toASTString(), this.cfaEdge, unaryExpression);
            }
            case MINUS: {
                ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)2);
                List<? extends SMGAbstractObjectAndState.SMGValueAndState> valueAndStates = unaryOperand.accept(this);
                for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : valueAndStates) {
                    SMGValue value = (SMGValue)sMGValueAndState.getObject();
                    SMGValue val = value.equals(SMGZeroValue.INSTANCE) ? value : SMGUnknownValue.INSTANCE;
                    result.add((Object)SMGAbstractObjectAndState.SMGValueAndState.of(sMGValueAndState.getSmgState(), val));
                }
                return result.build();
            }
            case SIZEOF: {
                long size = this.smgExpressionEvaluator.getBitSizeof(this.cfaEdge, TypeUtils.getRealExpressionType(unaryOperand), this.getInitialSmgState(), unaryOperand);
                SMGExplicitValue val = size == 0L ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
                return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(this.getInitialSmgState(), val));
            }
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this.getInitialSmgState()));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CPointerExpression pointerExpression) throws CPATransferException {
        CExpression operand = pointerExpression.getOperand();
        CType operandType = TypeUtils.getRealExpressionType(operand);
        CType expType = TypeUtils.getRealExpressionType(pointerExpression);
        if (operandType instanceof CPointerType) {
            return this.dereferencePointer(operand, expType);
        }
        if (operandType instanceof CArrayType) {
            return this.dereferenceArray(operand, expType);
        }
        throw new UnrecognizedCodeException("on pointer expression", this.cfaEdge, pointerExpression);
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CTypeIdExpression typeIdExp) throws UnrecognizedCodeException {
        CTypeIdExpression.TypeIdOperator typeOperator = typeIdExp.getOperator();
        CType type = typeIdExp.getType();
        switch (typeOperator) {
            case SIZEOF: {
                SMGExplicitValue val = this.smgExpressionEvaluator.getBitSizeof(this.cfaEdge, type, this.getInitialSmgState(), typeIdExp) == 0L ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
                return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(this.getInitialSmgState(), val));
            }
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this.getInitialSmgState()));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CBinaryExpression exp) throws CPATransferException {
        CBinaryExpression.BinaryOperator binaryOperator = exp.getOperator();
        CExpression lVarInBinaryExp = exp.getOperand1();
        CExpression rVarInBinaryExp = exp.getOperand2();
        ArrayList<? extends SMGAbstractObjectAndState.SMGValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>(4);
        List<? extends SMGAbstractObjectAndState.SMGValueAndState> lValAndStates = this.smgExpressionEvaluator.evaluateExpressionValue(this.getInitialSmgState(), this.getCfaEdge(), lVarInBinaryExp);
        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : lValAndStates) {
            SMGValue lVal = (SMGValue)sMGValueAndState.getObject();
            SMGState newState = sMGValueAndState.getSmgState();
            List<? extends SMGAbstractObjectAndState.SMGValueAndState> rValAndStates = this.smgExpressionEvaluator.evaluateExpressionValue(newState, this.getCfaEdge(), rVarInBinaryExp);
            for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState2 : rValAndStates) {
                SMGValue rVal = (SMGValue)sMGValueAndState2.getObject();
                newState = sMGValueAndState2.getSmgState();
                if (rVal.equals(SMGUnknownValue.INSTANCE) || lVal.equals(SMGUnknownValue.INSTANCE)) {
                    result.add(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(newState));
                    continue;
                }
                result.addAll(this.evaluateBinaryExpression(lVal, rVal, lVarInBinaryExp, binaryOperator, newState));
            }
        }
        return result;
    }

    private List<? extends SMGAbstractObjectAndState.SMGValueAndState> evaluateBinaryExpression(SMGValue lVal, SMGValue rVal, CExpression lVarInBinaryExp, CBinaryExpression.BinaryOperator binaryOperator, SMGState newState) throws SMGInconsistentException {
        if (lVal.equals(SMGUnknownValue.INSTANCE) || rVal.equals(SMGUnknownValue.INSTANCE)) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(newState));
        }
        switch (binaryOperator) {
            case PLUS: 
            case SHIFT_LEFT: 
            case BINARY_OR: 
            case BINARY_XOR: 
            case SHIFT_RIGHT: 
            case MINUS: 
            case MODULO: 
            case DIVIDE: 
            case MULTIPLY: 
            case BINARY_AND: {
                switch (binaryOperator) {
                    case PLUS: 
                    case SHIFT_LEFT: 
                    case BINARY_OR: 
                    case BINARY_XOR: 
                    case SHIFT_RIGHT: {
                        boolean isZero = lVal.equals(SMGZeroValue.INSTANCE) && rVal.equals(SMGZeroValue.INSTANCE);
                        SMGExplicitValue val = isZero ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
                        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(newState, val));
                    }
                    case MINUS: {
                        boolean isZero;
                        if (lVal instanceof SMGKnownAddressValue && rVal instanceof SMGKnownAddressValue) {
                            SMGKnownAddressValue lValAddress = (SMGKnownAddressValue)lVal;
                            SMGKnownAddressValue rValAddress = (SMGKnownAddressValue)rVal;
                            if (lValAddress.getObject().equals(rValAddress.getObject())) {
                                CType type;
                                CType cType = lVarInBinaryExp.getExpressionType().getCanonicalType();
                                if (cType instanceof CPointerType) {
                                    type = ((CPointerType)cType).getType();
                                } else if (cType instanceof CSimpleType) {
                                    type = cType;
                                } else {
                                    throw new AssertionError((Object)String.format("unhandled type '%s' for pointer comparison using '%s'.", cType, lVarInBinaryExp));
                                }
                                BigInteger sizeOfLVal = this.smgExpressionEvaluator.machineModel.getSizeofInBits(type);
                                SMGExplicitValue diff = lValAddress.getOffset().subtract(rValAddress.getOffset());
                                diff = diff.divide(SMGKnownExpValue.valueOf(sizeOfLVal));
                                return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(newState, diff));
                            }
                        }
                        SMGExplicitValue val = (isZero = lVal.equals(rVal)) ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
                        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(newState, val));
                    }
                    case MODULO: {
                        boolean isZero = lVal.equals(rVal);
                        SMGExplicitValue val = isZero ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
                        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(newState, val));
                    }
                    case DIVIDE: {
                        if (rVal.equals(SMGZeroValue.INSTANCE)) {
                            return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(newState));
                        }
                        boolean isZero = lVal.equals(SMGZeroValue.INSTANCE);
                        SMGExplicitValue val = isZero ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
                        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(newState, val));
                    }
                    case MULTIPLY: 
                    case BINARY_AND: {
                        boolean isZero = lVal.equals(SMGZeroValue.INSTANCE) || rVal.equals(SMGZeroValue.INSTANCE);
                        SMGExplicitValue val = isZero ? SMGZeroValue.INSTANCE : SMGUnknownValue.INSTANCE;
                        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.of(newState, val));
                    }
                }
                throw new AssertionError();
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                AssumeVisitor v = this.smgExpressionEvaluator.getAssumeVisitor(this.getCfaEdge(), newState);
                List<? extends SMGAbstractObjectAndState.SMGValueAndState> assumptionValueAndStates = v.evaluateBinaryAssumption(newState, binaryOperator, lVal, rVal);
                ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)2);
                for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : assumptionValueAndStates) {
                    newState = sMGValueAndState.getSmgState();
                    SMGValue assumptionVal = (SMGValue)sMGValueAndState.getObject();
                    if (assumptionVal.isZero()) {
                        SMGAbstractObjectAndState.SMGValueAndState resultValueAndState = SMGAbstractObjectAndState.SMGValueAndState.of(newState, SMGZeroValue.INSTANCE);
                        result.add((Object)resultValueAndState);
                        continue;
                    }
                    result.add((Object)SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(newState));
                }
                return result.build();
            }
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this.getInitialSmgState()));
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CCastExpression cast) throws CPATransferException {
        List<? extends SMGAbstractObjectAndState.SMGValueAndState> smgValueAndStates = this.smgExpressionEvaluator.evaluateExpressionValue(this.getInitialSmgState(), this.getCfaEdge(), cast.getOperand());
        CType expressionType = cast.getCastType();
        if (!SMGExpressionEvaluator.isAddressType(expressionType) && SMGExpressionEvaluator.isAddressType(TypeUtils.getRealExpressionType(cast.getOperand()))) {
            ArrayList<SMGAbstractObjectAndState.SMGValueAndState> castedValueAndStates = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>(smgValueAndStates.size());
            for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : smgValueAndStates) {
                if (!(sMGValueAndState instanceof SMGAbstractObjectAndState.SMGAddressValueAndState)) continue;
                castedValueAndStates.add(sMGValueAndState);
            }
            return castedValueAndStates;
        }
        return smgValueAndStates;
    }

    private List<? extends SMGAbstractObjectAndState.SMGValueAndState> dereferenceArray(CExpression exp, CType derefType) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>(2);
        ArrayVisitor v = this.smgExpressionEvaluator.getArrayVisitor(this.getCfaEdge(), this.getInitialSmgState());
        List<SMGAbstractObjectAndState.SMGAddressAndState> addressAndStates = exp.accept(v);
        for (SMGAbstractObjectAndState.SMGAddressAndState addressAndState : addressAndStates) {
            SMGAddress address = (SMGAddress)addressAndState.getObject();
            SMGState newState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                result.add(this.smgExpressionEvaluator.handleUnknownDereference(newState, this.cfaEdge));
                continue;
            }
            if (derefType instanceof CArrayType) {
                result.addAll(this.smgExpressionEvaluator.createAddress(newState, address.getObject(), address.getOffset()));
                continue;
            }
            result.add(this.smgExpressionEvaluator.readValue(newState, address.getObject(), address.getOffset(), derefType, this.cfaEdge));
        }
        return result;
    }

    private List<? extends SMGAbstractObjectAndState.SMGValueAndState> dereferencePointer(CExpression exp, CType derefType) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGValueAndState>(2);
        List<SMGAbstractObjectAndState.SMGAddressValueAndState> addressAndStates = this.smgExpressionEvaluator.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), exp);
        for (SMGAbstractObjectAndState.SMGAddressValueAndState addressAndState : addressAndStates) {
            SMGAddressValue address = addressAndState.getObject();
            SMGState newState = addressAndState.getSmgState();
            if (address.isUnknown()) {
                result.add(this.smgExpressionEvaluator.handleUnknownDereference(newState, this.getCfaEdge()));
                continue;
            }
            if (derefType instanceof CArrayType) {
                result.addAll(this.smgExpressionEvaluator.createAddress(newState, address.getObject(), address.getOffset()));
                continue;
            }
            result.add(this.smgExpressionEvaluator.readValue(newState, address.getObject(), address.getOffset(), derefType, this.cfaEdge));
        }
        return result;
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
        return Collections.singletonList(SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(this.getInitialSmgState()));
    }

    SMGState getInitialSmgState() {
        return this.initialSmgState;
    }

    CFAEdge getCfaEdge() {
        return this.cfaEdge;
    }
}

