/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

class PointerVisitor
extends ExpressionValueVisitor {
    public PointerVisitor(SMGExpressionEvaluator pSmgExpressionEvaluator, CFAEdge pEdge, SMGState pSmgState) {
        super(pSmgExpressionEvaluator, pEdge, pSmgState);
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CIntegerLiteralExpression exp) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(exp));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CCharLiteralExpression exp) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(exp));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CFloatLiteralExpression pExp) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(pExp));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CIdExpression exp) throws CPATransferException {
        CType c = TypeUtils.getRealExpressionType(exp);
        if (c instanceof CArrayType) {
            return this.createAddressOfVariable(exp);
        }
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(exp));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CUnaryExpression unaryExpression) throws CPATransferException {
        CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        CExpression unaryOperand = unaryExpression.getOperand();
        switch (unaryOperator) {
            case AMPER: {
                return this.handleAmper(unaryOperand);
            }
            case SIZEOF: {
                throw new UnrecognizedCodeException("Misinterpreted the expression type of " + unaryOperand.toASTString() + " as pointer type", this.cfaEdge, unaryExpression);
            }
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(this.getInitialSmgState()));
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> handleAmper(CRightHandSide amperOperand) throws CPATransferException {
        if (TypeUtils.getRealExpressionType(amperOperand) instanceof CFunctionType && amperOperand instanceof CIdExpression) {
            return this.createAddressOfFunction((CIdExpression)amperOperand);
        }
        if (amperOperand instanceof CIdExpression) {
            return this.createAddressOfVariable((CIdExpression)amperOperand);
        }
        if (amperOperand instanceof CPointerExpression) {
            CExpression rValue = ((CPointerExpression)amperOperand).getOperand();
            return this.smgExpressionEvaluator.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), rValue);
        }
        if (amperOperand instanceof CFieldReference) {
            return this.createAddressOfField((CFieldReference)amperOperand);
        }
        if (amperOperand instanceof CArraySubscriptExpression) {
            return this.createAddressOfArraySubscript((CArraySubscriptExpression)amperOperand);
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(this.getInitialSmgState()));
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> createAddressOfFunction(CIdExpression idFunctionExpression) throws SMGInconsistentException {
        SMGState state = this.getInitialSmgState();
        SMGObject functionObject = state.getObjectForFunction((CFunctionDeclaration)idFunctionExpression.getDeclaration());
        if (functionObject == null) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(state));
        }
        return this.smgExpressionEvaluator.createAddress(state, functionObject, SMGZeroValue.INSTANCE);
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> createAddressOfArraySubscript(CArraySubscriptExpression lValue) throws CPATransferException {
        CExpression arrayExpression = lValue.getArrayExpression();
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>(4);
        for (SMGAbstractObjectAndState.SMGAddressValueAndState arrayAddressAndState : this.smgExpressionEvaluator.evaluateAddress(this.getInitialSmgState(), this.getCfaEdge(), arrayExpression)) {
            SMGAddressValue arrayAddress = arrayAddressAndState.getObject();
            SMGState newState = arrayAddressAndState.getSmgState();
            if (arrayAddress.isUnknown()) {
                result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(newState));
                continue;
            }
            CExpression subscriptExpr = lValue.getSubscriptExpression();
            for (SMGAbstractObjectAndState.SMGExplicitValueAndState subscriptValueAndState : this.smgExpressionEvaluator.evaluateExplicitValue(newState, this.getCfaEdge(), subscriptExpr)) {
                SMGExplicitValue subscriptValue = (SMGExplicitValue)subscriptValueAndState.getObject();
                newState = subscriptValueAndState.getSmgState();
                if (subscriptValue.isUnknown()) {
                    result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(newState));
                    continue;
                }
                SMGExplicitValue arrayOffset = arrayAddress.getOffset();
                long typeSize = this.smgExpressionEvaluator.getBitSizeof(this.getCfaEdge(), TypeUtils.getRealExpressionType(lValue), newState, lValue);
                SMGKnownExpValue sizeOfType = SMGKnownExpValue.valueOf(typeSize);
                SMGExplicitValue offset = arrayOffset.add(subscriptValue.multiply(sizeOfType));
                List<SMGAbstractObjectAndState.SMGAddressValueAndState> resultAddressAndState = this.smgExpressionEvaluator.createAddress(newState, arrayAddress.getObject(), offset);
                result.addAll(resultAddressAndState);
            }
        }
        return result;
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> createAddressOfField(CFieldReference lValue) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>(2);
        for (SMGAbstractObjectAndState.SMGAddressAndState addressOfFieldAndState : this.smgExpressionEvaluator.getAddressOfField(this.getInitialSmgState(), this.getCfaEdge(), lValue)) {
            SMGAddress addressOfField = (SMGAddress)addressOfFieldAndState.getObject();
            SMGState newState = addressOfFieldAndState.getSmgState();
            if (addressOfField.isUnknown()) {
                result.add(SMGAbstractObjectAndState.SMGAddressValueAndState.of(newState));
                continue;
            }
            List<SMGAbstractObjectAndState.SMGAddressValueAndState> resultAddressValueAndState = this.smgExpressionEvaluator.createAddress(addressOfFieldAndState.getSmgState(), addressOfField.getObject(), addressOfField.getOffset());
            result.addAll(resultAddressValueAndState);
        }
        return result;
    }

    private List<SMGAbstractObjectAndState.SMGAddressValueAndState> createAddressOfVariable(CIdExpression idExpression) throws SMGInconsistentException {
        SMGState state = this.getInitialSmgState();
        SMGRegion variableObject = state.getHeap().getObjectForVisibleVariable(idExpression.getName());
        if (variableObject == null) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(state));
        }
        state.addElementToCurrentChain(variableObject);
        return this.smgExpressionEvaluator.createAddress(state, variableObject, SMGZeroValue.INSTANCE);
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CPointerExpression pointerExpression) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(pointerExpression));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CBinaryExpression binaryExp) throws CPATransferException {
        CPointerType addressType;
        CExpression pointerOffset;
        CExpression address;
        CType rVarInBinaryExpType;
        boolean rVarIsAddress;
        CExpression lVarInBinaryExp = binaryExp.getOperand1();
        CExpression rVarInBinaryExp = binaryExp.getOperand2();
        CType lVarInBinaryExpType = CTypes.adjustFunctionOrArrayType(TypeUtils.getRealExpressionType(lVarInBinaryExp));
        boolean lVarIsAddress = lVarInBinaryExpType instanceof CPointerType;
        if (lVarIsAddress == (rVarIsAddress = (rVarInBinaryExpType = CTypes.adjustFunctionOrArrayType(TypeUtils.getRealExpressionType(rVarInBinaryExp))) instanceof CPointerType)) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(this.getInitialSmgState()));
        }
        if (lVarIsAddress) {
            address = lVarInBinaryExp;
            pointerOffset = rVarInBinaryExp;
            addressType = (CPointerType)lVarInBinaryExpType;
        } else if (rVarIsAddress) {
            address = rVarInBinaryExp;
            pointerOffset = lVarInBinaryExp;
            addressType = (CPointerType)rVarInBinaryExpType;
        } else {
            throw new UnrecognizedCodeException("Expected either " + lVarInBinaryExp.toASTString() + " or " + rVarInBinaryExp.toASTString() + "to be a pointer.", binaryExp);
        }
        CType typeOfPointer = TypeUtils.getRealExpressionType(addressType.getType());
        return this.smgExpressionEvaluator.handlePointerArithmetic(this.getInitialSmgState(), this.getCfaEdge(), address, pointerOffset, typeOfPointer, lVarIsAddress, binaryExp);
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CArraySubscriptExpression exp) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(exp));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CFieldReference exp) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(exp));
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CCastExpression pCast) throws CPATransferException {
        return this.smgExpressionEvaluator.getAddressFromSymbolicValues((List<? extends SMGAbstractObjectAndState.SMGValueAndState>)super.visit(pCast));
    }
}

