/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelationKind;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.PointerVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGRightHandSideEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

class RHSPointerAddressVisitor
extends PointerVisitor {
    private final SMGRightHandSideEvaluator smgRightHandSideEvaluator;
    private final SMGTransferRelationKind kind;

    public RHSPointerAddressVisitor(SMGRightHandSideEvaluator pSmgRightHandSideEvaluator, CFAEdge pEdge, SMGState pSmgState, SMGTransferRelationKind pKind) {
        super(pSmgRightHandSideEvaluator, pEdge, pSmgState);
        this.smgRightHandSideEvaluator = pSmgRightHandSideEvaluator;
        this.kind = pKind;
    }

    @Override
    protected List<SMGAbstractObjectAndState.SMGAddressValueAndState> createAddressOfFunction(CIdExpression pIdFunctionExpression) throws SMGInconsistentException {
        CFunctionDeclaration functionDcl;
        SMGState state = this.getInitialSmgState();
        SMGObject functionObject = state.getObjectForFunction(functionDcl = (CFunctionDeclaration)pIdFunctionExpression.getDeclaration());
        if (functionObject == null) {
            functionObject = state.createObjectForFunction(functionDcl);
        }
        return this.smgRightHandSideEvaluator.createAddress(state, functionObject, SMGZeroValue.INSTANCE);
    }

    @Override
    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
        CExpression fileNameExpression = pIastFunctionCallExpression.getFunctionNameExpression();
        String functionName = fileNameExpression.toASTString();
        return this.smgRightHandSideEvaluator.builtins.handleFunctioncall(pIastFunctionCallExpression, functionName, this.getInitialSmgState(), this.getCfaEdge(), this.kind);
    }

    @Override
    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> visit(CStringLiteralExpression pStringLiteralExpression) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>();
        SMGState smgState = this.getInitialSmgState();
        String name = pStringLiteralExpression.getContentString() + " string literal";
        SMGRegion region = smgState.getHeap().getObjectForVisibleVariable(name);
        if (region != null) {
            result.addAll(this.smgRightHandSideEvaluator.createAddress(smgState, region, SMGZeroValue.INSTANCE));
            name = name + "ID" + SMGCPA.getNewValue();
        }
        smgState = this.getInitialSmgState();
        CArrayType cParamType = pStringLiteralExpression.transformTypeToArrayType();
        region = smgState.addGlobalVariable(this.smgExpressionEvaluator.machineModel.getSizeofInBits(cParamType).longValue(), name);
        long fieldOffset = 0L;
        for (CCharLiteralExpression cCharLiteralExpression : pStringLiteralExpression.expandStringLiteral(cParamType)) {
            SMGKnownExpValue explicitOfCharValue = SMGKnownExpValue.valueOf(cCharLiteralExpression.getCharacter());
            SMGKnownSymbolicValue symbolicOfCharValue = smgState.getSymbolicOfExplicit(explicitOfCharValue);
            if (symbolicOfCharValue == null) {
                symbolicOfCharValue = SMGKnownSymValue.of();
                smgState.putExplicit(symbolicOfCharValue, explicitOfCharValue);
            }
            this.smgRightHandSideEvaluator.assignFieldToState(smgState, this.getCfaEdge(), region, fieldOffset, symbolicOfCharValue, cParamType.getType());
            fieldOffset += (long)this.smgExpressionEvaluator.machineModel.getSizeofCharInBits();
        }
        result.addAll(this.smgRightHandSideEvaluator.createAddress(smgState, region, SMGZeroValue.INSTANCE));
        return result;
    }
}

