/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public abstract class SMGAbstractObjectAndState<T> {
    private final SMGState smgState;
    private final T object;

    private SMGAbstractObjectAndState(SMGState pState, T pValue) {
        this.smgState = pState;
        this.object = pValue;
    }

    public T getObject() {
        return this.object;
    }

    public SMGState getSmgState() {
        return this.smgState;
    }

    public String toString() {
        return this.object + " StateId: " + this.smgState.getId();
    }

    public static class SMGExplicitValueAndState
    extends SMGAbstractObjectAndState<SMGExplicitValue> {
        private SMGExplicitValueAndState(SMGState pState, SMGExplicitValue pValue) {
            super(pState, pValue);
        }

        public static SMGExplicitValueAndState of(SMGState pState, SMGExplicitValue pValue) {
            return new SMGExplicitValueAndState(pState, pValue);
        }
    }

    public static class SMGValueAndState
    extends SMGAbstractObjectAndState<SMGValue> {
        private SMGValueAndState(SMGState pState, SMGValue pValue) {
            super(pState, pValue);
        }

        public static SMGValueAndState withUnknownValue(SMGState pState) {
            return SMGValueAndState.of(pState, SMGUnknownValue.INSTANCE);
        }

        public static SMGValueAndState of(SMGState pState, SMGValue pValue) {
            return new SMGValueAndState(pState, pValue);
        }
    }

    public static class SMGAddressAndState
    extends SMGAbstractObjectAndState<SMGAddress> {
        private SMGAddressAndState(SMGState pState, SMGAddress pAddress) {
            super(pState, pAddress);
        }

        public static SMGAddressAndState withUnknownAddress(SMGState pState) {
            return SMGAddressAndState.of(pState, SMGAddress.UNKNOWN);
        }

        public static SMGAddressAndState of(SMGState pState, SMGAddress pAddress) {
            return new SMGAddressAndState(pState, pAddress);
        }
    }

    public static class SMGAddressValueAndState
    extends SMGValueAndState {
        private final SMGValue symbolicValue;

        private SMGAddressValueAndState(SMGState pState, SMGAddressValue pValue, SMGValue pSymbolicValue) {
            super(pState, pValue);
            this.symbolicValue = pSymbolicValue;
        }

        @Override
        public SMGAddressValue getObject() {
            return (SMGAddressValue)super.getObject();
        }

        public SMGValue getValue() {
            return this.symbolicValue;
        }

        public static SMGAddressValueAndState of(SMGState pState, SMGAddressValue pValue) {
            return new SMGAddressValueAndState(pState, pValue, pValue);
        }

        public static SMGAddressValueAndState of(SMGState pState) {
            return SMGAddressValueAndState.of(pState, SMGUnknownValue.INSTANCE);
        }

        public static SMGAddressValueAndState of(SMGState pState, SMGValue pValue) {
            return new SMGAddressValueAndState(pState, SMGUnknownValue.INSTANCE, pValue);
        }

        public static SMGAddressValueAndState of(SMGState pState, SMGEdgePointsTo pAddressValue) {
            return new SMGAddressValueAndState(pState, SMGKnownAddressValue.valueOf(pAddressValue), pAddressValue.getValue());
        }
    }
}

