/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ArrayVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.AssumeVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.CSizeOfVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ExplicitValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.LValueAssignmentVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.PointerVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.StructAndUnionVisitor;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGField;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class SMGExpressionEvaluator {
    final LogManagerWithoutDuplicates logger;
    final MachineModel machineModel;

    public SMGExpressionEvaluator(LogManagerWithoutDuplicates pLogger, MachineModel pMachineModel) {
        this.logger = pLogger;
        this.machineModel = pMachineModel;
    }

    public long getBitSizeof(CFAEdge pEdge, CType pType, SMGState pState, CExpression pExpression) throws UnrecognizedCodeException {
        return this.getBitSizeof(pEdge, pType, pState, Optional.of(pExpression));
    }

    public long getBitSizeof(CFAEdge pEdge, CType pType, SMGState pState) throws UnrecognizedCodeException {
        return this.getBitSizeof(pEdge, pType, pState, Optional.empty());
    }

    private long getBitSizeof(CFAEdge edge, CType pType, SMGState pState, Optional<CExpression> pExpression) throws UnrecognizedCodeException {
        if (pType instanceof CBitFieldType) {
            return ((CBitFieldType)pType).getBitFieldSize();
        }
        CSizeOfVisitor v = this.getSizeOfVisitor(edge, pState, pExpression);
        try {
            return pType.accept(v).multiply(BigInteger.valueOf(this.machineModel.getSizeofCharInBits())).longValueExact();
        }
        catch (IllegalArgumentException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCodeException("Could not resolve type.", edge);
        }
    }

    List<SMGAbstractObjectAndState.SMGAddressAndState> getAddressOfField(SMGState pSmgState, CFAEdge cfaEdge, CFieldReference fieldReference) throws CPATransferException {
        CExpression fieldOwner = fieldReference.getFieldOwner();
        CType ownerType = TypeUtils.getRealExpressionType(fieldOwner);
        ArrayList<SMGAbstractObjectAndState.SMGAddressAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressAndState>(4);
        for (SMGAbstractObjectAndState.SMGAddressValueAndState fieldOwnerAddressAndState : this.evaluateAddress(pSmgState, cfaEdge, fieldOwner)) {
            SMGAddressValue fieldOwnerAddress = fieldOwnerAddressAndState.getObject();
            SMGState newState = fieldOwnerAddressAndState.getSmgState();
            String fieldName = fieldReference.getFieldName();
            SMGField field = this.getField(ownerType, fieldName);
            if (field.isUnknown() || fieldOwnerAddress.isUnknown()) {
                if (fieldReference.isPointerDereference()) {
                    newState = this.handleUnknownDereference(newState, cfaEdge).getSmgState();
                }
                result.add(SMGAbstractObjectAndState.SMGAddressAndState.withUnknownAddress(newState));
                continue;
            }
            SMGAddress addressOfFieldOwner = fieldOwnerAddress.getAddress();
            SMGExplicitValue fieldOffset = addressOfFieldOwner.add(field.getOffset()).getOffset();
            SMGObject fieldObject = addressOfFieldOwner.getObject();
            SMGAddress address = SMGAddress.valueOf(fieldObject, fieldOffset);
            result.add(SMGAbstractObjectAndState.SMGAddressAndState.of(newState, address));
        }
        return result;
    }

    public SMGAbstractObjectAndState.SMGValueAndState readValue(SMGState pSmgState, SMGObject pObject, SMGExplicitValue pOffset, CType pType, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCodeException {
        boolean doesNotFitIntoObject;
        if (pOffset.isUnknown() || pObject == null) {
            return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(pSmgState);
        }
        long fieldOffset = pOffset.getAsLong();
        boolean bl = doesNotFitIntoObject = fieldOffset < 0L || fieldOffset + this.getBitSizeof(pEdge, pType, pSmgState) > pObject.getSize();
        if (doesNotFitIntoObject) {
            this.logger.log(Level.WARNING, new Object[]{pEdge.getFileLocation() + ":", "Field (" + fieldOffset + ", " + pType.toASTString("") + ") does not fit object " + pObject + "."});
            return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(pSmgState);
        }
        SMGValue value = (SMGValue)pSmgState.readValue(pObject, fieldOffset, this.machineModel.getSizeofInBits(pType).longValueExact()).getObject();
        return SMGAbstractObjectAndState.SMGValueAndState.of(pSmgState, value);
    }

    private SMGField getField(CType pOwnerType, String pFieldName) {
        if (pOwnerType instanceof CElaboratedType) {
            CComplexType realType = ((CElaboratedType)pOwnerType).getRealType();
            if (realType == null) {
                return SMGField.getUnknownInstance();
            }
            return this.getField(realType, pFieldName);
        }
        if (pOwnerType instanceof CCompositeType) {
            return this.getField((CCompositeType)pOwnerType, pFieldName);
        }
        if (pOwnerType instanceof CPointerType) {
            CType type = ((CPointerType)pOwnerType).getType();
            type = TypeUtils.getRealExpressionType(type);
            return this.getField(type, pFieldName);
        }
        throw new AssertionError();
    }

    private SMGField getField(CCompositeType pOwnerType, String pFieldName) {
        SMGExplicitValue smgValue;
        CType resultType = pOwnerType;
        BigInteger offset = this.machineModel.getFieldOffsetInBits(pOwnerType, pFieldName);
        for (CCompositeType.CCompositeTypeMemberDeclaration typeMember : pOwnerType.getMembers()) {
            if (!typeMember.getName().equals(pFieldName)) continue;
            resultType = typeMember.getType();
        }
        if (!resultType.equals(pOwnerType)) {
            smgValue = SMGKnownExpValue.valueOf(offset);
            resultType = TypeUtils.getRealExpressionType(resultType);
        } else {
            smgValue = SMGUnknownValue.INSTANCE;
        }
        return new SMGField(smgValue, resultType);
    }

    public static boolean isStructOrUnionType(CType rValueType) {
        if (rValueType instanceof CElaboratedType) {
            CElaboratedType type = (CElaboratedType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        if (rValueType instanceof CCompositeType) {
            CCompositeType type = (CCompositeType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        return false;
    }

    public SMGExplicitValue evaluateExplicitValueV2(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        List<SMGAbstractObjectAndState.SMGExplicitValueAndState> result = this.evaluateExplicitValue(smgState, cfaEdge, rValue);
        if (result.size() == 1) {
            return (SMGExplicitValue)result.get(0).getObject();
        }
        return SMGUnknownValue.INSTANCE;
    }

    public List<SMGAbstractObjectAndState.SMGExplicitValueAndState> evaluateExplicitValue(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGExplicitValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGExplicitValueAndState>();
        ExplicitValueVisitor visitor = new ExplicitValueVisitor(this, smgState, null, this.machineModel, this.logger, cfaEdge);
        Value value = rValue.accept(visitor);
        SMGState newState = visitor.getState();
        if (!value.isExplicitlyKnown() || !value.isNumericValue()) {
            for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : this.evaluateExpressionValue(newState, cfaEdge, rValue)) {
                result.add(this.deriveExplicitValueFromSymbolicValue(sMGValueAndState));
            }
        } else {
            BigInteger bigInteger = value.asNumericValue().bigInteger();
            result.add(SMGAbstractObjectAndState.SMGExplicitValueAndState.of(newState, SMGKnownExpValue.valueOf(bigInteger)));
        }
        for (SMGState sMGState : visitor.getSmgStatesToBeProccessed()) {
            result.addAll(this.evaluateExplicitValue(sMGState, cfaEdge, rValue));
        }
        return result;
    }

    private SMGAbstractObjectAndState.SMGExplicitValueAndState deriveExplicitValueFromSymbolicValue(SMGAbstractObjectAndState.SMGValueAndState symbolicValueAndState) {
        SMGValue symbolicValue = (SMGValue)symbolicValueAndState.getObject();
        SMGState newState = symbolicValueAndState.getSmgState();
        if (!symbolicValue.isUnknown()) {
            SMGAddressValue address;
            if (symbolicValue.isZero()) {
                return SMGAbstractObjectAndState.SMGExplicitValueAndState.of(newState, SMGZeroValue.INSTANCE);
            }
            if (symbolicValue instanceof SMGAddressValue && (address = (SMGAddressValue)symbolicValue).getObject() == SMGNullObject.INSTANCE) {
                return SMGAbstractObjectAndState.SMGExplicitValueAndState.of(newState, SMGKnownExpValue.valueOf(address.getOffset().getAsLong() / (long)this.machineModel.getSizeofCharInBits()));
            }
        }
        return SMGAbstractObjectAndState.SMGExplicitValueAndState.of(newState, SMGUnknownValue.INSTANCE);
    }

    public SMGValue evaluateExpressionValueV2(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        List<? extends SMGAbstractObjectAndState.SMGValueAndState> result = this.evaluateExpressionValue(smgState, cfaEdge, rValue);
        if (result.size() == 1) {
            return (SMGValue)result.get(0).getObject();
        }
        return SMGUnknownValue.INSTANCE;
    }

    public List<? extends SMGAbstractObjectAndState.SMGValueAndState> evaluateExpressionValue(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        CType expressionType = TypeUtils.getRealExpressionType(rValue);
        if (SMGExpressionEvaluator.isAddressType(expressionType)) {
            return this.evaluateAddress(smgState, cfaEdge, rValue);
        }
        return this.evaluateNonAddressValue(smgState, cfaEdge, rValue);
    }

    public static boolean isAddressType(CType pExpressionType) {
        CType type = TypeUtils.getRealExpressionType(pExpressionType);
        return type instanceof CPointerType || type instanceof CArrayType || SMGExpressionEvaluator.isStructOrUnionType(type) || type instanceof CFunctionType;
    }

    private List<? extends SMGAbstractObjectAndState.SMGValueAndState> evaluateNonAddressValue(SMGState newState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        return rValue.accept(this.getExpressionValueVisitor(cfaEdge, newState));
    }

    List<? extends SMGAbstractObjectAndState.SMGValueAndState> evaluateAssumptionValue(SMGState newState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
        return rValue.accept(this.getAssumeVisitor(cfaEdge, newState));
    }

    @Deprecated
    public SMGValue evaluateAssumptionValueV2(SMGState newState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
        List<? extends SMGAbstractObjectAndState.SMGValueAndState> result = this.evaluateAssumptionValue(newState, cfaEdge, rValue);
        if (result.size() == 1) {
            return (SMGValue)result.get(0).getObject();
        }
        return SMGUnknownValue.INSTANCE;
    }

    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> evaluateAddress(SMGState pState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        CType expressionType = TypeUtils.getRealExpressionType(rValue);
        if (expressionType instanceof CPointerType || expressionType instanceof CFunctionType && rValue instanceof CUnaryExpression && ((CUnaryExpression)rValue).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            PointerVisitor visitor = this.getPointerVisitor(cfaEdge, pState);
            return this.getAddressFromSymbolicValues(rValue.accept(visitor));
        }
        if (SMGExpressionEvaluator.isStructOrUnionType(expressionType)) {
            StructAndUnionVisitor visitor = this.getStructAndUnionVisitor(cfaEdge, pState);
            return this.createAddresses(rValue.accept(visitor));
        }
        if (expressionType instanceof CArrayType) {
            ArrayVisitor visitor = this.getArrayVisitor(cfaEdge, pState);
            return this.createAddresses(rValue.accept(visitor));
        }
        throw new AssertionError((Object)("The method evaluateAddress may not be calledwith the type " + expressionType.toASTString("")));
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> handlePointerArithmetic(SMGState initialSmgState, CFAEdge cfaEdge, CExpression address, CExpression pointerOffset, CType typeOfPointer, boolean lVarIsAddress, CBinaryExpression binaryExp) throws CPATransferException {
        CBinaryExpression.BinaryOperator binaryOperator = binaryExp.getOperator();
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: {
                ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)4);
                for (SMGAbstractObjectAndState.SMGAddressValueAndState addressValueAndState : this.evaluateAddress(initialSmgState, cfaEdge, address)) {
                    SMGAddressValue addressValue = addressValueAndState.getObject();
                    SMGState newState = addressValueAndState.getSmgState();
                    for (SMGAbstractObjectAndState.SMGExplicitValueAndState offsetValueAndState : this.evaluateExplicitValue(newState, cfaEdge, pointerOffset)) {
                        SMGExplicitValue newAddressOffset;
                        SMGExplicitValue offsetValue = (SMGExplicitValue)offsetValueAndState.getObject();
                        newState = offsetValueAndState.getSmgState();
                        if (addressValue.isUnknown() || offsetValue.isUnknown()) {
                            result.add((Object)SMGAbstractObjectAndState.SMGAddressValueAndState.of(newState));
                            continue;
                        }
                        SMGKnownExpValue typeSize = SMGKnownExpValue.valueOf(this.getBitSizeof(cfaEdge, typeOfPointer, newState, address));
                        SMGExplicitValue pointerOffsetValue = offsetValue.multiply(typeSize);
                        SMGObject target = addressValue.getObject();
                        SMGExplicitValue addressOffset = addressValue.getOffset();
                        switch (binaryOperator) {
                            case PLUS: {
                                newAddressOffset = addressOffset.add(pointerOffsetValue);
                                break;
                            }
                            case MINUS: {
                                if (lVarIsAddress) {
                                    newAddressOffset = addressOffset.subtract(pointerOffsetValue);
                                    break;
                                }
                                throw new UnrecognizedCodeException("Expected pointer arithmetic  with + or - but found " + binaryExp.toASTString(), binaryExp);
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        result.addAll(this.createAddress(newState, target, newAddressOffset));
                    }
                }
                return result.build();
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                throw new UnrecognizedCodeException("Misinterpreted the expression type of " + binaryExp + " as pointer type", cfaEdge, binaryExp);
            }
            case DIVIDE: 
            case MULTIPLY: 
            case MODULO: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new UnrecognizedCodeException("The operands of binary Expression " + binaryExp.toASTString() + " must have arithmetic types. " + address.toASTString() + " has a non arithmetic type", cfaEdge, binaryExp);
            }
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(initialSmgState));
    }

    List<SMGAbstractObjectAndState.SMGAddressAndState> evaluateArraySubscriptAddress(SMGState initialSmgState, CFAEdge cfaEdge, CArraySubscriptExpression exp) throws CPATransferException {
        ArrayList<SMGAbstractObjectAndState.SMGAddressAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressAndState>(2);
        for (SMGAbstractObjectAndState.SMGAddressValueAndState arrayAddressAndState : this.evaluateAddress(initialSmgState, cfaEdge, exp.getArrayExpression())) {
            SMGAddressValue arrayAddress = arrayAddressAndState.getObject();
            CExpression subscriptExpression = exp.getSubscriptExpression();
            for (SMGAbstractObjectAndState.SMGExplicitValueAndState subscriptValueAndState : this.evaluateExplicitValue(arrayAddressAndState.getSmgState(), cfaEdge, subscriptExpression)) {
                SMGExplicitValue subscriptValue = (SMGExplicitValue)subscriptValueAndState.getObject();
                SMGState newState = subscriptValueAndState.getSmgState();
                if (subscriptValue.isUnknown()) {
                    if (newState.isTrackErrorPredicatesEnabled() && !arrayAddress.isUnknown()) {
                        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : this.evaluateNonAddressValue(newState, cfaEdge, subscriptExpression)) {
                            SMGValue value = (SMGValue)sMGValueAndState.getObject();
                            newState = subscriptValueAndState.getSmgState();
                            if (value.isUnknown() || newState.getHeap().isObjectExternallyAllocated(arrayAddress.getObject())) continue;
                            long arrayBitSize = arrayAddress.getObject().getSize();
                            long typeBitSize = this.getBitSizeof(cfaEdge, exp.getExpressionType(), newState, exp);
                            long maxIndex = arrayBitSize / typeBitSize;
                            CType subscriptType = subscriptExpression.getExpressionType();
                            SMGType subscriptSMGType = SMGType.constructSMGType(subscriptType, newState, cfaEdge, this);
                            if (subscriptExpression instanceof CCastExpression) {
                                CCastExpression castExpression = (CCastExpression)subscriptExpression;
                                SMGType subscriptOriginSMGType = SMGType.constructSMGType(castExpression.getOperand().getExpressionType(), newState, cfaEdge, this);
                                subscriptSMGType = new SMGType(subscriptSMGType, subscriptOriginSMGType);
                            }
                            newState.addErrorPredicate(value, subscriptSMGType, SMGKnownExpValue.valueOf(maxIndex), cfaEdge);
                        }
                    } else {
                        if (newState.isCrashOnUnknownEnabled()) {
                            throw new CPATransferException("Unknown array index");
                        }
                        newState = this.handleUnknownDereference(newState, cfaEdge).getSmgState();
                    }
                    result.add(SMGAbstractObjectAndState.SMGAddressAndState.withUnknownAddress(newState));
                    continue;
                }
                SMGKnownExpValue typeSize = SMGKnownExpValue.valueOf(this.getBitSizeof(cfaEdge, exp.getExpressionType(), newState, exp));
                SMGExplicitValue sMGExplicitValue = subscriptValue.multiply(typeSize);
                SMGAbstractObjectAndState.SMGAddressAndState addressAndStateResult = SMGAbstractObjectAndState.SMGAddressAndState.of(newState, arrayAddress.getAddress().add(sMGExplicitValue));
                result.add(addressAndStateResult);
            }
        }
        return result;
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> createAddresses(List<SMGAbstractObjectAndState.SMGAddressAndState> pAddresses) throws SMGInconsistentException {
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> result = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>();
        for (SMGAbstractObjectAndState.SMGAddressAndState addressAndState : pAddresses) {
            SMGState state = addressAndState.getSmgState();
            SMGAddress address = (SMGAddress)addressAndState.getObject();
            result.addAll(state.getPointerFromAddress(address));
        }
        return result;
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> getAddressFromSymbolicValues(List<? extends SMGAbstractObjectAndState.SMGValueAndState> pAddressValueAndStateList) throws SMGInconsistentException {
        ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState> addressAndStateList = new ArrayList<SMGAbstractObjectAndState.SMGAddressValueAndState>();
        for (SMGAbstractObjectAndState.SMGValueAndState sMGValueAndState : pAddressValueAndStateList) {
            addressAndStateList.addAll(this.getAddressFromSymbolicValue(sMGValueAndState));
        }
        return addressAndStateList;
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> getAddressFromSymbolicValue(SMGAbstractObjectAndState.SMGValueAndState pAddressValueAndState) throws SMGInconsistentException {
        if (pAddressValueAndState instanceof SMGAbstractObjectAndState.SMGAddressValueAndState) {
            return Collections.singletonList((SMGAbstractObjectAndState.SMGAddressValueAndState)pAddressValueAndState);
        }
        SMGValue pAddressValue = (SMGValue)pAddressValueAndState.getObject();
        SMGState smgState = pAddressValueAndState.getSmgState();
        if (pAddressValue instanceof SMGAddressValue) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(smgState, (SMGAddressValue)pAddressValue));
        }
        if (pAddressValue.isUnknown()) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(smgState, pAddressValue));
        }
        SMGKnownExpValue explicit = smgState.getExplicit(pAddressValue);
        if (explicit != null && !explicit.isUnknown()) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(smgState, SMGKnownAddressValue.valueOf((SMGKnownSymbolicValue)pAddressValue, SMGNullObject.INSTANCE, explicit)));
        }
        if (!smgState.getHeap().isPointer(pAddressValue)) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(smgState, pAddressValue));
        }
        return smgState.getPointerFromValue(pAddressValue);
    }

    List<SMGAbstractObjectAndState.SMGAddressValueAndState> createAddress(SMGState pSmgState, SMGObject pTarget, SMGExplicitValue pOffset) throws SMGInconsistentException {
        return pSmgState.getPointerFromAddress(SMGAddress.valueOf(pTarget, pOffset));
    }

    SMGAbstractObjectAndState.SMGValueAndState handleUnknownDereference(SMGState smgState, CFAEdge edge) {
        return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(smgState);
    }

    private StructAndUnionVisitor getStructAndUnionVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new StructAndUnionVisitor(this, pCfaEdge, pNewState);
    }

    ArrayVisitor getArrayVisitor(CFAEdge pCfaEdge, SMGState pSmgState) {
        return new ArrayVisitor(this, pCfaEdge, pSmgState);
    }

    PointerVisitor getPointerVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new PointerVisitor(this, pCfaEdge, pNewState);
    }

    public AssumeVisitor getAssumeVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new AssumeVisitor(this, pCfaEdge, pNewState);
    }

    ExpressionValueVisitor getExpressionValueVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new ExpressionValueVisitor(this, pCfaEdge, pNewState);
    }

    LValueAssignmentVisitor getLValueAssignmentVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new LValueAssignmentVisitor(this, pCfaEdge, pNewState);
    }

    CSizeOfVisitor getSizeOfVisitor(CFAEdge pEdge, SMGState pState, Optional<CExpression> pExpression) {
        return new CSizeOfVisitor(this, pEdge, pState, pExpression);
    }
}

