/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.evaluator;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGBuiltins;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGExportDotOption;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelationKind;
import org.sosy_lab.cpachecker.cpa.smg.TypeUtils;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.AssigningValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.ForceExplicitValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.LValueAssignmentVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.PointerVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.RHSCSizeOfVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.RHSExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.RHSLValueAssignmentVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.RHSPointerAddressVisitor;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGAbstractObjectAndState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class SMGRightHandSideEvaluator
extends SMGExpressionEvaluator {
    private final SMGOptions options;
    private final SMGTransferRelationKind kind;
    public final SMGBuiltins builtins;

    public SMGRightHandSideEvaluator(LogManagerWithoutDuplicates pLogger, MachineModel pMachineModel, SMGOptions pOptions, SMGTransferRelationKind pKind, SMGExportDotOption exportSMGOptions) {
        super(pLogger, pMachineModel);
        this.options = pOptions;
        this.kind = pKind;
        this.builtins = new SMGBuiltins(this, this.options, exportSMGOptions, this.machineModel, (LogManager)this.logger);
    }

    public SMGAbstractObjectAndState.SMGExplicitValueAndState forceExplicitValue(SMGState smgState, CFAEdge pCfaEdge, CRightHandSide rVal) throws UnrecognizedCodeException {
        ForceExplicitValueVisitor v = new ForceExplicitValueVisitor(this, smgState, null, this.machineModel, this.logger, pCfaEdge, this.options);
        Value val = rVal.accept(v);
        if (val.isUnknown()) {
            return SMGAbstractObjectAndState.SMGExplicitValueAndState.of(v.getState(), SMGUnknownValue.INSTANCE);
        }
        return SMGAbstractObjectAndState.SMGExplicitValueAndState.of(v.getState(), SMGKnownExpValue.valueOf(val.asNumericValue().longValue()));
    }

    public SMGState deriveFurtherInformation(SMGState pNewState, boolean pTruthValue, CFAEdge pCfaEdge, CExpression rValue) throws CPATransferException {
        AssigningValueVisitor v = new AssigningValueVisitor(this, pNewState, pTruthValue, pCfaEdge);
        rValue.accept(v);
        return v.getAssignedState();
    }

    @Override
    public SMGAbstractObjectAndState.SMGValueAndState readValue(SMGState pSmgState, SMGObject pObject, SMGExplicitValue pOffset, CType pType, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCodeException {
        boolean doesNotFitIntoObject;
        if (pOffset.isUnknown() || pObject == null) {
            SMGState errState = pSmgState.withInvalidRead().withErrorDescription("Can't evaluate offset or object");
            return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(errState);
        }
        long fieldOffset = pOffset.getAsLong();
        long typeBitSize = this.getBitSizeof(pEdge, pType, pSmgState);
        long objectBitSize = pObject.getSize();
        boolean bl = doesNotFitIntoObject = fieldOffset < 0L || fieldOffset + typeBitSize > objectBitSize;
        if (doesNotFitIntoObject) {
            String description;
            SMGState errState = pSmgState.withInvalidRead();
            this.logger.log(Level.INFO, new Object[]{pEdge.getFileLocation(), ":", "Field ", "(", fieldOffset, ", ", pType.toASTString(""), ")", " does not fit object ", pObject, "."});
            if (!pObject.equals(SMGNullObject.INSTANCE)) {
                description = typeBitSize % 8L != 0L || fieldOffset % 8L != 0L || objectBitSize % 8L != 0L ? String.format("Field with %d  bit size can't be read from offset %s bit of object %d bit size", typeBitSize, fieldOffset, objectBitSize) : String.format("Field with %d  byte size can't be read from offset %s byte of object %d byte size", typeBitSize / 8L, fieldOffset / 8L, objectBitSize / 8L);
                errState.addInvalidObject(pObject);
            } else {
                description = "NULL pointer dereference on read";
            }
            errState = errState.withErrorDescription(description);
            return SMGAbstractObjectAndState.SMGValueAndState.withUnknownValue(errState);
        }
        return pSmgState.forceReadValue(pObject, fieldOffset, pType);
    }

    public SMGState writeValue(SMGState pState, SMGObject pMemoryOfField, long pFieldOffset, CType pRValueType, SMGValue pValue, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCodeException {
        SMGKnownSymbolicValue knownValue;
        boolean doesNotFitIntoObject;
        long memoryBitSize = pMemoryOfField.getSize();
        long rValueTypeBitSize = this.getBitSizeof(pEdge, pRValueType, pState);
        boolean bl = doesNotFitIntoObject = pFieldOffset < 0L || pFieldOffset + rValueTypeBitSize > memoryBitSize;
        if (doesNotFitIntoObject) {
            this.logger.log(Level.INFO, () -> String.format("%s: Field (%d, %s) does not fit object %s.", pEdge.getFileLocation(), pFieldOffset, pRValueType.toASTString(""), pMemoryOfField));
            SMGState newState = pState.withInvalidWrite();
            if (!pMemoryOfField.equals(SMGNullObject.INSTANCE)) {
                newState = newState.withErrorDescription(String.format("Field with size %d bit can't be written at offset %d bit of object %d bit size", rValueTypeBitSize, pFieldOffset, memoryBitSize));
                newState.addInvalidObject(pMemoryOfField);
            } else {
                newState = newState.withErrorDescription("NULL pointer dereference on write");
            }
            return newState;
        }
        if (pValue.isUnknown()) {
            return pState;
        }
        if (pRValueType instanceof CPointerType && !(pValue instanceof SMGAddressValue) && pValue instanceof SMGKnownSymbolicValue && pState.isExplicit(knownValue = (SMGKnownSymbolicValue)pValue)) {
            SMGKnownExpValue explicit = (SMGKnownExpValue)Preconditions.checkNotNull((Object)pState.getExplicit(knownValue));
            pValue = SMGKnownAddressValue.valueOf(knownValue, SMGNullObject.INSTANCE, explicit);
            pState.addPointsToEdge(SMGNullObject.INSTANCE, explicit.getAsLong(), pValue);
        }
        return pState.writeValue(pMemoryOfField, pFieldOffset, this.machineModel.getSizeofInBits(pRValueType).longValueExact(), pValue).getState();
    }

    public SMGState assignFieldToState(SMGState newState, CFAEdge cfaEdge, SMGObject memoryOfField, long fieldOffset, SMGValue value, CType rValueType) throws UnrecognizedCodeException, SMGInconsistentException {
        long sizeOfField = this.getBitSizeof(cfaEdge, rValueType, newState);
        if (memoryOfField.getSize() < sizeOfField) {
            this.logger.log(Level.INFO, () -> String.format("%s: Attempting to write %d bytes into a field with size %d bytes: %s", cfaEdge.getFileLocation(), sizeOfField, memoryOfField.getSize(), cfaEdge.getRawStatement()));
        }
        if (SMGRightHandSideEvaluator.isStructOrUnionType(rValueType)) {
            return this.assignStruct(newState, memoryOfField, fieldOffset, rValueType, value, cfaEdge);
        }
        return this.writeValue(newState, memoryOfField, fieldOffset, rValueType, value, cfaEdge);
    }

    private SMGState assignStruct(SMGState pNewState, SMGObject pMemoryOfField, long pFieldOffset, CType pRValueType, SMGValue pValue, CFAEdge pCfaEdge) throws SMGInconsistentException, UnrecognizedCodeException {
        if (pValue instanceof SMGKnownAddressValue) {
            SMGKnownAddressValue structAddress = (SMGKnownAddressValue)pValue;
            SMGObject source = structAddress.getObject();
            long structOffset = structAddress.getOffset().getAsLong();
            long structSize = structOffset + this.getBitSizeof(pCfaEdge, pRValueType, pNewState);
            return pNewState.copy(source, pMemoryOfField, structOffset, structSize, pFieldOffset);
        }
        return pNewState;
    }

    public List<SMGAbstractObjectAndState.SMGAddressValueAndState> handleSafeExternFunction(CFunctionCallExpression pFunctionCallExpression, SMGState pSmgState, CFAEdge pCfaEdge) throws CPATransferException {
        String calledFunctionName = pFunctionCallExpression.getFunctionNameExpression().toString();
        List<CExpression> parameters = pFunctionCallExpression.getParameterExpressions();
        for (int i = 0; i < parameters.size(); ++i) {
            CExpression param = parameters.get(i);
            CType paramType = TypeUtils.getRealExpressionType(param);
            if (!(paramType instanceof CPointerType) && !(paramType instanceof CArrayType)) continue;
            for (SMGAbstractObjectAndState.SMGAddressValueAndState addressOfFieldAndState : this.evaluateAddress(pSmgState, pCfaEdge, param)) {
                SMGAddress smgAddress = addressOfFieldAndState.getObject().getAddress();
                if (smgAddress.isUnknown()) continue;
                SMGObject object = smgAddress.getObject();
                SMGExplicitValue offset = smgAddress.getOffset();
                SMGState smgState = addressOfFieldAndState.getSmgState();
                if (object.equals(SMGNullObject.INSTANCE) || object.getSize() - offset.getAsLong() < (long)this.machineModel.getSizeofPtrInBits() || !smgState.getHeap().isObjectValid(object) && !smgState.getHeap().isObjectExternallyAllocated(object)) continue;
                SMGEdgePointsTo newParamValue = pSmgState.addExternalAllocation(calledFunctionName + "_Param_No_" + i + "_ID" + SMGCPA.getNewValue());
                pSmgState = this.assignFieldToState(pSmgState, pCfaEdge, object, offset.getAsLong(), newParamValue.getValue(), paramType);
            }
        }
        CType returnValueType = TypeUtils.getRealExpressionType(pFunctionCallExpression.getExpressionType());
        if (returnValueType instanceof CPointerType || returnValueType instanceof CArrayType) {
            return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(pSmgState, pSmgState.addExternalAllocation(calledFunctionName + SMGCPA.getNewValue())));
        }
        return Collections.singletonList(SMGAbstractObjectAndState.SMGAddressValueAndState.of(pSmgState));
    }

    @Override
    PointerVisitor getPointerVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new RHSPointerAddressVisitor(this, pCfaEdge, pNewState, this.kind);
    }

    @Override
    ExpressionValueVisitor getExpressionValueVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new RHSExpressionValueVisitor(this, this.builtins, pCfaEdge, pNewState, this.kind);
    }

    @Override
    public LValueAssignmentVisitor getLValueAssignmentVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new RHSLValueAssignmentVisitor(this, pCfaEdge, pNewState);
    }

    @Override
    RHSCSizeOfVisitor getSizeOfVisitor(CFAEdge pEdge, SMGState pState, Optional<CExpression> pExpression) {
        return new RHSCSizeOfVisitor(this, pEdge, pState, pExpression, this.kind);
    }

    @Override
    protected SMGAbstractObjectAndState.SMGValueAndState handleUnknownDereference(SMGState pSmgState, CFAEdge pEdge) {
        return super.handleUnknownDereference(pSmgState.withUnknownDereference(), pEdge);
    }
}

