/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.ImmutableLongArray;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGStateInformation;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdgeSet;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPath;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentStack;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class CLangSMG
extends SMG
implements UnmodifiableCLangSMG {
    private PersistentStack<CLangStackFrame> stack_objects = PersistentStack.of();
    private PersistentSet<SMGObject> heap_objects;
    private PersistentMap<String, SMGRegion> global_objects;
    private static LogManager logger = null;
    private static boolean perform_checks = false;

    public static void setPerformChecks(boolean pSetting, LogManager pLogger) {
        perform_checks = pSetting;
        logger = pLogger;
    }

    public static boolean performChecks() {
        return perform_checks;
    }

    public CLangSMG(MachineModel pMachineModel) {
        super(pMachineModel);
        this.global_objects = PathCopyingPersistentTreeMap.of();
        this.heap_objects = PersistentSet.of();
        this.heap_objects = this.heap_objects.addAndCopy(SMGNullObject.INSTANCE);
    }

    private CLangSMG(CLangSMG pHeap) {
        super(pHeap);
        this.stack_objects = pHeap.stack_objects;
        this.heap_objects = pHeap.heap_objects;
        this.global_objects = pHeap.global_objects;
    }

    @Override
    public CLangSMG copyOf() {
        return new CLangSMG(this);
    }

    public void addHeapObject(SMGObject pObject) {
        if (CLangSMG.performChecks() && this.heap_objects.contains(pObject)) {
            throw new IllegalArgumentException("Heap object already in the SMG: [" + pObject + "]");
        }
        this.heap_objects = this.heap_objects.addAndCopy(pObject);
        this.addObject(pObject);
    }

    public void addGlobalObject(SMGRegion pObject) {
        if (CLangSMG.performChecks() && this.global_objects.containsValue((Object)pObject)) {
            throw new IllegalArgumentException("Global object already in the SMG: [" + pObject + "]");
        }
        if (CLangSMG.performChecks() && this.global_objects.containsKey((Object)pObject.getLabel())) {
            throw new IllegalArgumentException("Global object with label [" + pObject.getLabel() + "] already in the SMG");
        }
        this.global_objects = this.global_objects.putAndCopy((Object)pObject.getLabel(), (Object)pObject);
        super.addObject(pObject);
    }

    public void addStackObject(SMGRegion pObject) {
        super.addObject(pObject);
        CLangStackFrame top = this.stack_objects.peek();
        Preconditions.checkArgument((!top.hasVariable(pObject.getLabel()) ? 1 : 0) != 0, (Object)"object with same label cannot be added twice");
        this.stack_objects = this.stack_objects.popAndCopy().pushAndCopy(top.addStackVariable(pObject.getLabel(), pObject));
    }

    public void addStackFrame(CFunctionDeclaration pFunctionDeclaration) {
        CLangStackFrame newFrame = new CLangStackFrame(pFunctionDeclaration, this.getMachineModel());
        SMGRegion returnObject = newFrame.getReturnObject();
        if (returnObject != null) {
            super.addObject(newFrame.getReturnObject());
        }
        this.stack_objects = this.stack_objects.pushAndCopy(newFrame);
    }

    public void dropStackFrame() {
        CLangStackFrame frame = this.stack_objects.peek();
        this.stack_objects = this.stack_objects.popAndCopy();
        for (SMGObject object : frame.getAllObjects()) {
            this.markObjectDeletedAndRemoveEdges(object);
        }
        if (CLangSMG.performChecks()) {
            CLangSMGConsistencyVerifier.verifyCLangSMG(logger, this);
        }
    }

    public Set<SMGObject> pruneUnreachable() {
        HashSet<SMGObject> seen = new HashSet<SMGObject>();
        HashSet<SMGValue> seen_values = new HashSet<SMGValue>();
        this.collectReachableObjectsAndValues(seen, seen_values);
        HashSet<SMGObject> stray_objects = new HashSet<SMGObject>((Collection<SMGObject>)Sets.difference(this.getObjects().asSet(), seen));
        this.markExternallyAllocatedObjects(stray_objects);
        Set<SMGObject> unreachableObjects = this.removeObjects(stray_objects);
        this.removeValues((Collection<SMGValue>)Sets.difference(this.getValues().asSet(), seen_values));
        if (CLangSMG.performChecks()) {
            CLangSMGConsistencyVerifier.verifyCLangSMG(logger, this);
        }
        return unreachableObjects;
    }

    private Set<SMGObject> removeObjects(Collection<SMGObject> objects) {
        LinkedHashSet<SMGObject> unreachableObjects = new LinkedHashSet<SMGObject>();
        for (SMGObject object : objects) {
            if (object == SMGNullObject.INSTANCE) continue;
            if (this.isObjectValid(object) && !this.isObjectExternallyAllocated(object)) {
                unreachableObjects.add(object);
            }
            this.markHeapObjectDeletedAndRemoveEdges(object);
            this.removeObject(object);
        }
        return unreachableObjects;
    }

    private void removeValues(Collection<SMGValue> values) {
        for (SMGValue value : values) {
            if (value.isZero()) continue;
            if (this.isPointer(value)) {
                this.removePointsToEdge(value);
            }
            this.removeValue(value);
        }
    }

    private void markExternallyAllocatedObjects(Collection<SMGObject> objects) {
        ArrayDeque<SMGObject> workqueue = new ArrayDeque<SMGObject>(objects);
        while (!workqueue.isEmpty()) {
            SMGObject processed = (SMGObject)workqueue.remove();
            if (!this.isObjectExternallyAllocated(processed)) continue;
            for (SMGEdgeHasValue outbound : this.getHVEdges(SMGEdgeHasValueFilter.objectFilter(processed))) {
                SMGObject pointedObject = this.getObjectPointedBy(outbound.getValue());
                if (!objects.contains(pointedObject) || this.isObjectExternallyAllocated(pointedObject)) continue;
                this.setExternallyAllocatedFlag(pointedObject, true);
                workqueue.add(pointedObject);
            }
        }
    }

    private void collectReachableObjectsAndValues(Set<SMGObject> seenObjects, Set<SMGValue> seenValues) {
        ArrayDeque<SMGObject> workqueue = new ArrayDeque<SMGObject>(this.getGlobalObjects().values());
        for (CLangStackFrame frame : this.getStackFrames()) {
            workqueue.addAll(frame.getAllObjects());
        }
        while (!workqueue.isEmpty()) {
            SMGObject obj = (SMGObject)workqueue.pop();
            if (!seenObjects.add(obj) || !this.isObjectValid(obj)) continue;
            for (SMGEdgeHasValue outbound : this.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj))) {
                SMGObject pointedObject = this.getObjectPointedBy(outbound.getValue());
                if (pointedObject != null) {
                    workqueue.add(pointedObject);
                }
                seenValues.add(outbound.getValue());
            }
        }
    }

    public String toString() {
        return "CLangSMG [\n  stack_objects=" + this.stack_objects + "\n  heap_objects=" + this.heap_objects + "\n  global_objects=" + this.global_objects + "\n  values=" + this.getValues() + "\n  pointsTo=" + this.getPTEdges() + "\n  hasValue=" + this.getHVEdges() + "\n  " + this.getMapOfMemoryLocationsWithValue() + "\n]";
    }

    private Map<MemoryLocation, SMGValue> getMapOfMemoryLocationsWithValue() {
        LinkedHashMap<MemoryLocation, SMGValue> result = new LinkedHashMap<MemoryLocation, SMGValue>();
        for (SMGEdgeHasValue hvedge : this.getHVEdges()) {
            MemoryLocation memloc = this.resolveMemLoc(hvedge);
            Iterable<SMGEdgeHasValue> edge = this.getHVEdgeFromMemoryLocation(memloc);
            if (!edge.iterator().hasNext()) continue;
            result.put(memloc, edge.iterator().next().getValue());
        }
        return result;
    }

    @Override
    public SMGRegion getObjectForVisibleVariable(String pVariableName) {
        if (this.stack_objects.size() != 0 && this.stack_objects.peek().containsVariable(pVariableName)) {
            return this.stack_objects.peek().getVariable(pVariableName);
        }
        if (this.global_objects.containsKey((Object)pVariableName)) {
            return (SMGRegion)this.global_objects.get((Object)pVariableName);
        }
        return null;
    }

    @Override
    public PersistentStack<CLangStackFrame> getStackFrames() {
        return this.stack_objects;
    }

    @Override
    public PersistentSet<SMGObject> getHeapObjects() {
        return this.heap_objects;
    }

    @Override
    public boolean isHeapObject(SMGObject object) {
        return this.getHeapObjects().contains(object);
    }

    @Override
    public PersistentMap<String, SMGRegion> getGlobalObjects() {
        return this.global_objects;
    }

    @Override
    public SMGObject getFunctionReturnObject() {
        return this.getStackFrames().peek().getReturnObject();
    }

    @Override
    public void replaceValue(SMGValue fresh, SMGValue old) {
        super.replaceValue(fresh, old);
        if (CLangSMG.performChecks()) {
            CLangSMGConsistencyVerifier.verifyCLangSMG(logger, this);
        }
    }

    public final void markHeapObjectDeletedAndRemoveEdges(SMGObject pObject) {
        this.heap_objects = this.heap_objects.removeAndCopy(pObject);
        this.markObjectDeletedAndRemoveEdges(pObject);
    }

    private Iterable<SMGEdgeHasValue> getHVEdgeFromMemoryLocation(MemoryLocation pLocation) {
        SMGObject objectAtLocation = this.getObjectFromMemoryLocation(pLocation);
        if (objectAtLocation == null) {
            return new SMGHasValueEdgeSet();
        }
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(objectAtLocation);
        if (pLocation.isReference()) {
            filter = filter.filterAtOffset(pLocation.getOffset()).filterWithoutSize();
        }
        return this.getHVEdges(filter);
    }

    private @Nullable SMGObject getObjectFromMemoryLocation(MemoryLocation pLocation) {
        String locId = pLocation.getIdentifier();
        if (pLocation.isOnFunctionStack()) {
            CLangStackFrame frame = (CLangStackFrame)Iterables.find(this.stack_objects, f -> f.getFunctionDeclaration().getName().equals(pLocation.getFunctionName()), null);
            if (frame == null) {
                return null;
            }
            if (locId.equals("___cpa_temp_result_var_")) {
                return frame.getReturnObject();
            }
            if (!frame.hasVariable(locId)) {
                return null;
            }
            return frame.getVariable(locId);
        }
        if (this.global_objects.containsKey((Object)locId)) {
            return (SMGObject)this.global_objects.get((Object)locId);
        }
        return (SMGObject)Iterables.tryFind(this.heap_objects, object -> object.getLabel().equals(locId)).orNull();
    }

    @Override
    public Optional<SMGEdgeHasValue> getHVEdgeFromMemoryLocation(SMGMemoryPath pLocation) {
        Optional<SMGObject> initialRegion = this.getInitialRegion(pLocation);
        if (!initialRegion.isPresent()) {
            return Optional.empty();
        }
        SMGObject object = initialRegion.orElseThrow();
        ImmutableLongArray offsets = pLocation.getPathOffset();
        for (int i = 0; i < offsets.length(); ++i) {
            long offset = offsets.get(i);
            Iterable<SMGEdgeHasValue> hves = this.getHVEdges(SMGEdgeHasValueFilter.objectFilter(object).filterAtOffset(offset));
            if (!hves.iterator().hasNext()) {
                return Optional.empty();
            }
            SMGEdgeHasValue hve = (SMGEdgeHasValue)Iterables.getOnlyElement(hves);
            if (i == offsets.length() - 1) {
                return Optional.of(hve);
            }
            SMGValue value = hve.getValue();
            if (!this.isPointer(value)) {
                return Optional.empty();
            }
            object = this.getPointer(value).getObject();
        }
        throw new AssertionError();
    }

    private Optional<SMGObject> getInitialRegion(SMGMemoryPath pLocation) {
        String initalVarName = pLocation.getVariableName();
        if (pLocation.startsWithGlobalVariable()) {
            return Optional.ofNullable((SMGObject)this.global_objects.get((Object)initalVarName));
        }
        String functionName = pLocation.getFunctionName();
        int locationOnStack = pLocation.getLocationOnStack();
        if (this.stack_objects.size() <= locationOnStack) {
            return Optional.empty();
        }
        CLangStackFrame frame = (CLangStackFrame)Iterables.get(this.stack_objects, (int)locationOnStack);
        if (!frame.getFunctionDeclaration().getName().equals(functionName)) {
            return Optional.empty();
        }
        return Optional.ofNullable(frame.getVariable(initalVarName));
    }

    private MemoryLocation resolveMemLoc(SMGEdgeHasValue hvEdge) {
        SMGObject object = hvEdge.getObject();
        long offset = hvEdge.getOffset();
        if (this.global_objects.containsValue((Object)object) || this.isHeapObject(object)) {
            return MemoryLocation.fromQualifiedName(object.getLabel(), offset);
        }
        String regionLabel = object.getLabel();
        CLangStackFrame frame = (CLangStackFrame)Iterables.find(this.stack_objects, f -> f.containsVariable(regionLabel) && f.getVariable(regionLabel) == object || object == f.getReturnObject());
        String functionName = frame.getFunctionDeclaration().getName();
        return MemoryLocation.forLocalVariable(functionName, object.getLabel(), offset);
    }

    public void clearValues() {
        this.clearValuesHvePte();
    }

    @Override
    public void clearObjects() {
        this.global_objects = PathCopyingPersistentTreeMap.of();
        this.heap_objects = PersistentSet.of();
        super.clearObjects();
        PersistentStack<CLangStackFrame> newStack = PersistentStack.of();
        for (CLangStackFrame frame : this.stack_objects) {
            newStack = newStack.pushAndCopy(new CLangStackFrame(frame.getFunctionDeclaration(), this.getMachineModel()));
            if (frame.getReturnObject() == null) continue;
            this.addObject(frame.getReturnObject());
        }
        this.stack_objects = newStack;
        this.heap_objects = this.heap_objects.addAndCopy(SMGNullObject.INSTANCE);
    }

    public void removeGlobalVariableAndEdges(String pVariable) {
        SMGObject obj = (SMGObject)this.global_objects.get((Object)pVariable);
        if (obj != null) {
            this.global_objects = this.global_objects.removeAndCopy((Object)pVariable);
            this.markObjectDeletedAndRemoveEdges(obj);
        }
    }

    public Optional<SMGEdgeHasValue> forget(SMGMemoryPath pLocation) {
        Optional<SMGEdgeHasValue> edgeToForget = this.getHVEdgeFromMemoryLocation(pLocation);
        if (!edgeToForget.isPresent()) {
            return Optional.empty();
        }
        this.removeHasValueEdge(edgeToForget.orElseThrow());
        return edgeToForget;
    }

    public SMGStateInformation forgetStackVariable(MemoryLocation pMemoryLocation) {
        if (pMemoryLocation.isOnFunctionStack()) {
            return this.forgetFunctionStackVariable(pMemoryLocation, true);
        }
        return this.forgetGlobalVariable(pMemoryLocation);
    }

    private SMGStateInformation forgetGlobalVariable(MemoryLocation pMemoryLocation) {
        String varName = pMemoryLocation.getIdentifier();
        if (!this.global_objects.containsKey((Object)varName)) {
            return SMGStateInformation.of();
        }
        SMGStateInformation info = this.createStateInfo((SMGObject)this.global_objects.get((Object)varName));
        this.removeGlobalVariableAndEdges(varName);
        return info;
    }

    private SMGStateInformation createStateInfo(SMGObject pObj) {
        SMGHasValueEdges hves = this.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj));
        Set<SMGEdgePointsTo> ptes = this.getPtEdges(SMGEdgePointsToFilter.targetObjectFilter(pObj));
        LinkedHashSet<SMGEdgePointsTo> resultPtes = new LinkedHashSet<SMGEdgePointsTo>(ptes);
        for (SMGEdgeHasValue edge : hves) {
            if (!this.isPointer(edge.getValue())) continue;
            resultPtes.add(this.getPointer(edge.getValue()));
        }
        return SMGStateInformation.of(hves, resultPtes, this.isObjectValid(pObj), this.isObjectExternallyAllocated(pObj));
    }

    public @Nullable SMGStateInformation forgetFunctionStackVariable(MemoryLocation pMemoryLocation, boolean createInfo) {
        CLangStackFrame frame = this.getFrame(pMemoryLocation);
        String variableName = pMemoryLocation.getIdentifier();
        if (frame == null || !frame.containsVariable(variableName)) {
            return SMGStateInformation.of();
        }
        SMGRegion reg = frame.getVariable(variableName);
        SMGStateInformation info = createInfo ? this.createStateInfo(reg) : null;
        this.stack_objects = this.stack_objects.replace((Predicate<CLangStackFrame>)((Predicate)f -> f == frame), frame.removeVariable(variableName));
        this.markObjectDeletedAndRemoveEdges(reg);
        return info;
    }

    private @Nullable CLangStackFrame getFrame(MemoryLocation pMemoryLocation) {
        for (CLangStackFrame frame : this.stack_objects) {
            if (!frame.getFunctionDeclaration().getName().equals(pMemoryLocation.getFunctionName())) continue;
            return frame;
        }
        return null;
    }

    public void remember(MemoryLocation pMemoryLocation, SMGRegion pRegion, SMGStateInformation pInfo) {
        this.rememberRegion(pMemoryLocation, pRegion, pInfo);
        this.rememberEdges(pInfo);
    }

    private void rememberEdges(SMGStateInformation pForgottenInformation) {
        SMGHasValueEdges forgottenHvEdges = pForgottenInformation.getHvEdges();
        SMGHasValueEdges toAddHvEdges = new SMGHasValueEdgeSet();
        for (SMGEdgeHasValue edge : forgottenHvEdges) {
            if (this.getHVEdges().contains(edge)) continue;
            toAddHvEdges = toAddHvEdges.addEdgeAndCopy(edge);
        }
        for (SMGEdgeHasValue edge : toAddHvEdges) {
            this.addHasValueEdge(edge);
        }
        for (SMGEdgePointsTo pte : pForgottenInformation.getPtEdges()) {
            if (this.isPointer(pte.getValue())) continue;
            this.addPointsToEdge(pte);
        }
    }

    private void rememberRegion(MemoryLocation pMemoryLocation, SMGRegion pRegion, SMGStateInformation pInfo) {
        if (pMemoryLocation.isOnFunctionStack()) {
            CLangStackFrame frame = this.getFrame(pMemoryLocation);
            if (frame != null) {
                this.stack_objects = this.stack_objects.replace((Predicate<CLangStackFrame>)((Predicate)f -> f == frame), frame.addStackVariable(pMemoryLocation.getIdentifier(), pRegion));
            }
        } else {
            this.global_objects = this.global_objects.putAndCopy((Object)pRegion.getLabel(), (Object)pRegion);
        }
        this.addObject(pRegion, pInfo.isValid(), pInfo.isExternal());
    }
}

