/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;

public class CLangSMGConsistencyVerifier {
    private CLangSMGConsistencyVerifier() {
    }

    private static boolean verifyCLangSMGProperty(boolean pResult, LogManager pLogger, String pMessage) {
        pLogger.log(Level.FINEST, new Object[]{pMessage, ":", pResult});
        return pResult;
    }

    private static boolean verifyDisjunctHeapAndGlobal(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        PersistentMap<String, SMGRegion> globals = pSmg.getGlobalObjects();
        Set<SMGObject> heap = pSmg.getHeapObjects().asSet();
        boolean toReturn = Collections.disjoint(globals.values(), heap);
        if (!toReturn) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent, heap and global objects are not disjoint"});
        }
        return toReturn;
    }

    private static boolean verifyDisjunctHeapAndStack(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        HashSet<SMGObject> stack = new HashSet<SMGObject>();
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            stack.addAll(frame.getAllObjects());
        }
        Set<SMGObject> heap = pSmg.getHeapObjects().asSet();
        boolean toReturn = Collections.disjoint(stack, heap);
        if (!toReturn) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent, heap and stack objects are not disjoint: " + Sets.intersection(stack, heap)});
        }
        return toReturn;
    }

    private static boolean verifyDisjunctGlobalAndStack(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        HashSet<SMGObject> stack = new HashSet<SMGObject>();
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            stack.addAll(frame.getAllObjects());
        }
        PersistentMap<String, SMGRegion> globals = pSmg.getGlobalObjects();
        boolean toReturn = Collections.disjoint(stack, globals.values());
        if (!toReturn) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent, global and stack objects are not disjoint"});
        }
        return toReturn;
    }

    private static boolean verifyStackGlobalHeapUnion(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        HashSet<SMGObject> object_union = new HashSet<SMGObject>();
        Iterables.addAll(object_union, pSmg.getHeapObjects());
        object_union.addAll(pSmg.getGlobalObjects().values());
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            object_union.addAll(frame.getAllObjects());
        }
        if (!object_union.containsAll(pSmg.getValidObjects())) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: union of stack, heap and global object contains less objects than the set of SMG objects. Missing object:", Sets.difference(pSmg.getValidObjects(), object_union)});
            return false;
        }
        if (!pSmg.getValidObjects().addAndCopy(SMGNullObject.INSTANCE).containsAll(pSmg.getGlobalObjects().values())) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: union of stack, heap and global object contains more objects than the set of SMG objects. Additional object:", Sets.difference(object_union, pSmg.getObjects().asSet())});
            return false;
        }
        return true;
    }

    private static boolean verifyNullObjectCLangProperties(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        for (SMGObject obj : pSmg.getGlobalObjects().values()) {
            if (obj != SMGNullObject.INSTANCE) continue;
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: null object in global object set [" + obj + "]"});
            return false;
        }
        SMGObject firstNull = null;
        for (SMGObject obj : pSmg.getHeapObjects()) {
            if (obj != SMGNullObject.INSTANCE) continue;
            if (firstNull != null) {
                pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: second null object in heap object set [first=" + firstNull + ", second=" + obj + "]"});
                return false;
            }
            firstNull = obj;
        }
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            for (SMGObject obj : frame.getAllObjects()) {
                if (obj != SMGNullObject.INSTANCE) continue;
                pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: null object in stack object set [" + obj + "]"});
                return false;
            }
        }
        if (firstNull == null) {
            pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: no null object"});
            return false;
        }
        return true;
    }

    private static boolean verifyGlobalNamespace(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        PersistentMap<String, SMGRegion> globals = pSmg.getGlobalObjects();
        for (String label : pSmg.getGlobalObjects().keySet()) {
            String globalLabel = ((SMGRegion)globals.get(label)).getLabel();
            if (globalLabel.equals(label)) continue;
            pLogger.logf(Level.SEVERE, "CLangSMG inconsistent: label [%s] points to an object with label [%s]", new Object[]{label, ((SMGRegion)pSmg.getGlobalObjects().get((Object)label)).getLabel()});
            return false;
        }
        return true;
    }

    private static boolean verifyStackNamespaces(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        HashSet<SMGObject> stack_objects = new HashSet<SMGObject>();
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            for (SMGObject object : frame.getAllObjects()) {
                if (stack_objects.contains(object)) {
                    pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: object [" + object + "] present multiple times in the stack"});
                    return false;
                }
                stack_objects.add(object);
            }
        }
        return true;
    }

    private static boolean verifyPointersSize(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        for (SMGEdgePointsTo ptEdge : pSmg.getPTEdges()) {
            if (ptEdge.getValue().isZero()) continue;
            SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.valueFilter(ptEdge.getValue());
            for (SMGEdgeHasValue hvEdge : pSmg.getHVEdges(filter)) {
                if (hvEdge.getSizeInBits() == (long)pSmg.getSizeofPtrInBits()) continue;
                pLogger.log(Level.SEVERE, new Object[]{"CLangSMG inconsistent: pointer [" + ptEdge + "] is stored with wrong size by hvEdge " + hvEdge});
                return false;
            }
        }
        return true;
    }

    public static boolean verifyCLangSMG(LogManager pLogger, UnmodifiableCLangSMG pSmg) {
        boolean toReturn = SMGConsistencyVerifier.verifySMG(pLogger, pSmg);
        pLogger.log(Level.FINEST, new Object[]{"Starting constistency check of a CLangSMG"});
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctHeapAndGlobal(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: heap and global object sets are disjunt");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctHeapAndStack(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: heap and stack objects are disjunct");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctGlobalAndStack(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: global and stack objects are disjunct");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyStackGlobalHeapUnion(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: global, stack and heap object union contains all objects in SMG");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyNullObjectCLangProperties(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: null object invariants hold");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyGlobalNamespace(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: global namespace problem");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyStackNamespaces(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: stack namespace");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyPointersSize(pLogger, pSmg), pLogger, "Checking CLangSMG consistency: pointer size");
        pLogger.log(Level.FINEST, new Object[]{"Ending consistency check of a CLangSMG"});
        return toReturn;
    }
}

