/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;

public class CLangSMGTest {
    private static final CFunctionType functionType = CFunctionType.functionTypeWithReturnType(CNumericTypes.UNSIGNED_LONG_INT);
    public static final CFunctionDeclaration DUMMY_FUNCTION = new CFunctionDeclaration(FileLocation.DUMMY, functionType, "foo", (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
    private CLangStackFrame sf;
    private static final LogManager logger = LogManager.createTestLogManager();
    private static final CIdExpression id_expression = new CIdExpression(FileLocation.DUMMY, null, "label", null);

    private static CLangSMG getNewCLangSMG64() {
        return new CLangSMG(MachineModel.LINUX64);
    }

    @Before
    public void setUp() {
        this.sf = new CLangStackFrame(DUMMY_FUNCTION, MachineModel.LINUX64);
        CLangSMG.setPerformChecks(true, logger);
    }

    @Test
    public void CLangSMGConstructorTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Truth.assertThat(smg.getStackFrames()).hasSize(0);
        Truth.assertThat(smg.getHeapObjects()).hasSize(1);
        Truth.assertThat(smg.getGlobalObjects()).hasSize(0);
        SMGRegion obj1 = new SMGRegion(64L, "obj1");
        SMGRegion obj2 = new SMGRegion(64L, "obj2");
        SMGKnownExpValue val1 = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue val2 = SMGKnownExpValue.valueOf(2);
        SMGEdgePointsTo pt = new SMGEdgePointsTo(val1, obj1, 0L);
        SMGEdgeHasValue hv = new SMGEdgeHasValue(smg.getMachineModel().getSizeofInBits(CNumericTypes.UNSIGNED_LONG_INT), 0L, (SMGObject)obj2, (SMGValue)val2);
        smg.addValue(val1);
        smg.addValue(val2);
        smg.addHeapObject(obj1);
        smg.addGlobalObject(obj2);
        smg.addPointsToEdge(pt);
        smg.addHasValueEdge(hv);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        CLangSMG smg_copy = smg.copyOf();
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg_copy)).isTrue();
        Truth.assertThat(smg_copy.getStackFrames()).hasSize(0);
        Truth.assertThat(smg_copy.getHeapObjects()).hasSize(2);
        Truth.assertThat(smg_copy.getGlobalObjects()).hasSize(1);
        Truth.assertThat((Comparable)smg_copy.getObjectPointedBy(val1)).isEqualTo((Object)obj1);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filter = SMGEdgeHasValueFilter.objectFilter(obj2);
        Truth.assertThat((Iterable)smg_copy.getHVEdges(filter)).containsExactly(new Object[]{hv});
    }

    @Test
    public void CLangSMGaddHeapObjectTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        SMGRegion obj2 = new SMGRegion(64L, "label");
        smg.addHeapObject(obj1);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        PersistentSet<SMGObject> heap_objs = smg.getHeapObjects();
        Truth.assertThat(heap_objs).contains((Object)obj1);
        Truth.assertThat(heap_objs).doesNotContain((Object)obj2);
        Truth.assertThat(heap_objs).hasSize(2);
        smg.addHeapObject(obj2);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        heap_objs = smg.getHeapObjects();
        Truth.assertThat(heap_objs).contains((Object)obj1);
        Truth.assertThat(heap_objs).contains((Object)obj2);
        Truth.assertThat(heap_objs).hasSize(3);
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddHeapObjectTwiceTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(64L, "label");
        smg.addHeapObject(obj);
        smg.addHeapObject(obj);
    }

    @Test
    public void CLangSMGaddHeapObjectTwiceWithoutChecksTest() {
        CLangSMG.setPerformChecks(false, logger);
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(64L, "label");
        smg.addHeapObject(obj);
        smg.addHeapObject(obj);
    }

    @Test
    public void CLangSMGaddGlobalObjectTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        SMGRegion obj2 = new SMGRegion(64L, "another_label");
        smg.addGlobalObject(obj1);
        PersistentMap<String, SMGRegion> global_objects = smg.getGlobalObjects();
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        Truth.assertThat(global_objects).hasSize(1);
        Truth.assertThat(global_objects.values()).contains((Object)obj1);
        smg.addGlobalObject(obj2);
        global_objects = smg.getGlobalObjects();
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        Truth.assertThat(global_objects).hasSize(2);
        Truth.assertThat(global_objects.values()).contains((Object)obj1);
        Truth.assertThat(global_objects.values()).contains((Object)obj2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddGlobalObjectTwiceTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(64L, "label");
        smg.addGlobalObject(obj);
        smg.addGlobalObject(obj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddGlobalObjectWithSameLabelTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        SMGRegion obj2 = new SMGRegion(128L, "label");
        smg.addGlobalObject(obj1);
        smg.addGlobalObject(obj2);
    }

    @Test
    public void CLangSMGaddStackObjectTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        SMGRegion diffobj1 = new SMGRegion(64L, "difflabel");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        CLangStackFrame current_frame = (CLangStackFrame)Iterables.get(smg.getStackFrames(), (int)0);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        Truth.assertThat((Comparable)current_frame.getVariable("label")).isEqualTo((Object)obj1);
        Truth.assertThat(current_frame.getVariables()).hasSize(1);
        smg.addStackObject(diffobj1);
        current_frame = (CLangStackFrame)Iterables.get(smg.getStackFrames(), (int)0);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        Truth.assertThat((Comparable)current_frame.getVariable("label")).isEqualTo((Object)obj1);
        Truth.assertThat((Comparable)current_frame.getVariable("difflabel")).isEqualTo((Object)diffobj1);
        Truth.assertThat(current_frame.getVariables()).hasSize(2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangSMGaddStackObjectTwiceTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        smg.addStackObject(obj1);
    }

    @Test
    public void CLangSMGgetObjectForVisibleVariableTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        SMGRegion obj2 = new SMGRegion(128L, "label");
        SMGRegion obj3 = new SMGRegion(256L, "label");
        Truth.assertThat((Comparable)smg.getObjectForVisibleVariable(id_expression.getName())).isNull();
        smg.addGlobalObject(obj3);
        Truth.assertThat((Comparable)smg.getObjectForVisibleVariable(id_expression.getName())).isEqualTo((Object)obj3);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        Truth.assertThat((Comparable)smg.getObjectForVisibleVariable(id_expression.getName())).isEqualTo((Object)obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj2);
        Truth.assertThat((Comparable)smg.getObjectForVisibleVariable(id_expression.getName())).isEqualTo((Object)obj2);
        Truth.assertThat((Comparable)smg.getObjectForVisibleVariable(id_expression.getName())).isNotEqualTo((Object)obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Truth.assertThat((Comparable)smg.getObjectForVisibleVariable(id_expression.getName())).isEqualTo((Object)obj3);
        Truth.assertThat((Comparable)smg.getObjectForVisibleVariable(id_expression.getName())).isNotEqualTo((Object)obj2);
    }

    @Test
    public void CLangSMGgetStackFramesTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Truth.assertThat(smg.getStackFrames()).hasSize(0);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(new SMGRegion(64L, "frame1_1"));
        smg.addStackObject(new SMGRegion(64L, "frame1_2"));
        smg.addStackObject(new SMGRegion(64L, "frame1_3"));
        Truth.assertThat(smg.getStackFrames()).hasSize(1);
        Truth.assertThat(((CLangStackFrame)Iterables.get(smg.getStackFrames(), (int)0)).getVariables()).hasSize(3);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(new SMGRegion(64L, "frame2_1"));
        smg.addStackObject(new SMGRegion(64L, "frame2_2"));
        Truth.assertThat(smg.getStackFrames()).hasSize(2);
        Truth.assertThat(((CLangStackFrame)Iterables.get(smg.getStackFrames(), (int)1)).getVariables()).hasSize(2);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(new SMGRegion(64L, "frame3_1"));
        Truth.assertThat(smg.getStackFrames()).hasSize(3);
        Truth.assertThat(((CLangStackFrame)Iterables.get(smg.getStackFrames(), (int)2)).getVariables()).hasSize(1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Truth.assertThat(smg.getStackFrames()).hasSize(4);
        Truth.assertThat(((CLangStackFrame)Iterables.get(smg.getStackFrames(), (int)3)).getVariables()).hasSize(0);
    }

    @Test
    public void CLangSMGgetHeapObjectsTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Truth.assertThat(smg.getHeapObjects()).hasSize(1);
        smg.addHeapObject(new SMGRegion(64L, "heap1"));
        Truth.assertThat(smg.getHeapObjects()).hasSize(2);
        smg.addHeapObject(new SMGRegion(64L, "heap2"));
        smg.addHeapObject(new SMGRegion(64L, "heap3"));
        Truth.assertThat(smg.getHeapObjects()).hasSize(4);
    }

    @Test
    public void CLangSMGgetGlobalObjectsTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Truth.assertThat(smg.getGlobalObjects()).hasSize(0);
        smg.addGlobalObject(new SMGRegion(64L, "heap1"));
        Truth.assertThat(smg.getGlobalObjects()).hasSize(1);
        smg.addGlobalObject(new SMGRegion(64L, "heap2"));
        smg.addGlobalObject(new SMGRegion(64L, "heap3"));
        Truth.assertThat(smg.getGlobalObjects()).hasSize(3);
    }

    @Test
    public void consistencyViolationDisjunctnessTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj = new SMGRegion(64L, "label");
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addHeapObject(obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addGlobalObject(obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isFalse();
        smg = CLangSMGTest.getNewCLangSMG64();
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addHeapObject(obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addStackObject(obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isFalse();
        smg = CLangSMGTest.getNewCLangSMG64();
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addGlobalObject(obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addStackObject(obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isFalse();
    }

    @Test
    public void consistencyViolationUnionTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        SMGRegion stack_obj = new SMGRegion(64L, "stack_variable");
        SMGRegion heap_obj = new SMGRegion(64L, "heap_object");
        SMGRegion global_obj = new SMGRegion(64L, "global_variable");
        SMGRegion dummy_obj = new SMGRegion(64L, "dummy_object");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addStackObject(stack_obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addGlobalObject(global_obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addHeapObject(heap_obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addObject(dummy_obj);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isFalse();
    }

    @Test
    public void consistencyViolationNullTest() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGObject null_object = smg.getHeapObjects().iterator().next();
        SMGKnownExpValue some_value = SMGKnownExpValue.valueOf(5);
        CType type = (CType)Mockito.mock(CType.class);
        Mockito.when((Object)type.getCanonicalType()).thenReturn((Object)type);
        SMGEdgeHasValue edge = new SMGEdgeHasValue(32L, 0L, null_object, (SMGValue)some_value);
        smg.addValue(some_value);
        smg.addHasValueEdge(edge);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isFalse();
    }

    @Test
    public void consistencyViolationStackNamespaceTest1() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isFalse();
    }

    @Test
    public void consistencyViolationStackNamespaceTest2() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        SMGRegion obj2 = new SMGRegion(128L, "label");
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj2);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
    }

    @Test
    public void consistencyViolationStackNamespaceTest3() {
        CLangSMG smg = CLangSMGTest.getNewCLangSMG64();
        SMGRegion obj1 = new SMGRegion(64L, "label");
        SMGRegion obj2 = new SMGRegion(128L, "label");
        smg.addGlobalObject(obj1);
        smg.addStackFrame(this.sf.getFunctionDeclaration());
        smg.addStackObject(obj2);
        Truth.assertThat((Boolean)CLangSMGConsistencyVerifier.verifyCLangSMG(logger, smg)).isTrue();
    }
}

