/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentMultimap;

final class NeqRelation {
    private final PersistentMultimap<SMGValue, SMGValue> smgValues;

    public NeqRelation() {
        this.smgValues = PersistentMultimap.of();
    }

    private NeqRelation(PersistentMultimap<SMGValue, SMGValue> pMap) {
        this.smgValues = pMap;
    }

    public Set<SMGValue> getNeqsForValue(SMGValue pV) {
        return this.smgValues.get(pV);
    }

    public NeqRelation addRelationAndCopy(SMGValue pOne, SMGValue pTwo) {
        Preconditions.checkNotNull((Object)pOne);
        Preconditions.checkNotNull((Object)pTwo);
        return new NeqRelation(this.smgValues.putAndCopy(pOne, pTwo).putAndCopy(pTwo, pOne));
    }

    public NeqRelation removeRelationAndCopy(SMGValue pOne, SMGValue pTwo) {
        return new NeqRelation(this.smgValues.removeAndCopy(pOne, pTwo).removeAndCopy(pTwo, pOne));
    }

    public boolean neq_exists(SMGValue pOne, SMGValue pTwo) {
        return this.smgValues.get(pOne).contains((Object)pTwo);
    }

    public NeqRelation removeValueAndCopy(SMGValue pOne) {
        PersistentMultimap<SMGValue, SMGValue> newSet = this.smgValues.removeAndCopy(pOne);
        for (SMGValue pTwo : this.smgValues.get(pOne)) {
            newSet = newSet.removeAndCopy(pTwo, pOne);
        }
        return new NeqRelation(newSet);
    }

    public NeqRelation replaceValueAndCopy(SMGValue fresh, SMGValue old) {
        NeqRelation result = this.removeValueAndCopy(old);
        for (SMGValue value : this.getNeqsForValue(old)) {
            result = result.addRelationAndCopy(fresh, value);
        }
        return result;
    }

    public String toString() {
        return "neq_rel=" + this.smgValues;
    }

    public int hashCode() {
        return this.smgValues.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NeqRelation other = (NeqRelation)obj;
        return other.smgValues != null && this.smgValues.equals(other.smgValues);
    }
}

