/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.graphs.NeqRelation;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdgeSet;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGPointsToEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGPointsToMap;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGPredicateRelation;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentMultimap;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;

public class SMG
implements UnmodifiableSMG {
    private PersistentSet<SMGObject> objects;
    private PersistentSet<SMGValue> values;
    private SMGHasValueEdges hv_edges;
    private SMGPointsToEdges pt_edges;
    private PersistentSet<SMGObject> validObjects;
    private PersistentSet<SMGObject> externalObjectAllocation;
    private NeqRelation neq = new NeqRelation();
    private PersistentMultimap<SMGObject, SMGObject> possibleEquals;
    private final SMGPredicateRelation pathPredicate = new SMGPredicateRelation();
    private SMGPredicateRelation errorPredicate = new SMGPredicateRelation();
    private final MachineModel machine_model;
    private static final SMGEdgePointsTo NULL_POINTER = new SMGEdgePointsTo(SMGZeroValue.INSTANCE, SMGNullObject.INSTANCE, 0L);

    @VisibleForTesting
    public SMG(MachineModel pMachineModel) {
        this.objects = PersistentSet.of();
        this.values = PersistentSet.of();
        this.hv_edges = new SMGHasValueEdgeSet();
        this.pt_edges = new SMGPointsToMap();
        this.validObjects = PersistentSet.of();
        this.externalObjectAllocation = PersistentSet.of();
        this.machine_model = pMachineModel;
        this.possibleEquals = PersistentMultimap.of();
        this.initializeNullObject();
        this.initializeNullAddress();
    }

    protected SMG(SMG pHeap) {
        this.machine_model = pHeap.machine_model;
        this.hv_edges = pHeap.hv_edges;
        this.pt_edges = pHeap.pt_edges;
        this.neq = pHeap.neq;
        this.pathPredicate.putAll(pHeap.pathPredicate);
        this.errorPredicate.putAll(pHeap.errorPredicate);
        this.validObjects = pHeap.validObjects;
        this.externalObjectAllocation = pHeap.externalObjectAllocation;
        this.objects = pHeap.objects;
        this.values = pHeap.values;
        this.possibleEquals = pHeap.possibleEquals;
    }

    @Override
    public SMG copyOf() {
        return new SMG(this);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.machine_model, this.hv_edges, this.neq, this.validObjects, this.objects, this.pt_edges, this.values});
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SMG other = (SMG)obj;
        return this.machine_model == other.machine_model && Objects.equals(this.hv_edges, other.hv_edges) && Objects.equals(this.neq, other.neq) && Objects.equals(this.validObjects, other.validObjects) && Objects.equals(this.objects, other.objects) && Objects.equals(this.pt_edges, other.pt_edges) && Objects.equals(this.values, other.values) && Objects.equals(this.externalObjectAllocation, other.externalObjectAllocation);
    }

    public final void addObject(SMGObject pObj) {
        Preconditions.checkArgument((SMGNullObject.INSTANCE != pObj ? 1 : 0) != 0, (Object)"NULL can not be added as valid object");
        this.addObject(pObj, true, false);
    }

    public final void removeValue(SMGValue pValue) {
        Preconditions.checkArgument((!pValue.isZero() ? 1 : 0) != 0, (Object)"Can not remove NULL from SMG");
        this.values = this.values.removeAndCopy(pValue);
        this.neq = this.neq.removeValueAndCopy(pValue);
        this.pathPredicate.removeValue(pValue);
        this.errorPredicate.removeValue(pValue);
        assert (!this.hv_edges.filter(SMGEdgeHasValueFilter.valueFilter(pValue)).iterator().hasNext());
    }

    @VisibleForTesting
    public final void removeObject(SMGObject pObj) {
        this.objects = this.objects.removeAndCopy(pObj);
        this.validObjects = this.validObjects.removeAndCopy(pObj);
        this.externalObjectAllocation = this.externalObjectAllocation.removeAndCopy(pObj);
        for (SMGObject object : this.possibleEquals.get(pObj)) {
            this.possibleEquals = this.possibleEquals.removeAndCopy(object, pObj);
        }
        this.possibleEquals = this.possibleEquals.removeAndCopy(pObj);
    }

    public final void markObjectDeletedAndRemoveEdges(SMGObject pObj) {
        Preconditions.checkArgument((pObj != SMGNullObject.INSTANCE ? 1 : 0) != 0, (Object)"Can not remove NULL from SMG");
        this.setValidity(pObj, false);
        this.hv_edges = this.hv_edges.removeAllEdgesOfObjectAndCopy(pObj);
    }

    public final void addObject(SMGObject pObj, boolean pValidity, boolean pExternal) {
        this.objects = this.objects.addAndCopy(pObj);
        this.setValidity(pObj, pValidity);
        this.setExternallyAllocatedFlag(pObj, pExternal);
    }

    public final void addValue(SMGValue pValue) {
        this.values = this.values.addAndCopy(pValue);
    }

    public final void addPointsToEdge(SMGEdgePointsTo pEdge) {
        Preconditions.checkArgument((boolean)this.values.contains(pEdge.getValue()), (Object)"adding an edge without source");
        this.pt_edges = this.pt_edges.addAndCopy(pEdge);
    }

    public final void addHasValueEdge(SMGEdgeHasValue pEdge) {
        Preconditions.checkArgument((boolean)this.values.contains(pEdge.getValue()), (Object)"adding edge without target");
        this.hv_edges = this.hv_edges.addEdgeAndCopy(pEdge);
    }

    public void addHasValueEdges(Iterable<SMGEdgeHasValue> pEdgesSet) {
        this.hv_edges = this.hv_edges.addEdgesForObject(pEdgesSet);
    }

    public final void removeHasValueEdge(SMGEdgeHasValue pEdge) {
        this.hv_edges = this.hv_edges.removeEdgeAndCopy(pEdge);
    }

    public final void removePointsToEdge(SMGValue pValue) {
        Preconditions.checkArgument((!pValue.isZero() ? 1 : 0) != 0, (Object)"Can not remove NULL from SMG");
        this.pt_edges = this.pt_edges.removeEdgeWithValueAndCopy(pValue);
    }

    public void setValidity(SMGObject pObject, boolean pValidity) {
        Preconditions.checkArgument((boolean)this.objects.contains(pObject), (String)"Object [%s] not in SMG", (Object)pObject);
        this.validObjects = pValidity ? this.validObjects.addAndCopy(pObject) : this.validObjects.removeAndCopy(pObject);
    }

    public void setExternallyAllocatedFlag(SMGObject pObject, boolean pExternal) {
        Preconditions.checkArgument((boolean)this.objects.contains(pObject), (String)"Object [%s] not in SMG", (Object)pObject);
        this.externalObjectAllocation = pExternal ? this.externalObjectAllocation.addAndCopy(pObject) : this.externalObjectAllocation.removeAndCopy(pObject);
    }

    public void addNeqRelation(SMGValue pV1, SMGValue pV2) {
        this.neq = this.neq.addRelationAndCopy(pV1, pV2);
    }

    @Override
    public SMGPredicateRelation getPathPredicateRelation() {
        return this.pathPredicate;
    }

    @Override
    public SMGPredicateRelation getErrorPredicateRelation() {
        return this.errorPredicate;
    }

    public void resetErrorRelation() {
        this.errorPredicate = new SMGPredicateRelation();
    }

    @Override
    public final PersistentSet<SMGValue> getValues() {
        return this.values;
    }

    @Override
    public final PersistentSet<SMGObject> getObjects() {
        return this.objects;
    }

    @Override
    public final PersistentSet<SMGObject> getValidObjects() {
        return this.validObjects;
    }

    @Override
    public final SMGHasValueEdges getHVEdges() {
        return this.hv_edges;
    }

    @Override
    public final Iterable<SMGEdgeHasValue> getHVEdges(SMGEdgeHasValueFilter pFilter) {
        return pFilter.filter(this.hv_edges);
    }

    @Override
    public final SMGHasValueEdges getHVEdges(SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject pFilter) {
        return pFilter.filter(this.hv_edges);
    }

    @Override
    public Set<SMGEdgePointsTo> getPtEdges(SMGEdgePointsToFilter pFilter) {
        return ImmutableSet.copyOf(pFilter.filter(this.pt_edges));
    }

    @Override
    public SMGPointsToEdges getPTEdges() {
        return this.pt_edges;
    }

    @Override
    public final @Nullable SMGObject getObjectPointedBy(SMGValue pValue) {
        Preconditions.checkArgument((boolean)this.values.contains(pValue), (String)"Value [%s] not in SMG", (Object)pValue);
        SMGEdgePointsTo ptEdge = this.pt_edges.getEdgeWithValue(pValue);
        if (ptEdge != null) {
            return ptEdge.getObject();
        }
        return null;
    }

    @Override
    public final boolean isObjectValid(SMGObject pObject) {
        return this.validObjects.contains(pObject);
    }

    @Override
    public final boolean isObjectExternallyAllocated(SMGObject pObject) {
        return this.externalObjectAllocation.contains(pObject);
    }

    @Override
    public final MachineModel getMachineModel() {
        return this.machine_model;
    }

    @Override
    public final int getSizeofPtrInBits() {
        return this.machine_model.getSizeofPtrInBits();
    }

    @Override
    public TreeMap<Long, Long> getNullEdgesMapOffsetToSizeForObject(SMGObject pObj) {
        SMGEdgeHasValueFilter nullValueFilter = SMGEdgeHasValueFilter.objectFilter(pObj).filterHavingValue(SMGZeroValue.INSTANCE).filterWithoutSize();
        TreeMap<Long, Long> offsetToSize = new TreeMap<Long, Long>();
        for (SMGEdgeHasValue edge : nullValueFilter.filter(this.hv_edges)) {
            long offset = edge.getOffset();
            long size = edge.getSizeInBits();
            offsetToSize.put(offset, size);
        }
        return offsetToSize;
    }

    @Override
    public boolean isPointer(SMGValue value) {
        return this.pt_edges.containsEdgeWithValue(value);
    }

    @Override
    public SMGEdgePointsTo getPointer(SMGValue value) {
        return this.pt_edges.getEdgeWithValue(value);
    }

    @Override
    public boolean isCoveredByNullifiedBlocks(SMGEdgeHasValue pEdge) {
        return this.isCoveredByNullifiedBlocks(pEdge.getObject(), pEdge.getOffset(), pEdge.getSizeInBits());
    }

    private boolean isCoveredByNullifiedBlocks(SMGObject pObject, long pOffset, long size) {
        long expectedMinClear = pOffset + size;
        TreeMap<Long, Long> nullEdgesOffsetToSize = this.getNullEdgesMapOffsetToSizeForObject(pObject);
        Map.Entry<Long, Long> floorEntry = nullEdgesOffsetToSize.floorEntry(pOffset);
        return floorEntry != null && floorEntry.getValue() + floorEntry.getKey() >= expectedMinClear;
    }

    public void replaceValue(SMGValue fresh, SMGValue old) {
        if (fresh == old) {
            return;
        }
        Preconditions.checkArgument((!old.isZero() ? 1 : 0) != 0, (String)"cannot replace ZERO (%s) with other value (%s)", (Object)old, (Object)fresh);
        this.addValue(fresh);
        this.neq = this.neq.replaceValueAndCopy(fresh, old);
        this.pathPredicate.replace(fresh, old);
        this.errorPredicate.replace(fresh, old);
        for (SMGEdgeHasValue old_hve : this.getHVEdges(SMGEdgeHasValueFilter.valueFilter(old))) {
            SMGEdgeHasValue newHvEdge = new SMGEdgeHasValue(old_hve.getSizeInBits(), old_hve.getOffset(), old_hve.getObject(), fresh);
            this.hv_edges = this.hv_edges.removeEdgeAndCopy(old_hve);
            this.hv_edges = this.hv_edges.addEdgeAndCopy(newHvEdge);
        }
        if (this.pt_edges.containsEdgeWithValue(old)) {
            SMGEdgePointsTo pt_edge = this.pt_edges.getEdgeWithValue(old);
            this.pt_edges = this.pt_edges.removeAndCopy(pt_edge);
            if (this.pt_edges.containsEdgeWithValue(fresh) && !fresh.isZero()) {
                assert (!this.getHVEdges(SMGEdgeHasValueFilter.valueFilter(fresh)).iterator().hasNext());
                this.pt_edges = this.pt_edges.removeEdgeWithValueAndCopy(fresh);
            }
            Preconditions.checkArgument((!this.pt_edges.containsEdgeWithValue(fresh) || fresh.equals(SMGZeroValue.INSTANCE) || old instanceof SMGKnownAddressValue && !this.isObjectValid(((SMGKnownAddressValue)old).getObject()) ? 1 : 0) != 0);
            this.pt_edges = this.pt_edges.addAndCopy(new SMGEdgePointsTo(fresh, pt_edge.getObject(), pt_edge.getOffset(), pt_edge.getTargetSpecifier()));
        }
        this.removeValue(old);
    }

    @Override
    public boolean haveNeqRelation(SMGValue pV1, SMGValue pV2) {
        return this.neq.neq_exists(pV1, pV2);
    }

    @Override
    public Set<SMGValue> getNeqsForValue(SMGValue pV) {
        return this.neq.getNeqsForValue(pV);
    }

    protected void clearValuesHvePte() {
        this.values = PersistentSet.of();
        this.hv_edges = new SMGHasValueEdgeSet();
        this.pt_edges = new SMGPointsToMap();
        this.neq = new NeqRelation();
        this.pathPredicate.clear();
        this.initializeNullAddress();
    }

    private void initializeNullAddress() {
        this.addValue(SMGZeroValue.INSTANCE);
        this.addPointsToEdge(NULL_POINTER);
    }

    public void clearObjects() {
        this.objects = PersistentSet.of();
        this.validObjects = PersistentSet.of();
        this.initializeNullObject();
    }

    private void initializeNullObject() {
        this.objects = this.objects.addAndCopy(SMGNullObject.INSTANCE);
    }

    public void addPossibleEqualObjects(SMGObject pObject1, SMGObject pObject2) {
        assert (!SMGNullObject.INSTANCE.equals(pObject1));
        assert (!SMGNullObject.INSTANCE.equals(pObject2));
        this.possibleEquals = this.possibleEquals.putAndCopy(pObject1, pObject2);
        this.possibleEquals = this.possibleEquals.putAndCopy(pObject2, pObject1);
    }

    public boolean arePossibleEquals(SMGObject pObject1, SMGObject pObject2) {
        return this.possibleEquals.containsEntry(pObject1, pObject2);
    }
}

