/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

final class SMGConsistencyVerifier {
    private SMGConsistencyVerifier() {
    }

    private static boolean verifySMGProperty(boolean pResult, LogManager pLogger, String pMessage) {
        pLogger.log(Level.FINEST, new Object[]{"Checking SMG consistency: ", pMessage, ":", pResult});
        return pResult;
    }

    private static boolean verifyNullObject(LogManager pLogger, UnmodifiableSMG pSmg) {
        SMGValue null_value = null;
        for (SMGValue value : pSmg.getValues()) {
            if (pSmg.getObjectPointedBy(value) != SMGNullObject.INSTANCE) continue;
            null_value = value;
            break;
        }
        if (null_value == null) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: no value pointing to null object"});
            return false;
        }
        if (pSmg.getObjectPointedBy(SMGZeroValue.INSTANCE) != SMGNullObject.INSTANCE) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null value not pointing to null object"});
            return false;
        }
        if (SMGZeroValue.INSTANCE != null_value) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null value in values set not returned by getNullValue()"});
            return false;
        }
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filter = SMGEdgeHasValueFilter.objectFilter(SMGNullObject.INSTANCE);
        if (!pSmg.getHVEdges(filter).isEmpty()) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null object has some value"});
            return false;
        }
        if (pSmg.isObjectValid(SMGNullObject.INSTANCE)) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null object is not invalid"});
            return false;
        }
        if (SMGNullObject.INSTANCE.getSize() != 0L) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null object does not have zero size"});
            return false;
        }
        return true;
    }

    private static boolean verifyInvalidRegionsHaveNoHVEdges(LogManager pLogger, UnmodifiableSMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filter;
            if (pSmg.isObjectValid(obj) || pSmg.isObjectExternallyAllocated(obj) || pSmg.getHVEdges(filter = SMGEdgeHasValueFilter.objectFilter(obj)).isEmpty()) continue;
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: invalid object has a HVEdge"});
            return false;
        }
        return true;
    }

    private static boolean checkSingleFieldConsistency(LogManager pLogger, SMGObject pObject, UnmodifiableSMG pSmg) {
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filter = SMGEdgeHasValueFilter.objectFilter(pObject);
        for (SMGEdgeHasValue hvEdge : pSmg.getHVEdges(filter)) {
            if (hvEdge.getOffset() + hvEdge.getSizeInBits() <= pObject.getSize()) continue;
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconistent: field exceedes boundary of the object"});
            pLogger.log(Level.SEVERE, new Object[]{"Object: ", pObject});
            pLogger.log(Level.SEVERE, new Object[]{"Field: ", hvEdge});
            return false;
        }
        return true;
    }

    private static boolean verifyFieldConsistency(LogManager pLogger, UnmodifiableSMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            if (SMGConsistencyVerifier.checkSingleFieldConsistency(pLogger, obj, pSmg)) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyEdgeConsistency(LogManager pLogger, UnmodifiableSMG pSmg, Iterable<? extends SMGEdge> pEdges) {
        ArrayDeque to_verify = Queues.newArrayDeque(pEdges);
        while (!to_verify.isEmpty()) {
            SMGEdge edge = (SMGEdge)to_verify.pop();
            if (!pSmg.getObjects().contains(edge.getObject())) {
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: Edge from a nonexistent object:", edge});
                return false;
            }
            if (!pSmg.getValues().contains(edge.getValue())) {
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: Edge to a nonexistent value:", edge});
                return false;
            }
            for (SMGEdge other_edge : to_verify) {
                if (edge.isConsistentWith(other_edge)) continue;
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: inconsistent edges"});
                pLogger.log(Level.SEVERE, new Object[]{"First edge:  ", edge});
                pLogger.log(Level.SEVERE, new Object[]{"Second edge: ", other_edge});
                return false;
            }
        }
        return true;
    }

    private static boolean verifyObjectConsistency(LogManager pLogger, UnmodifiableSMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            try {
                pSmg.isObjectValid(obj);
            }
            catch (IllegalArgumentException e) {
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: object does not have validity"});
                return false;
            }
            if (obj.getSize() >= 0L) continue;
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: object with size lower than 0"});
            return false;
        }
        return true;
    }

    public static boolean verifySMG(LogManager pLogger, UnmodifiableSMG pSmg) {
        boolean toReturn = true;
        pLogger.log(Level.FINEST, new Object[]{"Starting constistency check of a SMG"});
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyNullObject(pLogger, pSmg), pLogger, "null object invariants hold");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyInvalidRegionsHaveNoHVEdges(pLogger, pSmg), pLogger, "invalid regions have no outgoing edges");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyFieldConsistency(pLogger, pSmg), pLogger, "field consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyEdgeConsistency(pLogger, pSmg, pSmg.getHVEdges()), pLogger, "Has Value edge consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyEdgeConsistency(pLogger, pSmg, pSmg.getPTEdges()), pLogger, "Points To edge consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyObjectConsistency(pLogger, pSmg), pLogger, "Validity consistency");
        pLogger.log(Level.FINEST, new Object[]{"Ending consistency check of a SMG"});
        return toReturn;
    }
}

