/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGHasValueEdgeSet
implements SMGHasValueEdges {
    private final PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>> map;
    private final PersistentSortedMap<SMGObject, Integer> sizesMap;
    private int size = 0;

    public SMGHasValueEdgeSet() {
        this.map = PathCopyingPersistentTreeMap.of();
        this.sizesMap = PathCopyingPersistentTreeMap.of();
    }

    private SMGHasValueEdgeSet(PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>> pMap, PersistentSortedMap<SMGObject, Integer> pSizesMap, int pSize) {
        this.map = pMap;
        this.sizesMap = pSizesMap;
        this.size = pSize;
    }

    @Override
    public SMGHasValueEdgeSet removeAllEdgesOfObjectAndCopy(SMGObject obj) {
        PersistentSortedMap edgesForObject = (PersistentSortedMap)this.map.get((Object)obj);
        if (edgesForObject == null) {
            return this;
        }
        PersistentSortedMap newSizesMap = this.sizesMap.removeAndCopy((Object)obj);
        int pSize = this.size - (Integer)this.sizesMap.get((Object)obj);
        return new SMGHasValueEdgeSet((PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>>)this.map.removeAndCopy((Object)obj), (PersistentSortedMap<SMGObject, Integer>)newSizesMap, pSize);
    }

    @Override
    public SMGHasValueEdgeSet addEdgeAndCopy(SMGEdgeHasValue pEdge) {
        SMGHasValueEdgeSet result = this;
        Integer sizeForObject = (Integer)this.sizesMap.getOrDefault((Object)pEdge.getObject(), (Object)0);
        PersistentSortedMap sortedByOffsets = (PersistentSortedMap)this.map.getOrDefault((Object)pEdge.getObject(), (Object)PathCopyingPersistentTreeMap.of());
        Map.Entry ceilingEntry = sortedByOffsets.ceilingEntry((Object)pEdge.getOffset());
        long endOffset = pEdge.getSizeInBits() + pEdge.getOffset();
        assert (ceilingEntry == null || endOffset <= (Long)ceilingEntry.getKey());
        Map.Entry floorEntry = sortedByOffsets.lowerEntry((Object)endOffset);
        assert (floorEntry == null || pEdge.getOffset() >= ((SMGEdgeHasValue)floorEntry.getValue()).getSizeInBits() + ((SMGEdgeHasValue)floorEntry.getValue()).getOffset());
        if (pEdge.getValue().isZero()) {
            if (ceilingEntry != null && (Long)ceilingEntry.getKey() == endOffset && ((SMGEdgeHasValue)ceilingEntry.getValue()).getValue().isZero()) {
                pEdge = new SMGEdgeHasValue(pEdge.getSizeInBits() + ((SMGEdgeHasValue)ceilingEntry.getValue()).getSizeInBits(), pEdge.getOffset(), pEdge.getObject(), pEdge.getValue());
                result = result.removeEdgeAndCopy((SMGEdgeHasValue)ceilingEntry.getValue());
            }
            if (floorEntry != null && pEdge.getOffset() == ((SMGEdgeHasValue)floorEntry.getValue()).getSizeInBits() + ((SMGEdgeHasValue)floorEntry.getValue()).getOffset() && ((SMGEdgeHasValue)floorEntry.getValue()).getValue().isZero()) {
                pEdge = new SMGEdgeHasValue(pEdge.getSizeInBits() + ((SMGEdgeHasValue)floorEntry.getValue()).getSizeInBits(), (long)((Long)floorEntry.getKey()), pEdge.getObject(), pEdge.getValue());
                result = result.removeEdgeAndCopy((SMGEdgeHasValue)floorEntry.getValue());
            }
            sizeForObject = (Integer)result.sizesMap.getOrDefault((Object)pEdge.getObject(), (Object)0);
            sortedByOffsets = (PersistentSortedMap)result.map.getOrDefault((Object)pEdge.getObject(), (Object)PathCopyingPersistentTreeMap.of());
        }
        sortedByOffsets = sortedByOffsets.putAndCopy((Object)pEdge.getOffset(), (Object)pEdge);
        PersistentSortedMap newSizesMap = result.sizesMap.putAndCopy((Object)pEdge.getObject(), (Object)(sizeForObject + 1));
        return new SMGHasValueEdgeSet((PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>>)result.map.putAndCopy((Object)pEdge.getObject(), (Object)sortedByOffsets), (PersistentSortedMap<SMGObject, Integer>)newSizesMap, result.size + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SMGHasValueEdgeSet removeEdgeAndCopy(SMGEdgeHasValue pEdge) {
        PersistentSortedMap updated;
        int sizeForObject = (Integer)this.sizesMap.getOrDefault((Object)pEdge.getObject(), (Object)0);
        int pSize = this.size;
        if (sizeForObject == 0) {
            throw new AssertionError();
        }
        PersistentSortedMap sortedByOffsets = (PersistentSortedMap)this.map.get((Object)pEdge.getObject());
        if (pEdge.getValue().isZero()) {
            Map.Entry floorEntry = sortedByOffsets.floorEntry((Object)pEdge.getOffset());
            if (floorEntry == null) throw new AssertionError();
            SMGEdgeHasValue removingEdge = (SMGEdgeHasValue)floorEntry.getValue();
            if (removingEdge.getOffset() + removingEdge.getSizeInBits() <= pEdge.getOffset() && removingEdge.getOffset() != pEdge.getOffset()) {
                throw new AssertionError();
            }
            updated = sortedByOffsets.removeAndCopy((Object)removingEdge.getOffset());
            --pSize;
            --sizeForObject;
            if (removingEdge.getOffset() < pEdge.getOffset()) {
                updated = updated.putAndCopy((Object)removingEdge.getOffset(), (Object)new SMGEdgeHasValue(Math.toIntExact(pEdge.getOffset() - removingEdge.getOffset()), removingEdge.getOffset(), pEdge.getObject(), pEdge.getValue()));
                ++pSize;
                ++sizeForObject;
            }
            if (removingEdge.getOffset() + removingEdge.getSizeInBits() > pEdge.getOffset() + pEdge.getSizeInBits()) {
                updated = updated.putAndCopy((Object)(pEdge.getOffset() + pEdge.getSizeInBits()), (Object)new SMGEdgeHasValue((long)Math.toIntExact(removingEdge.getOffset() - pEdge.getOffset()) + removingEdge.getSizeInBits() - pEdge.getSizeInBits(), pEdge.getOffset() + pEdge.getSizeInBits(), pEdge.getObject(), pEdge.getValue()));
                ++pSize;
                ++sizeForObject;
            }
        } else {
            updated = sortedByOffsets.removeAndCopy((Object)pEdge.getOffset());
            --pSize;
            --sizeForObject;
        }
        if (updated == sortedByOffsets) {
            throw new AssertionError();
        }
        if (!updated.isEmpty()) return new SMGHasValueEdgeSet((PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>>)this.map.putAndCopy((Object)pEdge.getObject(), (Object)updated), (PersistentSortedMap<SMGObject, Integer>)this.sizesMap.putAndCopy((Object)pEdge.getObject(), (Object)sizeForObject), pSize);
        return new SMGHasValueEdgeSet((PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>>)this.map.removeAndCopy((Object)pEdge.getObject()), (PersistentSortedMap<SMGObject, Integer>)this.sizesMap.removeAndCopy((Object)pEdge.getObject()), pSize);
    }

    @Override
    public SMGHasValueEdgeSet getHvEdges() {
        return this;
    }

    @Override
    public Iterable<SMGEdgeHasValue> filter(SMGEdgeHasValueFilter pFilter) {
        SMGHasValueEdgeSet smgEdgeHasValues = this;
        return () -> new SMGHasValueEdgeSetIteratorWithFilter(smgEdgeHasValues, pFilter);
    }

    @Override
    public SMGHasValueEdgeSet getEdgesForObject(SMGObject pObject) {
        PersistentSortedMap edges = (PersistentSortedMap)this.map.get((Object)pObject);
        PersistentSortedMap newMap = PathCopyingPersistentTreeMap.of();
        PersistentSortedMap newSizesMap = PathCopyingPersistentTreeMap.of();
        int newSize = 0;
        if (edges != null && !edges.isEmpty()) {
            newSize = (Integer)this.sizesMap.get((Object)pObject);
            newSizesMap = newSizesMap.putAndCopy((Object)pObject, (Object)newSize);
            newMap = newMap.putAndCopy((Object)pObject, (Object)edges);
        }
        return new SMGHasValueEdgeSet((PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>>)newMap, (PersistentSortedMap<SMGObject, Integer>)newSizesMap, newSize);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(SMGEdgeHasValue pHv) {
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pHv.getObject()).filterAtOffset(pHv.getOffset()).filterHavingValue(pHv.getValue()).filterBySize(pHv.getSizeInBits());
        return this.filter(filter).iterator().hasNext();
    }

    @Override
    public SMGHasValueEdgeSet addEdgesForObject(Iterable<SMGEdgeHasValue> pEdgesSet) {
        Preconditions.checkArgument((boolean)(pEdgesSet instanceof SMGHasValueEdgeSet), (Object)"Can't use different SMGHasValueEdges implementations");
        SMGHasValueEdgeSet edgesSet = (SMGHasValueEdgeSet)pEdgesSet;
        NavigableSet entries = edgesSet.map.entrySet();
        assert (entries.size() == 1);
        Map.Entry entry = (Map.Entry)entries.first();
        assert (!this.map.containsKey(entry.getKey()));
        PersistentSortedMap newMap = this.map.putAndCopy((Object)((SMGObject)entry.getKey()), (Object)((PersistentSortedMap)entry.getValue()));
        PersistentSortedMap newSizesMap = this.sizesMap.putAndCopy((Object)((SMGObject)entry.getKey()), (Object)edgesSet.size);
        return new SMGHasValueEdgeSet((PersistentSortedMap<SMGObject, PersistentSortedMap<Long, SMGEdgeHasValue>>)newMap, (PersistentSortedMap<SMGObject, Integer>)newSizesMap, this.size + edgesSet.size);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object pObj) {
        if (pObj instanceof SMGHasValueEdgeSet) {
            SMGHasValueEdgeSet other = (SMGHasValueEdgeSet)pObj;
            return this.map.equals(other.map);
        }
        return false;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public AbstractIterator<SMGEdgeHasValue> iterator() {
        return new SMGHasValueEdgeSetIterator(this);
    }

    private static class SMGHasValueEdgeSetIterator
    extends AbstractIterator<SMGEdgeHasValue> {
        Iterator<PersistentSortedMap<Long, SMGEdgeHasValue>> firstLevelIterator;
        Iterator<SMGEdgeHasValue> secondLevelIterator = null;

        protected SMGHasValueEdgeSetIterator(SMGHasValueEdgeSet pSMGEdgeHasValues) {
            this.firstLevelIterator = pSMGEdgeHasValues.map.values().iterator();
            if (this.firstLevelIterator.hasNext()) {
                PersistentSortedMap<Long, SMGEdgeHasValue> next = this.firstLevelIterator.next();
                this.secondLevelIterator = next.values().iterator();
            }
        }

        protected SMGEdgeHasValue computeNext() {
            if (this.secondLevelIterator == null) {
                return (SMGEdgeHasValue)this.endOfData();
            }
            SMGEdgeHasValue result = this.secondLevelIterator.next();
            if (!this.secondLevelIterator.hasNext()) {
                this.secondLevelIterator = this.firstLevelIterator.hasNext() ? this.firstLevelIterator.next().values().iterator() : null;
            }
            return result;
        }
    }

    private static class SMGHasValueEdgeSetIteratorWithFilter
    extends AbstractIterator<SMGEdgeHasValue> {
        SMGEdgeHasValueFilter filter;
        Iterator<PersistentSortedMap<Long, SMGEdgeHasValue>> iteratorMain;
        Iterator<SMGEdgeHasValue> iteratorSecond;

        protected SMGHasValueEdgeSetIteratorWithFilter(SMGHasValueEdgeSet pSMGEdgeHasValues, SMGEdgeHasValueFilter pFilter) {
            SMGObject filterObject = pFilter.getObject();
            SMGEdgeHasValue filterOverlapsWith = pFilter.getOverlapsWith();
            SMGHasValueEdgeSet filtered = filterObject != null ? pSMGEdgeHasValues.getEdgesForObject(filterObject) : pSMGEdgeHasValues;
            if (filterOverlapsWith != null) {
                filtered = filtered.getEdgesForObject(filterOverlapsWith.getObject());
            }
            this.iteratorMain = filtered.map.values().iterator();
            this.iteratorSecond = null;
            this.filter = pFilter;
        }

        protected SMGEdgeHasValue computeNext() {
            while (this.iteratorMain.hasNext() || this.iteratorSecond != null) {
                if (this.iteratorSecond != null) {
                    while (this.iteratorSecond.hasNext()) {
                        SMGEdgeHasValue result = this.iteratorSecond.next();
                        if (!this.filter.holdsFor(result)) continue;
                        return result;
                    }
                    this.iteratorSecond = null;
                    continue;
                }
                this.iteratorSecond = this.computeSecondLevelIterator(this.iteratorMain.next(), this.filter);
            }
            return (SMGEdgeHasValue)this.endOfData();
        }

        private Iterator<SMGEdgeHasValue> computeSecondLevelIterator(PersistentSortedMap<Long, SMGEdgeHasValue> pMap, SMGEdgeHasValueFilter pFilter) {
            Long filterOffset = pFilter.getOffset();
            SMGValue filterValue = pFilter.getValue();
            long filterSize = pFilter.getSize();
            SMGEdgeHasValue filterOverlapsWith = pFilter.getOverlapsWith();
            ImmutableSet candidateSet = ImmutableSet.of();
            if (filterOffset == null && filterValue == null && filterSize == -1L && filterOverlapsWith == null) {
                return pMap.values().iterator();
            }
            if (filterOffset != null) {
                Map.Entry candidateEntry = pMap.floorEntry((Object)filterOffset);
                if (candidateEntry != null) {
                    SMGEdgeHasValue candidate = (SMGEdgeHasValue)candidateEntry.getValue();
                    if (candidate.getValue().isZero()) {
                        long newSize = candidate.getSizeInBits() - (filterOffset - candidate.getOffset());
                        if (filterSize >= 0L && newSize > filterSize) {
                            newSize = filterSize;
                        }
                        if (newSize > 0L || newSize == 0L && candidate.getSizeInBits() == 0L) {
                            candidate = new SMGEdgeHasValue(newSize, (long)filterOffset, candidate.getObject(), candidate.getValue());
                        }
                    }
                    if (pFilter.holdsFor(candidate)) {
                        candidateSet = ImmutableSet.of((Object)candidate);
                        return candidateSet.iterator();
                    }
                }
                return candidateSet.iterator();
            }
            if (filterOverlapsWith != null) {
                SMGEdgeHasValue edgeCandidate;
                long edgeCandidateOffset;
                long edgeCandidateEndOffset;
                long startOffset = filterOverlapsWith.getOffset();
                long endOffset = startOffset + filterOverlapsWith.getSizeInBits();
                Map.Entry floorEntryCandidate = pMap.floorEntry((Object)startOffset);
                if (floorEntryCandidate != null && (edgeCandidateEndOffset = (edgeCandidateOffset = (edgeCandidate = (SMGEdgeHasValue)floorEntryCandidate.getValue()).getOffset()) + edgeCandidate.getSizeInBits()) > startOffset) {
                    startOffset = edgeCandidateOffset;
                }
                return pMap.subMap((Object)startOffset, (Object)endOffset).values().iterator();
            }
            return pMap.values().iterator();
        }
    }
}

