/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import java.util.Iterator;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGPointsToEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGPointsToMap
implements SMGPointsToEdges {
    private final PersistentMap<SMGValue, SMGEdgePointsTo> map;

    public SMGPointsToMap() {
        this.map = PathCopyingPersistentTreeMap.of();
    }

    private SMGPointsToMap(PersistentMap<SMGValue, SMGEdgePointsTo> pMap) {
        this.map = pMap;
    }

    @Override
    public SMGPointsToMap addAndCopy(SMGEdgePointsTo pEdge) {
        return new SMGPointsToMap((PersistentMap<SMGValue, SMGEdgePointsTo>)this.map.putAndCopy((Object)pEdge.getValue(), (Object)pEdge));
    }

    @Override
    public SMGPointsToMap removeAndCopy(SMGEdgePointsTo pEdge) {
        return this.removeEdgeWithValueAndCopy(pEdge.getValue());
    }

    @Override
    public SMGPointsToMap removeAllEdgesOfObjectAndCopy(SMGObject pObj) {
        PersistentMap tmp = this.map;
        for (SMGEdgePointsTo edge : SMGEdgePointsToFilter.targetObjectFilter(pObj).filter(this)) {
            tmp = tmp.removeAndCopy((Object)edge.getValue());
        }
        return new SMGPointsToMap(tmp);
    }

    @Override
    public SMGPointsToMap removeEdgeWithValueAndCopy(SMGValue pValue) {
        return new SMGPointsToMap((PersistentMap<SMGValue, SMGEdgePointsTo>)this.map.removeAndCopy((Object)pValue));
    }

    @Override
    public boolean containsEdgeWithValue(SMGValue pValue) {
        return this.map.containsKey((Object)pValue);
    }

    @Override
    public SMGEdgePointsTo getEdgeWithValue(SMGValue pValue) {
        return (SMGEdgePointsTo)this.map.get((Object)pValue);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public boolean equals(Object o) {
        return o instanceof SMGPointsToMap && this.map.equals(((SMGPointsToMap)o).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.values().toString();
    }

    @Override
    public Iterator<SMGEdgePointsTo> iterator() {
        return this.map.values().iterator();
    }
}

