/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGType;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentMultimap;

public final class SMGPredicateRelation {
    private PersistentMultimap<SMGValuesPair, SymbolicRelation> smgValuesRelation = PersistentMultimap.of();
    private PersistentMultimap<SMGValue, SMGValue> smgValuesDependency = PersistentMultimap.of();
    private PersistentMultimap<SMGValue, ExplicitRelation> smgExplicitValueRelation = PersistentMultimap.of();

    public void putAll(SMGPredicateRelation pPred) {
        this.smgValuesRelation = pPred.smgValuesRelation;
        this.smgValuesDependency = pPred.smgValuesDependency;
        this.smgExplicitValueRelation = pPred.smgExplicitValueRelation;
    }

    public void addRelation(SMGValue pOne, SMGType pSMGTypeOne, SMGValue pTwo, SMGType pSMGTypeTwo, CBinaryExpression.BinaryOperator pOperator) {
        if (!pOne.isUnknown() && !pTwo.isUnknown()) {
            if (pOne instanceof SMGExplicitValue) {
                this.addExplicitRelation(pTwo, pSMGTypeTwo, (SMGExplicitValue)pOne, pOperator.getSwitchOperandsSidesLogicalOperator());
            } else if (pTwo instanceof SMGExplicitValue) {
                this.addExplicitRelation(pOne, pSMGTypeOne, (SMGExplicitValue)pTwo, pOperator);
            } else if (!pOne.isZero() && !pTwo.isZero()) {
                this.addSymbolicRelation(pOne, pSMGTypeOne, pTwo, pSMGTypeTwo, pOperator);
            } else if (pOne.isZero() && !pTwo.isZero()) {
                this.addExplicitRelation(pTwo, pSMGTypeTwo, SMGZeroValue.INSTANCE, pOperator.getSwitchOperandsSidesLogicalOperator());
            } else if (pTwo.isZero() && !pOne.isZero()) {
                this.addExplicitRelation(pOne, pSMGTypeOne, SMGZeroValue.INSTANCE, pOperator);
            }
        }
    }

    public void addSymbolicRelation(SMGValue pOne, SMGType pSMGTypeOne, SMGValue pTwo, SMGType pSMGTypeTwo, CBinaryExpression.BinaryOperator pOperator) {
        SymbolicRelation relation = new SymbolicRelation(pOne, pSMGTypeOne, pTwo, pSMGTypeTwo, pOperator);
        if (!this.smgValuesDependency.containsEntry(pOne, pTwo)) {
            this.smgValuesRelation = this.smgValuesRelation.putAndCopy(SMGValuesPair.of(pOne, pTwo), relation);
            this.smgValuesRelation = this.smgValuesRelation.putAndCopy(SMGValuesPair.of(pTwo, pOne), relation);
            this.smgValuesDependency = this.smgValuesDependency.putAndCopy(pOne, pTwo);
            this.smgValuesDependency = this.smgValuesDependency.putAndCopy(pTwo, pOne);
        } else if (!this.smgValuesRelation.containsEntry(SMGValuesPair.of(pOne, pTwo), relation)) {
            this.smgValuesRelation = this.smgValuesRelation.putAndCopy(SMGValuesPair.of(pOne, pTwo), relation);
            this.smgValuesRelation = this.smgValuesRelation.putAndCopy(SMGValuesPair.of(pTwo, pOne), relation);
        }
    }

    public void addExplicitRelation(SMGValue pSymbolicValue, SMGType pSymbolicSMGType, SMGExplicitValue pExplicitValue, CBinaryExpression.BinaryOperator pOp) {
        ExplicitRelation relation;
        if (!(pSymbolicValue.isZero() && pExplicitValue.isZero() || this.smgExplicitValueRelation.containsEntry(pSymbolicValue, relation = new ExplicitRelation(pSymbolicValue, pSymbolicSMGType, pExplicitValue, pOp)))) {
            this.smgExplicitValueRelation = this.smgExplicitValueRelation.putAndCopy(pSymbolicValue, relation);
        }
    }

    public void removeValue(SMGValue pValue) {
        for (SMGValue pOposit : this.smgValuesDependency.get(pValue)) {
            this.smgValuesDependency = this.smgValuesDependency.removeAndCopy(pOposit, pValue);
            this.smgValuesRelation = this.smgValuesRelation.removeAndCopy(SMGValuesPair.of(pOposit, pValue));
            this.smgValuesRelation = this.smgValuesRelation.removeAndCopy(SMGValuesPair.of(pValue, pOposit));
        }
        this.smgValuesDependency = this.smgValuesDependency.removeAndCopy(pValue);
        this.smgExplicitValueRelation = this.smgExplicitValueRelation.removeAndCopy(pValue);
    }

    public void replace(SMGValue fresh, SMGValue old) {
        for (SMGValue relatedValue : this.smgValuesDependency.get(old)) {
            this.smgValuesDependency = this.smgValuesDependency.removeAndCopy(relatedValue, old);
            ImmutableSet<SymbolicRelation> symbolicRelations = this.smgValuesRelation.get(SMGValuesPair.of(old, relatedValue));
            for (SymbolicRelation symbolicRelation : symbolicRelations) {
                SymbolicRelation newRelation = symbolicRelation.replace(fresh, old);
                this.addSymbolicRelation(newRelation.getFirstValue(), newRelation.getFirstValSMGType(), newRelation.getSecondValue(), newRelation.getSecondValSMGType(), newRelation.getOperator());
            }
            this.smgValuesRelation = this.smgValuesRelation.removeAndCopy(SMGValuesPair.of(old, relatedValue));
            this.smgValuesRelation = this.smgValuesRelation.removeAndCopy(SMGValuesPair.of(relatedValue, old));
        }
        for (ExplicitRelation explicitRelation : this.smgExplicitValueRelation.get(old)) {
            if (fresh.isZero()) continue;
            this.addExplicitRelation(fresh, explicitRelation.getSymbolicSMGType(), explicitRelation.explicitValue, explicitRelation.getOperator());
        }
        this.smgValuesDependency = this.smgValuesDependency.removeAndCopy(old);
        this.smgExplicitValueRelation = this.smgExplicitValueRelation.removeAndCopy(old);
    }

    public Set<SMGValue> closureDependencyFor(SMGPredicateRelation pRelation) {
        HashSet<SMGValue> toAdd = new HashSet<SMGValue>();
        for (Map.Entry<SMGValue, ImmutableSet<SMGValue>> entry : pRelation.smgValuesDependency.entries()) {
            SMGValue key = entry.getKey();
            ImmutableSet<SMGValue> values = entry.getValue();
            for (SMGValue value : values) {
                if (key.compareTo(value) <= 0) continue;
                toAdd.add(key);
                toAdd.add(value);
            }
        }
        HashSet<SMGValue> result = new HashSet<SMGValue>();
        while (!toAdd.isEmpty()) {
            result.addAll(toAdd);
            HashSet<SMGValue> tempAdd = new HashSet<SMGValue>();
            for (SMGValue symbolic : toAdd) {
                tempAdd.addAll((Collection<SMGValue>)this.smgValuesDependency.get(symbolic));
            }
            tempAdd.removeAll(result);
            toAdd = tempAdd;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.smgExplicitValueRelation.isEmpty() && this.smgValuesRelation.isEmpty();
    }

    public int hashCode() {
        return this.smgValuesRelation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SMGPredicateRelation other = (SMGPredicateRelation)obj;
        return other.smgValuesRelation != null && this.smgValuesRelation.equals(other.smgValuesRelation);
    }

    public String toString() {
        return "PredRelation{smgValuesRelation=" + this.smgValuesRelation + ", smgValuesDependency=" + this.smgValuesDependency + ", smgExplicitValueRelation=" + this.smgExplicitValueRelation + "}";
    }

    public Collection<ExplicitRelation> getExplicitRelations() {
        return this.smgExplicitValueRelation.values();
    }

    public Set<Map.Entry<SMGValuesPair, ImmutableSet<SymbolicRelation>>> getValuesRelations() {
        return this.smgValuesRelation.entries();
    }

    public boolean isLessOrEqual(SMGPredicateRelation pPathPredicateRelation) {
        if (this.smgValuesDependency.size() > pPathPredicateRelation.smgValuesDependency.size()) {
            return false;
        }
        if (this.smgExplicitValueRelation.size() > pPathPredicateRelation.smgExplicitValueRelation.size()) {
            return false;
        }
        if (this.smgValuesRelation.size() > pPathPredicateRelation.smgValuesDependency.size()) {
            return false;
        }
        if (!pPathPredicateRelation.smgValuesDependency.entries().containsAll(this.smgValuesDependency.entries())) {
            return false;
        }
        if (!pPathPredicateRelation.smgExplicitValueRelation.entries().containsAll(this.smgExplicitValueRelation.entries())) {
            return false;
        }
        return pPathPredicateRelation.smgValuesRelation.entries().containsAll(this.smgValuesRelation.entries());
    }

    public boolean hasRelation(SMGValue pSymbolicValue) {
        return this.smgValuesDependency.contains(pSymbolicValue);
    }

    public void clear() {
        this.smgExplicitValueRelation = PersistentMultimap.of();
        this.smgValuesDependency = PersistentMultimap.of();
        this.smgValuesRelation = PersistentMultimap.of();
    }

    public static class ExplicitRelation {
        private SMGValue symbolicValue;
        private SMGType symbolicSMGType;
        private SMGExplicitValue explicitValue;
        private CBinaryExpression.BinaryOperator operator;

        public ExplicitRelation(SMGValue pSymbolicValue, SMGType pSymbolicSMGType, SMGExplicitValue pExplicitValue, CBinaryExpression.BinaryOperator pOperator) {
            this.symbolicValue = pSymbolicValue;
            this.symbolicSMGType = pSymbolicSMGType;
            this.explicitValue = pExplicitValue;
            this.operator = pOperator;
        }

        public CBinaryExpression.BinaryOperator getOperator() {
            return this.operator;
        }

        public SMGExplicitValue getExplicitValue() {
            return this.explicitValue;
        }

        public SMGValue getSymbolicValue() {
            return this.symbolicValue;
        }

        public boolean equals(Object pO) {
            if (this == pO) {
                return true;
            }
            if (!(pO instanceof ExplicitRelation)) {
                return false;
            }
            ExplicitRelation relation = (ExplicitRelation)pO;
            return this.symbolicValue.equals(relation.symbolicValue) && this.explicitValue.equals(relation.explicitValue) && this.operator == relation.operator;
        }

        public int hashCode() {
            return Objects.hash(this.symbolicValue, this.explicitValue, this.operator);
        }

        public String toString() {
            return "{S_" + this.symbolicValue + " " + this.operator.getOperator() + " " + this.explicitValue + "}";
        }

        public SMGType getSymbolicSMGType() {
            return this.symbolicSMGType;
        }
    }

    public static class SymbolicRelation {
        private SMGValue valueOne;
        private SMGType firstValSMGType;
        private SMGValue valueTwo;
        private SMGType secondValSMGType;
        private CBinaryExpression.BinaryOperator operator;

        public SymbolicRelation(SMGValue pValueOne, SMGType pFirstValSMGType, SMGValue pValueTwo, SMGType pSecondValSMGType, CBinaryExpression.BinaryOperator pOperator) {
            this.valueOne = pValueOne;
            this.firstValSMGType = pFirstValSMGType;
            this.valueTwo = pValueTwo;
            this.secondValSMGType = pSecondValSMGType;
            this.operator = pOperator;
        }

        public CBinaryExpression.BinaryOperator getOperator() {
            return this.operator;
        }

        public SMGValue getFirstValue() {
            return this.valueOne;
        }

        public SMGValue getSecondValue() {
            return this.valueTwo;
        }

        public boolean equals(Object pO) {
            if (this == pO) {
                return true;
            }
            if (!(pO instanceof SymbolicRelation)) {
                return false;
            }
            SymbolicRelation relation = (SymbolicRelation)pO;
            return this.valueOne.equals(relation.valueOne) && this.valueTwo.equals(relation.valueTwo) && this.operator == relation.operator;
        }

        public int hashCode() {
            return Objects.hash(this.valueOne, this.valueTwo, this.operator);
        }

        public String toString() {
            return "{S_" + this.valueOne + " " + this.operator.getOperator() + " S_" + this.valueTwo + "}";
        }

        public SMGType getFirstValSMGType() {
            return this.firstValSMGType;
        }

        public SMGType getSecondValSMGType() {
            return this.secondValSMGType;
        }

        public SymbolicRelation replace(SMGValue pFresh, SMGValue pOld) {
            if (this.valueOne.equals(pOld)) {
                return new SymbolicRelation(pFresh, this.firstValSMGType, this.valueTwo, this.secondValSMGType, this.operator);
            }
            assert (this.valueTwo.equals(pOld));
            return new SymbolicRelation(this.valueOne, this.firstValSMGType, pFresh, this.secondValSMGType, this.operator);
        }
    }

    public static class SMGValuesPair
    implements Comparable<SMGValuesPair> {
        private final SMGValue first;
        private final SMGValue second;

        private SMGValuesPair(SMGValue pFirst, SMGValue pSecond) {
            this.first = pFirst;
            this.second = pSecond;
        }

        static SMGValuesPair of(SMGValue pFirst, SMGValue pSecond) {
            Preconditions.checkNotNull((Object)pFirst);
            Preconditions.checkNotNull((Object)pSecond);
            return new SMGValuesPair(pFirst, pSecond);
        }

        public SMGValue getFirst() {
            return this.first;
        }

        public SMGValue getSecond() {
            return this.second;
        }

        public boolean equals(Object pO) {
            if (this == pO) {
                return true;
            }
            if (!(pO instanceof SMGValuesPair)) {
                return false;
            }
            SMGValuesPair that = (SMGValuesPair)pO;
            return this.first.equals(that.first) && this.second.equals(that.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        @Override
        public int compareTo(SMGValuesPair pSMGValuesPair) {
            int cmp = this.first.compareTo(pSMGValuesPair.first);
            return cmp == 0 ? this.second.compareTo(pSMGValuesPair.second) : cmp;
        }
    }
}

