/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import com.google.common.truth.Truth;
import java.util.TreeMap;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.graphs.NeqRelation;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public class SMGTest {
    private LogManager logger = LogManager.createTestLogManager();
    private SMG smg;
    private static final int mockTypeSize = 32;
    SMGObject obj1 = new SMGRegion(64L, "object-1");
    SMGObject obj2 = new SMGRegion(64L, "object-2");
    SMGValue val1 = SMGKnownExpValue.valueOf(1);
    SMGValue val2 = SMGKnownExpValue.valueOf(2);
    SMGEdgePointsTo pt1to1 = new SMGEdgePointsTo(this.val1, this.obj1, 0L);
    SMGEdgeHasValue hv2has2at0 = new SMGEdgeHasValue(32L, 0L, this.obj2, this.val2);
    SMGEdgeHasValue hv2has1at4 = new SMGEdgeHasValue(32L, 32L, this.obj2, this.val1);

    private static SMG getNewSMG64() {
        return new SMG(MachineModel.LINUX64);
    }

    @Before
    public void setUp() {
        this.smg = SMGTest.getNewSMG64();
        this.smg.addObject(this.obj1);
        this.smg.addObject(this.obj2);
        this.smg.addValue(this.val1);
        this.smg.addValue(this.val2);
        this.smg.addPointsToEdge(this.pt1to1);
        this.smg.addHasValueEdge(this.hv2has2at0);
        this.smg.addHasValueEdge(this.hv2has1at4);
    }

    @Test
    public void getNullBytesForObjectTest() {
        SMG smg1 = SMGTest.getNewSMG64();
        smg1.addObject(this.obj1);
        SMGEdgeHasValue hv = new SMGEdgeHasValue(32L, 32L, this.obj1, (SMGValue)SMGZeroValue.INSTANCE);
        smg1.addHasValueEdge(hv);
        TreeMap<Long, Long> nullEdges = smg1.getNullEdgesMapOffsetToSizeForObject(this.obj1);
        Truth.assertThat(nullEdges).containsExactly((Object)32L, (Object)32L, new Object[0]);
    }

    @Test
    public void SMGConstructorTest() {
        SMG smg1 = SMGTest.getNewSMG64();
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        SMGNullObject nullObject = SMGNullObject.INSTANCE;
        SMGZeroValue nullAddress = SMGZeroValue.INSTANCE;
        Truth.assertThat((Comparable)nullObject).isNotNull();
        Truth.assertThat((Comparable)SMGNullObject.INSTANCE).isSameInstanceAs((Object)nullObject);
        Truth.assertThat(smg1.getObjects()).hasSize(1);
        Truth.assertThat(smg1.getObjects()).contains((Object)nullObject);
        Truth.assertThat(smg1.getValues()).hasSize(1);
        Truth.assertThat(smg1.getValues()).contains((Object)nullAddress);
        Truth.assertThat((Integer)smg1.getPTEdges().size()).isEqualTo((Object)1);
        SMGObject target_object = smg1.getObjectPointedBy(nullAddress);
        Truth.assertThat((Comparable)target_object).isEqualTo((Object)nullObject);
        Truth.assertThat((Iterable)smg1.getHVEdges()).hasSize(0);
        SMG smg_copy = new SMG(smg1);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy)).isTrue();
        SMGRegion third_object = new SMGRegion(128L, "object-3");
        SMGKnownExpValue third_value = SMGKnownExpValue.valueOf(3);
        smg_copy.addObject(third_object);
        smg_copy.addValue(third_value);
        smg_copy.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)third_object, (SMGValue)third_value));
        smg_copy.addPointsToEdge(new SMGEdgePointsTo(third_value, third_object, 0L));
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy)).isTrue();
        Truth.assertThat(smg1.getObjects()).hasSize(1);
        Truth.assertThat(smg_copy.getObjects()).hasSize(2);
        Truth.assertThat(smg_copy.getObjects()).contains((Object)third_object);
        Truth.assertThat(smg1.getValues()).hasSize(1);
        Truth.assertThat(smg_copy.getValues()).hasSize(2);
        Truth.assertThat(smg_copy.getValues()).contains((Object)third_value);
        Truth.assertThat((Integer)smg1.getPTEdges().size()).isEqualTo((Object)1);
        Truth.assertThat((Integer)smg_copy.getPTEdges().size()).isEqualTo((Object)2);
        SMGObject target_object_for_third = smg_copy.getObjectPointedBy(third_value);
        Truth.assertThat((Comparable)target_object_for_third).isEqualTo((Object)third_object);
        Truth.assertThat((Iterable)smg1.getHVEdges()).hasSize(0);
        Truth.assertThat((Iterable)smg_copy.getHVEdges()).hasSize(1);
    }

    @Test
    public void addRemoveHasValueEdgeTest() {
        SMG smg1 = SMGTest.getNewSMG64();
        SMGRegion object = new SMGRegion(32L, "object");
        SMGEdgeHasValue hv = new SMGEdgeHasValue(32L, 0L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE);
        smg1.addHasValueEdge(hv);
        Truth.assertThat((Iterable)smg1.getHVEdges()).contains((Object)hv);
        smg1.removeHasValueEdge(hv);
        Truth.assertThat((Iterable)smg1.getHVEdges()).doesNotContain((Object)hv);
    }

    @Test
    public void removeObjectTest() {
        SMG smg1 = SMGTest.getNewSMG64();
        SMGKnownSymbolicValue newValue = SMGKnownSymValue.of();
        SMGRegion object = new SMGRegion(64L, "object");
        SMGEdgeHasValue hv0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgePointsTo pt = new SMGEdgePointsTo(newValue, object, 0L);
        smg1.addValue(newValue);
        smg1.addObject(object);
        smg1.addPointsToEdge(pt);
        smg1.addHasValueEdge(hv0);
        smg1.addHasValueEdge(hv4);
        Truth.assertThat(smg1.getObjects()).contains((Object)object);
        smg1.removeObject(object);
        Truth.assertThat(smg1.getObjects()).doesNotContain((Object)object);
        Truth.assertThat((Boolean)smg1.getHVEdges().contains(hv0)).isTrue();
        Truth.assertThat((Boolean)smg1.getHVEdges().contains(hv4)).isTrue();
        Truth.assertThat((Iterable)smg1.getPTEdges()).contains((Object)pt);
    }

    @Test
    public void removeObjectAndEdgesTest() {
        SMG smg1 = SMGTest.getNewSMG64();
        SMGKnownSymbolicValue newValue = SMGKnownSymValue.of();
        SMGRegion object = new SMGRegion(64L, "object");
        SMGEdgeHasValue hv0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgePointsTo pt = new SMGEdgePointsTo(newValue, object, 0L);
        smg1.addValue(newValue);
        smg1.addObject(object);
        smg1.addPointsToEdge(pt);
        smg1.addHasValueEdge(hv0);
        smg1.addHasValueEdge(hv4);
        Truth.assertThat(smg1.getObjects()).contains((Object)object);
        smg1.markObjectDeletedAndRemoveEdges(object);
        Truth.assertThat((Boolean)smg1.isObjectValid(object)).isFalse();
        Truth.assertThat((Iterable)smg1.getHVEdges()).doesNotContain((Object)hv0);
        Truth.assertThat((Iterable)smg1.getHVEdges()).doesNotContain((Object)hv4);
        Truth.assertThat((Iterable)smg1.getPTEdges()).contains((Object)pt);
    }

    @Test
    public void validityTest() {
        Truth.assertThat((Boolean)this.smg.isObjectValid(SMGNullObject.INSTANCE)).isFalse();
        Truth.assertThat((Boolean)this.smg.isObjectValid(this.obj1)).isTrue();
        Truth.assertThat((Boolean)this.smg.isObjectValid(this.obj2)).isTrue();
        SMG smg_copy = this.smg.copyOf();
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy)).isTrue();
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg)).isTrue();
        this.smg.setValidity(this.obj1, false);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy)).isTrue();
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg)).isTrue();
        Truth.assertThat((Boolean)this.smg.isObjectValid(SMGNullObject.INSTANCE)).isFalse();
        Truth.assertThat((Boolean)this.smg.isObjectValid(this.obj1)).isFalse();
        Truth.assertThat((Boolean)this.smg.isObjectValid(this.obj2)).isTrue();
        Truth.assertThat((Boolean)smg_copy.isObjectValid(SMGNullObject.INSTANCE)).isFalse();
        Truth.assertThat((Boolean)smg_copy.isObjectValid(this.obj1)).isTrue();
        Truth.assertThat((Boolean)smg_copy.isObjectValid(this.obj2)).isTrue();
        this.smg.setValidity(this.obj2, false);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy)).isTrue();
        Truth.assertThat((Boolean)smg_copy.isObjectValid(SMGNullObject.INSTANCE)).isFalse();
        Truth.assertThat((Boolean)smg_copy.isObjectValid(this.obj1)).isTrue();
        Truth.assertThat((Boolean)smg_copy.isObjectValid(this.obj2)).isTrue();
    }

    @Test
    public void consistencyViolationValidNullTest() {
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg)).isTrue();
        this.smg.setValidity(SMGNullObject.INSTANCE, true);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg)).isFalse();
    }

    @Test
    public void consistencyViolationInvalidRegionHasValueTest() {
        this.smg.setValidity(this.obj1, false);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg)).isTrue();
        this.smg.setValidity(this.obj2, false);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg)).isFalse();
    }

    @Test
    public void consistencyViolationFieldConsistency() {
        SMG smg1 = SMGTest.getNewSMG64();
        SMG smg2 = SMGTest.getNewSMG64();
        SMGRegion object_2b = new SMGRegion(16L, "object_2b");
        SMGRegion object_4b = new SMGRegion(32L, "object_4b");
        SMGKnownExpValue random_value = SMGKnownExpValue.valueOf(6);
        smg1.addObject(object_2b);
        smg2.addObject(object_4b);
        smg1.addValue(random_value);
        smg2.addValue(random_value);
        SMGEdgeHasValue invalidHV1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object_2b, (SMGValue)random_value);
        SMGEdgeHasValue invalidHV2 = new SMGEdgeHasValue(32L, 64L, (SMGObject)object_4b, (SMGValue)random_value);
        smg1.addHasValueEdge(invalidHV1);
        smg2.addHasValueEdge(invalidHV2);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isFalse();
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg2)).isFalse();
    }

    @Test
    public void consistencyViolationHVConsistency() {
        SMG smg1 = SMGTest.getNewSMG64();
        SMGRegion object_8b = new SMGRegion(64L, "object_8b");
        SMGRegion object_16b = new SMGRegion(80L, "object_10b");
        SMGKnownExpValue first_value = SMGKnownExpValue.valueOf(6);
        SMGKnownExpValue second_value = SMGKnownExpValue.valueOf(8);
        SMGEdgeHasValue hv_edge1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object_8b, (SMGValue)first_value);
        SMGEdgeHasValue hv_edge2 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object_8b, (SMGValue)second_value);
        SMGEdgeHasValue hv_edge3 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object_8b, (SMGValue)second_value);
        SMGEdgeHasValue hv_edge4 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object_16b, (SMGValue)second_value);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        smg1.addValue(first_value);
        smg1.addObject(object_8b);
        smg1.addHasValueEdge(hv_edge1);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        smg1.addValue(second_value);
        smg1.addHasValueEdge(hv_edge3);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        smg1.addHasValueEdge(hv_edge4);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isFalse();
        smg1.addObject(object_16b);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        boolean thrown = false;
        try {
            smg1.addHasValueEdge(hv_edge2);
        }
        catch (AssertionError pAssertionError) {
            thrown = true;
        }
        Truth.assertThat((Boolean)thrown).isTrue();
    }

    @Test
    public void consistencyViolationPTConsistency() {
        SMG smg1 = SMGTest.getNewSMG64();
        SMGRegion object_8b = new SMGRegion(64L, "object_8b");
        SMGRegion object_16b = new SMGRegion(80L, "object_10b");
        SMGKnownExpValue first_value = SMGKnownExpValue.valueOf(6);
        SMGKnownExpValue second_value = SMGKnownExpValue.valueOf(8);
        SMGKnownExpValue third_value = SMGKnownExpValue.valueOf(10);
        SMGEdgePointsTo edge1 = new SMGEdgePointsTo(first_value, object_8b, 0L);
        SMGEdgePointsTo edge2 = new SMGEdgePointsTo(third_value, object_8b, 32L);
        SMGEdgePointsTo edge3 = new SMGEdgePointsTo(second_value, object_16b, 0L);
        SMGEdgePointsTo edge4 = new SMGEdgePointsTo(first_value, object_16b, 0L);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        smg1.addValue(first_value);
        smg1.addPointsToEdge(edge1);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isFalse();
        smg1.addObject(object_8b);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        smg1.addValue(third_value);
        smg1.addPointsToEdge(edge2);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        smg1.addValue(second_value);
        smg1.addObject(object_16b);
        smg1.addPointsToEdge(edge3);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isTrue();
        smg1.addPointsToEdge(edge4);
        Truth.assertThat((Boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1)).isFalse();
    }

    @Test
    public void isObjectValidBadCallTest() {
        Truth.assertThat((Boolean)this.smg.isObjectValid(new SMGRegion(192L, "wee"))).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setValidityBadCallTest() {
        this.smg.setValidity(new SMGRegion(192L, "wee"), true);
    }

    @Test
    public void getObjectsTest() {
        Truth.assertThat(this.smg.getObjects()).containsAtLeast((Object)this.obj1, (Object)this.obj2, new Object[]{SMGNullObject.INSTANCE});
    }

    @Test
    public void getNullObjectTest() {
        SMGNullObject nullObject = SMGNullObject.INSTANCE;
        Truth.assertThat((Boolean)this.smg.isObjectValid(nullObject)).isFalse();
        Truth.assertThat((Long)nullObject.getSize()).isEqualTo((Object)0);
    }

    @Test
    public void getValuesTest() {
        Truth.assertThat(this.smg.getValues()).containsAtLeast((Object)this.val1, (Object)this.val2, new Object[]{SMGZeroValue.INSTANCE});
    }

    @Test
    public void getHVEdgesTest() {
        Truth.assertThat((Iterable)this.smg.getHVEdges()).containsAtLeast((Object)this.hv2has2at0, (Object)this.hv2has1at4, new Object[0]);
    }

    @Test
    public void getPTEdgesTest() {
        Truth.assertThat((Iterable)this.smg.getPTEdges()).contains((Object)this.pt1to1);
    }

    @Test
    public void getObjectPointedByTest() {
        Truth.assertThat((Comparable)this.smg.getObjectPointedBy(this.val1)).isEqualTo((Object)this.obj1);
        Truth.assertThat((Comparable)this.smg.getObjectPointedBy(this.val2)).isNull();
    }

    @Test
    public void neqBasicTest() {
        NeqRelation nr = new NeqRelation();
        SMGKnownExpValue one = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue two = SMGKnownExpValue.valueOf(2);
        SMGKnownExpValue three = SMGKnownExpValue.valueOf(3);
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, one)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(three, one)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(three, two)).isFalse();
        nr = nr.addRelationAndCopy(one, three);
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, one)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(three, one)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(three, two)).isFalse();
        nr = nr.addRelationAndCopy(one, three);
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, one)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(three, one)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(three, two)).isFalse();
        nr = nr.addRelationAndCopy(two, three);
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(two, one)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(three, one)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(three, two)).isTrue();
        nr = nr.removeRelationAndCopy(one, three);
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(two, one)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(three, one)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(three, two)).isTrue();
    }

    @Test
    public void neqRemoveValueTest() {
        NeqRelation nr = new NeqRelation();
        SMGKnownExpValue one = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue two = SMGKnownExpValue.valueOf(2);
        SMGKnownExpValue three = SMGKnownExpValue.valueOf(3);
        nr = nr.addRelationAndCopy(one, two);
        nr = nr.addRelationAndCopy(one, three);
        nr = nr.removeValueAndCopy(one);
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isFalse();
    }

    @Test
    public void neqMergeValuesTest() {
        NeqRelation nr = new NeqRelation();
        SMGKnownExpValue one = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue two = SMGKnownExpValue.valueOf(2);
        SMGKnownExpValue three = SMGKnownExpValue.valueOf(3);
        nr = nr.addRelationAndCopy(one, three);
        nr = nr.replaceValueAndCopy(two, three);
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isFalse();
    }

    @Test
    public void neqMergeValuesTest2() {
        NeqRelation nr = new NeqRelation();
        SMGZeroValue zero = SMGZeroValue.INSTANCE;
        SMGKnownExpValue one = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue two = SMGKnownExpValue.valueOf(2);
        SMGKnownExpValue three = SMGKnownExpValue.valueOf(3);
        nr = nr.addRelationAndCopy(zero, three);
        nr = nr.addRelationAndCopy(one, three);
        nr = nr.replaceValueAndCopy(two, three);
        Truth.assertThat((Boolean)nr.neq_exists(zero, two)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(one, two)).isTrue();
        Truth.assertThat((Boolean)nr.neq_exists(zero, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(one, three)).isFalse();
        Truth.assertThat((Boolean)nr.neq_exists(two, three)).isFalse();
    }
}

