/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs;

import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.evaluator.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class SMGType {
    private final long castedSize;
    private final boolean castedSigned;
    private final long originSize;
    private final boolean originSigned;

    private SMGType(long pCastedSize, boolean pCastedSigned, long pOriginSize, boolean pOriginSigned) {
        this.castedSize = pCastedSize;
        this.castedSigned = pCastedSigned;
        this.originSize = pOriginSize;
        this.originSigned = pOriginSigned;
    }

    public SMGType(long pCastedSize, boolean pSigned) {
        this(pCastedSize, pSigned, pCastedSize, pSigned);
    }

    public SMGType(SMGType pCastedType, SMGType pOriginType) {
        this(pCastedType.getCastedSize(), pCastedType.isCastedSigned(), pOriginType.getOriginSize(), pOriginType.isCastedSigned());
    }

    public static SMGType constructSMGType(CType pType, SMGState pState, CFAEdge pEdge, SMGExpressionEvaluator smgExpressionEvaluator) throws UnrecognizedCodeException {
        boolean isSigned = false;
        if (pType instanceof CSimpleType) {
            isSigned = pState.getHeap().getMachineModel().isSigned((CSimpleType)pType);
        }
        long size = smgExpressionEvaluator.getBitSizeof(pEdge, pType, pState);
        return new SMGType(size, isSigned);
    }

    public long getCastedSize() {
        return this.castedSize;
    }

    public boolean isCastedSigned() {
        return this.castedSigned;
    }

    public long getOriginSize() {
        return this.originSize;
    }

    public boolean isOriginSigned() {
        return this.originSigned;
    }

    public String toString() {
        return String.format("CAST from '%ssigned %d bit' to '%ssigned %d bit'", this.originSigned ? "" : "un", this.originSize, this.castedSigned ? "" : "un", this.castedSize);
    }
}

