/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.edge;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public abstract class SMGEdge {
    protected final SMGValue value;
    protected final SMGObject object;
    private final long offset;

    SMGEdge(SMGValue pValue, SMGObject pObject, long pOffset) {
        this.value = (SMGValue)Preconditions.checkNotNull((Object)pValue);
        this.object = (SMGObject)Preconditions.checkNotNull((Object)pObject);
        this.offset = pOffset;
    }

    public SMGValue getValue() {
        return this.value;
    }

    public SMGObject getObject() {
        return this.object;
    }

    public long getOffset() {
        return this.offset;
    }

    public abstract boolean isConsistentWith(SMGEdge var1);

    public int hashCode() {
        return Objects.hash(this.object, this.value, this.offset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SMGEdge)) {
            return false;
        }
        SMGEdge other = (SMGEdge)obj;
        return this.value.equals(other.value) && this.offset == other.offset && Objects.equals(this.object, other.object);
    }
}

