/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.edge;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGEdgeHasValue
extends SMGEdge
implements Comparable<SMGEdgeHasValue> {
    private final BigInteger sizeInBits;

    public SMGEdgeHasValue(BigInteger pSizeInBits, long pOffset, SMGObject pObject, SMGValue pValue) {
        super(pValue, pObject, pOffset);
        this.sizeInBits = pSizeInBits;
    }

    public SMGEdgeHasValue(long pSizeInBits, long pOffset, SMGObject pObject, SMGValue pValue) {
        this(BigInteger.valueOf(pSizeInBits), pOffset, pObject, pValue);
    }

    public String toString() {
        return String.format("%s+%db[%sb]->%s", this.object.getLabel(), this.getOffset(), this.sizeInBits, this.value);
    }

    public long getSizeInBits() {
        return this.sizeInBits.longValueExact();
    }

    @Override
    public boolean isConsistentWith(SMGEdge other) {
        if (!(other instanceof SMGEdgeHasValue)) {
            return false;
        }
        if (this.object == other.object && this.getOffset() == other.getOffset() && this.sizeInBits.equals(((SMGEdgeHasValue)other).sizeInBits)) {
            return this.value.equals(other.value);
        }
        return true;
    }

    public boolean overlapsWith(SMGEdgeHasValue other) {
        Preconditions.checkArgument((this.object == other.object ? 1 : 0) != 0, (Object)"Call of overlapsWith() on Has-Value edges pair not originating from the same object");
        long otStart = other.getOffset();
        long otEnd = otStart + other.getSizeInBits();
        return this.overlapsWith(otStart, otEnd);
    }

    public boolean overlapsWith(long pOtStart, long pOtEnd) {
        long myStart = this.getOffset();
        long myEnd = myStart + this.getSizeInBits();
        if (myStart < pOtStart) {
            return myEnd > pOtStart;
        }
        if (pOtStart < myStart) {
            return pOtEnd > myStart;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.sizeInBits.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SMGEdgeHasValue)) {
            return false;
        }
        SMGEdgeHasValue other = (SMGEdgeHasValue)obj;
        return super.equals(obj) && this.sizeInBits.equals(other.sizeInBits);
    }

    @Override
    public int compareTo(SMGEdgeHasValue o) {
        int result = this.object.compareTo(o.object);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.getOffset(), o.getOffset());
        if (result != 0) {
            return result;
        }
        result = this.value.compareTo(o.value);
        if (result != 0) {
            return result;
        }
        return this.sizeInBits.compareTo(o.sizeInBits);
    }
}

