/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.edge;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGEdgeHasValueFilter {
    protected SMGObject object;
    private SMGValue value;
    private boolean valueComplement;
    private Long offset;
    private long sizeInBits;
    private boolean sizeNotRequired;
    private SMGEdgeHasValue overlapsWith;

    public SMGEdgeHasValueFilter() {
        this.object = null;
        this.value = null;
        this.valueComplement = false;
        this.offset = null;
        this.sizeInBits = -1L;
        this.sizeNotRequired = false;
        this.overlapsWith = null;
    }

    public SMGEdgeHasValueFilter(SMGEdgeHasValueFilter pFilter) {
        this.object = pFilter.object;
        this.value = pFilter.value;
        this.valueComplement = pFilter.valueComplement;
        this.offset = pFilter.offset;
        this.sizeInBits = pFilter.sizeInBits;
        this.sizeNotRequired = pFilter.sizeNotRequired;
        this.overlapsWith = pFilter.overlapsWith;
    }

    public static SMGEdgeHasValueFilterByObject objectFilter(SMGObject pObject) {
        return new SMGEdgeHasValueFilterByObject().filterByObject(pObject);
    }

    public SMGObject getObject() {
        return this.object;
    }

    public SMGValue getValue() {
        return this.value;
    }

    public Long getOffset() {
        return this.offset;
    }

    public long getSize() {
        return this.sizeInBits;
    }

    public boolean isSizeNotRequired() {
        return this.sizeNotRequired;
    }

    public SMGEdgeHasValue getOverlapsWith() {
        return this.overlapsWith;
    }

    @VisibleForTesting
    public SMGEdgeHasValueFilter filterByObject(SMGObject pObject) {
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter(this);
        filter.object = pObject;
        return filter;
    }

    public SMGEdgeHasValueFilter filterWithoutSize() {
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter(this);
        filter.sizeNotRequired = true;
        return filter;
    }

    public SMGEdgeHasValueFilter filterHavingValue(SMGValue pValue) {
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter(this);
        filter.value = pValue;
        filter.valueComplement = false;
        if (!pValue.isZero()) {
            filter.sizeNotRequired = true;
        }
        return filter;
    }

    public SMGEdgeHasValueFilter filterNotHavingValue(SMGValue pValue) {
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter(this);
        filter.value = pValue;
        filter.valueComplement = true;
        if (pValue.isZero()) {
            filter.sizeNotRequired = true;
        }
        return filter;
    }

    public SMGEdgeHasValueFilter filterAtOffset(long pOffset) {
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter(this);
        filter.offset = pOffset;
        return filter;
    }

    public SMGEdgeHasValueFilter filterBySize(long pSizeInBits) {
        Preconditions.checkArgument((pSizeInBits >= 0L ? 1 : 0) != 0, (Object)"negative sizes not allowed for filtering");
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter(this);
        filter.sizeInBits = pSizeInBits;
        return filter;
    }

    public SMGEdgeHasValueFilter overlapsWith(SMGEdgeHasValue pEdge) {
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter(this);
        filter.overlapsWith = pEdge;
        return filter;
    }

    public boolean holdsFor(SMGEdgeHasValue pEdge) {
        assert (this.sizeInBits >= 0L || this.sizeNotRequired || this.overlapsWith != null);
        if (this.object != null && this.object != pEdge.getObject()) {
            return false;
        }
        if (this.value != null) {
            if (this.valueComplement && pEdge.getValue().equals(this.value)) {
                return false;
            }
            if (!this.valueComplement && !pEdge.getValue().equals(this.value)) {
                return false;
            }
        }
        if (this.offset != null && this.offset.longValue() != pEdge.getOffset()) {
            return false;
        }
        if (this.overlapsWith != null) {
            if (!this.overlapsWith.getObject().equals(pEdge.getObject())) {
                return false;
            }
            if (this.overlapsWith.getOffset() > pEdge.getOffset() + pEdge.getSizeInBits()) {
                return false;
            }
            if (this.overlapsWith.getOffset() + this.overlapsWith.getSizeInBits() <= pEdge.getOffset()) {
                return false;
            }
        }
        if (this.sizeInBits >= 0L && this.sizeInBits != pEdge.getSizeInBits()) {
            return this.sizeInBits < pEdge.getSizeInBits() && pEdge.getValue().isZero();
        }
        return true;
    }

    public Iterable<SMGEdgeHasValue> filter(SMGHasValueEdges pEdges) {
        SMGHasValueEdges filtered = this.object != null ? pEdges.getEdgesForObject(this.object) : pEdges.getHvEdges();
        return filtered.filter(this);
    }

    public static SMGEdgeHasValueFilter valueFilter(SMGValue pValue) {
        return new SMGEdgeHasValueFilter().filterHavingValue(pValue);
    }

    public String toString() {
        return String.format("Filter %s<object=%s@%d, value=%s, size=%d>", this.valueComplement ? "NOT" : "", this.object, this.offset, this.value, this.sizeInBits);
    }

    public static class SMGEdgeHasValueFilterByObject
    extends SMGEdgeHasValueFilter {
        @Override
        @CanIgnoreReturnValue
        @VisibleForTesting
        public SMGEdgeHasValueFilterByObject filterByObject(SMGObject pObject) {
            this.object = pObject;
            return this;
        }

        public SMGHasValueEdges filter(SMGHasValueEdges pEdges) {
            SMGHasValueEdges filtered = this.object != null ? pEdges.getEdgesForObject(this.object) : pEdges.getHvEdges();
            return filtered;
        }
    }
}

