/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.edge;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdgeSet;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGEdgeHasValueTest {
    private static final int mockTypeSize = 32;
    private static final int mockTypeSize12b = 96;

    @Test
    public void testSMGEdgeHasValue() {
        SMGRegion obj = new SMGRegion(64L, "object");
        SMGKnownExpValue val = SMGKnownExpValue.valueOf(666);
        SMGEdgeHasValue hv = new SMGEdgeHasValue(32L, 32L, (SMGObject)obj, (SMGValue)val);
        Truth.assertThat((Comparable)hv.getObject()).isEqualTo((Object)obj);
        Truth.assertThat((Long)hv.getOffset()).isEqualTo((Object)32);
        Truth.assertThat((Long)hv.getSizeInBits()).isEqualTo((Object)32);
        Truth.assertThat((Long)hv.getSizeInBits()).isEqualTo((Object)32);
    }

    @Test
    public void testIsConsistentWith() {
        SMGRegion obj1 = new SMGRegion(64L, "object");
        SMGRegion obj2 = new SMGRegion(64L, "different object");
        SMGKnownExpValue val1 = SMGKnownExpValue.valueOf(666);
        SMGKnownExpValue val2 = SMGKnownExpValue.valueOf(777);
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)val1);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(32L, 32L, (SMGObject)obj1, (SMGValue)val2);
        SMGEdgeHasValue hv3 = new SMGEdgeHasValue(32L, 32L, (SMGObject)obj1, (SMGValue)val1);
        SMGEdgeHasValue hv4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)obj2, (SMGValue)val1);
        Truth.assertThat((Boolean)hv1.isConsistentWith(hv1)).isTrue();
        Truth.assertThat((Boolean)hv1.isConsistentWith(hv2)).isTrue();
        Truth.assertThat((Boolean)hv1.isConsistentWith(hv3)).isTrue();
        Truth.assertThat((Boolean)hv2.isConsistentWith(hv3)).isFalse();
        Truth.assertThat((Boolean)hv2.isConsistentWith(hv4)).isTrue();
    }

    @Test
    public void testOverlapsWith() {
        SMGRegion object = new SMGRegion(96L, "object");
        SMGKnownExpValue value = SMGKnownExpValue.valueOf(666);
        SMGEdgeHasValue at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object, (SMGValue)value);
        SMGEdgeHasValue at2 = new SMGEdgeHasValue(32L, 16L, (SMGObject)object, (SMGValue)value);
        SMGEdgeHasValue at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object, (SMGValue)value);
        SMGEdgeHasValue at6 = new SMGEdgeHasValue(32L, 48L, (SMGObject)object, (SMGValue)value);
        Truth.assertThat((Boolean)at0.overlapsWith(at2)).isTrue();
        Truth.assertThat((Boolean)at2.overlapsWith(at0)).isTrue();
        Truth.assertThat((Boolean)at2.overlapsWith(at4)).isTrue();
        Truth.assertThat((Boolean)at4.overlapsWith(at2)).isTrue();
        Truth.assertThat((Boolean)at4.overlapsWith(at6)).isTrue();
        Truth.assertThat((Boolean)at6.overlapsWith(at4)).isTrue();
        Truth.assertThat((Boolean)at0.overlapsWith(at0)).isTrue();
        Truth.assertThat((Boolean)at0.overlapsWith(at4)).isFalse();
        Truth.assertThat((Boolean)at0.overlapsWith(at6)).isFalse();
        Truth.assertThat((Boolean)at2.overlapsWith(at6)).isFalse();
        Truth.assertThat((Boolean)at4.overlapsWith(at0)).isFalse();
        Truth.assertThat((Boolean)at6.overlapsWith(at0)).isFalse();
        Truth.assertThat((Boolean)at6.overlapsWith(at2)).isFalse();
        SMGEdgeHasValue whole = new SMGEdgeHasValue(96L, 0L, (SMGObject)object, (SMGValue)value);
        Truth.assertThat((Boolean)whole.overlapsWith(at4)).isTrue();
        Truth.assertThat((Boolean)at4.overlapsWith(whole)).isTrue();
    }

    @Test
    public void testIsCompatibleFieldOnSameObject() {
        SMGRegion object1 = new SMGRegion(96L, "object-1");
        SMGRegion object2 = new SMGRegion(96L, "object-2");
        SMGKnownExpValue value = SMGKnownExpValue.valueOf(666);
        SMGEdgeHasValue obj1_at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object1, (SMGValue)value);
        SMGEdgeHasValue obj1_at2 = new SMGEdgeHasValue(32L, 16L, (SMGObject)object1, (SMGValue)value);
        SMGEdgeHasValue obj1_at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object1, (SMGValue)value);
        SMGEdgeHasValue obj1_12at0 = new SMGEdgeHasValue(96L, 0L, (SMGObject)object1, (SMGValue)value);
        SMGEdgeHasValue obj2_at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object2, (SMGValue)value);
        SMGEdgeHasValue obj2_at2 = new SMGEdgeHasValue(32L, 16L, (SMGObject)object2, (SMGValue)value);
        SMGEdgeHasValue obj2_at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object2, (SMGValue)value);
        SMGEdgeHasValue obj2_12at0 = new SMGEdgeHasValue(96L, 0L, (SMGObject)object2, (SMGValue)value);
        Truth.assertThat((Boolean)obj1_at0.equals(obj1_at0)).isTrue();
        Truth.assertThat((Boolean)obj1_at0.equals(obj1_at2)).isFalse();
        Truth.assertThat((Boolean)obj1_at0.equals(obj1_at4)).isFalse();
        Truth.assertThat((Boolean)obj1_at0.equals(obj1_12at0)).isFalse();
        Truth.assertThat((Boolean)obj1_at0.equals(obj2_at0)).isFalse();
        Truth.assertThat((Boolean)obj1_at0.equals(obj2_at2)).isFalse();
        Truth.assertThat((Boolean)obj1_at0.equals(obj2_at4)).isFalse();
        Truth.assertThat((Boolean)obj1_at0.equals(obj2_12at0)).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalOverlapsWith() {
        SMGRegion object1 = new SMGRegion(96L, "object1");
        SMGRegion object2 = new SMGRegion(96L, "object2");
        SMGKnownExpValue value = SMGKnownExpValue.valueOf(666);
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object1, (SMGValue)value);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(32L, 16L, (SMGObject)object2, (SMGValue)value);
        hv1.overlapsWith(hv2);
    }

    @Test
    public void testFilterAsPredicate() {
        SMGRegion object1 = new SMGRegion(64L, "object1");
        SMGKnownExpValue value1 = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue value2 = SMGKnownExpValue.valueOf(2);
        SMGEdgeHasValue hv11at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object1, (SMGValue)value1);
        SMGEdgeHasValue hv12at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object1, (SMGValue)value2);
        Predicate predicate = SMGEdgeHasValueFilter.objectFilter(object1).filterHavingValue(value1)::holdsFor;
        Truth.assertThat((Boolean)predicate.apply((Object)hv11at0)).isTrue();
        Truth.assertThat((Boolean)predicate.apply((Object)hv12at0)).isFalse();
    }

    @Test
    public void testFilterOnObject() {
        SMGRegion object1 = new SMGRegion(64L, "object1");
        SMGRegion object2 = new SMGRegion(64L, "Object2");
        SMGKnownExpValue value1 = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue value2 = SMGKnownExpValue.valueOf(2);
        SMGEdgeHasValue hv11at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object1, (SMGValue)value1);
        SMGEdgeHasValue hv12at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object1, (SMGValue)value2);
        SMGEdgeHasValue hv21at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object2, (SMGValue)value1);
        SMGEdgeHasValue hv22at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object2, (SMGValue)value2);
        SMGHasValueEdges allEdges = new SMGHasValueEdgeSet();
        allEdges = allEdges.addEdgeAndCopy(hv11at0);
        allEdges = allEdges.addEdgeAndCopy(hv12at4);
        allEdges = allEdges.addEdgeAndCopy(hv21at0);
        allEdges = allEdges.addEdgeAndCopy(hv22at4);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter().filterWithoutSize();
        Truth.assertThat((Boolean)filter.holdsFor(hv11at0)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv12at4)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv21at0)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv22at4)).isTrue();
        filter = filter.filterByObject(object1);
        Truth.assertThat((Boolean)filter.holdsFor(hv11at0)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv12at4)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv21at0)).isFalse();
        Truth.assertThat((Boolean)filter.holdsFor(hv22at4)).isFalse();
        ImmutableSet filteredSet = ImmutableSet.copyOf(filter.filter(allEdges));
        Truth.assertThat((Iterable)filteredSet).hasSize(2);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv11at0);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv12at4);
    }

    @Test
    public void testFilterAtOffset() {
        SMGRegion object1 = new SMGRegion(64L, "object1");
        SMGRegion object2 = new SMGRegion(64L, "Object2");
        SMGKnownExpValue value1 = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue value2 = SMGKnownExpValue.valueOf(2);
        SMGEdgeHasValue hv11at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object1, (SMGValue)value1);
        SMGEdgeHasValue hv12at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object1, (SMGValue)value2);
        SMGEdgeHasValue hv21at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object2, (SMGValue)value1);
        SMGEdgeHasValue hv22at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object2, (SMGValue)value2);
        SMGHasValueEdges allEdges = new SMGHasValueEdgeSet();
        allEdges = allEdges.addEdgeAndCopy(hv11at0);
        allEdges = allEdges.addEdgeAndCopy(hv12at4);
        allEdges = allEdges.addEdgeAndCopy(hv21at0);
        allEdges = allEdges.addEdgeAndCopy(hv22at4);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter().filterAtOffset(0L).filterWithoutSize();
        Truth.assertThat((Boolean)filter.holdsFor(hv11at0)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv12at4)).isFalse();
        Truth.assertThat((Boolean)filter.holdsFor(hv21at0)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv22at4)).isFalse();
        ImmutableSet filteredSet = ImmutableSet.copyOf(filter.filter(allEdges));
        Truth.assertThat((Iterable)filteredSet).hasSize(2);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv11at0);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv21at0);
    }

    @Test
    public void testFilterOnValue() {
        SMGRegion object1 = new SMGRegion(64L, "object1");
        SMGRegion object2 = new SMGRegion(64L, "Object2");
        SMGKnownExpValue value1 = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue value2 = SMGKnownExpValue.valueOf(2);
        SMGEdgeHasValue hv11at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object1, (SMGValue)value1);
        SMGEdgeHasValue hv12at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object1, (SMGValue)value2);
        SMGEdgeHasValue hv21at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object2, (SMGValue)value1);
        SMGEdgeHasValue hv22at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object2, (SMGValue)value2);
        SMGHasValueEdges allEdges = new SMGHasValueEdgeSet();
        allEdges = allEdges.addEdgeAndCopy(hv11at0);
        allEdges = allEdges.addEdgeAndCopy(hv12at4);
        allEdges = allEdges.addEdgeAndCopy(hv21at0);
        allEdges = allEdges.addEdgeAndCopy(hv22at4);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter().filterHavingValue(value1);
        Truth.assertThat((Boolean)filter.holdsFor(hv11at0)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv12at4)).isFalse();
        Truth.assertThat((Boolean)filter.holdsFor(hv21at0)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv22at4)).isFalse();
        ImmutableSet filteredSet = ImmutableSet.copyOf(filter.filter(allEdges));
        Truth.assertThat((Iterable)filteredSet).hasSize(2);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv11at0);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv21at0);
        filter = filter.filterNotHavingValue(value1);
        Truth.assertThat((Boolean)filter.holdsFor(hv11at0)).isFalse();
        Truth.assertThat((Boolean)filter.holdsFor(hv12at4)).isTrue();
        Truth.assertThat((Boolean)filter.holdsFor(hv21at0)).isFalse();
        Truth.assertThat((Boolean)filter.holdsFor(hv22at4)).isTrue();
        filteredSet = ImmutableSet.copyOf(filter.filter(allEdges));
        Truth.assertThat((Iterable)filteredSet).hasSize(2);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv22at4);
        Truth.assertThat((Iterable)filteredSet).contains((Object)hv12at4);
    }
}

