/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.edge;

import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGEdgePointsTo
extends SMGEdge {
    private final SMGTargetSpecifier tg;

    public SMGEdgePointsTo(SMGValue pValue, SMGObject pObject, long pOffset) {
        this(pValue, pObject, pOffset, pObject instanceof SMGRegion ? SMGTargetSpecifier.REGION : SMGTargetSpecifier.UNKNOWN);
    }

    public SMGEdgePointsTo(SMGValue pValue, SMGObject pObject, long pOffset, SMGTargetSpecifier pTg) {
        super(pValue, pObject, pOffset);
        this.tg = pTg;
    }

    public String toString() {
        return this.value + "->" + this.object.getLabel() + "+" + this.getOffset() + "b";
    }

    public SMGTargetSpecifier getTargetSpecifier() {
        return this.tg;
    }

    @Override
    public boolean isConsistentWith(SMGEdge edge) {
        if (!(edge instanceof SMGEdgePointsTo)) {
            return false;
        }
        SMGEdgePointsTo other = (SMGEdgePointsTo)edge;
        if (this.value == other.value) {
            return this.getOffset() == other.getOffset() && this.object == other.object && this.tg == other.tg;
        }
        return this.getOffset() != other.getOffset() || this.object != other.object || this.tg != SMGTargetSpecifier.UNKNOWN && other.tg != SMGTargetSpecifier.UNKNOWN && this.tg != other.tg;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.tg.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SMGEdgePointsTo)) {
            return false;
        }
        SMGEdgePointsTo other = (SMGEdgePointsTo)obj;
        return super.equals(obj) && this.tg == other.tg;
    }
}

