/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.edge;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGPointsToEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGEdgePointsToFilter {
    private final SMGObject targetObject;
    private SMGValue value = null;
    private Long targetOffset = null;
    private SMGTargetSpecifier targetSpecifier = null;

    private SMGEdgePointsToFilter(SMGObject pTargetObject) {
        this.targetObject = (SMGObject)Preconditions.checkNotNull((Object)pTargetObject, (Object)"fitlering for NULL might be useless");
    }

    @CanIgnoreReturnValue
    public SMGEdgePointsToFilter filterHavingValue(SMGValue pValue) {
        this.value = pValue;
        return this;
    }

    @CanIgnoreReturnValue
    public SMGEdgePointsToFilter filterAtTargetOffset(Long pOffset) {
        this.targetOffset = pOffset;
        return this;
    }

    @CanIgnoreReturnValue
    public SMGEdgePointsToFilter filterByTargetSpecifier(SMGTargetSpecifier pTargetSpecifier) {
        this.targetSpecifier = pTargetSpecifier;
        return this;
    }

    public static SMGEdgePointsToFilter targetObjectFilter(SMGObject pTargetObject) {
        return new SMGEdgePointsToFilter(pTargetObject);
    }

    public boolean holdsFor(SMGEdgePointsTo pEdge) {
        if (this.targetObject != null && !this.targetObject.equals(pEdge.getObject())) {
            return false;
        }
        if (this.value != null && !this.value.equals(pEdge.getValue())) {
            return false;
        }
        if (this.targetOffset != null && !this.targetOffset.equals(pEdge.getOffset())) {
            return false;
        }
        return this.targetSpecifier == null || this.targetSpecifier == pEdge.getTargetSpecifier();
    }

    public Iterable<SMGEdgePointsTo> filter(SMGPointsToEdges edges) {
        if (this.value != null) {
            SMGEdgePointsTo result = edges.getEdgeWithValue(this.value);
            if (result == null) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of((Object)result);
        }
        return Iterables.filter((Iterable)edges, this::holdsFor);
    }
}

