/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.edge;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;

public class SMGEdgePointsToTest {
    @Test
    public void testSMGEdgePointsTo() {
        SMGKnownExpValue val = SMGKnownExpValue.valueOf(6);
        SMGRegion obj = new SMGRegion(64L, "object");
        SMGEdgePointsTo edge = new SMGEdgePointsTo(val, obj, 0L);
        Truth.assertThat((Comparable)edge.getValue()).isEqualTo((Object)val);
        Truth.assertThat((Comparable)edge.getObject()).isEqualTo((Object)obj);
        Truth.assertThat((Long)edge.getOffset()).isEqualTo((Object)0);
    }

    @Test
    public void testIsConsistentWith() {
        SMGKnownExpValue val1 = SMGKnownExpValue.valueOf(1);
        SMGKnownExpValue val2 = SMGKnownExpValue.valueOf(2);
        SMGRegion obj = new SMGRegion(64L, "object");
        SMGRegion obj2 = new SMGRegion(64L, "object2");
        SMGEdgePointsTo edge1 = new SMGEdgePointsTo(val1, obj, 0L);
        SMGEdgePointsTo edge2 = new SMGEdgePointsTo(val2, obj, 0L);
        SMGEdgePointsTo edge3 = new SMGEdgePointsTo(val1, obj, 32L);
        SMGEdgePointsTo edge4 = new SMGEdgePointsTo(val1, obj2, 0L);
        Truth.assertThat((Boolean)edge1.isConsistentWith(edge1)).isTrue();
        Truth.assertThat((Boolean)edge1.isConsistentWith(edge2)).isFalse();
        Truth.assertThat((Boolean)edge1.isConsistentWith(edge3)).isFalse();
        Truth.assertThat((Boolean)edge1.isConsistentWith(edge4)).isFalse();
    }
}

