/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object;

import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;

public abstract class SMGAbstractList<S>
extends SMGObject
implements SMGAbstractObject {
    private final int minimumLength;
    private final S shape;

    protected SMGAbstractList(long pSize, String label, int level, SMGObjectKind kind, S pShape, int pMinLength) {
        super(pSize, label, level, kind);
        this.shape = pShape;
        this.minimumLength = pMinLength;
    }

    protected SMGAbstractList(SMGAbstractList<S> other) {
        super(other.getSize(), other.getLabel(), other.getLevel(), other.getKind());
        this.shape = other.shape;
        this.minimumLength = other.minimumLength;
    }

    @Override
    public boolean matchGenericShape(SMGAbstractObject pOther) {
        return pOther.getKind() == this.getKind();
    }

    @Override
    public boolean matchSpecificShape(SMGAbstractObject pOther) {
        return this.matchGenericShape(pOther) && this.shape.equals(((SMGAbstractList)pOther).shape);
    }

    public int getMinimumLength() {
        return this.minimumLength;
    }

    public S getShape() {
        return this.shape;
    }

    @Override
    public boolean isMoreGeneral(SMGObject pOther) {
        switch (pOther.getKind()) {
            case REG: {
                return this.minimumLength < 2;
            }
            case OPTIONAL: {
                return this.minimumLength == 0;
            }
            case DLL: 
            case SLL: {
                return this.matchSpecificShape((SMGAbstractObject)((Object)pOther)) && this.minimumLength < ((SMGAbstractList)pOther).minimumLength;
            }
        }
        return false;
    }

    @Override
    public SMGObject join(SMGObject pOther, int pDestLevel) {
        switch (pOther.getKind()) {
            case DLL: 
            case SLL: {
                SMGAbstractList otherLinkedList = (SMGAbstractList)pOther;
                assert (this.matchSpecificShape(otherLinkedList));
                int minlength = Math.min(this.getMinimumLength(), otherLinkedList.getMinimumLength());
                return this.copy(minlength, pDestLevel);
            }
            case REG: 
            case OPTIONAL: {
                assert (this.getSize() == pOther.getSize());
                int otherLength = pOther.getKind() == SMGObjectKind.REG ? 1 : 0;
                int minlength = Math.min(this.getMinimumLength(), otherLength);
                return this.copy(minlength, pDestLevel);
            }
        }
        throw new IllegalArgumentException("join called on unjoinable Objects");
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    protected abstract SMGAbstractList<S> copy(int var1, int var2);
}

